// This file implements the IEnumSTATSTG Interface and Gateway for Python.
// Generated by makegw.py

#include "stdafx.h"
#include "PythonCOM.h"
#include "PythonCOMServer.h"
#include "PyIEnumSTATSTG.h"

// @doc - This file contains autoduck documentation

// ---------------------------------------------------
//
// Interface Implementation

PyIEnumSTATSTG::PyIEnumSTATSTG(IUnknown *pdisp):
	PyIUnknown(pdisp)
{
	ob_type = &type;
}

PyIEnumSTATSTG::~PyIEnumSTATSTG()
{
}

/* static */ IEnumSTATSTG *PyIEnumSTATSTG::GetI(PyObject *self)
{
	return (IEnumSTATSTG *)PyIUnknown::GetI(self);
}

// @pymethod object|PyIEnumSTATSTG|Next|Retrieves a specified number of items in the enumeration sequence.
PyObject *PyIEnumSTATSTG::Next(PyObject *self, PyObject *args)
{
	long celt = 1;
	// @pyparm int|num|1|Number of items to retrieve.
	if ( !PyArg_ParseTuple(args, "|l:Next", &celt) )
		return NULL;

	IEnumSTATSTG *pIESTATSTG = GetI(self);
	if ( pIESTATSTG == NULL )
		return NULL;

	STATSTG *rgVar = new STATSTG[celt];
	if ( rgVar == NULL )
		return OleSetMemoryError("allocating result STATSTGs");

	int i;
/*	for ( i = celt; i--; )
		// *** possibly init each structure element???
*/

	ULONG celtFetched;
	HRESULT hr = pIESTATSTG->Next(celt, rgVar, &celtFetched);
	if ( FAILED(hr) )
	{
		delete [] rgVar;
		return OleSetOleError(hr);
	}

	PyObject *result = PyTuple_New(celtFetched);
	if ( result != NULL )
	{
		for ( i = celtFetched; i--; )
		{
			PyObject *ob = PyCom_PyObjectFromSTATSTG(&rgVar[i]);
			if ( ob == NULL )
			{
				Py_DECREF(result);
				result = NULL;
				break;
			}
			PyTuple_SET_ITEM(result, i, ob);
		}
	}

/*	for ( i = celtFetched; i--; )
		// *** possibly cleanup each structure element???
*/
	delete [] rgVar;
	return result;
}

// @pymethod |PyIEnumSTATSTG|Skip|Skips over the next specified elementes.
PyObject *PyIEnumSTATSTG::Skip(PyObject *self, PyObject *args)
{
	long celt;
	if ( !PyArg_ParseTuple(args, "l:Skip", &celt) )
		return NULL;

	IEnumSTATSTG *pIESTATSTG = GetI(self);
	if ( pIESTATSTG == NULL )
		return NULL;

	HRESULT hr = pIESTATSTG->Skip(celt);
	if ( FAILED(hr) )
		return OleSetOleError(hr);

	Py_INCREF(Py_None);
	return Py_None;
}

// @pymethod |PyIEnumSTATSTG|Reset|Resets the enumeration sequence to the beginning.
PyObject *PyIEnumSTATSTG::Reset(PyObject *self, PyObject *args)
{
	if ( !PyArg_ParseTuple(args, ":Reset") )
		return NULL;

	IEnumSTATSTG *pIESTATSTG = GetI(self);
	if ( pIESTATSTG == NULL )
		return NULL;

	HRESULT hr = pIESTATSTG->Reset();
	if ( FAILED(hr) )
		return OleSetOleError(hr);

	Py_INCREF(Py_None);
	return Py_None;
}

// @pymethod <o PyIEnumSTATSTG>|PyIEnumSTATSTG|Clone|Creates another enumerator that contains the same enumeration state as the current one
PyObject *PyIEnumSTATSTG::Clone(PyObject *self, PyObject *args)
{
	if ( !PyArg_ParseTuple(args, ":Clone") )
		return NULL;

	IEnumSTATSTG *pIESTATSTG = GetI(self);
	if ( pIESTATSTG == NULL )
		return NULL;

	IEnumSTATSTG *pClone;
	HRESULT hr = pIESTATSTG->Clone(&pClone);
	if ( FAILED(hr) )
		return OleSetOleError(hr);

	return PyCom_PyObjectFromIUnknown(pClone, IID_IEnumSTATSTG, FALSE);
}

// @object PyIEnumSTATSTG|A Python interface to IEnumVARIANT
static struct PyMethodDef PyIEnumSTATSTG_methods[] =
{
	{ "Next", PyIEnumSTATSTG::Next, 1 },    // @pymeth Next|Retrieves a specified number of items in the enumeration sequence.
	{ "Skip", PyIEnumSTATSTG::Skip, 1 },	// @pymeth Skip|Skips over the next specified elementes.
	{ "Reset", PyIEnumSTATSTG::Reset, 1 },	// @pymeth Reset|Resets the enumeration sequence to the beginning.
	{ "Clone", PyIEnumSTATSTG::Clone, 1 },	// @pymeth Clone|Creates another enumerator that contains the same enumeration state as the current one.
	{ NULL }
};

PyComTypeObject PyIEnumSTATSTG::type("PyIEnumSTATSTG",
		&PyIUnknown::type,
		sizeof(PyIEnumSTATSTG),
		PyIEnumSTATSTG_methods,
		GET_PYCOM_CTOR(PyIEnumSTATSTG));

// ---------------------------------------------------
//
// Gateway Implementation

// Std delegation
STDMETHODIMP_(ULONG) PyGEnumSTATSTG::AddRef(void) {return PyGatewayBase::AddRef();}
STDMETHODIMP_(ULONG) PyGEnumSTATSTG::Release(void) {return PyGatewayBase::Release();}
STDMETHODIMP PyGEnumSTATSTG::QueryInterface(REFIID iid, void ** obj) {return PyGatewayBase::QueryInterface(iid, obj);}
STDMETHODIMP PyGEnumSTATSTG::GetTypeInfoCount(UINT FAR* pctInfo) {return PyGatewayBase::GetTypeInfoCount(pctInfo);}
STDMETHODIMP PyGEnumSTATSTG::GetTypeInfo(UINT itinfo, LCID lcid, ITypeInfo FAR* FAR* pptInfo) {return PyGatewayBase::GetTypeInfo(itinfo, lcid, pptInfo);}
STDMETHODIMP PyGEnumSTATSTG::GetIDsOfNames(REFIID refiid, OLECHAR FAR* FAR* rgszNames, UINT cNames, LCID lcid, DISPID FAR* rgdispid) {return PyGatewayBase::GetIDsOfNames( refiid, rgszNames, cNames, lcid, rgdispid);}
STDMETHODIMP PyGEnumSTATSTG::Invoke(DISPID dispid, REFIID riid, LCID lcid, WORD wFlags, DISPPARAMS FAR* params, VARIANT FAR* pVarResult, EXCEPINFO FAR* pexcepinfo, UINT FAR* puArgErr) {return PyGatewayBase::Invoke( dispid, riid, lcid, wFlags, params, pVarResult, pexcepinfo, puArgErr);}

STDMETHODIMP PyGEnumSTATSTG::Next( 
            /* [in] */ ULONG celt,
            /* [length_is][size_is][out] */ STATSTG __RPC_FAR *rgVar,
            /* [out] */ ULONG __RPC_FAR *pCeltFetched)
{
	PY_GATEWAY_METHOD;
	PyObject *result;
	HRESULT hr = InvokeViaPolicy("Next", &result, "i", celt);
	if ( FAILED(hr) )
		return hr;

	if ( !PySequence_Check(result) )
		goto error;
	int len;
	len = PyObject_Length(result);
	if ( len == -1 )
		goto error;
	if ( len > (int)celt)
		len = celt;

	if ( pCeltFetched )
		*pCeltFetched = len;

	int i;
	for ( i = 0; i < len; ++i )
	{
		PyObject *ob = PySequence_GetItem(result, i);
		if ( ob == NULL )
			goto error;

		if ( !PyCom_PyObjectAsSTATSTG(ob, &rgVar[i]) )
		{
			Py_DECREF(result);
			return PyCom_SetFromSimple(E_OUTOFMEMORY, IID_IEnumSTATSTG);
		}
	}

	Py_DECREF(result);

	return len < (int)celt ? S_FALSE : S_OK;

  error:
	PyErr_Clear();	// just in case
	Py_DECREF(result);
	return PyCom_SetFromSimple(E_FAIL, IID_IEnumSTATSTG);
}

STDMETHODIMP PyGEnumSTATSTG::Skip( 
            /* [in] */ ULONG celt)
{
	PY_GATEWAY_METHOD;
	return InvokeViaPolicy("Skip", NULL, "i", celt);
}

STDMETHODIMP PyGEnumSTATSTG::Reset(void)
{
	PY_GATEWAY_METHOD;
	return InvokeViaPolicy("Reset");
}

STDMETHODIMP PyGEnumSTATSTG::Clone( 
            /* [out] */ IEnumSTATSTG __RPC_FAR *__RPC_FAR *ppEnum)
{
	PY_GATEWAY_METHOD;
	PyObject * result;
	HRESULT hr = InvokeViaPolicy("Clone", &result);
	if ( FAILED(hr) )
		return hr;

	/*
	** Make sure we have the right kind of object: we should have some kind
	** of IUnknown subclass wrapped into a PyIUnknown instance.
	*/
	if ( !PyIBase::is_object(result, &PyIUnknown::type) )
	{
		/* the wrong kind of object was returned to us */
		Py_DECREF(result);
		return PyCom_SetFromSimple(E_FAIL, IID_IEnumSTATSTG);
	}

	/*
	** Get the IUnknown out of the thing. note that the Python ob maintains
	** a reference, so we don't have to explicitly AddRef() here.
	*/
	IUnknown *punk = ((PyIUnknown *)result)->m_obj;
	if ( !punk )
	{
		/* damn. the object was released. */
		Py_DECREF(result);
		return PyCom_SetFromSimple(E_FAIL, IID_IEnumSTATSTG);
	}

	/*
	** Get the interface we want. note it is returned with a refcount.
	** This QI is actually going to instantiate a PyGEnumSTATSTG.
	*/
	hr = punk->QueryInterface(IID_IEnumSTATSTG, (LPVOID *)ppEnum);

	/* done with the result; this DECREF is also for <punk> */
	Py_DECREF(result);

	return PyCom_SetFromSimple(hr, IID_IEnumSTATSTG);
}
