// PyICategory

// @doc
#include "stdafx.h"
#include "PythonCOM.h"
#include <comcat.h>
#include "PyIEnumGUID.h"

PyIEnumCATEGORYINFO::PyIEnumCATEGORYINFO(IUnknown *pDisp) :
	PyIUnknown(pDisp)
{
	ob_type = &type;
}

PyIEnumCATEGORYINFO::~PyIEnumCATEGORYINFO()
{
}

/*static*/ IEnumCATEGORYINFO *PyIEnumCATEGORYINFO::GetI(PyObject *self)
{
	return (IEnumCATEGORYINFO *)PyIUnknown::GetI(self);
}


// @pymethod ( (<o PyIID>, int, string), ...)|PyIEnumCATEGORYINFO|Next|Retrieves a specified number of items in the enumeration sequence.
PyObject *PyIEnumCATEGORYINFO::Next(PyObject *self, PyObject *args)
{
	USES_CONVERSION;
	long celt = 1;
	// @pyparm int|num|1|Number of items to retrieve.
	if ( !PyArg_ParseTuple(args, "|l:Next", &celt) )
		return NULL;

	IEnumCATEGORYINFO *pMy = GetI(self);
	if (pMy==NULL) return NULL;


	CATEGORYINFO *rgVar = new CATEGORYINFO[celt];
	if ( rgVar == NULL )
		return OleSetMemoryError("allocating result CATEGORYINFOs");

	int i;
	for ( i = celt; i--; )
		memset(rgVar+i,'\0',sizeof(CATEGORYINFO));

	ULONG celtFetched = 0;
	HRESULT hr = pMy->Next(celt, rgVar, &celtFetched);
	if ( HRESULT_CODE(hr) != ERROR_NO_MORE_ITEMS && FAILED(hr) )
	{
		delete [] rgVar;
		return OleSetOleError(hr);
	}

	PyObject *result = PyTuple_New(celtFetched);
	if ( result != NULL )
	{
		for ( i = celtFetched; i--; )
		{
			PyObject *ob = Py_BuildValue("Oiz", PyCom_PyIIDObjectFromIID(rgVar[i].catid), rgVar[i].lcid, W2A(rgVar[i].szDescription));
			if ( ob == NULL )
			{
				Py_DECREF(result);
				result = NULL;
				break;
			}
			PyTuple_SET_ITEM(result, i, ob);
		}
	}
	delete [] rgVar;
	return result;
	// @rdesc The result is a tuple of (IID object, LCID, string description) tuples, 
	// one for each element returned.
}
// @pymethod |PyIEnumCATEGORYINFO|Skip|Skips over the next specified elementes.
PyObject *PyIEnumCATEGORYINFO::Skip(PyObject *self, PyObject *args)
{
	ULONG num;
	// @pyparm int|num||The number of elements being requested.
	if (!PyArg_ParseTuple(args, "l:Skip", &num))
		return NULL;

	IEnumCATEGORYINFO *pMy = GetI(self);
	if (pMy==NULL) return NULL;

	HRESULT hr = pMy->Skip(num);
	if (FAILED(hr))
		return OleSetOleError(hr);
	Py_INCREF(Py_None);
	return Py_None;
}
// @pymethod |PyIEnumCATEGORYINFO|Reset|Resets the enumeration sequence to the beginning.
PyObject *PyIEnumCATEGORYINFO::Reset(PyObject *self, PyObject *args)
{
	if (!PyArg_ParseTuple(args, ":Reset"))
		return NULL;

	IEnumCATEGORYINFO *pMy = GetI(self);
	if (pMy==NULL) return NULL;

	HRESULT hr = pMy->Reset();
	if (FAILED(hr))
		return OleSetOleError(hr);
	Py_INCREF(Py_None);
	return Py_None;
}

// @pymethod <o PyIEnumCATEGORYINFO>|PyIEnumCATEGORYINFO|Clone|Creates another enumerator that contains the same enumeration state as the current one
PyObject *PyIEnumCATEGORYINFO::Clone(PyObject *self, PyObject *args)
{
	if (!PyArg_ParseTuple(args, ":Clone"))
		return NULL;

	IEnumCATEGORYINFO *pMy = GetI(self);
	if (pMy==NULL) return NULL;

	IEnumCATEGORYINFO *pNew = NULL;
	HRESULT hr = pMy->Clone(&pNew);
	if (FAILED(hr))
		return OleSetOleError(hr);
	return PyCom_PyObjectFromIUnknown(pNew, IID_IEnumCATEGORYINFO, FALSE);
}

// @object PyIEnumCATEGORYINFO|A Python interface to IEnumCATEGORYINFO
static struct PyMethodDef PyIEnumCATEGORYINFO_methods[] =
{
	{"Next",          PyIEnumCATEGORYINFO::Next,  1}, // @pymeth Next|Retrieves a specified number of items in the enumeration sequence.
	{"Skip",          PyIEnumCATEGORYINFO::Skip,  1}, // @pymeth Skip|Skips over the next specified elementes.
	{"Reset",          PyIEnumCATEGORYINFO::Reset,  1}, // @pymeth Reset|Resets the enumeration sequence to the beginning.
	{"Clone",          PyIEnumCATEGORYINFO::Clone,  1}, // @pymeth Clone|Creates another enumerator that contains the same enumeration state as the current one.
	{NULL,  NULL}        
};

PyComTypeObject PyIEnumCATEGORYINFO::type("PyIEnumCATEGORYINFO",
                 &PyIUnknown::type,
                 sizeof(PyIEnumCATEGORYINFO),
                 PyIEnumCATEGORYINFO_methods,
				 GET_PYCOM_CTOR(PyIEnumCATEGORYINFO));

