#include "stdafx.h"
#include "PythonCOM.h"

PyIConnectionPointContainer::PyIConnectionPointContainer(IUnknown *pdisp):
	PyIUnknown(pdisp)
{
	ob_type = &type;
}

PyIConnectionPointContainer::~PyIConnectionPointContainer()
{
}

/* static */ IConnectionPointContainer *PyIConnectionPointContainer::GetI(PyObject *self)
{
	return (IConnectionPointContainer *)PyIUnknown::GetI(self);
}

/* static  PyObject *PyIConnectionPointContainer::EnumConnectionPoints(PyObject *self, PyObject *args)
{
	if ( !PyArg_ParseTuple(args, ":EnumConnectionPoints") )
		return NULL;

	IConnectionPointContainer *pICPC = GetI(self);
	if ( pICPC == NULL )
		return NULL;

	HRESULT hr = pICPC->EnumConnectionPoints();
	if ( FAILED(hr) )
		return OleSetOleError(hr);

	Py_INCREF(Py_None);
	return Py_None;
} */

/* static */ PyObject *PyIConnectionPointContainer::FindConnectionPoint(PyObject *self, PyObject *args)
{
	PyObject *obIID;
	if ( !PyArg_ParseTuple(args, "O:FindConnectionPoint", &obIID) )
		return NULL;

	IID iid;
	if (!PyCom_CLSIDFromPyObject( obIID, &iid ))
		return NULL;

	IConnectionPointContainer *pICPC = GetI(self);
	if ( pICPC == NULL )
		return NULL;

	IConnectionPoint *pCP;
	HRESULT hr = pICPC->FindConnectionPoint( iid, &pCP);
	if ( FAILED(hr) )
		return OleSetOleError(hr);

	return PyCom_PyObjectFromIUnknown( pCP, IID_IConnectionPoint );
}

static struct PyMethodDef PyIConnectionPointContainer_methods[] =
{
//	{ "EnumConnectionPoints", PyIConnectionPointContainer::EnumConnectionPoints, 1 },
	{ "FindConnectionPoint", PyIConnectionPointContainer::FindConnectionPoint, 1 },
	{ NULL }
};

PyComTypeObject PyIConnectionPointContainer::type("PyIConnectionPointContainer",
		&PyIUnknown::type,
		sizeof(PyIConnectionPointContainer),
		PyIConnectionPointContainer_methods,
		GET_PYCOM_CTOR(PyIConnectionPointContainer));
