#include "stdafx.h"
#include "PythonCOM.h"

PyIConnectionPoint::PyIConnectionPoint(IUnknown *pdisp):
	PyIUnknown(pdisp)
{
	ob_type = &type;
}

PyIConnectionPoint::~PyIConnectionPoint()
{
}

/* static */ IConnectionPoint *PyIConnectionPoint::GetI(PyObject *self)
{
	return (IConnectionPoint *)PyIUnknown::GetI(self);
}

/* static */ PyObject *PyIConnectionPoint::GetConnectionInterface(PyObject *self, PyObject *args)
{
	if ( !PyArg_ParseTuple(args, ":GetConnectionInterface") )
		return NULL;

	IConnectionPoint *pICP = GetI(self);
	if ( pICP == NULL )
		return NULL;

	IID iid;
	HRESULT hr = pICP->GetConnectionInterface(&iid);
	if ( FAILED(hr) )
		return OleSetOleError(hr);

	return PyCom_PyIIDObjectFromIID(iid);
}

/* static */ PyObject *PyIConnectionPoint::GetConnectionPointContainer(PyObject *self, PyObject *args)
{
	if ( !PyArg_ParseTuple(args, ":GetConnectionPointContainer") )
		return NULL;

	IConnectionPoint *pICP = GetI(self);
	if ( pICP == NULL )
		return NULL;

	IConnectionPointContainer *pCont;
	HRESULT hr = pICP->GetConnectionPointContainer(&pCont);
	if ( FAILED(hr) )
		return OleSetOleError(hr);

	return PyCom_PyObjectFromIUnknown( pCont, IID_IConnectionPointContainer );
}

/* static */ PyObject *PyIConnectionPoint::Advise(PyObject *self, PyObject *args)
{
	PyObject *obUnk;
	if ( !PyArg_ParseTuple(args, "O:Advise", &obUnk) )
		return NULL;

	IUnknown *pUnk;
	if (!PyCom_IUnknownFromPyObject(obUnk, &pUnk, FALSE))
		return NULL;

	IConnectionPoint *pICP = GetI(self);
	if ( pICP == NULL )
		return NULL;

	DWORD cookie;
	HRESULT hr = pICP->Advise( pUnk, &cookie );
	if ( FAILED(hr) )
		return OleSetOleError(hr);

	return PyInt_FromLong(cookie);
}

/* static */ PyObject *PyIConnectionPoint::Unadvise(PyObject *self, PyObject *args)
{
	DWORD cookie;
	if ( !PyArg_ParseTuple(args, "i:Unadvise", &cookie) )
		return NULL;

	IConnectionPoint *pICP = GetI(self);
	if ( pICP == NULL )
		return NULL;

	HRESULT hr = pICP->Unadvise(cookie);
	if ( FAILED(hr) )
		return OleSetOleError(hr);

	Py_INCREF(Py_None);
	return Py_None;
}

/* static  PyObject *PyIConnectionPoint::EnumConnections(PyObject *self, PyObject *args)
{
	if ( !PyArg_ParseTuple(args, ":EnumConnections") )
		return NULL;

	IConnectionPoint *pICP = GetI(self);
	if ( pICP == NULL )
		return NULL;

	HRESULT hr = pICP->EnumConnections();
	if ( FAILED(hr) )
		return OleSetOleError(hr);

	Py_INCREF(Py_None);
	return Py_None;
}*/

static struct PyMethodDef PyIConnectionPoint_methods[] =
{
	{ "GetConnectionInterface", PyIConnectionPoint::GetConnectionInterface, 1 },
	{ "GetConnectionPointContainer", PyIConnectionPoint::GetConnectionPointContainer, 1 },
	{ "Advise", PyIConnectionPoint::Advise, 1 },
	{ "Unadvise", PyIConnectionPoint::Unadvise, 1 },
//	{ "EnumConnections", PyIConnectionPoint::EnumConnections, 1 },
	{ NULL }
};

PyComTypeObject PyIConnectionPoint::type("PyIConnectionPoint",
		&PyIUnknown::type,
		sizeof(PyIConnectionPoint),
		PyIConnectionPoint_methods,
		GET_PYCOM_CTOR(PyIConnectionPoint));
