#include "stdafx.h"
#include "PythonCOM.h"
#include "PythonCOMServer.h"
#include "propbag.h"

// Std delegation
STDMETHODIMP_(ULONG) PyGPropertyBag::AddRef(void) {return PyGatewayBase::AddRef();}
STDMETHODIMP_(ULONG) PyGPropertyBag::Release(void) {return PyGatewayBase::Release();}
STDMETHODIMP PyGPropertyBag::QueryInterface(REFIID iid, void ** obj) {return PyGatewayBase::QueryInterface(iid, obj);}
STDMETHODIMP PyGPropertyBag::GetTypeInfoCount(UINT FAR* pctInfo) {return PyGatewayBase::GetTypeInfoCount(pctInfo);}
STDMETHODIMP PyGPropertyBag::GetTypeInfo(UINT itinfo, LCID lcid, ITypeInfo FAR* FAR* pptInfo) {return PyGatewayBase::GetTypeInfo(itinfo, lcid, pptInfo);}
STDMETHODIMP PyGPropertyBag::GetIDsOfNames(REFIID refiid, OLECHAR FAR* FAR* rgszNames, UINT cNames, LCID lcid, DISPID FAR* rgdispid) {return PyGatewayBase::GetIDsOfNames( refiid, rgszNames, cNames, lcid, rgdispid);}
STDMETHODIMP PyGPropertyBag::Invoke(DISPID dispid, REFIID riid, LCID lcid, WORD wFlags, DISPPARAMS FAR* params, VARIANT FAR* pVarResult, EXCEPINFO FAR* pexcepinfo, UINT FAR* puArgErr) {return PyGatewayBase::Invoke( dispid, riid, lcid, wFlags, params, pVarResult, pexcepinfo, puArgErr);}

STDMETHODIMP PyGPropertyBag::Read(
            /* [in] */ LPCOLESTR pszPropName,
            /* [out][in] */ VARIANT __RPC_FAR *pVar,
            /* [in] */ IErrorLog __RPC_FAR *pErrorLog)
{
	if ( pszPropName == NULL || pVar == NULL )
		return E_POINTER;

	PyObject *obLog;
	if ( pErrorLog )
	{
		obLog = PyCom_PyObjectFromIUnknown(pErrorLog, IID_IErrorLog, TRUE);
		if ( !obLog )
			return PyCom_HandlePythonFailureToCOM();
	}
	else
	{
		Py_INCREF(Py_None);
		obLog = Py_None;
	}

	USES_CONVERSION;
	PyObject *result = DispatchViaPolicy("Read",
										 "siO",
										 OLE2A(pszPropName),
										 (int)V_VT(pVar),
										 obLog);

	HRESULT hr = PyCom_HandlePythonFailureToCOM();
	Py_DECREF(obLog);
	if ( !result )
		return hr;

	BOOL ok = PyCom_VariantFromPyObject(result, pVar);
	Py_DECREF(result);

	return ok ? S_OK : E_FAIL;
}

STDMETHODIMP PyGPropertyBag::Write(
            /* [in] */ LPCOLESTR pszPropName,
            /* [in] */ VARIANT __RPC_FAR *pVar)
{
	if ( pszPropName == NULL || pVar == NULL )
		return E_POINTER;

	PyObject *value = PyCom_PyObjectFromVariant(pVar);
	if ( !value )
		return PyCom_HandlePythonFailureToCOM();

	USES_CONVERSION;
	PyObject *result = DispatchViaPolicy("Write",
										 "sO",
										 OLE2A(pszPropName),
										 value);
	HRESULT hr = PyCom_HandlePythonFailureToCOM();
	Py_DECREF(value);
	Py_XDECREF(result);
	return hr;
}

