#include "stdafx.h"
#include "PythonCOM.h"
#include "PythonCOMServer.h"
#include "propbag.h"

// Std delegation
STDMETHODIMP_(ULONG) PyGPersist::AddRef(void) {return PyGatewayBase::AddRef();}
STDMETHODIMP_(ULONG) PyGPersist::Release(void) {return PyGatewayBase::Release();}
STDMETHODIMP PyGPersist::QueryInterface(REFIID iid, void ** obj) {return PyGatewayBase::QueryInterface(iid, obj);}
STDMETHODIMP PyGPersist::GetTypeInfoCount(UINT FAR* pctInfo) {return PyGatewayBase::GetTypeInfoCount(pctInfo);}
STDMETHODIMP PyGPersist::GetTypeInfo(UINT itinfo, LCID lcid, ITypeInfo FAR* FAR* pptInfo) {return PyGatewayBase::GetTypeInfo(itinfo, lcid, pptInfo);}
STDMETHODIMP PyGPersist::GetIDsOfNames(REFIID refiid, OLECHAR FAR* FAR* rgszNames, UINT cNames, LCID lcid, DISPID FAR* rgdispid) {return PyGatewayBase::GetIDsOfNames( refiid, rgszNames, cNames, lcid, rgdispid);}
STDMETHODIMP PyGPersist::Invoke(DISPID dispid, REFIID riid, LCID lcid, WORD wFlags, DISPPARAMS FAR* params, VARIANT FAR* pVarResult, EXCEPINFO FAR* pexcepinfo, UINT FAR* puArgErr) {return PyGatewayBase::Invoke( dispid, riid, lcid, wFlags, params, pVarResult, pexcepinfo, puArgErr);}

STDMETHODIMP PyGPersist::GetClassID(
            /* [out] */ CLSID __RPC_FAR *pClassID)
{
	if ( pClassID == NULL )
		return PyCom_SetFromSimple(E_POINTER, GetIID());

	HRESULT hr;
	PyCom_EnterPython();
	{
		PyObject *result;
		hr = InvokeViaPolicy("GetClassID", &result);
		if ( SUCCEEDED(hr) )
		{
			hr = PyCom_CLSIDFromPyObject(result, pClassID) ? S_OK : E_FAIL;
			Py_DECREF(result);

			// register the error if necessary
			PyCom_SetFromSimple(hr, GetIID());
		}
	}
	PyCom_LeavePython();
	return hr;
}

