/*
** Registration type stuff
*/

#include "stdafx.h"
#include <comcat.h>
#include "PythonCOM.h"
#include "PythonCOMServer.h"
#include "PyIStream.h"
#include "PyIPersist.h"
#include "PyIStorage.h"
#include "PyIPersistStorage.h"
#include "PyGPersistStorage.h"
#include "PyIPersistStream.h"
#include "PyIPersistStreamInit.h"
#include "PyIMoniker.h"
#include "PyIRunningObjectTable.h"
#include "PyIBindCtx.h"
#include "PyIEnumGUID.h"
#include "PyIEnumVARIANT.h"
#include "PyICatInformation.h"
#include "PyICatRegister.h"
#include "propbag.h"
#include "PyGConnectionPoint.h"
#include "PyGConnectionPointContainer.h"
#include "PyILockBytes.h"
#include "PyIEnumSTATSTG.h"
#include "PyIExternalConnection.h"


//PyObject *CLSIDMapping;  // Maps CLSIDs onto PyClassObjects
PyObject *g_obPyCom_MapIIDToType = NULL; // map of IID's to client types.
PyObject *g_obPyCom_MapNameToType = NULL; // map of Names to client types.
PyObject *g_obPyCom_MapGatewayIIDToName = NULL; // map of IID's to names
PyObject *g_obPyCom_MapServerIIDToGateway = NULL; // map of IID's to gateways.

// Register a Python on both the UID and Name maps.
int PyCom_RegisterClientType(PyTypeObject *typeOb, const GUID *guid)
{
	int rc = PyDict_SetItemString(g_obPyCom_MapNameToType,
								  typeOb->tp_name,
								  (PyObject *)typeOb);
	if (rc==0 && guid) {
		PyObject *obiid = PyCom_PyIIDObjectFromIID(*guid);
		if (!obiid) return 1;
		rc = PyDict_SetItem(g_obPyCom_MapIIDToType, obiid, (PyObject *)typeOb);
		PyTS_DECREF(obiid);
	}
	return rc;
}

// COM Server helpers.
HRESULT PyCom_RegisterGatewayObject(REFIID iid, pfnPyGatewayConstructor ctor, const char *interfaceName)
{
	if (ctor==NULL) return E_INVALIDARG;
	if (g_obPyCom_MapServerIIDToGateway==NULL) {
		g_obPyCom_MapServerIIDToGateway = PyDict_New();
	}
	if (g_obPyCom_MapServerIIDToGateway==NULL) return E_OUTOFMEMORY;
	PyObject *keyObject = PyCom_PyIIDObjectFromIID(iid);
	if (!keyObject) return E_FAIL;
	PyObject *valueObject = PyInt_FromLong((long)ctor);
	if (!valueObject) {
		PyTS_DECREF(keyObject);
		return E_FAIL;
	}
	if (PyDict_SetItem(g_obPyCom_MapServerIIDToGateway, keyObject, valueObject)!=0) {
		PyTS_DECREF(keyObject);
		return E_FAIL;
	}
	PyTS_DECREF(valueObject);
	// Now in the other server map.
	if (g_obPyCom_MapGatewayIIDToName) {
		if (PyDict_SetItem(g_obPyCom_MapGatewayIIDToName, keyObject, PyString_FromString((char *)interfaceName))!=0) {
			PyTS_DECREF(keyObject);
			return E_FAIL;
		}
	}
	PyTS_DECREF(keyObject);
	return S_OK;
}

typedef struct
{
	const GUID *pGUID; // The supported IID - required
	const char *interfaceName; // Name of the interface - required
	const char *iidName; // Name of the IID that goes into the dict. - required
	PyTypeObject *pTypeOb; // the type object for client PyI* side - NULL for server only support.
	pfnPyGatewayConstructor ctor; // Gateway (PyG*) interface constructor - NULL for client only support

} interfaceSupportInfo;

#define PYCOM_INTERFACE_IID_ONLY(ifc)	{ &IID_I##ifc, "I" #ifc, "IID_I" #ifc, NULL, NULL  }
#define PYCOM_INTERFACE_CLSID_ONLY(ifc)	{ &CLSID_##ifc, "CLSID_" #ifc,  "CLSID_" #ifc, NULL, NULL  }
#define PYCOM_INTERFACE_CLIENT_ONLY(ifc)	{ &IID_I##ifc, "I" #ifc, "IID_I" #ifc, &PyI##ifc::type, NULL }
#define PYCOM_INTERFACE_SERVER_ONLY(ifc)	{ &IID_I##ifc, "I" #ifc, "IID_I" #ifc, NULL, &IID_I##ifc, GET_PYGATEWAY_CTOR(PyG##ifc)}
#define PYCOM_INTERFACE_FULL(ifc)	{ &IID_I##ifc, "I" #ifc, "IID_I" #ifc, &PyI##ifc::type, GET_PYGATEWAY_CTOR(PyG##ifc)}

static const interfaceSupportInfo g_interfaceSupportData[] =
{
	PYCOM_INTERFACE_CLSID_ONLY ( StdComponentCategoriesMgr ),
	// Sort alphabetically just for us poor humans!
	PYCOM_INTERFACE_CLIENT_ONLY( BindCtx),
	PYCOM_INTERFACE_CLIENT_ONLY( CatInformation),
	PYCOM_INTERFACE_CLIENT_ONLY( CatRegister),
	PYCOM_INTERFACE_FULL       ( ConnectionPoint),
	PYCOM_INTERFACE_FULL       ( ConnectionPointContainer),
	PYCOM_INTERFACE_CLIENT_ONLY( EnumCATEGORYINFO),
	PYCOM_INTERFACE_CLIENT_ONLY( EnumGUID),
	PYCOM_INTERFACE_CLIENT_ONLY( EnumMoniker),
	PYCOM_INTERFACE_FULL       ( EnumSTATSTG),
	PYCOM_INTERFACE_FULL       ( EnumVARIANT),
	PYCOM_INTERFACE_FULL       ( ErrorLog),
	PYCOM_INTERFACE_FULL       ( ExternalConnection),
	PYCOM_INTERFACE_CLIENT_ONLY( LockBytes),
	PYCOM_INTERFACE_CLIENT_ONLY( Moniker),
	PYCOM_INTERFACE_FULL       ( Persist),
	PYCOM_INTERFACE_FULL       ( PersistPropertyBag),
	PYCOM_INTERFACE_FULL       ( PersistStorage),
	PYCOM_INTERFACE_FULL       ( PersistStream),
	PYCOM_INTERFACE_FULL       ( PersistStreamInit),
	PYCOM_INTERFACE_FULL       ( PropertyBag),

	PYCOM_INTERFACE_CLIENT_ONLY( ProvideClassInfo),
	PYCOM_INTERFACE_CLIENT_ONLY( ProvideClassInfo2),
	
	PYCOM_INTERFACE_CLIENT_ONLY( RunningObjectTable),
	PYCOM_INTERFACE_CLIENT_ONLY( TypeInfo),
	PYCOM_INTERFACE_CLIENT_ONLY( TypeLib),
	PYCOM_INTERFACE_FULL       ( Storage),
	PYCOM_INTERFACE_FULL       ( Stream),

	// NULL, Unknown and dispatch special cases.
	{ &IID_NULL, "Null", "IID_NULL", NULL, NULL},
	{ &IID_IUnknown, "IUnknown", "IID_IUnknown", &PyIUnknown::type, GET_PYGATEWAY_CTOR(PyGatewayBase)},
	{ &IID_IDispatch, "IDispatch", "IID_IDispatch", &PyIDispatch::type, GET_PYGATEWAY_CTOR(PyGatewayBase) },

};

int PyCom_RegisterCoreSupport(void)
{
	extern void PyCom_InitCoreModule();
	extern PyObject *PyCom_GetCoreModuleDict();

	// Create the name and type mappings.
	g_obPyCom_MapIIDToType = PyDict_New(); // map of IID's to types.
	if (g_obPyCom_MapIIDToType==NULL) return -1;
	g_obPyCom_MapNameToType = PyDict_New(); // map of names to types.
	if (g_obPyCom_MapNameToType==NULL) return -1;
	g_obPyCom_MapGatewayIIDToName = PyDict_New();
	if (g_obPyCom_MapGatewayIIDToName==NULL) return -1;

	// Initialise the core Python module
	PyCom_InitCoreModule();
	PyObject *modDict = PyCom_GetCoreModuleDict();

	// Register all interfaces, IID's, etc
	int i;
	for ( i = sizeof(g_interfaceSupportData)/sizeof(interfaceSupportInfo); i--; ) {
		if ( g_interfaceSupportData[i].pTypeOb && PyCom_RegisterClientType(g_interfaceSupportData[i].pTypeOb, g_interfaceSupportData[i].pGUID) != 0 )
			return -1;
		if ( g_interfaceSupportData[i].ctor != NULL ) {
			HRESULT hr = PyCom_RegisterGatewayObject(*g_interfaceSupportData[i].pGUID,
													g_interfaceSupportData[i].ctor,
													g_interfaceSupportData[i].interfaceName);
			if ( FAILED(hr) )
				return -1;
		}
		// Add the IID to the core module dictionary
		PyObject *newIID = PyCom_PyIIDObjectFromIID(*g_interfaceSupportData[i].pGUID);
		if (!newIID) return -1;
		int rc = PyDict_SetItemString(modDict, (char *)g_interfaceSupportData[i].iidName, newIID);
		PyTS_DECREF(newIID);
		if (rc!=0) return -1;
	}

	return 0;
}

int PyCom_UnregisterCoreSupport(void)
{
	Py_DECREF(g_obPyCom_MapNameToType);
	g_obPyCom_MapNameToType = NULL;
	Py_DECREF(g_obPyCom_MapIIDToType);
	g_obPyCom_MapIIDToType = NULL;
	Py_DECREF(g_obPyCom_MapGatewayIIDToName);
	g_obPyCom_MapGatewayIIDToName = NULL;
	return 0;
}
