#include "windows.h"
#include "Python.h"
#include "atlbase.h"
#include "PythonCOM.h"
#include "PythonCOMServer.h"
#include "PyFactory.h"
#include "atlconv.cpp"

const char *usage = \
"Invalid command line arguments\r\n\r\n"
"This program provides LocalServer COM support for Python COM objects\r\n\r\n"
"It is typically run automatically by COM, passing as arguments\r\n"
"The ProgID or CLSID of the Python Server(s) to be hosted";

// Exported privately from PythonCOM.
PYCOM_EXPORT void PyCom_SetLockCountWaitEvent( HANDLE hEvent );
PYCOM_EXPORT void PyCom_LogF(const char *fmt, ...);

// The main thread for COM should dispatch messages, else
// risk hanging the _entire_ explorer UI :-)
// So we do, dispatching until PythonCOM.dll signals our
// event that all COM objects have died...
BOOL WaitWithMessageLoop(HANDLE hEvent)
{
	DWORD dwRet;
	MSG msg;

	while(1)
    {
		dwRet = MsgWaitForMultipleObjects( 1,    // One event to wait for
               &hEvent,        // The array of events
               FALSE,          // Wait for 1 event
               INFINITE,       // Timeout value
               QS_ALLINPUT);   // Any message wakes up
		if(dwRet == WAIT_OBJECT_0) {
			// The event was signaled, return
			return TRUE;
		} else if(dwRet == WAIT_OBJECT_0 + 1) {
			// There is a window message available. Dispatch it.
			while(PeekMessage(&msg,NULL,NULL,NULL,PM_REMOVE)) {
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
		} else {
			// Something else happened. Return.
			return FALSE;
       }
	}
}

int WINAPI WinMain(HINSTANCE, HINSTANCE, LPSTR szCmdParam, int)
{
	CPyFactory **pFactories = NULL;
	DWORD *pRegIds = NULL;
	HRESULT hr;
	USES_CONVERSION;

	int numClasses = 0;
	for (int i=1;i<__argc;i++)
		if (__argv[i][0] != '-' && __argv[i][0] != '/')
			numClasses++;

	if (numClasses==0) {
		MessageBox(0, usage, "PythonCOM Exe", MB_OK);
		return 2;
	}

	pFactories = new CPyFactory *[numClasses];
	pRegIds = new DWORD[numClasses];
	int classNum = 0;

	for (i=1;i<__argc;i++) {
		CLSID iid;
		if (__argv[i][0]=='-' || __argv[i][0]=='/') {
			continue;
		}

		if (S_OK != CLSIDFromProgID(A2W(__argv[i]), &iid)) {
			PyCom_LogF("Could not create factory for %s - bad CLSID", __argv[i]);
			return 1;
		}
		pFactories[classNum] = new CPyFactory(iid);

		// Dont want Factories to mess my DLL reference count.
		PyCom_DLLReleaseRef();

		// Probably need to look these flags up in the registry for the IID?
		hr = CoRegisterClassObject(iid, pFactories[classNum], CLSCTX_LOCAL_SERVER, REGCLS_MULTIPLEUSE|REGCLS_SUSPENDED, pRegIds+classNum);

		if (FAILED(hr)) {
			PyCom_LogF("Registration of %s class object failed - %d\n", __argv[i], hr);
			return 1;
		}
		classNum++;
	}
	HANDLE hEvent = CreateEvent(NULL, TRUE, FALSE, NULL);
	PyCom_SetLockCountWaitEvent(hEvent);
	hr = CoResumeClassObjects();
	if (FAILED(hr)) {
		PyCom_LogF("CoResumeClassObjects failed - %d\n", hr);
		return 1;
	}
	WaitWithMessageLoop(hEvent);

	for (i=0;i<numClasses;i++) {
		hr = CoRevokeClassObject(pRegIds[i]);
		if (FAILED(hr))
			PyCom_LogF("Warning - CoRevokeClassObject failed - %d\n", hr);
		PyCom_DLLAddRef(); // Screwing with rcounts - bring back to balance...
		delete pFactories[i];
	}
	delete [] pFactories;
	delete [] pRegIds;

	return 0;
}

