// PyIUnknown

// @doc
#include "stdafx.h"
#include "PythonCOM.h"
#include "PythonCOMServer.h"

extern void PyCom_LogF(const char *fmt, ...);
#define LogF PyCom_LogF

char *PyIUnknown::szErrMsgObjectReleased = "The COM object has been released.";

static LONG cUnknowns=0;

LONG _PyCom_GetInterfaceCount(void)
{
	return cUnknowns;
}

PyIUnknown::PyIUnknown(IUnknown *punk)
{
	ob_type = &type;
	m_obj = punk;
	// refcnt of object managed by caller.
	InterlockedIncrement(&cUnknowns);
	PyCom_DLLAddRef();
}

PyIUnknown::~PyIUnknown()
{
	SafeRelease(this);	
	InterlockedDecrement(&cUnknowns);
	PyCom_DLLReleaseRef();
}

PyObject * PyIUnknown::repr()
{
	char buf[80];
	wsprintf(buf, "<%s at 0x%0lx with obj at 0x%0lx>",ob_type->tp_name, (long)(PyObject *)this, (long)m_obj);
	return PyString_FromString(buf);
}

/*static void PyIUnknown::CleanupTrackList()
{
#ifdef _DEBUG
	int numInMap = m_obTrackList ? PyMapping_Length(m_obTrackList) : 0;
	LogF("Cleaning up %d COM objects...", numInMap);
	USES_CONVERSION;
	OLECHAR FAR *pythonOb = A2OLE("pythonObject");
#endif
	if (m_obTrackList) {
		AllocThreadState();
		PyObject *keys = PyMapping_Keys(m_obTrackList);
		if (keys) {
			int len = PySequence_Length(keys);
			for (int index=0;index<len;index++) {
				PyObject *intLook = PySequence_GetItem(keys, index);
				PyIUnknown *pLook = (PyIUnknown *)PyInt_AsLong(intLook);
				if (pLook) {
#ifdef NOPE_DEBUG
					const char *relDesc = pLook->m_obj ? "NOT RELEASED" : "released";
					LogF(" object <%s> at 0x%0lx, m_obj at 0x%0lx, ob_refcnt=%d, %s", pLook->ob_type->tp_name, pLook, pLook->m_obj, pLook->ob_refcnt, relDesc);
					if ( pLook->m_obj )
					{
						IDispatch *pdisp;
						HRESULT hr = pLook->m_obj->QueryInterface(IID_IDispatch, (LPVOID *)&pdisp);
						if ( SUCCEEDED(hr) )
						{
							DISPID dispid;
							hr = pdisp->GetIDsOfNames(IID_NULL, &pythonOb, 1, LOCALE_SYSTEM_DEFAULT, &dispid);
							if ( SUCCEEDED(hr) )
							{
								DISPPARAMS dispparams = { NULL, NULL, 0, 0 };
								VARIANT result;
								VariantInit(&result);
								hr = pdisp->Invoke(dispid, IID_NULL, LOCALE_SYSTEM_DEFAULT, DISPATCH_METHOD, &dispparams, &result, NULL, NULL);
								if ( SUCCEEDED(hr) && V_VT(&result) == VT_I4 )
								{
									PyObject *ob = (PyObject *)V_I4(&result);
									if ( PyInstance_Check(ob) )
									{
										LogF("   object is a Python class instance of: %s", PyString_AsString(((PyInstanceObject *)ob)->in_class->cl_name));
									}
									else
									{
										LogF("   object is a Python object of type: %s", ob->ob_type->tp_name);
									}
								}
							}

							/* successful QI; need to release it 
							pdisp->Release();
						}
					}
#endif // _DEBUG
//					SafeRelease(pLook);
				}
			}
		}
		PyTS_XDECREF(keys);
		// no need to actually remove each item from the map - just
		// remove ref to the map.
		PyTS_DECREF(m_obTrackList);
		m_obTrackList = NULL;
		FreeThreadState();
	}
#ifdef _DEBUG
	LogF("COM object cleanup complete.");
#endif
}
*/
/*static*/ IUnknown *PyIUnknown::GetI(PyObject *self)
{
	if (self==NULL) {
		OleSetError("The Python object is invalid");
		return NULL;
	}
	PyIUnknown *pPyUnk = (PyIUnknown *)self;
	if (pPyUnk->m_obj==NULL) {
		OleSetError(szErrMsgObjectReleased);
		return NULL;
	}
	return pPyUnk->m_obj;
}

/*static*/ void PyIUnknown::SafeRelease(PyIUnknown *ob)
{
	if (!ob)
		return;
	if (ob->m_obj)
	{
		long rcnt = ob->m_obj->Release();
#ifdef _DEBUG_LIFETIMES
		LogF(buf, "   SafeRelease(%ld) -> %s at 0x%0lx, IUnknown at 0x%0lx - Release() returned %ld",GetCurrentThreadId(), ob->ob_type->tp_name,ob, ob->m_obj,rcnt);
#endif
		ob->m_obj = NULL;
	}
}

// @pymethod |PyIUnknown|SafeRelease|Releases an OLE item.
PyObject *PyIUnknown::SafeRelease(PyObject *self, PyObject *args)
{
	if (!PyArg_ParseTuple(args,":SafeRelease")) return NULL;
	SafeRelease((PyIUnknown *)self);
	PyTS_INCREF(Py_None);
	return Py_None;
}

// @pymethod <o PyIUnknown>|PyIUnknown|QueryInterface|Queries an object for a specific interface.
PyObject *PyIUnknown::QueryInterface(PyObject *self, PyObject *args)
{
	PyObject *obiid;
	PyObject *obUseIID = NULL;
	// @pyparm IID|iid||The IID requested.
	// @pyparm IID|useIID|None|If provided and not None, will return an interface for the specified IID if a native interface can not be supported.
	// @comm Typically, the IID should be IID_IUnknown or IID_IDispatch.
	// This is a pretty dangerous option because the assumption is made
	// that the interface returned by QueryInterface() is derived from
	// the specified interface. This is always true for IUnknown, and is
	// always true for IDispatch with dual interfaces. Another example
	// might be to return an unsupported persistence interface as a
	// PyIPersist instance.<nl>
	// For backwards compatibility: the integer 0 implies None, and the
	// integer 1 implies IID_IUnknown.
	if (!PyArg_ParseTuple(args, "O|O:QueryInterface", &obiid, &obUseIID ))
		return NULL;

	IID	iid;
	if (!PyCom_CLSIDFromPyObject(obiid, &iid))
		return NULL;

	IID useIID;	/* used if obUseIID != NULL */

	if ( obUseIID != NULL )
	{
		if ( obUseIID == Py_None )
			obUseIID = NULL;
		else if ( PyInt_Check(obUseIID) )
		{
			if ( PyInt_AS_LONG((PyIntObject *)obUseIID) )
				useIID = IID_IUnknown;
			else
				obUseIID = NULL;
		}
		else if ( !PyCom_CLSIDFromPyObject(obUseIID, &useIID) )
			return NULL;
	}

	IUnknown *pMyUnknown = GetI(self);
	if (pMyUnknown==NULL) return NULL;

	IUnknown *punk;
	HRESULT hr = pMyUnknown->QueryInterface(iid, (LPVOID*)&punk);

	/* Note that this failure may include E_NOINTERFACE */
	if ( FAILED(hr) )
		return OleSetOleError(hr);

	/* Return a type based on the IID (with no extra ref) */
	PyObject *rc = PyCom_PyObjectFromIUnknown(punk, iid, FALSE);

	/* we may have been asked to use a different interface */
	if ( rc == NULL && obUseIID != NULL )
	{
		PyErr_Clear();
		rc = PyCom_PyObjectFromIUnknown(punk, useIID, FALSE);
	}
	return rc;
}

// @object PyIUnknown|A OLE automation client object.
static struct PyMethodDef PyIUnknown_methods[] =
{
	{ "QueryInterface", PyIUnknown::QueryInterface, 1 }, // @pymeth QueryInterface|Queries the object for an interface.
	{ "Release",        PyIUnknown::SafeRelease, 1 },
	{ "SafeRelease",    PyIUnknown::SafeRelease, 1 }, // @pymeth SafeRelease|Releases the underlying OLE object
	{NULL,  NULL}        
};

PyComTypeObject PyIUnknown::type("PyIUnknown",
                 NULL,
                 sizeof(PyIUnknown),
                 PyIUnknown_methods,
				 GET_PYCOM_CTOR(PyIUnknown));

