// MiscTypes.cpp - misc Python types.
#include "stdafx.h"
#include "PythonCOM.h"

PyComTypeObject::PyComTypeObject( const char *name, PyComTypeObject *pBase, int typeSize, struct PyMethodDef* methodList, PyIUnknown * (* thector)(IUnknown *))
{
// originally, this copied the typeobject of the parent, but as it is impossible
// to gurantee order of static object construction, I went this way.  This is 
// probably better, as is forces _all_ python objects have the same type sig.
	static PyTypeObject type_template = {
		PyObject_HEAD_INIT(&PyType_Type)
		0,													/*ob_size*/
		"PythonComTypeTemplate",											/*tp_name*/
		sizeof(PyIBase), 									/*tp_size*/
		0,													/*tp_itemsize*/
		/* methods */
		(destructor) PyIBase::dealloc, 						/*tp_dealloc*/
		0,													/*tp_print*/
		(getattrfunc) PyIBase::getattr, 					/*tp_getattr*/
		(setattrfunc) PyIBase::setattr,						/*tp_setattr*/
		0,													/*tp_compare*/
		(reprfunc)PyIBase::repr,							/*tp_repr*/
    	0,													/*tp_as_number*/
	};

	*((PyTypeObject *)this) = type_template;
	methods = methodList;
	// cast away const, as Python doesnt use it.
	tp_name = (char *)name;
	tp_basicsize = typeSize;
	baseType = pBase;
	ctor = thector;
}
PyComTypeObject::~PyComTypeObject()
{
}

/////////////////////////////////////////////////////////////////////////////
// class PyOleEmpty
PyOleEmpty::PyOleEmpty()
{
	ob_type = &PyOleEmptyType;
	_Py_NewReference(this);
}

static void empty_dealloc(PyOleEmpty *o)
{
	delete o;
}

PyTypeObject PyOleEmptyType =
{
	PyObject_HEAD_INIT(&PyType_Type)
	0,
	"PyOleEmpty",
	sizeof(PyOleEmpty),
	0,
	(destructor)empty_dealloc,  /*tp_dealloc*/
	0,                      /*tp_print*/
	0,                      /*tp_getattr*/
	0,                      /*tp_setattr*/
	0,                      /*tp_compare*/
	0,                      /*tp_repr*/
	0,                      /*tp_as_number*/
	0,                      /*tp_as_sequence*/
	0,                      /*tp_as_mapping*/
};

/////////////////////////////////////////////////////////////////////////////
// class PyOleMissing
PyOleMissing::PyOleMissing()
{
	ob_type = &PyOleMissingType;
	_Py_NewReference(this);
}

static void missing_dealloc(PyOleMissing *o)
{
	delete o;
}

PYCOM_EXPORT PyTypeObject PyOleMissingType =
{
	PyObject_HEAD_INIT(&PyType_Type)
	0,
	"PyOleMissing",
	sizeof(PyOleMissing),
	0,
	(destructor)missing_dealloc,  /*tp_dealloc*/
	0,                      /*tp_print*/
	0,                      /*tp_getattr*/
	0,                      /*tp_setattr*/
	0,                      /*tp_compare*/
	0,                      /*tp_repr*/
	0,                      /*tp_as_number*/
	0,                      /*tp_as_sequence*/
	0,                      /*tp_as_mapping*/
};
////////////////////////////////
