# esdump = Exchange Server Dump

import olemsg32
import win32com


#
# Recursive dump of folders.
#
def DumpFolder(folder, indent = 0):
	print " " * indent, folder.Name
	folders = folder.Folders
	folder = folders.GetFirst()
	while folder:
		DumpFolder(folder, indent+1)
		folder = folders.GetNext()

def DumpFolders(session):
	infostores = session.InfoStores
	print infostores
	print "There are %d infostores" % infostores.Count
	for i in range(infostores.Count):
		infostore = infostores[i+1]
		print "Infostore = ", infostore.Name
		folder = infostore.RootFolder
		DumpFolder(folder)

# Build a dictionary of property tags, so I can reverse look-up
#
PropTagsById={}
for name, val in olemsg32.ActMsgPropTags.__dict__.items():
	PropTagsById[val] = name


def TestAddress(session):
#	entry = session.GetAddressEntry("Skip")
#	print entry
	pass


def TestUser(session):
	ae = session.CurrentUser
	fields = ae.Fields
	print "User has %d fields" % fields.Count
	for f in range(len(fields)):
		field = fields[f+1]
		try:
			id = PropTagsById[field.ID]
			print "%s/%s=%s" % (field.Name, id, field.Value)
#			if field.ID==olemsg32.ActMsgPropTags.ActMsgPR_DISPLAY_NAME_A:
#				field.Value = "Hammoond"
		except KeyError:
			pass
			
#		field.Value = field.Value
#	ae.Update()
	
def test():
	session = win32com.client.Dispatch("MAPI.Session")
	session.Logon()
	try:
		TestUser(session)
		TestAddress(session)
		DumpFolders(session)
	finally:
		session.Logoff

if __name__=='__main__':
	test()
