import win32api, types
import ni, sys, win32com, win32com.client.connect
from util import CheckClean

importMsg = "**** PyCOMTest is not installed ***\n  PyCOMTest is a Python test specific COM client and server.\n  It is likely this server is not installed on this machine\n  To install the server, you must get the win32com sources\n  and build it using MS Visual C++"

error = "testPyCOMTest error"

try:
	import PyCOMTest # Generated by makepy.py from PyCOMTest.tlb
except:
	print "The PyCOMTest module can not be located."
	print importMsg
	raise sys.exc_type, sys.exc_value

import sys

verbose = 0

def TestApplyResult(fn, args, result):
	try:
		import string
		fnName = string.split(str(fn))[1]
	except:	
		fnName = str(fn)
	if verbose: 
		print "Testing ", fnName,
		pref = ""
	else:
		pref = "fn " + fnName
	try:
		rc  = apply(fn, args)
		if rc != result:
			raise error, "%s failed - result not %d but %d" % (pref, result, rc)
	except:
		raise error, "%s caused exception %s,%s" % (pref, sys.exc_type, sys.exc_value)

	if verbose: print

	
# Simple handler class.  This demo only fires one event.
class RandomEventHandler (PyCOMTest.IPyCOMTestEvent):
	def __init__(self, oobj = None):
		PyCOMTest.IPyCOMTestEvent.__init__(self, oobj)
		self.fireds = {}

	def OnFire(self, no):
		try:
			self.fireds[no] = self.fireds[no] + 1
		except KeyError:
			self.fireds[no] = 0
	def _DumpFireds(self):
		for firedId, no in self.fireds.items():
			print "ID %d fired %d times" % (firedId, no)

def TestDynamic():
	if verbose: print "Testing Dynamic"
	import win32com.client.dynamic
	o = win32com.client.dynamic.DumbDispatch("PyCOMTest.PyCOMTest")

	if verbose: print "Getting counter"
	counter = o.GetSimpleCounter()
	TestCounter(counter)

	l=[]
	TestApplyResult(o.SetVariantSafeArray, (l,), len(l))
	l=[1,2,3,4]
	TestApplyResult(o.SetVariantSafeArray, (l,), len(l))
#	TestApplyResult(o.SetIntSafeArray, (l,), len(l))       Still fails, and probably always will.


def TestGenerated():
	# Create an instance of the server.
	o=PyCOMTest.CoPyCOMTest()

	counter = o.GetSimpleCounter()
	TestCounter(counter)
	i1, i2 = o.GetMultipleInterfaces()
	if type(i1) !=win32com.pythoncom.TypeIIDs[win32com.pythoncom.IID_IDispatch] or \
           type(i2) !=win32com.pythoncom.TypeIIDs[win32com.pythoncom.IID_IDispatch]:
		# Ideally result would be a class instance, but this currently isnt done for args.
		raise error,  "GetMultipleInterfaces did not return an IDispatch"
	del i1
	del i2
	sys.exc_type = sys.exc_value = sys.exc_traceback = None

	if verbose: print "Checking var args"
	o.SetVarArgs("Hi", "There", "From", "Python", 1)
	if o.GetLastVarArgs() != (("Hi", "There", "From", "Python", 1),):
		raise error, "VarArgs failed"
	if verbose: print "Checking getting/passing IUnknown"
	if type(o.GetSetUnknown(o)) !=win32com.pythoncom.TypeIIDs[win32com.pythoncom.IID_IUnknown]:
		raise error, "GetSetUnknown failed"
	if verbose: print "Checking getting/passing IDispatch"
	if type(o.GetSetDispatch(o)) !=types.InstanceType:
		raise error, "GetSetDispatch failed"
	if verbose: print "Checking getting/passing IDispatch of known type"
	if o.GetSetInterface(o).__class__ != PyCOMTest.IPyCOMTest:
		raise error, "GetSetDispatch failed"

	TestApplyResult(o.GetSimpleSafeArray, (None,), tuple(range(10)))
	resultCheck = tuple(range(5)), tuple(range(10)), tuple(range(20))
	TestApplyResult(o.GetSafeArrays, (None, None, None), resultCheck)


	l=[1,2,3,4]
	TestApplyResult(o.SetVariantSafeArray, (l,), len(l))
	TestApplyResult(o.SetIntSafeArray, (l,), len(l))
	l=[]
	TestApplyResult(o.SetVariantSafeArray, (l,), len(l))
	TestApplyResult(o.SetIntSafeArray, (l,), len(l))
	# Tell the server to do what it does!
	TestApplyResult(o.Test, ("Key", 12), 12)
	TestApplyResult(o.Test2, (PyCOMTest.QsAttribute.Attr2,), PyCOMTest.QsAttribute.Attr2)

	# Do the connection point thing...
	# Create a connection object.
	connection = win32com.client.connect.SimpleConnection()

	session = None
	try:
		session = o.Start()
		# Create an event handler instance, and connect it to the server.
		handler = RandomEventHandler()
		connection.Connect(o, handler)
		win32api.Sleep(100)
	finally:
		# Stop the servers
		if session:
			o.Stop(session)
		if handler: handler._DumpFireds()
		# Break the connection.
		connection.Disconnect()

def TestCounter(counter):
	# Test random access into container
	if verbose: print "Testing counter"
	import rand
	for i in xrange(50):
		num = rand.rand() % len(counter)
		try:
			ret = counter[num]
			if ret != num+1:
				raise error, "Random access into element %d failed - return was %s" % (num,`ret`)
		except IndexError:	
			raise error, "** IndexError accessing collection element %d" % num

	num = 0
# Doesnt work currently??	counter.TestProperty = 1 # default second arg
# Neither does this - WTF?	counter.SetTestProperty(1,2)
	counter.LBound=1
	counter.UBound=10
	if counter.LBound <> 1 or counter.UBound<>10:
		print "** Error - counter did not keep its properties"

	bounds = counter.GetBounds()
	if bounds[0]<>1 or bounds[1]<>10:
		raise error, "** Error - counter did not give the same properties back"
	counter.SetBounds(bounds[0], bounds[1])

	for item in counter:
		num = num + 1
	if num <> len(counter):
		raise error, "*** Length of counter and loop iterations dont match ***"
	if num <> 10:
		raise error, "*** Unexpected number of loop iterations ***"

	counter = counter._enum_.Clone() # Test Clone() and enum directly
	counter.Reset()
	num = 0
	for item in counter:
		num = num + 1
	if num <> 10:
		raise error, "*** Unexpected number of loop iterations - got %d ***" % num
	if verbose: print "Finished testing counter"

def TestAll():
	try:
		# Make sure server installed
		import win32com.client.dynamic
		win32com.client.dynamic.DumbDispatch("PyCOMTest.PyCOMTest")
	except win32com.pythoncom.com_error:
		print importMsg
		return

	print "Testing Python COM Test Horse..."
	TestDynamic()
	TestGenerated()

if __name__=='__main__':
	TestAll()
	CheckClean()

