#
# Generate scripts needed for serious testing!
#
import ni, win32com, win32com.client.makepy
import win32com.test
import sys, os

genList = [
("dao3032",  "{00025E01-0000-0000-C000-000000000046}",3,0),
("msaccess", "{4AFFC9A0-5F99-101B-AF4E-00AA003F0F07}",7,0),
("PyCOMTest", "{6BCDCB60-5605-11D0-AE5F-CADD4C000000}",1,0),
("xl5en32", "{00020813-0000-0000-C000-000000000046}",1,0),
("shdocvw", "{EAB22AC0-30C1-11CF-A7EB-0000C05BAE0B}",1,0),
("olemsg32", "{3FA7DEA7-6438-101B-ACC1-00AA00423326}",1,1),
("dao350", "{00025E01-0000-0000-C000-000000000046}",4,0),
("msword8", "{00020905-0000-0000-C000-000000000046}",8,0),
("excel8", "{00020813-0000-0000-C000-000000000046}",1,2),
("msacc8", "{4AFFC9A0-5F99-101B-AF4E-00AA003F0F07}",8,0),
]

genDir = "Generated4Test"
def GetGenPath():
	import win32api
	return os.path.join(win32api.GetFullPathName(win32com.test.__path__[0]), genDir)

def GenerateFromRegistered(fname, iid, major, minor):
	tlb = win32com.pythoncom.LoadRegTypeLib(iid, major, minor)
	genPath = GetGenPath()
	try:
		os.stat(genPath)
	except os.error:
		os.mkdir(genPath)
	print fname, ": generating -",
	f = open(os.path.join(genPath, fname + ".py"), "w")
	oldOut = sys.stdout
	try:
		sys.stdout = f
		win32com.client.makepy.MakeClassesFromTypeLib(tlb,1,0)
	finally:
		sys.stdout = oldOut
		f.close()
	print "compiling -",
	fullModName = "win32com.test.%s.%s" % (genDir, fname)
	exec "import " + fullModName
	# Inject the generated module as a top level module.
	sys.modules[fname] = sys.modules[fullModName]
	print "done"
	
	
def GenerateAll():
	for args in genList:
		try:
			apply(GenerateFromRegistered, args)
		except KeyboardInterrupt:
			print "** Interrupted ***"
			break
		except win32com.pythoncom.com_error:
			print "** Could not generate test code for ", args[0]

def CleanAll():
	print "Cleaning generated test scripts..."
	try: # Clear exceptions!
		1/0
	except:
		pass
	genPath = GetGenPath()
	for args in genList:
		try:
			name = args[0]+".py"
			os.unlink(os.path.join(genPath, name))
		except os.error, details:
			if type(details)==type(()) and details[0]!=2:
				print "Could not deleted generated", name, details
		try:
			name = args[0]+".pyc"
			os.unlink(os.path.join(genPath, name))
		except os.error, details:
			if type(details)==type(()) and details[0]!=2:
				print "Could not deleted generated", name, details
	try:
		os.rmdir(genPath)
	except os.error, details:
		print "Could not delete test directory -", details

if __name__=='__main__':
	GenerateAll()
	CleanAll()
