"""Exception Handling

 Exceptions

	 To better support COM exceptions, the framework allows for an instance to be
	 raised.  This instance may have a certain number of known attributes, which are
	 translated into COM exception details.
	
	 This means, for example, that Python could raise a COM exception that includes details
	 on a Help file and location, and a description for the user.
	
	 This module provides a class which provides the necessary attributes.

"""

class Exception:
	"""An Exception object that is understood by the framework.
	
	If the framework is presented with an exception of type class,
	it looks for certain known attributes on this class to provide rich
	error information to the caller.

	It should be noted that the framework supports providing this error
	information via COM Exceptions, or via the ISupportErrorInfo interface.

	By using this class, you automatically provide rich error information to the
	server.
	"""
	def __init__(self, description = None, scode = None,
	             source = None, helpfile = None, helpContext = None,
                     desc = None):
		"""Initialize an exception
		**Params**

		description -- A string description for the exception.
		scode -- An integer scode to be returned to the server, if necessary.
		source -- A string which identifies the source of the error.
		helpfile -- A string which points to a help file which contains details on the error.
		helpContext -- An integer context in the help file.
		desc -- A short-cut for description.
		"""

		if description: self.description = description
		if desc: self.description = desc
		if scode: self.scode = scode
		if source: self.source = source
#	def __repr__(self):
#		return "<a COM Exception - desc=%s, scode=%s>" % (`self.description`, `self.scode`)
