# Originally written by Curt Hagenlocher, and various bits
# and pieces by Mark Hammond (and now Greg Stein has had
# a go too :-)

# XXX - TO DO
# XXX - Greg and Mark have some ideas for a revamp - just no
#       time - if you want to help, contact us for details.
#       Main idea is to drop the classes exported and move to a more
#       traditional data driven model.

"""Generate a .py file from an OLE TypeLibrary file.


 This module is concerned only with the actual writing of
 a .py file.  It draws on the @build@ module, which builds 
 the knowledge of a COM interface.
 
Usage:

  **makepy** [-h] [-x0|1] [-u] typelib > fname.py
  
  typelib -- A TLB, DLL, OCX, or possibly something else.
  -h -- Generate hidden methods.
  -x -- controls generation of OCX information.  
     If ommitted, type library filename is used (eg, if == .ocx)
  -u -- Attempt to convert all Unicode objects to strings.
  fname.py -- The name of the generated file.  By convention, this
     file has the same name as the typelib, but with a .py extension

"""
import os
import sys
import string
import time
import ni

from win32com import pythoncom
import build

error = "makepy.error"
makepy_version = "0.1.4" # Written to generated file.
g_bUnicodeToString = 1 # Should I convert strings to Unicode?


def ReportError(msg):
	sys.stderr.write("%s\n" % msg)


# This map is used purely for the users benefit -it shows the
# raw, underlying type of Alias/Enums, etc.  The COM implementation
# does not use this map at runtime - all Alias/Enum have already
# been translated.
mapVTToTypeString = {
	pythoncom.VT_I2: 'types.IntType',
	pythoncom.VT_I4: 'types.IntType',
	pythoncom.VT_R4: 'types.FloatType',
	pythoncom.VT_R8: 'types.FloatType',
	pythoncom.VT_BSTR: 'types.StringType',
	pythoncom.VT_BOOL: 'types.IntType',
	pythoncom.VT_VARIANT: 'types.TypeType',
	pythoncom.VT_I1: 'types.IntType',
	pythoncom.VT_UI1: 'types.IntType',
	pythoncom.VT_UI2: 'types.IntType',
	pythoncom.VT_UI4: 'types.IntType',
	pythoncom.VT_I8: 'types.LongType',
	pythoncom.VT_UI8: 'types.LongType',
	pythoncom.VT_INT: 'types.IntType',
	pythoncom.VT_DATE: 'pythoncom.PyTimeType',
	pythoncom.VT_UINT: 'types.IntType',
}

def WriteGetMapDelegation(mapName, resTypeStr = "details[0][8]", argsTypeStr = "details[0][2]"):
  print '\t\t# Delegate to %s property map' % mapName
  print '\t\ttry:'
  print '\t\t\tdetails=%s[attr]' % mapName
  print '\t\t\tif len(details)>1:'
  print '\t\t\t\tresultCLSID=details[1]'
  print '\t\t\telse:'
  print '\t\t\t\tresultCLSID=None'
  print '\t\t\treturn self._ApplyTypes_(details[0][0], %d, %s, %s, attr, resultCLSID)' % (pythoncom.DISPATCH_PROPERTYGET, resTypeStr, argsTypeStr)
  print '\t\texcept KeyError:'
  print '\t\t\tpass'

def MakeEventMethodName(eventName):
	if eventName[:2]=="On":
		return eventName
	else:
		return "On"+eventName

def WriteSinkEventMap(obj):
	print '\t\tself.__dict__["_dispid_to_func_"] = {'
	for name, entry in obj.propMapGet.items() + obj.propMapPut.items() + obj.mapFuncs.items():
		fdesc = entry.desc
		id = fdesc[0]
		print '\t\t\t%9d : self.%s,' % (entry.desc[0], MakeEventMethodName(entry.names[0]))
	print '\t\t\t}'
	print
	

# MI is used to join my writable helpers, and the OLE
# classes.
class WritableItem:
	def __cmp__(self, other):
		"Compare for sorting"	
		ret = cmp(self.order, other.order)
		if ret==0 and self.doc: ret = cmp(self.doc[0], other.doc[0])
		return ret
	def __repr__(self):
		return "OleItem: doc=%s, order=%d" % (`self.doc`, self.order)


class RecordItem(build.OleItem, WritableItem):
  order = 9
  typename = "RECORD"

  def __init__(self, typeInfo, typeAttr, doc=None, bForUser=1):
    build.OleItem.__init__(self, doc)
#    ReportError("Ignoring %s object" % self.typename)

  def WriteClass(self):
    pass

class InterfaceItem(build.OleItem, WritableItem):
  order = 4
  typename = "INTERFACE"

  def __init__(self, typeInfo, typeAttr, doc=None, bForUser=1):
    build.OleItem.__init__(self, doc)
#    ReportError("Ignoring %s object" % self.typename)

  def WriteClass(self):
    pass


class AliasItem(build.OleItem, WritableItem):
  order = 2
  typename = "ALIAS"

  def __init__(self, typeinfo, attr, doc=None, bForUser = 1):
    build.OleItem.__init__(self, doc)

    ai = attr[14]
    self.attr = attr
    if type(ai) == type(()):
      href = ai[1]
      alinfo = typeinfo.GetRefTypeInfo(href)
      self.aliasDoc = alinfo.GetDocumentation(-1)
      self.aliasAttr = alinfo.GetTypeAttr()
    else:
      self.aliasDoc = None
      self.aliasAttr = None

  def WriteAliasCode(self, aliasDict):
    # we could have been written as part of an alias dependency
    if self.bWritten:
      return

    if self.aliasDoc:
      depName = self.aliasDoc[0]
      if aliasDict.has_key(depName):
        aliasDict[depName].WriteAliasCode(aliasDict)
      print self.doc[0] + " = " + depName
    else:
      ai = self.attr[14]
      if type(ai) == type(0):
        try:
          typeStr = mapVTToTypeString[ai]
          print self.doc[0] + " = " + typeStr
        except KeyError:
          print self.doc[0] + " = None # Can't convert alias info " + str(ai)
    print
    self.bWritten = 1

class EnumerationItem(build.OleItem, WritableItem):
  order = 1
  typename = "ENUMERATION"

  def __init__(self, typeinfo, attr, doc=None, bForUser=1):
    build.OleItem.__init__(self, doc)

    self.clsid = attr[0]
    self.mapVars = {}
    typeFlags = attr[11]
    self.hidden = typeFlags & pythoncom.TYPEFLAG_FHIDDEN or \
                  typeFlags & pythoncom.TYPEFLAG_FRESTRICTED

    for j in range(attr[7]):
      vdesc = typeinfo.GetVarDesc(j)
      name = typeinfo.GetNames(vdesc[0])[0]
      self.mapVars[name] = build.MapEntry(vdesc)

  def WriteEnumerationCode(self):
#    if self.hidden:
#      return

    doc = self.doc
    if doc[0] == 'Constants':
      # Allow module named "Constants" to be imported directly
      prefix = ''
    else:
      prefix = '\t'
      print 'class ' + doc[0] + ':'
      if doc[1]:
        print '\t\"' + doc[1] + '\"\n'

    # Write in name alpha order
    names = self.mapVars.keys()
    names.sort()
    for name in names:
      entry = self.mapVars[name]
      vdesc = entry.desc
      if vdesc[4] == pythoncom.VAR_CONST:
        if type(vdesc[1])==type(0):
          if vdesc[1]==0x80000000: # special case
            use = "0x80000000"
          else:
            use = hex(vdesc[1])
        else:
          use = repr(str(vdesc[1]))
        print prefix + name + ' = ' + use
    print

class DispatchItem(build.DispatchItem, WritableItem):
	order = 3

        def __init__(self, typeinfo, attr, doc=None):
          build.DispatchItem.__init__(self, typeinfo, attr, doc)

          self.bIsSink = 0

	def WriteClass(self):
          if self.bIsSink:
            self.WriteEventSinkClassHeader()
            self.WriteCallbackClassBody()
          else:
            self.WriteClassHeader()
            self.WriteClassBody()

	def WriteClassHeader(self):
          g_gen.checkWriteDispatchBaseClass()
          doc = self.doc
          className = doc[0]
          print 'class ' + className + '(DispatchBaseClass):'
          if doc[1]: print '\t\"' + doc[1] + '\"'
          try:
            clsidStr = pythoncom.ProgIDFromCLSID(self.clsid)
          except pythoncom.com_error:
            clsidStr = str(self.clsid)
          print "\tCLSID = pythoncom.MakeIID('" + clsidStr + "')"
          print
          self.bWritten = 1

	def WriteEventSinkClassHeader(self):
		doc = self.doc
		className = doc[0]
		print 'class ' + className + ':'
		if doc[1]: print '\t\"' + doc[1] + '\"'
		try:
			clsidStr = pythoncom.ProgIDFromCLSID(self.clsid)
		except pythoncom.com_error:
			clsidStr = str(self.clsid)
		print '\tCLSID = pythoncom.MakeIID(\'' + clsidStr + '\')'
		print '\t_public_methods_ = [] # For COM Server support'
		print
		print '\tdef __init__(self, oobj = None):'
		WriteSinkEventMap(self)
		print '\tdef _query_interface_(self, iid):'
		print '\t\timport ni, win32com.server.util'
		print '\t\tif iid==self.CLSID: return win32com.server.util.wrap(self)'
		print
		self.bWritten = 1

	def WriteCallbackClassBody(self):
		print "\t# Handlers for the control"
		for name, entry in self.propMapGet.items() + self.propMapPut.items() + self.mapFuncs.items():
			fdesc = entry.desc
			id = fdesc[0]
			methName = MakeEventMethodName(entry.names[0])
			print '\tdef ' + methName + '(self' + build.BuildCallList(fdesc, entry.names, "defaultNamedOptArg", "defaultNamedNotOptArg","defaultUnnamedArg") + '):'
			if entry.doc and entry.doc[1]: print '\t\t"' + entry.doc[1] + '"'
			print "\t\tpass"
		print
		self.bWritten = 1

	def WriteClassBody(self):
		doc = self.doc
		# Write in alpha order.
		names = self.mapFuncs.keys()
		names.sort()
		defEntry = None
		specialItems = {"count":None, "item":None,"value":None} # If found, will end up with (entry, invoke_tupe)
		itemCount = None
		enumEntry = None
		for name in names:
			entry=self.mapFuncs[name]
			try:
				specialItems[string.lower(name)] = (entry, pythoncom.DISPATCH_METHOD)
			except KeyError:
				pass # Not a special name
			if entry.desc[0]==pythoncom.DISPID_VALUE: defEntry = entry
			if entry.desc[0]==pythoncom.DISPID_NEWENUM: enumEntry = entry; continue # Dont build this one now!
			if g_gen.bBuildHidden or not entry.hidden:
				if entry.GetResultName():
					print '\t# Result is of type ' + entry.GetResultName()
				if entry.wasProperty:
					print '\t# The method %s is actually a property, but must be used as a method to correctly pass the arguments' % name
				ret = self.MakeFuncMethod(entry,name)
				for line in ret:
					print line
		if self.propMap:
			print "\tdef _get_prop_map_(self):"
			print "\t\treturn {"
			names = self.propMap.keys(); names.sort()
			for key in names:
				entry = self.propMap[key]
				resultDesc = ''
				if entry.GetResultName():
					resultDesc = ' # Result is ' + entry.GetResultName()
				try:
					specialItems[string.lower(key)] = (entry, pythoncom.DISPATCH_PROPERTYGET)
				except KeyError:
					pass # Not a special name
				print '\t\t\t"%s": (%s,%s),%s' % (key,entry.desc,entry.GetResultCLSIDStr(),resultDesc)
			print "\t\t\t}"
		if self.propMapPut:
			print "\tdef _get_prop_map_put_(self):"
			print "\t\treturn {"
			names = self.propMapPut.keys(); names.sort()
			for key in names:
				print '\t\t\t"%s": (%s,None),' % (key,self.propMapPut[key].desc)
			print "\t\t\t}"
		if self.propMapGet:
			print "\tdef _get_prop_map_get_(self):"
			print "\t\treturn {"
			names = self.propMapGet.keys(); names.sort()
			for key in names:
				entry = self.propMapGet[key]
				resultDesc = ''
				if entry.GetResultName():
					resultDesc = ' # Result is ' + entry.GetResultName()
				if entry.desc[0]==pythoncom.DISPID_VALUE: defEntry = entry
				if entry.desc[0]==pythoncom.DISPID_NEWENUM: ReportError("in wrong map!"); enumEntry = entry; continue # Dont build this one now.
				try:
					specialItems[string.lower(key)] = (entry, pythoncom.DISPATCH_PROPERTYGET)
				except KeyError:
					pass # Not a special name

				print '\t\t\t"%s": (%s,%s),%s' % (key,entry.desc,entry.GetResultCLSIDStr(), resultDesc)
			print "\t\t\t}"
		if defEntry:
			print "\t# Default method for this class is '%s'" % defEntry.names[0]
			ret = self.MakeFuncMethod(defEntry,'__call__')
			for line in ret:
				print line
		elif specialItems["value"]:
			entry, invoketype = specialItems["value"]
			print '\t#This class has Value property/method - allow () access'
			print '\tdef __call__(self, *args):'
			print '\t\treturn self._get_good_object_(apply(self._oleobj_.Invoke, (0x%x, LCID, %d, 1)+args), "Value")' % (entry.desc[0], invoketype)

		if enumEntry:
			# If we have a default entry, assume enumerator is of same type
			if defEntry:
				resultCLSID = defEntry.GetResultCLSIDStr()
			else:
				resultCLSID = "None"
			print '\tdef _NewEnum(self):'
			print '\t\t"Create an enumerator from this object"'
			print '\t\treturn win32com.client.util.WrapEnum(self._oleobj_.InvokeTypes(%d,LCID,%d,(13, 10),()),%s)' % (pythoncom.DISPID_NEWENUM, enumEntry.desc[4], resultCLSID)
			print '\tdef __getitem__(self, index):'
			print '\t\t"Allow this class to be accessed as a collection"'
			print "\t\tif not self.__dict__.has_key('_enum_'):"
			print "\t\t\timport win32com.client.util"
			print "\t\t\tself.__dict__['_enum_'] = self._NewEnum()"
			print "\t\treturn self._enum_.__getitem__(index)"
		else: # Not an Enumerator, but may be an "Item/Count" based collection
			if specialItems["item"]:
				entry, invoketype = specialItems["item"]
				print '\t#This class has Item property/method which may take args - allow indexed access'
				print '\tdef __getitem__(self, item):'
				print '\t\treturn self._get_good_object_(apply(self._oleobj_.Invoke, (0x%x, LCID, %d, 1, item)), "Item")' % (entry.desc[0], invoketype)
		if specialItems["count"]:
			entry, invoketype = specialItems["count"]
			print "\t#This class has Count() prop/method - allow len(ob) to provide this"
			ret = self.MakeFuncMethod(entry,'__len__')
			for line in ret:
				print line
			# Also include a __nonzero__
			print "\t#This class has a __len__ - this is needed so 'if object:' always returns TRUE."
			print "\tdef __nonzero__(self):"
			print "\t\treturn 1"
	
		print
		self.bWritten = 1


class CoClassItem(build.OleItem, WritableItem):
  order = 5
  typename = "COCLASS"

  def __init__(self, typeinfo, attr, doc=None, sourceItem=None, dispItem=None, bForUser=1):
    build.OleItem.__init__(self, doc)
    self.sourceItem = sourceItem
    self.dispItem = dispItem
    self.clsid = attr[0]

  def WriteClass(self):
    dispItem = self.dispItem
    sourceItem = self.sourceItem
    if not dispItem is None:
      self.WriteCoClass(dispItem, sourceItem)
    if not sourceItem is None and g_gen.bBuildOCX:
      self.WriteOcxClass(dispItem, sourceItem)

  def WriteCoClass(self, dispItem, sourceItem):
    doc = self.doc
    className = doc[0]
    print 'class ' + className + ':'
    if doc and doc[1]: print '\t\"' + doc[1] + '\"'
    try:
      clsidStr = pythoncom.ProgIDFromCLSID(self.clsid)
    except pythoncom.com_error:
      clsidStr = str(self.clsid)
    print '\tCLSID = pythoncom.MakeIID(\'' + clsidStr + '\')'
    print
    if 1: # sourceItem is None:
      contextStr = "pythoncom.CLSCTX_SERVER"
    else:
      contextStr = "pythoncom.CLSCTX_ALL"
    print '\tdef __init__(self, oobj = None):'
    print '\t\tif oobj is None: oobj = pythoncom.CoCreateInstance(self.CLSID, None, ' + contextStr + ', pythoncom.IID_IDispatch)'
    print '\t\tself.__dict__["_oleobj_"] = oobj # so we dont call __setattr__'
    print '\t\tself.__dict__["_classDispatch_"] = ' + dispItem.doc[0]
    print '\t\tself.__dict__["_dispobj_"] = self._classDispatch_(oobj)'
    print
    print '\tdef __getattr__(self, attr):'
    print '\t\t"Delegate attributes to the Dispatch object for this class"'
    print '\t\treturn getattr(self._dispobj_, attr)'
    print "\tdef __setattr__(self, attr, value):"
    print "\t\tif self.__dict__.has_key(attr): self.__dict__[attr] = value; return"
    print "\t\tsetattr(self._dispobj_, attr, value)"
    print

    self.bWritten = 1

  def WriteOcxClass(self, dispItem, sourceItem):
    g_gen.checkWriteOcxBaseClass()
    doc = self.doc
    className = doc[0]
    print 'class OCX' + className + '(window.Wnd,' + sourceItem.doc[0] + '):'
    if doc and doc[1]: print '\t\"' + doc[1] + ' - OCX Wrapper\"'
    print '\tdef __init__(self):'
    print '\t\tself.__dict__["_dispobj_"] = None'
    print '\t\twindow.Wnd.__init__(self, None)'
    print '\t\t%s.__init__(self)' % (sourceItem.doc[0])

    print '\tdef CreateControl(self, windowTitle, style, rect, parent, id):'
    print '\t\tself.__dict__["_obj_"] = win32ui.CreateControl(str('+doc[0]+'.CLSID), windowTitle, style, rect, parent, id)'
    print '\t\tself.__dict__["_dispobj_"] = ' + dispItem.doc[0] + '(win32uiole.GetIDispatchForWindow(self._obj_))'
    print '\t\tself.HookOleEvents()'

    print '\tdef HookOleEvents(self):'
    print '\t\tfor dispid, method in self._dispid_to_func_.items():'
    print '\t\t\tself.HookOleEvent( method, dispid )'

    print '\tdef __getattr__(self, attr):'
    print '\t\t"Delegate attributes to the windows and the Dispatch object for this class"'
    print '\t\ttry:'
    print '\t\t\treturn window.Wnd.__getattr__(self, attr)'
    print '\t\texcept AttributeError:'
    print '\t\t\tpass'
    print '\t\treturn getattr(self._dispobj_, attr)'

    print '\tdef __setattr__(self, attr, value):'
    print '\t\tif hasattr(self.__dict__, attr):'
    print '\t\t\tself.__dict__[attr] = value'
    print '\t\t\treturn'
    print '\t\ttry:'
    print '\t\t\tif self._dispobj_: self._dispobj_.__setattr__(attr, value);return'
    print '\t\texcept AttributeError:'
    print '\t\t\tpass'
    print '\t\tself.__dict__[attr] = value'
    print


def BuildOleItemsFromType(t):
  oleItems = {}
  enumItems = {}
  aliasItems = {}
  for i in xrange(t.GetTypeInfoCount()):
    info = t.GetTypeInfo(i)
    infotype = t.GetTypeInfoType(i)
    doc = t.GetDocumentation(i)
    attr = info.GetTypeAttr()
    itemClass = None
    if infotype == pythoncom.TKIND_ENUM or infotype == pythoncom.TKIND_MODULE:
      newItem = EnumerationItem(info, attr, doc)
      enumItems[newItem.doc[0]] = newItem
    elif infotype == pythoncom.TKIND_DISPATCH:
      if not g_gen.bQuiet:
        if attr[11] & pythoncom.TYPEFLAG_FDUAL:
          ReportError("Dual interface: %s" % doc[0])
        else:
          ReportError("Dispatch interface: %s" % doc[0])
      if oleItems.has_key(attr[0]):
        continue # already built by CoClass processing.
      newItem = DispatchItem(info, attr, doc)
      oleItems[newItem.clsid] = newItem
    elif infotype == pythoncom.TKIND_INTERFACE:
      ### we can't build these
      if not g_gen.bQuiet:
        ReportError("Skipped interface: %s" % doc[0])
    elif infotype == pythoncom.TKIND_RECORD or infotype == pythoncom.TKIND_UNION:
      newItem = RecordItem(info, attr, doc)
      ### where to put the newItem ??
    elif infotype == pythoncom.TKIND_ALIAS:
      newItem = AliasItem(info, attr, doc)
      aliasItems[newItem.doc[0]] = newItem
    elif infotype == pythoncom.TKIND_COCLASS:
      # try to find the dispinterfaces for the coclass
      jDispIntf = jDispSource = jIntf = jSource = None
      for j in range(attr[8]):
        flags = info.GetImplTypeFlags(j)
        default = flags & pythoncom.IMPLTYPEFLAG_FDEFAULT
        dual = info.GetRefTypeInfo(info.GetRefTypeOfImplType(j)).GetTypeAttr()[11] & pythoncom.TYPEFLAG_FDUAL
        if flags & pythoncom.IMPLTYPEFLAG_FSOURCE:
          if default:
            jSource = j
          if not dual:
            jDispSource = j
        else:
          if default:
            jIntf = j
          if not dual:
            jDispIntf = j

      if jDispIntf is not None:
        jIntf = jDispIntf
      if jDispSource is not None:
        jSource = jDispSource

      sourceItem = dispItem = None
      if jIntf is not None:
        refType = info.GetRefTypeInfo(info.GetRefTypeOfImplType(jIntf))
        refAttr = refType.GetTypeAttr()
        if oleItems.has_key(refAttr[0]):
          dispItem = oleItems[refAttr[0]]
        else:
          dispItem = DispatchItem(refType, refAttr, refType.GetDocumentation(-1))
          oleItems[dispItem.clsid] = dispItem
      if jSource is not None:
        refType = info.GetRefTypeInfo(info.GetRefTypeOfImplType(jSource))
        refAttr = refType.GetTypeAttr()
        if oleItems.has_key(refAttr[0]):
          sourceItem = oleItems[refAttr[0]]
        else:
          sourceItem = DispatchItem(refType, refAttr, refType.GetDocumentation(-1))
          oleItems[sourceItem.clsid] = sourceItem

        ### always set this? is it possible it is already set?
        sourceItem.bIsSink = 1

      newItem = CoClassItem(info, attr, doc, sourceItem, dispItem)
      oleItems[newItem.clsid] = newItem
    else:
      ReportError("Unknown TKIND found: %d" % infotype)

  return oleItems, enumItems, aliasItems


class Generator:
  def __init__(self, typelib, bQuiet=0, bBuildOCX=1, bBuildHidden=0):
    self.bHaveWrittenDispatchBaseClass = 0
    self.bHaveWrittenOcxBaseClass = 0

    self.typelib = typelib
    self.bQuiet = bQuiet
    self.bBuildOCX = bBuildOCX
    self.bBuildHidden = bBuildHidden

  def generate(self):
    if not self.bQuiet:
      ReportError("Building Definitions...");

    oleItems, enumItems, aliasItems = BuildOleItemsFromType(self.typelib)
    moduleDoc = self.typelib.GetDocumentation(-1)
    la = self.typelib.GetLibAttr()
    if not self.bQuiet:
      ReportError("Generating Python code...");

    try:
      print '"' + moduleDoc[1] + '"'
      print
    except:
      pass
    print 'makepy_version =', `makepy_version`
    print
    print 'import ni, win32com.client.CLSIDToClass\npythoncom=win32com.pythoncom'
    print 'import types'	### not always needed
    if g_bUnicodeToString:
    	print 'from pywintypes import UnicodeType'
    print
    print '# The following 3 lines may need tweaking for the particular server'
    print '# Candidates are pythoncom.Missing and pythoncom.Empty'
    print 'defaultNamedOptArg=pythoncom.Missing'
    print 'defaultNamedNotOptArg=pythoncom.Missing'
    print 'defaultUnnamedArg=pythoncom.Missing'
    print
    print 'CLSID = pythoncom.MakeIID(\'' + str(la[0]) + '\')'
    print 'MajorVersion = ' + str(la[3])
    print 'MinorVersion = ' + str(la[4])
    print 'LibraryFlags = ' + str(la[5])
    print 'LCID = ' + hex(la[1])
    print

    list = enumItems.values()
    list.sort()
    for oleitem in list:
      ### why is this commented out? do enums always need to be written?
#     if bBuildHidden or not oleitem.hidden:
        oleitem.WriteEnumerationCode()

    list = oleItems.values()
    list.sort()
    for oleitem in list:
#		if oleitem.bWritten:
#			continue
      oleitem.WriteClass()

    list = aliasItems.values()
    if list:
      print "# The following Aliases have been generated for informational purposes only"
      for oleitem in list:
        oleitem.WriteAliasCode(aliasItems)

    # Write out _all_ my generated CLSID's in the map
    print 'CLSIDToClassMap = {'
    for item in oleItems.values():
      if item.bWritten:
        print "\t'%s' : %s," % (str(item.clsid), item.doc[0])
    print '}'
    print
    print 'win32com.client.CLSIDToClass.RegisterCLSIDsFromDict( CLSIDToClassMap )'
    print

  def checkWriteDispatchBaseClass(self):
    if not self.bHaveWrittenDispatchBaseClass:
      print "_PyIDispatchType = pythoncom.TypeIIDs[pythoncom.IID_IDispatch]"
      print
      print "class DispatchBaseClass:"
      print '\tdef __init__(self, oobj=None):'
      print '\t\tif oobj is None:'
      print '\t\t\toobj = pythoncom.new(self.CLSID)'
      print '\t\telif type(self) == type(oobj): # An instance'
      print '\t\t\toobj = oobj._oleobj_ # Must be a valid COM instance'
      print '\t\tself.__dict__["_oleobj_"] = oobj # so we dont call __setattr__'
      print

      print '\tdef _ApplyTypes_(self, dispid, wFlags, retType, argTypes, user, resultCLSID, *args):'
      print '\t\treturn self._get_good_object_(apply(self._oleobj_.InvokeTypes, (dispid, LCID, wFlags, retType, argTypes) + args), user, resultCLSID)'
      print

      # Create . operators for the class.
      mapName = "self._get_prop_map_()"
      mapNamePut = "self._get_prop_map_put_()"
      mapNameGet = "self._get_prop_map_get_()"
      print '\tdef __getattr__(self, attr):'
      WriteGetMapDelegation(mapName,'details[0][2]','()')
      WriteGetMapDelegation(mapNameGet)
      print '\t\t# Delegate to underlying _oleobj_'
      print '\t\treturn getattr(self._oleobj_, attr)'
      print "\tdef __setattr__(self, attr, value):"
      print "\t\tif self.__dict__.has_key(attr): self.__dict__[attr] = value; return"
      print "\t\t# Allow property assignment."
      print "\t\tif %s.has_key(attr):" % mapName
      print "\t\t\treturn self._oleobj_.Invoke(%s[attr][0][0], LCID, pythoncom.DISPATCH_PROPERTYPUT, 0, value)" % (mapName)
      print "\t\t# Allow property assignment."
      print "\t\tif %s.has_key(attr):" % mapNamePut
      print "\t\t\treturn self._oleobj_.Invoke(%s[attr][0][0], LCID, pythoncom.DISPATCH_PROPERTYPUT, 0, value)" % (mapNamePut)
      print "\t\traise AttributeError, attr"
      print "\tdef _get_prop_map_(self):"
      print "\t\treturn { }"
      print "\tdef _get_prop_map_get_(self):"
      print "\t\treturn { }"
      print "\tdef _get_prop_map_put_(self):"
      print "\t\treturn { }"
      print "\tdef _get_good_single_object_(self, obj, obUserName=None, resultCLSID=None):"
      print "\t\tif _PyIDispatchType==type(obj):"
      print "\t\t\treturn win32com.client.Dispatch(obj, obUserName, resultCLSID, UnicodeToString=%d)" % (g_bUnicodeToString)
      if g_bUnicodeToString:
        print "\t\telif UnicodeType==type(obj):"
        print "\t\t\treturn str(obj)"
      print "\t\treturn obj"
      print "\tdef _get_good_object_(self, obj, obUserName=None, resultCLSID=None):"
      print "\t\tif obj is None:"
      print "\t\t\treturn None"
      print "\t\telif type(obj)==type(()):"
      print "\t\t\treturn tuple(map(lambda o, s=self, oun=obUserName, rc=resultCLSID: s._get_good_single_object(o, oun, rc),  obj))"
      print "\t\telse:"
      print "\t\t\treturn self._get_good_single_object_(obj, obUserName, resultCLSID)"
      print
      self.bHaveWrittenDispatchBaseClass = 1

  def checkWriteOcxBaseClass(self):
    # Not really a base class any more.
    if not self.bHaveWrittenOcxBaseClass:
      print "import window, win32ui, win32uiole"
      print
      self.bHaveWrittenOcxBaseClass = 1

if __name__=='__main__':
	import getopt
	ocxSpec = -1
	hiddenSpec = 0
	try:
		opts, args = getopt.getopt(sys.argv[1:], 'x:hu')
		for o,a in opts:
			if o=='-x':
				try:
					ocxSpec = string.atoi(a)
				except ValueError:
					raise error, "Use -x0, -x1 or neither"
					ReportError("Generating without OCX definitions.")
			elif o=='-h':
				hiddenSpec = 1
			elif o=='-u':
				g_bUnicodeToString = 1
		if len(args)<>1:
			raise error, "only 1 library can be specified"
	except (getopt.error,error), msg:
		ReportError(msg)
		ReportError("usage: makepy [-h] [-x0|1] typelib\ntypelib may be a TLB, DLL, OCX, or possibly something else.")
		ReportError("       -x controls generation of OCX information.")
		ReportError("          If ommitted, type library filename is used (eg, if == .ocx)")
		ReportError("       -h Allows hidden methods to be generated.")
		ReportError("       -u Convert Unicode to strings.")
		sys.exit(2)
	fname = args[0]
	print '# Created by makepy.py version %s from %s' % (makepy_version,os.path.split(fname)[1])
        print '# On date: %s' % time.ctime(time.time())
	print '#\n# Command line used:', string.join(sys.argv[1:]," ")
	try:
		print
		ReportError("Loading Type Library %s..." % fname);
		typelib = pythoncom.LoadTypeLib(fname)
		
	except:
		ReportError("Unable to load type library from '%s' - %s" % (fname, `sys.exc_value`))
		sys.exit(1)
	if ocxSpec==-1:
		ocxSpec = string.lower(os.path.splitext(fname)[1])==".ocx"

		global g_gen
        g_gen = Generator(typelib, 0, ocxSpec, hiddenSpec)
        g_gen.generate()

### for backwards compat for the test suite
### note: called with: bQuiet==1 and bBuildOCX==0
def MakeClassesFromTypeLib(typelib, bQuiet, bBuildOCX):
  global g_gen
  g_gen = Generator(typelib, bQuiet, bBuildOCX)
  g_gen.generate()
  g_gen = None
