"""Utilities for working with Connections"""
import __.__.server.util, __.__.pythoncom

error = __name__ + " error"

class SimpleConnection:
	"A simple, single connection object"
	def __init__(self, coInstance = None, eventInstance = None, eventCLSID = None):
		self.cp = None
		if not coInstance is None:
			self.Connect(coInstance , eventInstance, eventCLSID)
	
	def __del__(self):
		self.Disconnect()

	def _wrap(self, obj):
		return __.__.server.util.wrap(obj)

	def Connect(self, coInstance, eventInstance, eventCLSID = None, dispatcher = None):
		try:
			oleobj = coInstance._oleobj_
		except AttributeError:
			oleobj = coInstance
		cpc=oleobj.QueryInterface(__.__.pythoncom.IID_IConnectionPointContainer)
#		if cpc is None: # Will except
#			raise error, "No ConnectionPointContainer is available"
		if eventCLSID is None: eventCLSID = eventInstance.CLSID
		comEventInstance = self._wrap(eventInstance)
		self.cp=cpc.FindConnectionPoint(eventCLSID)
		self.cookie = self.cp.Advise(comEventInstance)

	def Disconnect(self):
		if not self.cp is None:
			self.cp.Unadvise(self.cookie)
			self.cp = None		
