# This module exists to create the "best" dispatch object for a given
# object.  If "makepy" support for a given object is detected, it is
# used, otherwise a dynamic dispatch object.

# Note that if the unknown dispatch object then returns a known
# dispatch object, the known class will be used.  This contrasts
# with dynamic.Dispatch behaviour, where dynamic objects are always used.
import dynamic, CLSIDToClass, pythoncom

def Dispatch(dispatch, userName = None, resultCLSID = None, typeinfo = None, UnicodeToString=1):
  dispatch = dynamic._GetGoodDispatch(dispatch)
  if resultCLSID is None:
    try:
      typeinfo = dispatch.GetTypeInfo()
      resultCLSID = str(typeinfo.GetTypeAttr()[0])
    except pythoncom.com_error:
      pass
  if resultCLSID is not None:
    try:
      return CLSIDToClass.GetClass(resultCLSID)(dispatch)
    except KeyError: # We dont know this CLSID - ignore it
      pass

  # Return a "dynamic" object - best we can do!
  return dynamic.Dispatch(dispatch, createClass = CDispatch, typeinfo=typeinfo,UnicodeToString=UnicodeToString)

__.Dispatch = Dispatch
del Dispatch

class CDispatch(dynamic.CDispatch):
  """The dynamic class used as a last resort.
  """
  def _wrap_dispatch_(self, ob, userName = None, returnCLSID = None, UnicodeToString = 1):
    return __.Dispatch(ob, userName, returnCLSID,None,UnicodeToString)


