// dcom.cpp :
// $Id:$

/***
Note that this source file contains embedded documentation.
This documentation consists of marked up text inside the
C comments, and is prefixed with an '@' symbol.  The source
files are processed by a tool called "autoduck" which
generates Windows .hlp files.
@doc
***/

#define _WIN32_DCOM
#include "Windows.h"
#include <objbase.h>
#include <comcat.h>
#include <comdef.h>
#include "Python.h"
#include <atlbase.h>
#include "PythonCOM.h"
#include "PythonCOMServer.h"
#include <atlconv.cpp>


// @pymethod <o PyIUnknown>|dcom|CoCreateInstanceEx|Create a new instance of an OLE automation server possibly on a remote machine.
static PyObject *dcom_CoCreateInstanceEx(PyObject *self, PyObject *args)
{
	PyObject *obCLSID;
	PyObject *obUnk;
	PyObject *obCoServer;
	DWORD dwClsContext;
	PyObject *obrgiids;
	CLSID clsid;
	IUnknown *punk;
	if (!PyArg_ParseTuple(args, "OOiOO:CoCreateInstanceEx",
		&obCLSID,
		&obUnk,
		&dwClsContext,
		&obCoServer,
		&obrgiids))
		return NULL;
	if (obCoServer != Py_None) {
		PyErr_SetString(PyExc_TypeError, "Only None is supported for SERVERINFO");
		return NULL;
	}
	if (!PyCom_CLSIDFromPyObject(obCLSID, &clsid))
		return NULL;
	if (!PyCom_IUnknownFromPyObject(obUnk, &punk))
		return NULL;

	if (!PySequence_Check(obrgiids)) {
		PyErr_SetString(PyExc_TypeError, "IID's must be sequence of IID objects");
		return NULL;
	}
	int numIIDs = PySequence_Length(obrgiids);

	IID *iids = new IID[numIIDs];
	MULTI_QI *mqi = new MULTI_QI[numIIDs];
	if (iids==NULL || mqi==NULL) {
		delete [] iids;
		delete [] mqi;
		PyErr_SetString(PyExc_MemoryError, "Allocating MULTIQI array");
		return NULL;
	}

	BOOL ok = TRUE;
	for (int i=0;ok && i<numIIDs;i++) {
		PyObject *me = PySequence_GetItem(obrgiids, i);
		ok = (me != NULL);
		if (ok) {
			ok = PyCom_CLSIDFromPyObject(me, iids+i);
			if (ok) {
				mqi[i].pIID = iids+i;
				mqi[i].pItf = NULL;
				mqi[i].hr = 0;
			}
			Py_DECREF(me);
		}
	}
	HRESULT hr;
	if (ok) {
		hr = CoCreateInstanceEx(clsid, punk, dwClsContext, NULL, numIIDs, mqi);
		if (FAILED(hr)) {
			ok = FALSE;
			OleSetOleError(hr);
		}
	}
	PyObject *result;
	if (ok)	{
		result = PyTuple_New(numIIDs);
		ok = (result!=NULL);
		for (i=0;ok && i<numIIDs;i++) {
			PyObject *obNew;
			if (mqi[i].hr==0)
				obNew = PyCom_PyObjectFromIUnknown(mqi[i].pItf, *mqi[i].pIID, FALSE);
			else {
				obNew = Py_None;
				Py_INCREF(Py_None);
			}
			PyTuple_SET_ITEM(result, i, obNew);
		}
	} else
		result = NULL;

	delete [] iids;
	delete [] mqi;
	return result;
}

// @pymethod |dcom|CoInitializeEx|Initialize OLE with additional options.
static PyObject *dcom_CoInitializeEx(PyObject *self, PyObject *args)
{
	DWORD flags;
	if (!PyArg_ParseTuple(args, "l:CoInitializeEx", &flags))
		return NULL;
	HRESULT hr = CoInitializeEx(NULL, flags);
	return PyInt_FromLong(hr);
}

// @pymethod |dcom|CoResumeClassObjects|Called by a server that can register multiple class objects to inform the OLE SCM about all registered classes, and permits activation requests for those class objects. 
static PyObject *dcom_CoResumeClassObjects(PyObject *self, PyObject *args)
{
	if (!PyArg_ParseTuple(args, ":CoResumeClassObjects"))
		return NULL;
	HRESULT hr = CoResumeClassObjects();
	Py_INCREF(Py_None);
	return Py_None;
}

/* List of module functions */
// @object pythoncom|A module, encapsulating the OLE automation API
static struct PyMethodDef pythoncom_methods[]=
{
	{ "CoCreateInstanceEx",    dcom_CoCreateInstanceEx, 1 },    // @pymeth CoCreateInstanceEx|Create a new instance of an OLE automation server possibly on a remote machine.
	{ "CoInitializeEx",	       dcom_CoInitializeEx, 1 },    // @pymeth CoInitializeEx|
	{ "CoResumeClassObjects",  dcom_CoResumeClassObjects, 1}, // @pymeth CoResumeClassObjects|Called by a server that can register multiple class objects to inform the OLE SCM about all registered classes, and permits activation requests for those class objects. 
	{ NULL, NULL }
};


static char *modName = "dcom";


/* Module initialisation */
extern "C" __declspec(dllexport) void initdcom()
{
	static PyObject *oModule = NULL;
	if (oModule) return;

	// Create the module and add the functions
	oModule = Py_InitModule(modName, pythoncom_methods);

//	PyObject *dict = PyModule_GetDict(oModule);
}
