/* File : PyIMAPIProp.i */

%module IMAPIProp // An COM interface to MAPI

%include "typemaps.i"
%include "pywin32.i"
%include "pythoncom.i"
%include "mapilib.i"

%{

#include "PyIMAPIProp.h"

PyIMAPIProp::PyIMAPIProp(IUnknown *pDisp) :
	PyIUnknown(pDisp)
{
	ob_type = &type;
}

PyIMAPIProp::~PyIMAPIProp()
{
}

/*static*/ IMAPIProp *PyIMAPIProp::GetI(PyObject *self)
{
	return (IMAPIProp *)PyIUnknown::GetI(self);
}

// @pyswig int, [items, ]|GetProps|Returns a list of property values.
PyObject *PyIMAPIProp::GetProps(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    HRESULT  _result;
    SPropTagArray * _arg0;
    unsigned long  _arg1;
    PyObject * _obj0 = 0;

	IMAPIProp *_swig_self;
	if ((_swig_self=GetI(self))==NULL) return NULL;
	// @pyparm <o PySPropTagArray>|propList||The list of properties
	// @pyparm int|flags||
    if(!PyArg_ParseTuple(args,"Ol:GetProps",&_obj0,&_arg1)) 
        return NULL;
	if (!PyMAPIObject_AsSPropTagArray(_obj0, &_arg0))
		return NULL;
	ULONG numValues;
	SPropValue *pv;
    _result = (HRESULT )_swig_self->GetProps(_arg0,_arg1, &numValues, &pv);
	PyMAPIObject_FreeSPropTagArray(_arg0);
    if (FAILED(_result))  {
       return OleSetOleError(_result);
    }

	_resultobj = PyTuple_New(numValues);
	if (_resultobj==NULL) {
		PyErr_SetString(PyExc_MemoryError, "Allocating SRowSet result");
		return NULL;
	}
	for (ULONG i=0;i<numValues;i++) {
		PyObject *newOb = PyMAPIObject_FromSPropValue(pv+i);
		if (newOb==NULL) {
			Py_DECREF(_resultobj);
			return NULL;
		}
		PyTuple_SetItem(_resultobj, i, newOb);
	}
	PyObject *realrc = Py_BuildValue("iO", _result, _resultobj);
	Py_DECREF(_resultobj);
	return realrc;
}

// @pyswig int, [problems, ]|DeleteProps|Deletes a set of properties.
PyObject *PyIMAPIProp::DeleteProps(PyObject *self, PyObject *args) 
{
	PyObject *obs;
    SPropTagArray * _arg0;
	HRESULT hr;
	IMAPIProp *pMAPIProp;
	if ((pMAPIProp=GetI(self))==NULL) return NULL;
	PyObject *myob = NULL;
	// @pyparm <o PySPropTagArray>|propList||The list of properties
    if(!PyArg_ParseTuple(args,"O:DeleteProps",&obs))
		return NULL;
	if (!PyMAPIObject_AsSPropTagArray(obs, &_arg0))
		return NULL;
	hr = pMAPIProp->DeleteProps( _arg0, NULL);
	PyMAPIObject_FreeSPropTagArray(_arg0);
	if (FAILED(hr))
		return OleSetOleError(hr);
	return Py_BuildValue("iz", hr, NULL); // None used as place holder for problem array later.
}

// @pyswig int, [problems, ]|SetProps|Sets a set of properties.
PyObject *PyIMAPIProp::SetProps(PyObject *self, PyObject *args) 
{
	PyObject *obs;
	HRESULT hr;
	IMAPIProp *pMAPIProp;
	if ((pMAPIProp=GetI(self))==NULL) return NULL;
	PyObject *myob = NULL;
	// @pyparm [<o PySPropValue>, ]|propList||The list of properties
    if(!PyArg_ParseTuple(args,"O:SetProps",&obs))
		return NULL;
	if (!PySequence_Check(obs)) {
		PyErr_SetString(PyExc_TypeError, "Properties must be a sequence of tuples");
		return NULL;
	}
	int seqLen = PySequence_Length(obs);
	SPropValue *pPV;
	if (S_OK != (hr=MAPIAllocateBuffer(sizeof(SPropValue) * seqLen, (void **)&pPV)))
		return OleSetOleError(hr);
	for (ULONG i=0;i<(ULONG)seqLen;i++) {
		myob = PySequence_GetItem(obs, i);
		if (myob==NULL)	{
			MAPIFreeBuffer(pPV);
			return NULL;
		}
		BOOL rc = PyMAPIObject_AsSPropValue(myob, pPV+i, pPV);
		Py_DECREF(myob);
		if (!rc) {
			MAPIFreeBuffer(pPV);
			return NULL;
		}
	}
	hr = pMAPIProp->SetProps( seqLen, pPV, NULL);
	MAPIFreeBuffer(pPV);
	if (FAILED(hr))
		return OleSetOleError(hr);
	return Py_BuildValue("iz", hr, NULL); // None used as place holder for proplem array later.
}

// @pyswig int, [problems, ]|CopyTo|Copies an object to another
PyObject *PyIMAPIProp::CopyTo(PyObject *self, PyObject *args) 
{
	IID *pExclude = NULL;
	ULONG ciidExclude = 0;
	IID iid;
	IUnknown *pUnk = NULL;
	SPropTagArray *pta = NULL;
	PyObject *result = NULL;
	PyObject *obIIDExclude, *obPropTags, *obDest, *obIID;
	ULONG ulUIParm, flags;
	char *szIgnore;
	HRESULT hr;
	IMAPIProp *pMAPIProp;
	if ((pMAPIProp=GetI(self))==NULL) return NULL;
	// @pyparm [<o PyIID>, ]|IIDExcludeList||A sequence of IIDs to exclude.
	// @pyparm <o PySPropTagArray>|propTags||The property tags to copy
	// @pyparm int|uiFlags||Flags for the progress object
	// @pyparm None|progress||Reserved - must pass None
	// @pyparm <o PyIID>|resultIID||IID of the destination object
	// @pyparm <o PyIMAPIProp>|dest||The destination object
	// @pyparm int|flags||flags
    if(!PyArg_ParseTuple(args,"OOlzOOl:CopyTo",&obIIDExclude, &obPropTags, &ulUIParm, &szIgnore, &obIID, &obDest, &flags))
		return NULL;
	if (obIIDExclude==Py_None)
		pExclude = NULL;
	else {
		if (!PySequence_Check(obIIDExclude)) {
			OleSetTypeError("Argument 1 must be a sequence of IID's, or None");
			goto error;
		}
		ciidExclude = PySequence_Length(obIIDExclude);
		pExclude = new IID[ciidExclude];
		if (pExclude==NULL) {
			OleSetMemoryError("Allocating array of IID's");
			goto error;
		}
		for (ULONG i=0;i<ciidExclude;i++) {
			PyObject *ob = PySequence_GetItem(obIIDExclude, (int)i);
			BOOL ok = PyCom_CLSIDFromPyObject(ob, pExclude+i);
			Py_XDECREF(ob);
			if (!ok) {
				goto error;
			}
		}
	}
	// PropTagArray
	if (!PyMAPIObject_AsSPropTagArray(obPropTags, &pta))
		goto error;
	// IID.
	if (!PyCom_CLSIDFromPyObject(obIID, &iid))
		goto error;
	// IUnknown.
	if (!PyCom_InterfaceFromPyInstanceOrObject(obDest, IID_IUnknown, (void **)&pUnk, 0))
		goto error;
	// Finally make the call.
	hr = pMAPIProp->CopyTo(ciidExclude, pExclude, pta, ulUIParm, NULL, &iid, (void *)pUnk, flags, NULL );
	if (FAILED(hr)) {
		OleSetOleError(hr);
		goto error;
	}
	result = Py_BuildValue("iz", hr, NULL);
error:
	free(pExclude);
	PyMAPIObject_FreeSPropTagArray(pta);
	if (pUnk)
		pUnk->Release();
	return result;
}

// @pyswig int, [problems, ]|CopyProps|Copies a set of properties to another object
PyObject *PyIMAPIProp::CopyProps(PyObject *self, PyObject *args) 
{
	IID iid;
	IUnknown *pUnk = NULL;
	SPropTagArray *pta = NULL;
	PyObject *result = NULL;
	PyObject *obPropTags, *obDest, *obIID;
	ULONG ulUIParm, flags;
	char *szIgnore;
	HRESULT hr;
	IMAPIProp *pMAPIProp;
	if ((pMAPIProp=GetI(self))==NULL) return NULL;
	// @pyparm <o PySPropTagArray>|propTags||The property tags to copy
	// @pyparm int|uiFlags||Flags for the progress object
	// @pyparm None|progress||Reserved - must pass None
	// @pyparm <o PyIID>|resultIID||IID of the destination object
	// @pyparm <o PyIMAPIProp>|dest||The destination object
	// @pyparm int|flags||flags
    if(!PyArg_ParseTuple(args,"OlzOOl:CopyProps",&obPropTags, &ulUIParm, &szIgnore, &obIID, &obDest, &flags))
		return NULL;
	// PropTagArray
	if (!PyMAPIObject_AsSPropTagArray(obPropTags, &pta))
		goto error;
	// IID.
	if (!PyCom_CLSIDFromPyObject(obIID, &iid))
		goto error;
	// IUnknown.
	if (!PyCom_InterfaceFromPyInstanceOrObject(obDest, IID_IUnknown, (void **)&pUnk, 0))
		goto error;
	// Finally make the call.
	hr = pMAPIProp->CopyProps(pta, ulUIParm, NULL, &iid, (void *)pUnk, flags, NULL );
	if (FAILED(hr)) {
		OleSetOleError(hr);
		goto error;
	}
	result = Py_BuildValue("iz", hr, NULL);
error:
	PyMAPIObject_FreeSPropTagArray(pta);
	if (pUnk)
		pUnk->Release();
	return result;
}

// @pyswig <o PySPropTagArray>|GetIDsFromNames|Determines property IDs
PyObject *PyIMAPIProp::GetIDsFromNames(PyObject *self, PyObject *args)
{
	PyObject *obNameIds;
	ULONG flags;
	// @pyparm PyMAPINAMEIDArray|nameIds||Sequence of name ids
	// @pyparm int|flags||
	if (!PyArg_ParseTuple(args, "Ol:GetIDsFromNames", &obNameIds, &flags))
		return NULL;
	MAPINAMEID **ppIds;
	ULONG numIds = 0;
	IMAPIProp *pMAPIProp;
	if ((pMAPIProp=GetI(self))==NULL) return NULL;
	if (!PyMAPIObject_AsMAPINAMEIDArray(obNameIds, &ppIds, &numIds, TRUE))
		return NULL;
	SPropTagArray *pTagResult;
	HRESULT hr = pMAPIProp->GetIDsFromNames(numIds, ppIds, flags, &pTagResult);
	PyMAPIObject_FreeMAPINAMEIDArray(ppIds);
	if (FAILED(hr))
		return OleSetOleError(hr);
	PyObject *rc = PyMAPIObject_FromSPropTagArray(pTagResult);
	MAPIFreeBuffer(pTagResult);
	return rc;
}
%}


// @pyswig <o MAPIERROR>|GetLastError|Returns the last error code for the object.
// @pyparm int|hr||Contains the error code generated in the previous method call.
// @pyparm int|flags||Indicates for format for the output.
HRESULT GetLastError(HRESULT hr, unsigned long flags, MAPIERROR **OUTPUT);

// @pyswig |SaveChanges|Saves pending changes to the object
// @pyparm int|flags||flags
HRESULT SaveChanges(unsigned long flags);

%native(GetProps) GetProps; // GetProps manually done :-(

%native(SetProps) SetProps;

%native(CopyTo) CopyTo;

%native(CopyProps) CopyProps;

%native(DeleteProps) DeleteProps;

%native(GetIDsFromNames) GetIDsFromNames;

// @pyswig <o PySPropTagArray>|GetPropList|Gets a list of properties
// @pyparm int|flags||flags
HRESULT GetPropList(
	unsigned long ulFlags,
	SPropTagArray **OUTPUT
);

// HRESULT OpenProperty( ULONG ulPropTag, LPCIID lpiid, ULONG ulInterfaceOptions, ULONG ulFlags, LPUNKNOWN FAR * lppUnk )


// HRESULT CopyTo( ULONG ciidExclude, LPCIID rgiidExclude, LPSPropTagArray lpExcludeProps, ULONG ulUIParam, LPMAPIPROGRESS lpProgress, LPCIID lpInterface, LPVOID lpDestObj, ULONG ulFlags,   LPSPropProblemArray FAR * lppProblems );

// HRESULT GetNamesFromIDs( LPSPropTagArray FAR * lppPropTags, LPGUID lpPropSetGuid, ULONG ulFlags, ULONG FAR * lpcPropNames, LPMAPINAMEID FAR * FAR * lpppPropNames );

// HRESULT GetIDsFromNames( ULONG cPropNames, LPMAPINAMEID FAR * lppPropNames, ULONG ulFlags, LPSPropTagArray FAR * lppPropTags );
