/* File : PyIMAPIContainer.i */

%module IMAPIContainer // An COM interface to MAPI

%include "typemaps.i"
%include "pywin32.i"
%include "pythoncom.i"
%include "mapilib.i"

%{

#include "PyIMAPIProp.h"
#include "PyIMAPIContainer.h"

PyIMAPIContainer::PyIMAPIContainer(IUnknown *pDisp) :
	PyIMAPIProp(pDisp)
{
	ob_type = &type;
}

PyIMAPIContainer::~PyIMAPIContainer()
{
}

/*static*/ IMAPIContainer *PyIMAPIContainer::GetI(PyObject *self)
{
	return (IMAPIContainer *)PyIUnknown::GetI(self);
}

PyObject *PyIMAPIContainer::OpenEntry(PyObject *self, PyObject *args) 
{
    HRESULT  _result;
    char * entryString;
	int entryStrLen;
    IID iid;
	IID *pIID;
    PyObject * objIID = 0;
    unsigned long  flags;
    IUnknown * pUnk = NULL;
	ULONG resType;
	PyObject *obEntry;

	IMAPIContainer *_swig_self;
	if ((_swig_self=GetI(self))==NULL) return NULL;
    if(!PyArg_ParseTuple(args,"OOl:OpenEntry",&obEntry, &objIID,&flags)) 
        return NULL;
	if (obEntry==Py_None) {
		entryString = NULL;
		entryStrLen = 0;
	} else if PyString_Check(obEntry) {
		entryString = PyString_AsString(obEntry);
		entryStrLen = PyString_Size(obEntry);
	} else {
		PyErr_SetString(PyExc_TypeError, "EntryID must be a string or None");
		return NULL;
	}
	if (objIID==Py_None)
		pIID = NULL;
	else {
		pIID = &iid;
		if (!PyCom_CLSIDFromPyObject(objIID, pIID))
			return NULL;
	}
     _result = (HRESULT )_swig_self->OpenEntry(entryStrLen,(ENTRYID *)entryString,pIID,flags, &resType, &pUnk);
     if (FAILED(_result)) {
           return OleSetOleError(_result);
     }
	 return PyMAPIObject_FromTypedUnknown( resType, pUnk, FALSE /*bAddRef*/);
}


%}

HRESULT GetContentsTable( unsigned long ulFlags, IMAPITable **OUTPUT);
HRESULT GetHierarchyTable( unsigned long ulFlags, IMAPITable **OUTPUT);

%native(OpenEntry) OpenEntry; // OpenEntry manually done :-(

