MV_FLAG         = 0x1000          # Multi-value flag 

PT_UNSPECIFIED  = 0
PT_NULL         = 1
PT_I2           = 2
PT_LONG         = 3
PT_R4           = 4
PT_DOUBLE       = 5
PT_CURRENCY     = 6
PT_APPTIME      = 7
PT_ERROR        = 10
PT_BOOLEAN      = 11
PT_OBJECT       = 13
PT_I8           = 20
PT_STRING8      = 30
PT_UNICODE      = 31
PT_SYSTIME      = 64
PT_CLSID        = 72
PT_BINARY       = 258

PT_SHORT    = PT_I2
PT_I4       = PT_LONG
PT_FLOAT    = PT_R4
PT_R8       = PT_DOUBLE
PT_LONGLONG = PT_I8

PT_MV_I2        = (MV_FLAG|PT_I2)
PT_MV_LONG      = (MV_FLAG|PT_LONG)
PT_MV_R4        = (MV_FLAG|PT_R4)
PT_MV_DOUBLE    = (MV_FLAG|PT_DOUBLE)
PT_MV_CURRENCY  = (MV_FLAG|PT_CURRENCY)
PT_MV_APPTIME   = (MV_FLAG|PT_APPTIME)
PT_MV_SYSTIME   = (MV_FLAG|PT_SYSTIME)
PT_MV_STRING8   = (MV_FLAG|PT_STRING8)
PT_MV_BINARY    = (MV_FLAG|PT_BINARY)
PT_MV_UNICODE   = (MV_FLAG|PT_UNICODE)
PT_MV_CLSID     = (MV_FLAG|PT_CLSID)
PT_MV_I8        = (MV_FLAG|PT_I8)

PT_MV_SHORT     = PT_MV_I2
PT_MV_I4        = PT_MV_LONG
PT_MV_FLOAT     = PT_MV_R4
PT_MV_R8        = PT_MV_DOUBLE
PT_MV_LONGLONG  = PT_MV_I8

PT_TSTRING = PT_UNICODE # ???
PT_MV_TSTRING =  (MV_FLAG|PT_UNICODE)


PROP_TYPE_MASK          = 0x0000FFFF # Mask for Property type

def PROP_TYPE(ulPropTag):
	return ulPropTag & PROP_TYPE_MASK

def PROP_ID(ulPropTag):
	return ulPropTag>>16

def PROP_TAG(ulPropType,ulPropID):
	return (ulPropID<<16)|(ulPropType)

PROP_ID_NULL            = 0
PROP_ID_INVALID         = 0xFFFF
PR_NULL                 = PROP_TAG( PT_NULL, PROP_ID_NULL)


PR_ACKNOWLEDGEMENT_MODE                     = PROP_TAG( PT_LONG,      0x0001)
PR_ACKNOWLEDGEMENT_MODE                     = PROP_TAG( PT_LONG,      0x0001)
PR_ALTERNATE_RECIPIENT_ALLOWED              = PROP_TAG( PT_BOOLEAN,   0x0002)
PR_AUTHORIZING_USERS                        = PROP_TAG( PT_BINARY,    0x0003)
PR_AUTO_FORWARD_COMMENT                     = PROP_TAG( PT_TSTRING,   0x0004)
PR_AUTO_FORWARD_COMMENT_W                   = PROP_TAG( PT_UNICODE,   0x0004)
PR_AUTO_FORWARD_COMMENT_W                   = PROP_TAG( PT_UNICODE,   0x0004)
PR_AUTO_FORWARD_COMMENT_A                   = PROP_TAG( PT_STRING8,   0x0004)
PR_AUTO_FORWARDED                           = PROP_TAG( PT_BOOLEAN,   0x0005)
PR_CONTENT_CONFIDENTIALITY_ALGORITHM_ID     = PROP_TAG( PT_BINARY,    0x0006)
PR_CONTENT_CORRELATOR                       = PROP_TAG( PT_BINARY,    0x0007)
PR_CONTENT_IDENTIFIER                       = PROP_TAG( PT_TSTRING,   0x0008)
PR_CONTENT_IDENTIFIER_W                     = PROP_TAG( PT_UNICODE,   0x0008)
PR_CONTENT_IDENTIFIER_A                     = PROP_TAG( PT_STRING8,   0x0008)
PR_CONTENT_LENGTH                           = PROP_TAG( PT_LONG,      0x0009)
PR_CONTENT_RETURN_REQUESTED                 = PROP_TAG( PT_BOOLEAN,   0x000A)
PR_CONVERSATION_KEY                         = PROP_TAG( PT_BINARY,    0x000B)
PR_CONVERSION_EITS                          = PROP_TAG( PT_BINARY,    0x000C)
PR_CONVERSION_WITH_LOSS_PROHIBITED          = PROP_TAG( PT_BOOLEAN,   0x000D)
PR_CONVERTED_EITS                           = PROP_TAG( PT_BINARY,    0x000E)
PR_DEFERRED_DELIVERY_TIME                   = PROP_TAG( PT_SYSTIME,   0x000F)
PR_DELIVER_TIME                             = PROP_TAG( PT_SYSTIME,   0x0010)
PR_DISCARD_REASON                           = PROP_TAG( PT_LONG,      0x0011)
PR_DISCLOSURE_OF_RECIPIENTS                 = PROP_TAG( PT_BOOLEAN,   0x0012)
PR_DL_EXPANSION_HISTORY                     = PROP_TAG( PT_BINARY,    0x0013)
PR_DL_EXPANSION_PROHIBITED                  = PROP_TAG( PT_BOOLEAN,   0x0014)
PR_EXPIRY_TIME                              = PROP_TAG( PT_SYSTIME,   0x0015)
PR_IMPLICIT_CONVERSION_PROHIBITED           = PROP_TAG( PT_BOOLEAN,   0x0016)
PR_IMPORTANCE                               = PROP_TAG( PT_LONG,      0x0017)
PR_IPM_ID                                   = PROP_TAG( PT_BINARY,    0x0018)
PR_LATEST_DELIVERY_TIME                     = PROP_TAG( PT_SYSTIME,   0x0019)
PR_MESSAGE_CLASS                            = PROP_TAG( PT_TSTRING,   0x001A)
PR_MESSAGE_CLASS_W                          = PROP_TAG( PT_UNICODE,   0x001A)
PR_MESSAGE_CLASS_A                          = PROP_TAG( PT_STRING8,   0x001A)
PR_MESSAGE_DELIVERY_ID                      = PROP_TAG( PT_BINARY,    0x001B)
PR_MESSAGE_SECURITY_LABEL                   = PROP_TAG( PT_BINARY,    0x001E)
PR_OBSOLETED_IPMS                           = PROP_TAG( PT_BINARY,    0x001F)
PR_ORIGINALLY_INTENDED_RECIPIENT_NAME       = PROP_TAG( PT_BINARY,    0x0020)
PR_ORIGINAL_EITS                            = PROP_TAG( PT_BINARY,    0x0021)
PR_ORIGINATOR_CERTIFICATE                   = PROP_TAG( PT_BINARY,    0x0022)
PR_ORIGINATOR_DELIVERY_REPORT_REQUESTED     = PROP_TAG( PT_BOOLEAN,   0x0023)
PR_ORIGINATOR_RETURN_ADDRESS                = PROP_TAG( PT_BINARY,    0x0024)
PR_PARENT_KEY                               = PROP_TAG( PT_BINARY,    0x0025)
PR_PRIORITY                                 = PROP_TAG( PT_LONG,      0x0026)
PR_ORIGIN_CHECK                             = PROP_TAG( PT_BINARY,    0x0027)
PR_PROOF_OF_SUBMISSION_REQUESTED            = PROP_TAG( PT_BOOLEAN,   0x0028)
PR_READ_RECEIPT_REQUESTED                   = PROP_TAG( PT_BOOLEAN,   0x0029)
PR_RECEIPT_TIME                             = PROP_TAG( PT_SYSTIME,   0x002A)
PR_RECIPIENT_REASSIGNMENT_PROHIBITED        = PROP_TAG( PT_BOOLEAN,   0x002B)
PR_REDIRECTION_HISTORY                      = PROP_TAG( PT_BINARY,    0x002C)
PR_RELATED_IPMS                             = PROP_TAG( PT_BINARY,    0x002D)
PR_ORIGINAL_SENSITIVITY                     = PROP_TAG( PT_LONG,      0x002E)
PR_LANGUAGES                                = PROP_TAG( PT_TSTRING,   0x002F)
PR_LANGUAGES_W                              = PROP_TAG( PT_UNICODE,   0x002F)
PR_LANGUAGES_A                              = PROP_TAG( PT_STRING8,   0x002F)
PR_REPLY_TIME                               = PROP_TAG( PT_SYSTIME,   0x0030)
PR_REPORT_TAG                               = PROP_TAG( PT_BINARY,    0x0031)
PR_REPORT_TIME                              = PROP_TAG( PT_SYSTIME,   0x0032)
PR_RETURNED_IPM                             = PROP_TAG( PT_BOOLEAN,   0x0033)
PR_SECURITY                                 = PROP_TAG( PT_LONG,      0x0034)
PR_INCOMPLETE_COPY                          = PROP_TAG( PT_BOOLEAN,   0x0035)
PR_SENSITIVITY                              = PROP_TAG( PT_LONG,      0x0036)
PR_SUBJECT                                  = PROP_TAG( PT_TSTRING,   0x0037)
PR_SUBJECT_W                                = PROP_TAG( PT_UNICODE,   0x0037)
PR_SUBJECT_A                                = PROP_TAG( PT_STRING8,   0x0037)
PR_SUBJECT_IPM                              = PROP_TAG( PT_BINARY,    0x0038)
PR_CLIENT_SUBMIT_TIME                       = PROP_TAG( PT_SYSTIME,   0x0039)
PR_REPORT_NAME                              = PROP_TAG( PT_TSTRING,   0x003A)
PR_REPORT_NAME_W                            = PROP_TAG( PT_UNICODE,   0x003A)
PR_REPORT_NAME_A                            = PROP_TAG( PT_STRING8,   0x003A)
PR_SENT_REPRESENTING_SEARCH_KEY             = PROP_TAG( PT_BINARY,    0x003B)
PR_X400_CONTENT_TYPE                        = PROP_TAG( PT_BINARY,    0x003C)
PR_SUBJECT_PREFIX                           = PROP_TAG( PT_TSTRING,   0x003D)
PR_SUBJECT_PREFIX_W                         = PROP_TAG( PT_UNICODE,   0x003D)
PR_SUBJECT_PREFIX_A                         = PROP_TAG( PT_STRING8,   0x003D)
PR_NON_RECEIPT_REASON                       = PROP_TAG( PT_LONG,      0x003E)
PR_RECEIVED_BY_ENTRYID                      = PROP_TAG( PT_BINARY,    0x003F)
PR_RECEIVED_BY_NAME                         = PROP_TAG( PT_TSTRING,   0x0040)
PR_RECEIVED_BY_NAME_W                       = PROP_TAG( PT_UNICODE,   0x0040)
PR_RECEIVED_BY_NAME_A                       = PROP_TAG( PT_STRING8,   0x0040)
PR_SENT_REPRESENTING_ENTRYID                = PROP_TAG( PT_BINARY,    0x0041)
PR_SENT_REPRESENTING_NAME                   = PROP_TAG( PT_TSTRING,   0x0042)
PR_SENT_REPRESENTING_NAME_W                 = PROP_TAG( PT_UNICODE,   0x0042)
PR_SENT_REPRESENTING_NAME_A                 = PROP_TAG( PT_STRING8,   0x0042)
PR_RCVD_REPRESENTING_ENTRYID                = PROP_TAG( PT_BINARY,    0x0043)
PR_RCVD_REPRESENTING_NAME                   = PROP_TAG( PT_TSTRING,   0x0044)
PR_RCVD_REPRESENTING_NAME_W                 = PROP_TAG( PT_UNICODE,   0x0044)
PR_RCVD_REPRESENTING_NAME_A                 = PROP_TAG( PT_STRING8,   0x0044)
PR_REPORT_ENTRYID                           = PROP_TAG( PT_BINARY,    0x0045)
PR_READ_RECEIPT_ENTRYID                     = PROP_TAG( PT_BINARY,    0x0046)
PR_MESSAGE_SUBMISSION_ID                    = PROP_TAG( PT_BINARY,    0x0047)
PR_PROVIDER_SUBMIT_TIME                     = PROP_TAG( PT_SYSTIME,   0x0048)
PR_ORIGINAL_SUBJECT                         = PROP_TAG( PT_TSTRING,   0x0049)
PR_ORIGINAL_SUBJECT_W                       = PROP_TAG( PT_UNICODE,   0x0049)
PR_ORIGINAL_SUBJECT_A                       = PROP_TAG( PT_STRING8,   0x0049)
PR_DISC_VAL                                 = PROP_TAG( PT_BOOLEAN,   0x004A)
PR_ORIG_MESSAGE_CLASS                       = PROP_TAG( PT_TSTRING,   0x004B)
PR_ORIG_MESSAGE_CLASS_W                     = PROP_TAG( PT_UNICODE,   0x004B)
PR_ORIG_MESSAGE_CLASS_A                     = PROP_TAG( PT_STRING8,   0x004B)
PR_ORIGINAL_AUTHOR_ENTRYID                  = PROP_TAG( PT_BINARY,    0x004C)
PR_ORIGINAL_AUTHOR_NAME                     = PROP_TAG( PT_TSTRING,   0x004D)
PR_ORIGINAL_AUTHOR_NAME_W                   = PROP_TAG( PT_UNICODE,   0x004D)
PR_ORIGINAL_AUTHOR_NAME_A                   = PROP_TAG( PT_STRING8,   0x004D)
PR_ORIGINAL_SUBMIT_TIME                     = PROP_TAG( PT_SYSTIME,   0x004E)
PR_REPLY_RECIPIENT_ENTRIES                  = PROP_TAG( PT_BINARY,    0x004F)
PR_REPLY_RECIPIENT_NAMES                    = PROP_TAG( PT_TSTRING,   0x0050)
PR_REPLY_RECIPIENT_NAMES_W                  = PROP_TAG( PT_UNICODE,   0x0050)
PR_REPLY_RECIPIENT_NAMES_A                  = PROP_TAG( PT_STRING8,   0x0050)
PR_RECEIVED_BY_SEARCH_KEY                   = PROP_TAG( PT_BINARY,    0x0051)
PR_RCVD_REPRESENTING_SEARCH_KEY             = PROP_TAG( PT_BINARY,    0x0052)
PR_READ_RECEIPT_SEARCH_KEY                  = PROP_TAG( PT_BINARY,    0x0053)
PR_REPORT_SEARCH_KEY                        = PROP_TAG( PT_BINARY,    0x0054)
PR_ORIGINAL_DELIVERY_TIME                   = PROP_TAG( PT_SYSTIME,   0x0055)
PR_ORIGINAL_AUTHOR_SEARCH_KEY               = PROP_TAG( PT_BINARY,    0x0056)
PR_MESSAGE_TO_ME                            = PROP_TAG( PT_BOOLEAN,   0x0057)
PR_MESSAGE_CC_ME                            = PROP_TAG( PT_BOOLEAN,   0x0058)
PR_MESSAGE_RECIP_ME                         = PROP_TAG( PT_BOOLEAN,   0x0059)
PR_ORIGINAL_SENDER_NAME                     = PROP_TAG( PT_TSTRING,   0x005A)
PR_ORIGINAL_SENDER_NAME_W                   = PROP_TAG( PT_UNICODE,   0x005A)
PR_ORIGINAL_SENDER_NAME_A                   = PROP_TAG( PT_STRING8,   0x005A)
PR_ORIGINAL_SENDER_ENTRYID                  = PROP_TAG( PT_BINARY,    0x005B)
PR_ORIGINAL_SENDER_SEARCH_KEY               = PROP_TAG( PT_BINARY,    0x005C)
PR_ORIGINAL_SENT_REPRESENTING_NAME          = PROP_TAG( PT_TSTRING,   0x005D)
PR_ORIGINAL_SENT_REPRESENTING_NAME_W        = PROP_TAG( PT_UNICODE,   0x005D)
PR_ORIGINAL_SENT_REPRESENTING_NAME_A        = PROP_TAG( PT_STRING8,   0x005D)
PR_ORIGINAL_SENT_REPRESENTING_ENTRYID       = PROP_TAG( PT_BINARY,    0x005E)
PR_ORIGINAL_SENT_REPRESENTING_SEARCH_KEY    = PROP_TAG( PT_BINARY,    0x005F)
PR_START_DATE                               = PROP_TAG( PT_SYSTIME,   0x0060)
PR_END_DATE                                 = PROP_TAG( PT_SYSTIME,   0x0061)
PR_OWNER_APPT_ID                            = PROP_TAG( PT_LONG,      0x0062)
PR_RESPONSE_REQUESTED                       = PROP_TAG( PT_BOOLEAN,   0x0063)
PR_SENT_REPRESENTING_ADDRTYPE               = PROP_TAG( PT_TSTRING,   0x0064)
PR_SENT_REPRESENTING_ADDRTYPE_W             = PROP_TAG( PT_UNICODE,   0x0064)
PR_SENT_REPRESENTING_ADDRTYPE_A             = PROP_TAG( PT_STRING8,   0x0064)
PR_SENT_REPRESENTING_EMAIL_ADDRESS          = PROP_TAG( PT_TSTRING,   0x0065)
PR_SENT_REPRESENTING_EMAIL_ADDRESS_W        = PROP_TAG( PT_UNICODE,   0x0065)
PR_SENT_REPRESENTING_EMAIL_ADDRESS_A        = PROP_TAG( PT_STRING8,   0x0065)
PR_ORIGINAL_SENDER_ADDRTYPE                 = PROP_TAG( PT_TSTRING,   0x0066)
PR_ORIGINAL_SENDER_ADDRTYPE_W               = PROP_TAG( PT_UNICODE,   0x0066)
PR_ORIGINAL_SENDER_ADDRTYPE_A               = PROP_TAG( PT_STRING8,   0x0066)
PR_ORIGINAL_SENDER_EMAIL_ADDRESS            = PROP_TAG( PT_TSTRING,   0x0067)
PR_ORIGINAL_SENDER_EMAIL_ADDRESS_W          = PROP_TAG( PT_UNICODE,   0x0067)
PR_ORIGINAL_SENDER_EMAIL_ADDRESS_A          = PROP_TAG( PT_STRING8,   0x0067)
PR_ORIGINAL_SENT_REPRESENTING_ADDRTYPE      = PROP_TAG( PT_TSTRING,   0x0068)
PR_ORIGINAL_SENT_REPRESENTING_ADDRTYPE_W    = PROP_TAG( PT_UNICODE,   0x0068)
PR_ORIGINAL_SENT_REPRESENTING_ADDRTYPE_A    = PROP_TAG( PT_STRING8,   0x0068)
PR_ORIGINAL_SENT_REPRESENTING_EMAIL_ADDRESS = PROP_TAG( PT_TSTRING,   0x0069)
PR_ORIGINAL_SENT_REPRESENTING_EMAIL_ADDRESS_W   = PROP_TAG( PT_UNICODE,   0x0069)
PR_ORIGINAL_SENT_REPRESENTING_EMAIL_ADDRESS_A   = PROP_TAG( PT_STRING8,   0x0069)
PR_CONVERSATION_TOPIC                       = PROP_TAG( PT_TSTRING,   0x0070)
PR_CONVERSATION_TOPIC_W                     = PROP_TAG( PT_UNICODE,   0x0070)
PR_CONVERSATION_TOPIC_A                     = PROP_TAG( PT_STRING8,   0x0070)
PR_CONVERSATION_INDEX                       = PROP_TAG( PT_BINARY,    0x0071)
PR_ORIGINAL_DISPLAY_BCC                     = PROP_TAG( PT_TSTRING,   0x0072)
PR_ORIGINAL_DISPLAY_BCC_W                   = PROP_TAG( PT_UNICODE,   0x0072)
PR_ORIGINAL_DISPLAY_BCC_A                   = PROP_TAG( PT_STRING8,   0x0072)
PR_ORIGINAL_DISPLAY_CC                      = PROP_TAG( PT_TSTRING,   0x0073)
PR_ORIGINAL_DISPLAY_CC_W                    = PROP_TAG( PT_UNICODE,   0x0073)
PR_ORIGINAL_DISPLAY_CC_A                    = PROP_TAG( PT_STRING8,   0x0073)
PR_ORIGINAL_DISPLAY_TO                      = PROP_TAG( PT_TSTRING,   0x0074)
PR_ORIGINAL_DISPLAY_TO_W                    = PROP_TAG( PT_UNICODE,   0x0074)
PR_ORIGINAL_DISPLAY_TO_A                    = PROP_TAG( PT_STRING8,   0x0074)
PR_RECEIVED_BY_ADDRTYPE                     = PROP_TAG( PT_TSTRING,   0x0075)
PR_RECEIVED_BY_ADDRTYPE_W                   = PROP_TAG( PT_UNICODE,   0x0075)
PR_RECEIVED_BY_ADDRTYPE_A                   = PROP_TAG( PT_STRING8,   0x0075)
PR_RECEIVED_BY_EMAIL_ADDRESS                = PROP_TAG( PT_TSTRING,   0x0076)
PR_RECEIVED_BY_EMAIL_ADDRESS_W              = PROP_TAG( PT_UNICODE,   0x0076)
PR_RECEIVED_BY_EMAIL_ADDRESS_A              = PROP_TAG( PT_STRING8,   0x0076)
PR_RCVD_REPRESENTING_ADDRTYPE               = PROP_TAG( PT_TSTRING,   0x0077)
PR_RCVD_REPRESENTING_ADDRTYPE_W             = PROP_TAG( PT_UNICODE,   0x0077)
PR_RCVD_REPRESENTING_ADDRTYPE_A             = PROP_TAG( PT_STRING8,   0x0077)
PR_RCVD_REPRESENTING_EMAIL_ADDRESS          = PROP_TAG( PT_TSTRING,   0x0078)
PR_RCVD_REPRESENTING_EMAIL_ADDRESS_W        = PROP_TAG( PT_UNICODE,   0x0078)
PR_RCVD_REPRESENTING_EMAIL_ADDRESS_A        = PROP_TAG( PT_STRING8,   0x0078)
PR_ORIGINAL_AUTHOR_ADDRTYPE                 = PROP_TAG( PT_TSTRING,   0x0079)
PR_ORIGINAL_AUTHOR_ADDRTYPE_W               = PROP_TAG( PT_UNICODE,   0x0079)
PR_ORIGINAL_AUTHOR_ADDRTYPE_A               = PROP_TAG( PT_STRING8,   0x0079)
PR_ORIGINAL_AUTHOR_EMAIL_ADDRESS            = PROP_TAG( PT_TSTRING,   0x007A)
PR_ORIGINAL_AUTHOR_EMAIL_ADDRESS_W          = PROP_TAG( PT_UNICODE,   0x007A)
PR_ORIGINAL_AUTHOR_EMAIL_ADDRESS_A          = PROP_TAG( PT_STRING8,   0x007A)
PR_ORIGINALLY_INTENDED_RECIP_ADDRTYPE       = PROP_TAG( PT_TSTRING,   0x007B)
PR_ORIGINALLY_INTENDED_RECIP_ADDRTYPE_W     = PROP_TAG( PT_UNICODE,   0x007B)
PR_ORIGINALLY_INTENDED_RECIP_ADDRTYPE_A     = PROP_TAG( PT_STRING8,   0x007B)
PR_ORIGINALLY_INTENDED_RECIP_EMAIL_ADDRESS  = PROP_TAG( PT_TSTRING,   0x007C)
PR_ORIGINALLY_INTENDED_RECIP_EMAIL_ADDRESS_W    = PROP_TAG( PT_UNICODE,   0x007C)
PR_ORIGINALLY_INTENDED_RECIP_EMAIL_ADDRESS_A    = PROP_TAG( PT_STRING8,   0x007C)
PR_TRANSPORT_MESSAGE_HEADERS                = PROP_TAG(PT_TSTRING,    0x007D)
PR_TRANSPORT_MESSAGE_HEADERS_W              = PROP_TAG(PT_UNICODE,    0x007D)
PR_TRANSPORT_MESSAGE_HEADERS_A              = PROP_TAG(PT_STRING8,    0x007D)
PR_DELEGATION                               = PROP_TAG(PT_BINARY,     0x007E)
PR_TNEF_CORRELATION_KEY                     = PROP_TAG(PT_BINARY,     0x007F)
PR_BODY                                     = PROP_TAG( PT_TSTRING,   0x1000)
PR_BODY_W                                   = PROP_TAG( PT_UNICODE,   0x1000)
PR_BODY_A                                   = PROP_TAG( PT_STRING8,   0x1000)
PR_REPORT_TEXT                              = PROP_TAG( PT_TSTRING,   0x1001)
PR_REPORT_TEXT_W                            = PROP_TAG( PT_UNICODE,   0x1001)
PR_REPORT_TEXT_A                            = PROP_TAG( PT_STRING8,   0x1001)
PR_ORIGINATOR_AND_DL_EXPANSION_HISTORY      = PROP_TAG( PT_BINARY,    0x1002)
PR_REPORTING_DL_NAME                        = PROP_TAG( PT_BINARY,    0x1003)
PR_REPORTING_MTA_CERTIFICATE                = PROP_TAG( PT_BINARY,    0x1004)
PR_RTF_SYNC_BODY_CRC                        = PROP_TAG( PT_LONG,      0x1006)
PR_RTF_SYNC_BODY_COUNT                      = PROP_TAG( PT_LONG,      0x1007)
PR_RTF_SYNC_BODY_TAG                        = PROP_TAG( PT_TSTRING,   0x1008)
PR_RTF_SYNC_BODY_TAG_W                      = PROP_TAG( PT_UNICODE,   0x1008)
PR_RTF_SYNC_BODY_TAG_A                      = PROP_TAG( PT_STRING8,   0x1008)
PR_RTF_COMPRESSED                           = PROP_TAG( PT_BINARY,    0x1009)
PR_RTF_SYNC_PREFIX_COUNT                    = PROP_TAG( PT_LONG,      0x1010)
PR_RTF_SYNC_TRAILING_COUNT                  = PROP_TAG( PT_LONG,      0x1011)
PR_ORIGINALLY_INTENDED_RECIP_ENTRYID        = PROP_TAG( PT_BINARY,    0x1012)
PR_CONTENT_INTEGRITY_CHECK                  = PROP_TAG( PT_BINARY,    0x0C00)
PR_EXPLICIT_CONVERSION                      = PROP_TAG( PT_LONG,      0x0C01)
PR_IPM_RETURN_REQUESTED                     = PROP_TAG( PT_BOOLEAN,   0x0C02)
PR_MESSAGE_TOKEN                            = PROP_TAG( PT_BINARY,    0x0C03)
PR_NDR_REASON_CODE                          = PROP_TAG( PT_LONG,      0x0C04)
PR_NDR_DIAG_CODE                            = PROP_TAG( PT_LONG,      0x0C05)
PR_NON_RECEIPT_NOTIFICATION_REQUESTED       = PROP_TAG( PT_BOOLEAN,   0x0C06)
PR_DELIVERY_POINT                           = PROP_TAG( PT_LONG,      0x0C07)
PR_ORIGINATOR_NON_DELIVERY_REPORT_REQUESTED = PROP_TAG( PT_BOOLEAN,   0x0C08)
PR_ORIGINATOR_REQUESTED_ALTERNATE_RECIPIENT = PROP_TAG( PT_BINARY,    0x0C09)
PR_PHYSICAL_DELIVERY_BUREAU_FAX_DELIVERY    = PROP_TAG( PT_BOOLEAN,   0x0C0A)
PR_PHYSICAL_DELIVERY_MODE                   = PROP_TAG( PT_LONG,      0x0C0B)
PR_PHYSICAL_DELIVERY_REPORT_REQUEST         = PROP_TAG( PT_LONG,      0x0C0C)
PR_PHYSICAL_FORWARDING_ADDRESS              = PROP_TAG( PT_BINARY,    0x0C0D)
PR_PHYSICAL_FORWARDING_ADDRESS_REQUESTED    = PROP_TAG( PT_BOOLEAN,   0x0C0E)
PR_PHYSICAL_FORWARDING_PROHIBITED           = PROP_TAG( PT_BOOLEAN,   0x0C0F)
PR_PHYSICAL_RENDITION_ATTRIBUTES            = PROP_TAG( PT_BINARY,    0x0C10)
PR_PROOF_OF_DELIVERY                        = PROP_TAG( PT_BINARY,    0x0C11)
PR_PROOF_OF_DELIVERY_REQUESTED              = PROP_TAG( PT_BOOLEAN,   0x0C12)
PR_RECIPIENT_CERTIFICATE                    = PROP_TAG( PT_BINARY,    0x0C13)
PR_RECIPIENT_NUMBER_FOR_ADVICE              = PROP_TAG( PT_TSTRING,   0x0C14)
PR_RECIPIENT_NUMBER_FOR_ADVICE_W            = PROP_TAG( PT_UNICODE,   0x0C14)
PR_RECIPIENT_NUMBER_FOR_ADVICE_A            = PROP_TAG( PT_STRING8,   0x0C14)
PR_RECIPIENT_TYPE                           = PROP_TAG( PT_LONG,      0x0C15)
PR_REGISTERED_MAIL_TYPE                     = PROP_TAG( PT_LONG,      0x0C16)
PR_REPLY_REQUESTED                          = PROP_TAG( PT_BOOLEAN,   0x0C17)
PR_REQUESTED_DELIVERY_METHOD                = PROP_TAG( PT_LONG,      0x0C18)
PR_SENDER_ENTRYID                           = PROP_TAG( PT_BINARY,    0x0C19)
PR_SENDER_NAME                              = PROP_TAG( PT_TSTRING,   0x0C1A)
PR_SENDER_NAME_W                            = PROP_TAG( PT_UNICODE,   0x0C1A)
PR_SENDER_NAME_A                            = PROP_TAG( PT_STRING8,   0x0C1A)
PR_SUPPLEMENTARY_INFO                       = PROP_TAG( PT_TSTRING,   0x0C1B)
PR_SUPPLEMENTARY_INFO_W                     = PROP_TAG( PT_UNICODE,   0x0C1B)
PR_SUPPLEMENTARY_INFO_A                     = PROP_TAG( PT_STRING8,   0x0C1B)
PR_TYPE_OF_MTS_USER                         = PROP_TAG( PT_LONG,      0x0C1C)
PR_SENDER_SEARCH_KEY                        = PROP_TAG( PT_BINARY,    0x0C1D)
PR_SENDER_ADDRTYPE                          = PROP_TAG( PT_TSTRING,   0x0C1E)
PR_SENDER_ADDRTYPE_W                        = PROP_TAG( PT_UNICODE,   0x0C1E)
PR_SENDER_ADDRTYPE_A                        = PROP_TAG( PT_STRING8,   0x0C1E)
PR_SENDER_EMAIL_ADDRESS                     = PROP_TAG( PT_TSTRING,   0x0C1F)
PR_SENDER_EMAIL_ADDRESS_W                   = PROP_TAG( PT_UNICODE,   0x0C1F)
PR_SENDER_EMAIL_ADDRESS_A                   = PROP_TAG( PT_STRING8,   0x0C1F)
PR_CURRENT_VERSION                          = PROP_TAG( PT_I8,        0x0E00)
PR_DELETE_AFTER_SUBMIT                      = PROP_TAG( PT_BOOLEAN,   0x0E01)
PR_DISPLAY_BCC                              = PROP_TAG( PT_TSTRING,   0x0E02)
PR_DISPLAY_BCC_W                            = PROP_TAG( PT_UNICODE,   0x0E02)
PR_DISPLAY_BCC_A                            = PROP_TAG( PT_STRING8,   0x0E02)
PR_DISPLAY_CC                               = PROP_TAG( PT_TSTRING,   0x0E03)
PR_DISPLAY_CC_W                             = PROP_TAG( PT_UNICODE,   0x0E03)
PR_DISPLAY_CC_A                             = PROP_TAG( PT_STRING8,   0x0E03)
PR_DISPLAY_TO                               = PROP_TAG( PT_TSTRING,   0x0E04)
PR_DISPLAY_TO_W                             = PROP_TAG( PT_UNICODE,   0x0E04)
PR_DISPLAY_TO_A                             = PROP_TAG( PT_STRING8,   0x0E04)
PR_PARENT_DISPLAY                           = PROP_TAG( PT_TSTRING,   0x0E05)
PR_PARENT_DISPLAY_W                         = PROP_TAG( PT_UNICODE,   0x0E05)
PR_PARENT_DISPLAY_A                         = PROP_TAG( PT_STRING8,   0x0E05)
PR_MESSAGE_DELIVERY_TIME                    = PROP_TAG( PT_SYSTIME,   0x0E06)
PR_MESSAGE_FLAGS                            = PROP_TAG( PT_LONG,      0x0E07)
PR_MESSAGE_SIZE                             = PROP_TAG( PT_LONG,      0x0E08)
PR_PARENT_ENTRYID                           = PROP_TAG( PT_BINARY,    0x0E09)
PR_SENTMAIL_ENTRYID                         = PROP_TAG( PT_BINARY,    0x0E0A)
PR_CORRELATE                                = PROP_TAG( PT_BOOLEAN,   0x0E0C)
PR_CORRELATE_MTSID                          = PROP_TAG( PT_BINARY,    0x0E0D)
PR_DISCRETE_VALUES                          = PROP_TAG( PT_BOOLEAN,   0x0E0E)
PR_RESPONSIBILITY                           = PROP_TAG( PT_BOOLEAN,   0x0E0F)
PR_SPOOLER_STATUS                           = PROP_TAG( PT_LONG,      0x0E10)
PR_TRANSPORT_STATUS                         = PROP_TAG( PT_LONG,      0x0E11)
PR_MESSAGE_RECIPIENTS                       = PROP_TAG( PT_OBJECT,    0x0E12)
PR_MESSAGE_ATTACHMENTS                      = PROP_TAG( PT_OBJECT,    0x0E13)
PR_SUBMIT_FLAGS                             = PROP_TAG( PT_LONG,      0x0E14)
PR_RECIPIENT_STATUS                         = PROP_TAG( PT_LONG,      0x0E15)
PR_TRANSPORT_KEY                            = PROP_TAG( PT_LONG,      0x0E16)
PR_MSG_STATUS                               = PROP_TAG( PT_LONG,      0x0E17)
PR_MESSAGE_DOWNLOAD_TIME                    = PROP_TAG( PT_LONG,      0x0E18)
PR_CREATION_VERSION                         = PROP_TAG( PT_I8,        0x0E19)
PR_MODIFY_VERSION                           = PROP_TAG( PT_I8,        0x0E1A)
PR_HASATTACH                                = PROP_TAG( PT_BOOLEAN,   0x0E1B)
PR_BODY_CRC                                 = PROP_TAG( PT_LONG,      0x0E1C)
PR_NORMALIZED_SUBJECT                       = PROP_TAG( PT_TSTRING,   0x0E1D)
PR_NORMALIZED_SUBJECT_W                     = PROP_TAG( PT_UNICODE,   0x0E1D)
PR_NORMALIZED_SUBJECT_A                     = PROP_TAG( PT_STRING8,   0x0E1D)
PR_RTF_IN_SYNC                              = PROP_TAG( PT_BOOLEAN,   0x0E1F)
PR_ATTACH_SIZE                              = PROP_TAG( PT_LONG,      0x0E20)
PR_ATTACH_NUM                               = PROP_TAG( PT_LONG,      0x0E21)
PR_PREPROCESS                               = PROP_TAG( PT_BOOLEAN,   0x0E22)
PR_ORIGINATING_MTA_CERTIFICATE              = PROP_TAG( PT_BINARY,    0x0E25)
PR_PROOF_OF_SUBMISSION                      = PROP_TAG( PT_BINARY,    0x0E26)
PR_ENTRYID                                  = PROP_TAG( PT_BINARY,    0x0FFF)
PR_OBJECT_TYPE                              = PROP_TAG( PT_LONG,      0x0FFE)
PR_ICON                                     = PROP_TAG( PT_BINARY,    0x0FFD)
PR_MINI_ICON                                = PROP_TAG( PT_BINARY,    0x0FFC)
PR_STORE_ENTRYID                            = PROP_TAG( PT_BINARY,    0x0FFB)
PR_STORE_RECORD_KEY                         = PROP_TAG( PT_BINARY,    0x0FFA)
PR_RECORD_KEY                               = PROP_TAG( PT_BINARY,    0x0FF9)
PR_MAPPING_SIGNATURE                        = PROP_TAG( PT_BINARY,    0x0FF8)
PR_ACCESS_LEVEL                             = PROP_TAG( PT_LONG,      0x0FF7)
PR_INSTANCE_KEY                             = PROP_TAG( PT_BINARY,    0x0FF6)
PR_ROW_TYPE                                 = PROP_TAG( PT_LONG,      0x0FF5)
PR_ACCESS                                   = PROP_TAG( PT_LONG,      0x0FF4)
PR_ROWID                                    = PROP_TAG( PT_LONG,      0x3000)
PR_DISPLAY_NAME                             = PROP_TAG( PT_TSTRING,   0x3001)
PR_DISPLAY_NAME_W                           = PROP_TAG( PT_UNICODE,   0x3001)
PR_DISPLAY_NAME_A                           = PROP_TAG( PT_STRING8,   0x3001)
PR_ADDRTYPE                                 = PROP_TAG( PT_TSTRING,   0x3002)
PR_ADDRTYPE_W                               = PROP_TAG( PT_UNICODE,   0x3002)
PR_ADDRTYPE_A                               = PROP_TAG( PT_STRING8,   0x3002)
PR_EMAIL_ADDRESS                            = PROP_TAG( PT_TSTRING,   0x3003)
PR_EMAIL_ADDRESS_W                          = PROP_TAG( PT_UNICODE,   0x3003)
PR_EMAIL_ADDRESS_A                          = PROP_TAG( PT_STRING8,   0x3003)
PR_COMMENT                                  = PROP_TAG( PT_TSTRING,   0x3004)
PR_COMMENT_W                                = PROP_TAG( PT_UNICODE,   0x3004)
PR_COMMENT_A                                = PROP_TAG( PT_STRING8,   0x3004)
PR_DEPTH                                    = PROP_TAG( PT_LONG,      0x3005)
PR_PROVIDER_DISPLAY                         = PROP_TAG( PT_TSTRING,   0x3006)
PR_PROVIDER_DISPLAY_W                       = PROP_TAG( PT_UNICODE,   0x3006)
PR_PROVIDER_DISPLAY_A                       = PROP_TAG( PT_STRING8,   0x3006)
PR_CREATION_TIME                            = PROP_TAG( PT_SYSTIME,   0x3007)
PR_LAST_MODIFICATION_TIME                   = PROP_TAG( PT_SYSTIME,   0x3008)
PR_RESOURCE_FLAGS                           = PROP_TAG( PT_LONG,      0x3009)
PR_PROVIDER_DLL_NAME                        = PROP_TAG( PT_TSTRING,   0x300A)
PR_PROVIDER_DLL_NAME_W                      = PROP_TAG( PT_UNICODE,   0x300A)
PR_PROVIDER_DLL_NAME_A                      = PROP_TAG( PT_STRING8,   0x300A)
PR_SEARCH_KEY                               = PROP_TAG( PT_BINARY,    0x300B)
PR_PROVIDER_UID                             = PROP_TAG( PT_BINARY,    0x300C)
PR_PROVIDER_ORDINAL                         = PROP_TAG( PT_LONG,      0x300D)
PR_FORM_VERSION                             = PROP_TAG(PT_TSTRING,    0x3301)
PR_FORM_VERSION_W                           = PROP_TAG(PT_UNICODE,    0x3301)
PR_FORM_VERSION_A                           = PROP_TAG(PT_STRING8,    0x3301)
PR_FORM_CLSID                               = PROP_TAG(PT_CLSID,      0x3302)
PR_FORM_CONTACT_NAME                        = PROP_TAG(PT_TSTRING,    0x3303)
PR_FORM_CONTACT_NAME_W                      = PROP_TAG(PT_UNICODE,    0x3303)
PR_FORM_CONTACT_NAME_A                      = PROP_TAG(PT_STRING8,    0x3303)
PR_FORM_CATEGORY                            = PROP_TAG(PT_TSTRING,    0x3304)
PR_FORM_CATEGORY_W                          = PROP_TAG(PT_UNICODE,    0x3304)
PR_FORM_CATEGORY_A                          = PROP_TAG(PT_STRING8,    0x3304)
PR_FORM_CATEGORY_SUB                        = PROP_TAG(PT_TSTRING,    0x3305)
PR_FORM_CATEGORY_SUB_W                      = PROP_TAG(PT_UNICODE,    0x3305)
PR_FORM_CATEGORY_SUB_A                      = PROP_TAG(PT_STRING8,    0x3305)
PR_FORM_HOST_MAP                            = PROP_TAG(PT_MV_LONG,    0x3306)
PR_FORM_HIDDEN                              = PROP_TAG(PT_BOOLEAN,    0x3307)
PR_FORM_DESIGNER_NAME                       = PROP_TAG(PT_TSTRING,    0x3308)
PR_FORM_DESIGNER_NAME_W                     = PROP_TAG(PT_UNICODE,    0x3308)
PR_FORM_DESIGNER_NAME_A                     = PROP_TAG(PT_STRING8,    0x3308)
PR_FORM_DESIGNER_GUID                       = PROP_TAG(PT_CLSID,      0x3309)
PR_FORM_MESSAGE_BEHAVIOR                    = PROP_TAG(PT_LONG,       0x330A)
PR_DEFAULT_STORE                            = PROP_TAG( PT_BOOLEAN,   0x3400)
PR_STORE_SUPPORT_MASK                       = PROP_TAG( PT_LONG,      0x340D)
PR_STORE_STATE                              = PROP_TAG( PT_LONG,      0x340E)
PR_IPM_SUBTREE_SEARCH_KEY                   = PROP_TAG( PT_BINARY,    0x3410)
PR_IPM_OUTBOX_SEARCH_KEY                    = PROP_TAG( PT_BINARY,    0x3411)
PR_IPM_WASTEBASKET_SEARCH_KEY               = PROP_TAG( PT_BINARY,    0x3412)
PR_IPM_SENTMAIL_SEARCH_KEY                  = PROP_TAG( PT_BINARY,    0x3413)
PR_MDB_PROVIDER                             = PROP_TAG( PT_BINARY,    0x3414)
PR_RECEIVE_FOLDER_SETTINGS                  = PROP_TAG( PT_OBJECT,    0x3415)
PR_VALID_FOLDER_MASK                        = PROP_TAG( PT_LONG,      0x35DF)
PR_IPM_SUBTREE_ENTRYID                      = PROP_TAG( PT_BINARY,    0x35E0)
PR_IPM_OUTBOX_ENTRYID                       = PROP_TAG( PT_BINARY,    0x35E2)
PR_IPM_WASTEBASKET_ENTRYID                  = PROP_TAG( PT_BINARY,    0x35E3)
PR_IPM_SENTMAIL_ENTRYID                     = PROP_TAG( PT_BINARY,    0x35E4)
PR_VIEWS_ENTRYID                            = PROP_TAG( PT_BINARY,    0x35E5)
PR_COMMON_VIEWS_ENTRYID                     = PROP_TAG( PT_BINARY,    0x35E6)
PR_FINDER_ENTRYID                           = PROP_TAG( PT_BINARY,    0x35E7)
PR_CONTAINER_FLAGS                          = PROP_TAG( PT_LONG,      0x3600)
PR_FOLDER_TYPE                              = PROP_TAG( PT_LONG,      0x3601)
PR_CONTENT_COUNT                            = PROP_TAG( PT_LONG,      0x3602)
PR_CONTENT_UNREAD                           = PROP_TAG( PT_LONG,      0x3603)
PR_CREATE_TEMPLATES                         = PROP_TAG( PT_OBJECT,    0x3604)
PR_DETAILS_TABLE                            = PROP_TAG( PT_OBJECT,    0x3605)
PR_SEARCH                                   = PROP_TAG( PT_OBJECT,    0x3607)
PR_SELECTABLE                               = PROP_TAG( PT_BOOLEAN,   0x3609)
PR_SUBFOLDERS                               = PROP_TAG( PT_BOOLEAN,   0x360A)
PR_STATUS                                   = PROP_TAG( PT_LONG,      0x360B)
PR_ANR                                      = PROP_TAG( PT_TSTRING,   0x360C)
PR_ANR_W                                    = PROP_TAG( PT_UNICODE,   0x360C)
PR_ANR_A                                    = PROP_TAG( PT_STRING8,   0x360C)
PR_CONTENTS_SORT_ORDER                      = PROP_TAG( PT_MV_LONG,   0x360D)
PR_CONTAINER_HIERARCHY                      = PROP_TAG( PT_OBJECT,    0x360E)
PR_CONTAINER_CONTENTS                       = PROP_TAG( PT_OBJECT,    0x360F)
PR_FOLDER_ASSOCIATED_CONTENTS               = PROP_TAG( PT_OBJECT,    0x3610)
PR_DEF_CREATE_DL                            = PROP_TAG( PT_BINARY,    0x3611)
PR_DEF_CREATE_MAILUSER                      = PROP_TAG( PT_BINARY,    0x3612)
PR_CONTAINER_CLASS                          = PROP_TAG( PT_TSTRING,   0x3613)
PR_CONTAINER_CLASS_W                        = PROP_TAG( PT_UNICODE,   0x3613)
PR_CONTAINER_CLASS_A                        = PROP_TAG( PT_STRING8,   0x3613)
PR_CONTAINER_MODIFY_VERSION                 = PROP_TAG( PT_I8,        0x3614)
PR_AB_PROVIDER_ID                           = PROP_TAG( PT_BINARY,    0x3615)
PR_DEFAULT_VIEW_ENTRYID                     = PROP_TAG( PT_BINARY,    0x3616)
PR_ASSOC_CONTENT_COUNT                      = PROP_TAG( PT_LONG,      0x3617)
PR_ATTACHMENT_X400_PARAMETERS               = PROP_TAG( PT_BINARY,    0x3700)
PR_ATTACH_DATA_OBJ                          = PROP_TAG( PT_OBJECT,    0x3701)
PR_ATTACH_DATA_BIN                          = PROP_TAG( PT_BINARY,    0x3701)
PR_ATTACH_ENCODING                          = PROP_TAG( PT_BINARY,    0x3702)
PR_ATTACH_EXTENSION                         = PROP_TAG( PT_TSTRING,   0x3703)
PR_ATTACH_EXTENSION_W                       = PROP_TAG( PT_UNICODE,   0x3703)
PR_ATTACH_EXTENSION_A                       = PROP_TAG( PT_STRING8,   0x3703)
PR_ATTACH_FILENAME                          = PROP_TAG( PT_TSTRING,   0x3704)
PR_ATTACH_FILENAME_W                        = PROP_TAG( PT_UNICODE,   0x3704)
PR_ATTACH_FILENAME_A                        = PROP_TAG( PT_STRING8,   0x3704)
PR_ATTACH_METHOD                            = PROP_TAG( PT_LONG,      0x3705)
PR_ATTACH_LONG_FILENAME                     = PROP_TAG( PT_TSTRING,   0x3707)
PR_ATTACH_LONG_FILENAME_W                   = PROP_TAG( PT_UNICODE,   0x3707)
PR_ATTACH_LONG_FILENAME_A                   = PROP_TAG( PT_STRING8,   0x3707)
PR_ATTACH_PATHNAME                          = PROP_TAG( PT_TSTRING,   0x3708)
PR_ATTACH_PATHNAME_W                        = PROP_TAG( PT_UNICODE,   0x3708)
PR_ATTACH_PATHNAME_A                        = PROP_TAG( PT_STRING8,   0x3708)
PR_ATTACH_RENDERING                         = PROP_TAG( PT_BINARY,    0x3709)
PR_ATTACH_TAG                               = PROP_TAG( PT_BINARY,    0x370A)
PR_RENDERING_POSITION                       = PROP_TAG( PT_LONG,      0x370B)
PR_ATTACH_TRANSPORT_NAME                    = PROP_TAG( PT_TSTRING,   0x370C)
PR_ATTACH_TRANSPORT_NAME_W                  = PROP_TAG( PT_UNICODE,   0x370C)
PR_ATTACH_TRANSPORT_NAME_A                  = PROP_TAG( PT_STRING8,   0x370C)
PR_ATTACH_LONG_PATHNAME                     = PROP_TAG( PT_TSTRING,   0x370D)
PR_ATTACH_LONG_PATHNAME_W                   = PROP_TAG( PT_UNICODE,   0x370D)
PR_ATTACH_LONG_PATHNAME_A                   = PROP_TAG( PT_STRING8,   0x370D)
PR_ATTACH_MIME_TAG                          = PROP_TAG( PT_TSTRING,   0x370E)
PR_ATTACH_MIME_TAG_W                        = PROP_TAG( PT_UNICODE,   0x370E)
PR_ATTACH_MIME_TAG_A                        = PROP_TAG( PT_STRING8,   0x370E)
PR_ATTACH_ADDITIONAL_INFO                   = PROP_TAG( PT_BINARY,    0x370F)
PR_DISPLAY_TYPE                             = PROP_TAG( PT_LONG,      0x3900)
PR_TEMPLATEID                               = PROP_TAG( PT_BINARY,    0x3902)
PR_PRIMARY_CAPABILITY                       = PROP_TAG( PT_BINARY,    0x3904)
PR_7BIT_DISPLAY_NAME                        = PROP_TAG( PT_STRING8,   0x39FF)
PR_ACCOUNT                                  = PROP_TAG( PT_TSTRING,   0x3A00)
PR_ACCOUNT_W                                = PROP_TAG( PT_UNICODE,   0x3A00)
PR_ACCOUNT_A                                = PROP_TAG( PT_STRING8,   0x3A00)
PR_ALTERNATE_RECIPIENT                      = PROP_TAG( PT_BINARY,    0x3A01)
PR_CALLBACK_TELEPHONE_NUMBER                = PROP_TAG( PT_TSTRING,   0x3A02)
PR_CALLBACK_TELEPHONE_NUMBER_W              = PROP_TAG( PT_UNICODE,   0x3A02)
PR_CALLBACK_TELEPHONE_NUMBER_A              = PROP_TAG( PT_STRING8,   0x3A02)
PR_CONVERSION_PROHIBITED                    = PROP_TAG( PT_BOOLEAN,   0x3A03)
PR_DISCLOSE_RECIPIENTS                      = PROP_TAG( PT_BOOLEAN,   0x3A04)
PR_GENERATION                               = PROP_TAG( PT_TSTRING,   0x3A05)
PR_GENERATION_W                             = PROP_TAG( PT_UNICODE,   0x3A05)
PR_GENERATION_A                             = PROP_TAG( PT_STRING8,   0x3A05)
PR_GIVEN_NAME                               = PROP_TAG( PT_TSTRING,   0x3A06)
PR_GIVEN_NAME_W                             = PROP_TAG( PT_UNICODE,   0x3A06)
PR_GIVEN_NAME_A                             = PROP_TAG( PT_STRING8,   0x3A06)
PR_GOVERNMENT_ID_NUMBER                     = PROP_TAG( PT_TSTRING,   0x3A07)
PR_GOVERNMENT_ID_NUMBER_W                   = PROP_TAG( PT_UNICODE,   0x3A07)
PR_GOVERNMENT_ID_NUMBER_A                   = PROP_TAG( PT_STRING8,   0x3A07)
PR_BUSINESS_TELEPHONE_NUMBER                = PROP_TAG( PT_TSTRING,   0x3A08)
PR_BUSINESS_TELEPHONE_NUMBER_W              = PROP_TAG( PT_UNICODE,   0x3A08)
PR_BUSINESS_TELEPHONE_NUMBER_A              = PROP_TAG( PT_STRING8,   0x3A08)
PR_OFFICE_TELEPHONE_NUMBER                  = PR_BUSINESS_TELEPHONE_NUMBER
PR_OFFICE_TELEPHONE_NUMBER_W                = PR_BUSINESS_TELEPHONE_NUMBER_W
PR_OFFICE_TELEPHONE_NUMBER_A                = PR_BUSINESS_TELEPHONE_NUMBER_A
PR_HOME_TELEPHONE_NUMBER                    = PROP_TAG( PT_TSTRING,   0x3A09)
PR_HOME_TELEPHONE_NUMBER_W                  = PROP_TAG( PT_UNICODE,   0x3A09)
PR_HOME_TELEPHONE_NUMBER_A                  = PROP_TAG( PT_STRING8,   0x3A09)
PR_INITIALS                                 = PROP_TAG( PT_TSTRING,   0x3A0A)
PR_INITIALS_W                               = PROP_TAG( PT_UNICODE,   0x3A0A)
PR_INITIALS_A                               = PROP_TAG( PT_STRING8,   0x3A0A)
PR_KEYWORD                                  = PROP_TAG( PT_TSTRING,   0x3A0B)
PR_KEYWORD_W                                = PROP_TAG( PT_UNICODE,   0x3A0B)
PR_KEYWORD_A                                = PROP_TAG( PT_STRING8,   0x3A0B)
PR_LANGUAGE                                 = PROP_TAG( PT_TSTRING,   0x3A0C)
PR_LANGUAGE_W                               = PROP_TAG( PT_UNICODE,   0x3A0C)
PR_LANGUAGE_A                               = PROP_TAG( PT_STRING8,   0x3A0C)
PR_LOCATION                                 = PROP_TAG( PT_TSTRING,   0x3A0D)
PR_LOCATION_W                               = PROP_TAG( PT_UNICODE,   0x3A0D)
PR_LOCATION_A                               = PROP_TAG( PT_STRING8,   0x3A0D)
PR_MAIL_PERMISSION                          = PROP_TAG( PT_BOOLEAN,   0x3A0E)
PR_MHS_COMMON_NAME                          = PROP_TAG( PT_TSTRING,   0x3A0F)
PR_MHS_COMMON_NAME_W                        = PROP_TAG( PT_UNICODE,   0x3A0F)
PR_MHS_COMMON_NAME_A                        = PROP_TAG( PT_STRING8,   0x3A0F)
PR_ORGANIZATIONAL_ID_NUMBER                 = PROP_TAG( PT_TSTRING,   0x3A10)
PR_ORGANIZATIONAL_ID_NUMBER_W               = PROP_TAG( PT_UNICODE,   0x3A10)
PR_ORGANIZATIONAL_ID_NUMBER_A               = PROP_TAG( PT_STRING8,   0x3A10)
PR_SURNAME                                  = PROP_TAG( PT_TSTRING,   0x3A11)
PR_SURNAME_W                                = PROP_TAG( PT_UNICODE,   0x3A11)
PR_SURNAME_A                                = PROP_TAG( PT_STRING8,   0x3A11)
PR_ORIGINAL_ENTRYID                         = PROP_TAG( PT_BINARY,    0x3A12)
PR_ORIGINAL_DISPLAY_NAME                    = PROP_TAG( PT_TSTRING,   0x3A13)
PR_ORIGINAL_DISPLAY_NAME_W                  = PROP_TAG( PT_UNICODE,   0x3A13)
PR_ORIGINAL_DISPLAY_NAME_A                  = PROP_TAG( PT_STRING8,   0x3A13)
PR_ORIGINAL_SEARCH_KEY                      = PROP_TAG( PT_BINARY,    0x3A14)
PR_POSTAL_ADDRESS                           = PROP_TAG( PT_TSTRING,   0x3A15)
PR_POSTAL_ADDRESS_W                         = PROP_TAG( PT_UNICODE,   0x3A15)
PR_POSTAL_ADDRESS_A                         = PROP_TAG( PT_STRING8,   0x3A15)
PR_COMPANY_NAME                             = PROP_TAG( PT_TSTRING,   0x3A16)
PR_COMPANY_NAME_W                           = PROP_TAG( PT_UNICODE,   0x3A16)
PR_COMPANY_NAME_A                           = PROP_TAG( PT_STRING8,   0x3A16)
PR_TITLE                                    = PROP_TAG( PT_TSTRING,   0x3A17)
PR_TITLE_W                                  = PROP_TAG( PT_UNICODE,   0x3A17)
PR_TITLE_A                                  = PROP_TAG( PT_STRING8,   0x3A17)
PR_DEPARTMENT_NAME                          = PROP_TAG( PT_TSTRING,   0x3A18)
PR_DEPARTMENT_NAME_W                        = PROP_TAG( PT_UNICODE,   0x3A18)
PR_DEPARTMENT_NAME_A                        = PROP_TAG( PT_STRING8,   0x3A18)
PR_OFFICE_LOCATION                          = PROP_TAG( PT_TSTRING,   0x3A19)
PR_OFFICE_LOCATION_W                        = PROP_TAG( PT_UNICODE,   0x3A19)
PR_OFFICE_LOCATION_A                        = PROP_TAG( PT_STRING8,   0x3A19)
PR_PRIMARY_TELEPHONE_NUMBER                 = PROP_TAG( PT_TSTRING,   0x3A1A)
PR_PRIMARY_TELEPHONE_NUMBER_W               = PROP_TAG( PT_UNICODE,   0x3A1A)
PR_PRIMARY_TELEPHONE_NUMBER_A               = PROP_TAG( PT_STRING8,   0x3A1A)
PR_BUSINESS2_TELEPHONE_NUMBER               = PROP_TAG( PT_TSTRING,   0x3A1B)
PR_BUSINESS2_TELEPHONE_NUMBER_W             = PROP_TAG( PT_UNICODE,   0x3A1B)
PR_BUSINESS2_TELEPHONE_NUMBER_A             = PROP_TAG( PT_STRING8,   0x3A1B)
PR_OFFICE2_TELEPHONE_NUMBER                 = PR_BUSINESS2_TELEPHONE_NUMBER
PR_OFFICE2_TELEPHONE_NUMBER_W               = PR_BUSINESS2_TELEPHONE_NUMBER_W
PR_OFFICE2_TELEPHONE_NUMBER_A               = PR_BUSINESS2_TELEPHONE_NUMBER_A
PR_MOBILE_TELEPHONE_NUMBER                  = PROP_TAG( PT_TSTRING,   0x3A1C)
PR_MOBILE_TELEPHONE_NUMBER_W                = PROP_TAG( PT_UNICODE,   0x3A1C)
PR_MOBILE_TELEPHONE_NUMBER_A                = PROP_TAG( PT_STRING8,   0x3A1C)
PR_CELLULAR_TELEPHONE_NUMBER                = PR_MOBILE_TELEPHONE_NUMBER
PR_CELLULAR_TELEPHONE_NUMBER_W              = PR_MOBILE_TELEPHONE_NUMBER_W
PR_CELLULAR_TELEPHONE_NUMBER_A              = PR_MOBILE_TELEPHONE_NUMBER_A
PR_RADIO_TELEPHONE_NUMBER                   = PROP_TAG( PT_TSTRING,   0x3A1D)
PR_RADIO_TELEPHONE_NUMBER_W                 = PROP_TAG( PT_UNICODE,   0x3A1D)
PR_RADIO_TELEPHONE_NUMBER_A                 = PROP_TAG( PT_STRING8,   0x3A1D)
PR_CAR_TELEPHONE_NUMBER                     = PROP_TAG( PT_TSTRING,   0x3A1E)
PR_CAR_TELEPHONE_NUMBER_W                   = PROP_TAG( PT_UNICODE,   0x3A1E)
PR_CAR_TELEPHONE_NUMBER_A                   = PROP_TAG( PT_STRING8,   0x3A1E)
PR_OTHER_TELEPHONE_NUMBER                   = PROP_TAG( PT_TSTRING,   0x3A1F)
PR_OTHER_TELEPHONE_NUMBER_W                 = PROP_TAG( PT_UNICODE,   0x3A1F)
PR_OTHER_TELEPHONE_NUMBER_A                 = PROP_TAG( PT_STRING8,   0x3A1F)
PR_TRANSMITABLE_DISPLAY_NAME                = PROP_TAG( PT_TSTRING,   0x3A20)
PR_TRANSMITABLE_DISPLAY_NAME_W              = PROP_TAG( PT_UNICODE,   0x3A20)
PR_TRANSMITABLE_DISPLAY_NAME_A              = PROP_TAG( PT_STRING8,   0x3A20)
PR_PAGER_TELEPHONE_NUMBER                   = PROP_TAG( PT_TSTRING,   0x3A21)
PR_PAGER_TELEPHONE_NUMBER_W                 = PROP_TAG( PT_UNICODE,   0x3A21)
PR_PAGER_TELEPHONE_NUMBER_A                 = PROP_TAG( PT_STRING8,   0x3A21)
PR_BEEPER_TELEPHONE_NUMBER                  = PR_PAGER_TELEPHONE_NUMBER
PR_BEEPER_TELEPHONE_NUMBER_W                = PR_PAGER_TELEPHONE_NUMBER_W
PR_BEEPER_TELEPHONE_NUMBER_A                = PR_PAGER_TELEPHONE_NUMBER_A
PR_USER_CERTIFICATE                         = PROP_TAG( PT_BINARY,    0x3A22)
PR_PRIMARY_FAX_NUMBER                       = PROP_TAG( PT_TSTRING,   0x3A23)
PR_PRIMARY_FAX_NUMBER_W                     = PROP_TAG( PT_UNICODE,   0x3A23)
PR_PRIMARY_FAX_NUMBER_A                     = PROP_TAG( PT_STRING8,   0x3A23)
PR_BUSINESS_FAX_NUMBER                      = PROP_TAG( PT_TSTRING,   0x3A24)
PR_BUSINESS_FAX_NUMBER_W                    = PROP_TAG( PT_UNICODE,   0x3A24)
PR_BUSINESS_FAX_NUMBER_A                    = PROP_TAG( PT_STRING8,   0x3A24)
PR_HOME_FAX_NUMBER                          = PROP_TAG( PT_TSTRING,   0x3A25)
PR_HOME_FAX_NUMBER_W                        = PROP_TAG( PT_UNICODE,   0x3A25)
PR_HOME_FAX_NUMBER_A                        = PROP_TAG( PT_STRING8,   0x3A25)
PR_COUNTRY                                  = PROP_TAG( PT_TSTRING,   0x3A26)
PR_COUNTRY_W                                = PROP_TAG( PT_UNICODE,   0x3A26)
PR_COUNTRY_A                                = PROP_TAG( PT_STRING8,   0x3A26)
PR_BUSINESS_ADDRESS_COUNTRY                 = PR_COUNTRY
PR_BUSINESS_ADDRESS_COUNTRY_W               = PR_COUNTRY_W
PR_BUSINESS_ADDRESS_COUNTRY_A               = PR_COUNTRY_A
PR_LOCALITY                                 = PROP_TAG( PT_TSTRING,   0x3A27)
PR_LOCALITY_W                               = PROP_TAG( PT_UNICODE,   0x3A27)
PR_LOCALITY_A                               = PROP_TAG( PT_STRING8,   0x3A27)
PR_BUSINESS_ADDRESS_CITY                    = PR_LOCALITY
PR_BUSINESS_ADDRESS_CITY_W                  = PR_LOCALITY_W
PR_BUSINESS_ADDRESS_CITY_A                  = PR_LOCALITY_A
PR_STATE_OR_PROVINCE                        = PROP_TAG( PT_TSTRING,   0x3A28)
PR_STATE_OR_PROVINCE_W                      = PROP_TAG( PT_UNICODE,   0x3A28)
PR_STATE_OR_PROVINCE_A                      = PROP_TAG( PT_STRING8,   0x3A28)
PR_BUSINESS_ADDRESS_STATE_OR_PROVINCE       = PR_STATE_OR_PROVINCE
PR_BUSINESS_ADDRESS_STATE_OR_PROVINCE_W     = PR_STATE_OR_PROVINCE_W
PR_BUSINESS_ADDRESS_STATE_OR_PROVINCE_A     = PR_STATE_OR_PROVINCE_A
PR_STREET_ADDRESS                           = PROP_TAG( PT_TSTRING,   0x3A29)
PR_STREET_ADDRESS_W                         = PROP_TAG( PT_UNICODE,   0x3A29)
PR_STREET_ADDRESS_A                         = PROP_TAG( PT_STRING8,   0x3A29)
PR_BUSINESS_ADDRESS_STREET                  = PR_STREET_ADDRESS
PR_BUSINESS_ADDRESS_STREET_W                = PR_STREET_ADDRESS_W
PR_BUSINESS_ADDRESS_STREET_A                = PR_STREET_ADDRESS_A
PR_POSTAL_CODE                              = PROP_TAG( PT_TSTRING,   0x3A2A)
PR_POSTAL_CODE_W                            = PROP_TAG( PT_UNICODE,   0x3A2A)
PR_POSTAL_CODE_A                            = PROP_TAG( PT_STRING8,   0x3A2A)
PR_BUSINESS_ADDRESS_POSTAL_CODE             = PR_POSTAL_CODE
PR_BUSINESS_ADDRESS_POSTAL_CODE_W           = PR_POSTAL_CODE_W
PR_BUSINESS_ADDRESS_POSTAL_CODE_A           = PR_POSTAL_CODE_A
PR_POST_OFFICE_BOX                          = PROP_TAG( PT_TSTRING,   0x3A2B)
PR_POST_OFFICE_BOX_W                        = PROP_TAG( PT_UNICODE,   0x3A2B)
PR_POST_OFFICE_BOX_A                        = PROP_TAG( PT_STRING8,   0x3A2B)
PR_BUSINESS_ADDRESS_POST_OFFICE_BOX         = PR_POST_OFFICE_BOX
PR_BUSINESS_ADDRESS_POST_OFFICE_BOX_W       = PR_POST_OFFICE_BOX_W
PR_BUSINESS_ADDRESS_POST_OFFICE_BOX_A       = PR_POST_OFFICE_BOX_A
PR_TELEX_NUMBER                             = PROP_TAG( PT_TSTRING,   0x3A2C)
PR_TELEX_NUMBER_W                           = PROP_TAG( PT_UNICODE,   0x3A2C)
PR_TELEX_NUMBER_A                           = PROP_TAG( PT_STRING8,   0x3A2C)
PR_ISDN_NUMBER                              = PROP_TAG( PT_TSTRING,   0x3A2D)
PR_ISDN_NUMBER_W                            = PROP_TAG( PT_UNICODE,   0x3A2D)
PR_ISDN_NUMBER_A                            = PROP_TAG( PT_STRING8,   0x3A2D)
PR_ASSISTANT_TELEPHONE_NUMBER               = PROP_TAG( PT_TSTRING,   0x3A2E)
PR_ASSISTANT_TELEPHONE_NUMBER_W             = PROP_TAG( PT_UNICODE,   0x3A2E)
PR_ASSISTANT_TELEPHONE_NUMBER_A             = PROP_TAG( PT_STRING8,   0x3A2E)
PR_HOME2_TELEPHONE_NUMBER                   = PROP_TAG( PT_TSTRING,   0x3A2F)
PR_HOME2_TELEPHONE_NUMBER_W                 = PROP_TAG( PT_UNICODE,   0x3A2F)
PR_HOME2_TELEPHONE_NUMBER_A                 = PROP_TAG( PT_STRING8,   0x3A2F)
PR_ASSISTANT                                = PROP_TAG( PT_TSTRING,   0x3A30)
PR_ASSISTANT_W                              = PROP_TAG( PT_UNICODE,   0x3A30)
PR_ASSISTANT_A                              = PROP_TAG( PT_STRING8,   0x3A30)
PR_SEND_RICH_INFO                           = PROP_TAG( PT_BOOLEAN,   0x3A40)
PR_WEDDING_ANNIVERSARY                      = PROP_TAG( PT_SYSTIME, 0x3A41)
PR_BIRTHDAY                                 = PROP_TAG( PT_SYSTIME, 0x3A42)
PR_HOBBIES                                  = PROP_TAG( PT_TSTRING, 0x3A43)
PR_HOBBIES_W                                = PROP_TAG( PT_UNICODE, 0x3A43)
PR_HOBBIES_A                                = PROP_TAG( PT_STRING8, 0x3A43)
PR_MIDDLE_NAME                              = PROP_TAG( PT_TSTRING, 0x3A44)
PR_MIDDLE_NAME_W                            = PROP_TAG( PT_UNICODE, 0x3A44)
PR_MIDDLE_NAME_A                            = PROP_TAG( PT_STRING8, 0x3A44)
PR_DISPLAY_NAME_PREFIX                      = PROP_TAG( PT_TSTRING, 0x3A45)
PR_DISPLAY_NAME_PREFIX_W                    = PROP_TAG( PT_UNICODE, 0x3A45)
PR_DISPLAY_NAME_PREFIX_A                    = PROP_TAG( PT_STRING8, 0x3A45)
PR_PROFESSION                               = PROP_TAG( PT_TSTRING, 0x3A46)
PR_PROFESSION_W                             = PROP_TAG( PT_UNICODE, 0x3A46)
PR_PROFESSION_A                             = PROP_TAG( PT_STRING8, 0x3A46)
PR_PREFERRED_BY_NAME                        = PROP_TAG( PT_TSTRING, 0x3A47)
PR_PREFERRED_BY_NAME_W                      = PROP_TAG( PT_UNICODE, 0x3A47)
PR_PREFERRED_BY_NAME_A                      = PROP_TAG( PT_STRING8, 0x3A47)
PR_SPOUSE_NAME                              = PROP_TAG( PT_TSTRING, 0x3A48)
PR_SPOUSE_NAME_W                            = PROP_TAG( PT_UNICODE, 0x3A48)
PR_SPOUSE_NAME_A                            = PROP_TAG( PT_STRING8, 0x3A48)
PR_COMPUTER_NETWORK_NAME                    = PROP_TAG( PT_TSTRING, 0x3A49)
PR_COMPUTER_NETWORK_NAME_W                  = PROP_TAG( PT_UNICODE, 0x3A49)
PR_COMPUTER_NETWORK_NAME_A                  = PROP_TAG( PT_STRING8, 0x3A49)
PR_CUSTOMER_ID                              = PROP_TAG( PT_TSTRING, 0x3A4A)
PR_CUSTOMER_ID_W                            = PROP_TAG( PT_UNICODE, 0x3A4A)
PR_CUSTOMER_ID_A                            = PROP_TAG( PT_STRING8, 0x3A4A)
PR_TTYTDD_PHONE_NUMBER                      = PROP_TAG( PT_TSTRING, 0x3A4B)
PR_TTYTDD_PHONE_NUMBER_W                    = PROP_TAG( PT_UNICODE, 0x3A4B)
PR_TTYTDD_PHONE_NUMBER_A                    = PROP_TAG( PT_STRING8, 0x3A4B)
PR_FTP_SITE                                 = PROP_TAG( PT_TSTRING, 0x3A4C)
PR_FTP_SITE_W                               = PROP_TAG( PT_UNICODE, 0x3A4C)
PR_FTP_SITE_A                               = PROP_TAG( PT_STRING8, 0x3A4C)
PR_GENDER                                   = PROP_TAG( PT_SHORT, 0x3A4D)
PR_MANAGER_NAME                             = PROP_TAG( PT_TSTRING, 0x3A4E)
PR_MANAGER_NAME_W                           = PROP_TAG( PT_UNICODE, 0x3A4E)
PR_MANAGER_NAME_A                           = PROP_TAG( PT_STRING8, 0x3A4E)
PR_NICKNAME                                 = PROP_TAG( PT_TSTRING, 0x3A4F)
PR_NICKNAME_W                               = PROP_TAG( PT_UNICODE, 0x3A4F)
PR_NICKNAME_A                               = PROP_TAG( PT_STRING8, 0x3A4F)
PR_PERSONAL_HOME_PAGE                       = PROP_TAG( PT_TSTRING, 0x3A50)
PR_PERSONAL_HOME_PAGE_W                     = PROP_TAG( PT_UNICODE, 0x3A50)
PR_PERSONAL_HOME_PAGE_A                     = PROP_TAG( PT_STRING8, 0x3A50)
PR_BUSINESS_HOME_PAGE                       = PROP_TAG( PT_TSTRING, 0x3A51)
PR_BUSINESS_HOME_PAGE_W                     = PROP_TAG( PT_UNICODE, 0x3A51)
PR_BUSINESS_HOME_PAGE_A                     = PROP_TAG( PT_STRING8, 0x3A51)
PR_CONTACT_VERSION                          = PROP_TAG( PT_CLSID, 0x3A52)
PR_CONTACT_ENTRYIDS                         = PROP_TAG( PT_MV_BINARY, 0x3A53)
PR_CONTACT_ADDRTYPES                        = PROP_TAG( PT_MV_TSTRING, 0x3A54)
PR_CONTACT_ADDRTYPES_W                      = PROP_TAG( PT_MV_UNICODE, 0x3A54)
PR_CONTACT_ADDRTYPES_A                      = PROP_TAG( PT_MV_STRING8, 0x3A54)
PR_CONTACT_DEFAULT_ADDRESS_INDEX            = PROP_TAG( PT_LONG, 0x3A55)
PR_CONTACT_EMAIL_ADDRESSES                  = PROP_TAG( PT_MV_TSTRING, 0x3A56)
PR_CONTACT_EMAIL_ADDRESSES_W                = PROP_TAG( PT_MV_UNICODE, 0x3A56)
PR_CONTACT_EMAIL_ADDRESSES_A                = PROP_TAG( PT_MV_STRING8, 0x3A56)
PR_COMPANY_MAIN_PHONE_NUMBER                = PROP_TAG( PT_TSTRING, 0x3A57)
PR_COMPANY_MAIN_PHONE_NUMBER_W              = PROP_TAG( PT_UNICODE, 0x3A57)
PR_COMPANY_MAIN_PHONE_NUMBER_A              = PROP_TAG( PT_STRING8, 0x3A57)
PR_CHILDRENS_NAMES                          = PROP_TAG( PT_MV_TSTRING, 0x3A58)
PR_CHILDRENS_NAMES_W                        = PROP_TAG( PT_MV_UNICODE, 0x3A58)
PR_CHILDRENS_NAMES_A                        = PROP_TAG( PT_MV_STRING8, 0x3A58)
PR_HOME_ADDRESS_CITY                        = PROP_TAG( PT_TSTRING, 0x3A59)
PR_HOME_ADDRESS_CITY_W                      = PROP_TAG( PT_UNICODE, 0x3A59)
PR_HOME_ADDRESS_CITY_A                      = PROP_TAG( PT_STRING8, 0x3A59)
PR_HOME_ADDRESS_COUNTRY                     = PROP_TAG( PT_TSTRING, 0x3A5A)
PR_HOME_ADDRESS_COUNTRY_W                   = PROP_TAG( PT_UNICODE, 0x3A5A)
PR_HOME_ADDRESS_COUNTRY_A                   = PROP_TAG( PT_STRING8, 0x3A5A)
PR_HOME_ADDRESS_POSTAL_CODE                 = PROP_TAG( PT_TSTRING, 0x3A5B)
PR_HOME_ADDRESS_POSTAL_CODE_W               = PROP_TAG( PT_UNICODE, 0x3A5B)
PR_HOME_ADDRESS_POSTAL_CODE_A               = PROP_TAG( PT_STRING8, 0x3A5B)
PR_HOME_ADDRESS_STATE_OR_PROVINCE           = PROP_TAG( PT_TSTRING, 0x3A5C)
PR_HOME_ADDRESS_STATE_OR_PROVINCE_W         = PROP_TAG( PT_UNICODE, 0x3A5C)
PR_HOME_ADDRESS_STATE_OR_PROVINCE_A         = PROP_TAG( PT_STRING8, 0x3A5C)
PR_HOME_ADDRESS_STREET                      = PROP_TAG( PT_TSTRING, 0x3A5D)
PR_HOME_ADDRESS_STREET_W                    = PROP_TAG( PT_UNICODE, 0x3A5D)
PR_HOME_ADDRESS_STREET_A                    = PROP_TAG( PT_STRING8, 0x3A5D)
PR_HOME_ADDRESS_POST_OFFICE_BOX             = PROP_TAG( PT_TSTRING, 0x3A5E)
PR_HOME_ADDRESS_POST_OFFICE_BOX_W           = PROP_TAG( PT_UNICODE, 0x3A5E)
PR_HOME_ADDRESS_POST_OFFICE_BOX_A           = PROP_TAG( PT_STRING8, 0x3A5E)
PR_OTHER_ADDRESS_CITY                       = PROP_TAG( PT_TSTRING, 0x3A5F)
PR_OTHER_ADDRESS_CITY_W                     = PROP_TAG( PT_UNICODE, 0x3A5F)
PR_OTHER_ADDRESS_CITY_A                     = PROP_TAG( PT_STRING8, 0x3A5F)
PR_OTHER_ADDRESS_COUNTRY                    = PROP_TAG( PT_TSTRING, 0x3A60)
PR_OTHER_ADDRESS_COUNTRY_W                  = PROP_TAG( PT_UNICODE, 0x3A60)
PR_OTHER_ADDRESS_COUNTRY_A                  = PROP_TAG( PT_STRING8, 0x3A60)
PR_OTHER_ADDRESS_POSTAL_CODE                = PROP_TAG( PT_TSTRING, 0x3A61)
PR_OTHER_ADDRESS_POSTAL_CODE_W              = PROP_TAG( PT_UNICODE, 0x3A61)
PR_OTHER_ADDRESS_POSTAL_CODE_A              = PROP_TAG( PT_STRING8, 0x3A61)
PR_OTHER_ADDRESS_STATE_OR_PROVINCE          = PROP_TAG( PT_TSTRING, 0x3A62)
PR_OTHER_ADDRESS_STATE_OR_PROVINCE_W        = PROP_TAG( PT_UNICODE, 0x3A62)
PR_OTHER_ADDRESS_STATE_OR_PROVINCE_A        = PROP_TAG( PT_STRING8, 0x3A62)
PR_OTHER_ADDRESS_STREET                     = PROP_TAG( PT_TSTRING, 0x3A63)
PR_OTHER_ADDRESS_STREET_W                   = PROP_TAG( PT_UNICODE, 0x3A63)
PR_OTHER_ADDRESS_STREET_A                   = PROP_TAG( PT_STRING8, 0x3A63)
PR_OTHER_ADDRESS_POST_OFFICE_BOX            = PROP_TAG( PT_TSTRING, 0x3A64)
PR_OTHER_ADDRESS_POST_OFFICE_BOX_W          = PROP_TAG( PT_UNICODE, 0x3A64)
PR_OTHER_ADDRESS_POST_OFFICE_BOX_A          = PROP_TAG( PT_STRING8, 0x3A64)
PR_STORE_PROVIDERS                          = PROP_TAG( PT_BINARY,    0x3D00)
PR_AB_PROVIDERS                             = PROP_TAG( PT_BINARY,    0x3D01)
PR_TRANSPORT_PROVIDERS                      = PROP_TAG( PT_BINARY,    0x3D02)
PR_DEFAULT_PROFILE                          = PROP_TAG( PT_BOOLEAN,   0x3D04)
PR_AB_SEARCH_PATH                           = PROP_TAG( PT_MV_BINARY, 0x3D05)
PR_AB_DEFAULT_DIR                           = PROP_TAG( PT_BINARY,    0x3D06)
PR_AB_DEFAULT_PAB                           = PROP_TAG( PT_BINARY,    0x3D07)
PR_FILTERING_HOOKS                          = PROP_TAG( PT_BINARY,    0x3D08)
PR_SERVICE_NAME                             = PROP_TAG( PT_TSTRING,   0x3D09)
PR_SERVICE_NAME_W                           = PROP_TAG( PT_UNICODE,   0x3D09)
PR_SERVICE_NAME_A                           = PROP_TAG( PT_STRING8,   0x3D09)
PR_SERVICE_DLL_NAME                         = PROP_TAG( PT_TSTRING,   0x3D0A)
PR_SERVICE_DLL_NAME_W                       = PROP_TAG( PT_UNICODE,   0x3D0A)
PR_SERVICE_DLL_NAME_A                       = PROP_TAG( PT_STRING8,   0x3D0A)
PR_SERVICE_ENTRY_NAME                       = PROP_TAG( PT_STRING8,   0x3D0B)
PR_SERVICE_UID                              = PROP_TAG( PT_BINARY,    0x3D0C)
PR_SERVICE_EXTRA_UIDS                       = PROP_TAG( PT_BINARY,    0x3D0D)
PR_SERVICES                                 = PROP_TAG( PT_BINARY,    0x3D0E)
PR_SERVICE_SUPPORT_FILES                    = PROP_TAG( PT_MV_TSTRING, 0x3D0F)
PR_SERVICE_SUPPORT_FILES_W                  = PROP_TAG( PT_MV_UNICODE, 0x3D0F)
PR_SERVICE_SUPPORT_FILES_A                  = PROP_TAG( PT_MV_STRING8, 0x3D0F)
PR_SERVICE_DELETE_FILES                     = PROP_TAG( PT_MV_TSTRING, 0x3D10)
PR_SERVICE_DELETE_FILES_W                   = PROP_TAG( PT_MV_UNICODE, 0x3D10)
PR_SERVICE_DELETE_FILES_A                   = PROP_TAG( PT_MV_STRING8, 0x3D10)
PR_AB_SEARCH_PATH_UPDATE                    = PROP_TAG( PT_BINARY,     0x3D11)
PR_PROFILE_NAME                             = PROP_TAG( PT_TSTRING,   0x3D12)
PR_PROFILE_NAME_A                           = PROP_TAG( PT_STRING8,   0x3D12)
PR_PROFILE_NAME_W                           = PROP_TAG( PT_UNICODE,   0x3D12)
PR_IDENTITY_DISPLAY                         = PROP_TAG( PT_TSTRING,   0x3E00)
PR_IDENTITY_DISPLAY_W                       = PROP_TAG( PT_UNICODE,   0x3E00)
PR_IDENTITY_DISPLAY_A                       = PROP_TAG( PT_STRING8,   0x3E00)
PR_IDENTITY_ENTRYID                         = PROP_TAG( PT_BINARY,    0x3E01)
PR_RESOURCE_METHODS                         = PROP_TAG( PT_LONG,      0x3E02)
PR_RESOURCE_TYPE                            = PROP_TAG( PT_LONG,      0x3E03)
PR_STATUS_CODE                              = PROP_TAG( PT_LONG,      0x3E04)
PR_IDENTITY_SEARCH_KEY                      = PROP_TAG( PT_BINARY,    0x3E05)
PR_OWN_STORE_ENTRYID                        = PROP_TAG( PT_BINARY,    0x3E06)
PR_RESOURCE_PATH                            = PROP_TAG( PT_TSTRING,   0x3E07)
PR_RESOURCE_PATH_W                          = PROP_TAG( PT_UNICODE,   0x3E07)
PR_RESOURCE_PATH_A                          = PROP_TAG( PT_STRING8,   0x3E07)
PR_STATUS_STRING                            = PROP_TAG( PT_TSTRING,   0x3E08)
PR_STATUS_STRING_W                          = PROP_TAG( PT_UNICODE,   0x3E08)
PR_STATUS_STRING_A                          = PROP_TAG( PT_STRING8,   0x3E08)
PR_X400_DEFERRED_DELIVERY_CANCEL            = PROP_TAG( PT_BOOLEAN,   0x3E09)
PR_HEADER_FOLDER_ENTRYID                    = PROP_TAG( PT_BINARY,    0x3E0A)
PR_REMOTE_PROGRESS                          = PROP_TAG( PT_LONG,      0x3E0B)
PR_REMOTE_PROGRESS_TEXT                     = PROP_TAG( PT_TSTRING,   0x3E0C)
PR_REMOTE_PROGRESS_TEXT_W                   = PROP_TAG( PT_UNICODE,   0x3E0C)
PR_REMOTE_PROGRESS_TEXT_A                   = PROP_TAG( PT_STRING8,   0x3E0C)
PR_REMOTE_VALIDATE_OK                       = PROP_TAG( PT_BOOLEAN,   0x3E0D)
PR_CONTROL_FLAGS                            = PROP_TAG( PT_LONG,      0x3F00)
PR_CONTROL_STRUCTURE                        = PROP_TAG( PT_BINARY,    0x3F01)
PR_CONTROL_TYPE                             = PROP_TAG( PT_LONG,      0x3F02)
PR_DELTAX                                   = PROP_TAG( PT_LONG,      0x3F03)
PR_DELTAY                                   = PROP_TAG( PT_LONG,      0x3F04)
PR_XPOS                                     = PROP_TAG( PT_LONG,      0x3F05)
PR_YPOS                                     = PROP_TAG( PT_LONG,      0x3F06)
PR_CONTROL_ID                               = PROP_TAG( PT_BINARY,    0x3F07)
PR_INITIAL_DETAILS_PANE                     = PROP_TAG( PT_LONG,      0x3F08)

PROP_ID_SECURE_MIN =                         0x67F0
PROP_ID_SECURE_MAX =                         0x67FF

# From EDKMDB.H
pidExchangeXmitReservedMin		= 0x3FE0
pidExchangeNonXmitReservedMin	= 0x65E0
pidProfileMin					= 0x6600
pidStoreMin						= 0x6618
pidFolderMin					= 0x6638
pidMessageReadOnlyMin			= 0x6640
pidMessageWriteableMin			= 0x6658
pidAttachReadOnlyMin			= 0x666C
pidSpecialMin					= 0x6670
pidAdminMin						= 0x6690
pidSecureProfileMin				= PROP_ID_SECURE_MIN

PR_PROFILE_VERSION				= PROP_TAG( PT_LONG, pidProfileMin+0x00)
PR_PROFILE_CONFIG_FLAGS			= PROP_TAG( PT_LONG, pidProfileMin+0x01)
PR_PROFILE_HOME_SERVER			= PROP_TAG( PT_STRING8, pidProfileMin+0x02)
PR_PROFILE_HOME_SERVER_DN		= PROP_TAG( PT_STRING8, pidProfileMin+0x12)
PR_PROFILE_HOME_SERVER_ADDRS	= PROP_TAG( PT_MV_STRING8, pidProfileMin+0x13)
PR_PROFILE_USER					= PROP_TAG( PT_STRING8, pidProfileMin+0x03)
PR_PROFILE_CONNECT_FLAGS		= PROP_TAG( PT_LONG, pidProfileMin+0x04)
PR_PROFILE_TRANSPORT_FLAGS		= PROP_TAG( PT_LONG, pidProfileMin+0x05)
PR_PROFILE_UI_STATE				= PROP_TAG( PT_LONG, pidProfileMin+0x06)
PR_PROFILE_UNRESOLVED_NAME		= PROP_TAG( PT_STRING8, pidProfileMin+0x07)
PR_PROFILE_UNRESOLVED_SERVER	= PROP_TAG( PT_STRING8, pidProfileMin+0x08)
PR_PROFILE_BINDING_ORDER		= PROP_TAG( PT_STRING8, pidProfileMin+0x09)
PR_PROFILE_MAX_RESTRICT			= PROP_TAG( PT_LONG, pidProfileMin+0x0D)
PR_PROFILE_AB_FILES_PATH		= PROP_TAG( PT_STRING8, pidProfileMin+0xE)
PR_PROFILE_OFFLINE_STORE_PATH	= PROP_TAG( PT_STRING8, pidProfileMin+0x10)
PR_PROFILE_OFFLINE_INFO			= PROP_TAG( PT_BINARY, pidProfileMin+0x11)
PR_PROFILE_ADDR_INFO			= PROP_TAG( PT_BINARY, pidSpecialMin+0x17)
PR_PROFILE_OPTIONS_DATA			= PROP_TAG( PT_BINARY, pidSpecialMin+0x19)
PR_PROFILE_SECURE_MAILBOX		= PROP_TAG( PT_BINARY, pidSecureProfileMin + 0)
PR_DISABLE_WINSOCK				= PROP_TAG( PT_LONG, pidProfileMin+0x18)
PR_OST_ENCRYPTION				= PROP_TAG(PT_LONG, 0x6702)
PR_PROFILE_OPEN_FLAGS			= PROP_TAG( PT_LONG, pidProfileMin+0x09)
PR_PROFILE_TYPE					= PROP_TAG( PT_LONG, pidProfileMin+0x0A)
PR_PROFILE_MAILBOX				= PROP_TAG( PT_STRING8, pidProfileMin+0x0B)
PR_PROFILE_SERVER				= PROP_TAG( PT_STRING8, pidProfileMin+0x0C)
PR_PROFILE_SERVER_DN			= PROP_TAG( PT_STRING8, pidProfileMin+0x14)
PR_PROFILE_FAVFLD_DISPLAY_NAME	= PROP_TAG(PT_STRING8, pidProfileMin+0x0F)
PR_PROFILE_FAVFLD_COMMENT		= PROP_TAG(PT_STRING8, pidProfileMin+0x15)
PR_PROFILE_ALLPUB_DISPLAY_NAME	= PROP_TAG(PT_STRING8, pidProfileMin+0x16)
PR_PROFILE_ALLPUB_COMMENT		= PROP_TAG(PT_STRING8, pidProfileMin+0x17)

OSTF_NO_ENCRYPTION              = 0x80000000
OSTF_COMPRESSABLE_ENCRYPTION    = 0x40000000
OSTF_BEST_ENCRYPTION            = 0x20000000


PR_NON_IPM_SUBTREE_ENTRYID				= PROP_TAG( PT_BINARY, pidStoreMin+0x08)
PR_EFORMS_REGISTRY_ENTRYID				= PROP_TAG( PT_BINARY, pidStoreMin+0x09)
PR_SPLUS_FREE_BUSY_ENTRYID				= PROP_TAG( PT_BINARY, pidStoreMin+0x0A)
PR_OFFLINE_ADDRBOOK_ENTRYID				= PROP_TAG( PT_BINARY, pidStoreMin+0x0B)
PR_EFORMS_FOR_LOCALE_ENTRYID			= PROP_TAG( PT_BINARY, pidStoreMin+0x0C)
PR_FREE_BUSY_FOR_LOCAL_SITE_ENTRYID		= PROP_TAG( PT_BINARY, pidStoreMin+0x0D)
PR_ADDRBOOK_FOR_LOCAL_SITE_ENTRYID		= PROP_TAG( PT_BINARY, pidStoreMin+0x0E)
PR_OFFLINE_MESSAGE_ENTRYID				= PROP_TAG( PT_BINARY, pidStoreMin+0x0F)
PR_IPM_FAVORITES_ENTRYID				= PROP_TAG( PT_BINARY, pidStoreMin+0x18)
PR_IPM_PUBLIC_FOLDERS_ENTRYID			= PROP_TAG( PT_BINARY, pidStoreMin+0x19)
PR_GW_MTSIN_ENTRYID				= PROP_TAG( PT_BINARY, pidStoreMin+0x10)
PR_GW_MTSOUT_ENTRYID			= PROP_TAG( PT_BINARY, pidStoreMin+0x11)
PR_TRANSFER_ENABLED				= PROP_TAG( PT_BOOLEAN, pidStoreMin+0x12)
PR_TEST_LINE_SPEED				= PROP_TAG( PT_BINARY, pidStoreMin+0x13)
PR_HIERARCHY_SYNCHRONIZER		= PROP_TAG( PT_OBJECT, pidStoreMin+0x14)
PR_CONTENTS_SYNCHRONIZER		= PROP_TAG( PT_OBJECT, pidStoreMin+0x15)
PR_COLLECTOR					= PROP_TAG( PT_OBJECT, pidStoreMin+0x16)
PR_FAST_TRANSFER				= PROP_TAG( PT_OBJECT, pidStoreMin+0x17)
PR_STORE_OFFLINE				= PROP_TAG( PT_BOOLEAN, pidStoreMin+0x1A)
PR_IN_TRANSIT					= PROP_TAG( PT_BOOLEAN, pidStoreMin)
PR_REPLICATION_STYLE			= PROP_TAG( PT_LONG, pidAdminMin)
PR_REPLICATION_SCHEDULE			= PROP_TAG( PT_BINARY, pidAdminMin+0x01)
PR_REPLICATION_MESSAGE_PRIORITY = PROP_TAG( PT_LONG, pidAdminMin+0x02)
PR_OVERALL_MSG_AGE_LIMIT		= PROP_TAG( PT_LONG, pidAdminMin+0x03 )
PR_REPLICATION_ALWAYS_INTERVAL	= PROP_TAG( PT_LONG, pidAdminMin+0x04 )
PR_REPLICATION_MSG_SIZE			= PROP_TAG( PT_LONG, pidAdminMin+0x05 )
STYLE_ALWAYS_INTERVAL_DEFAULT	= 15
REPLICATION_MESSAGE_SIZE_LIMIT_DEFAULT	= 100
STYLE_NEVER				= 0
STYLE_NORMAL			= 1
STYLE_ALWAYS			= 2
STYLE_DEFAULT			= -1
PR_SOURCE_KEY					= PROP_TAG( PT_BINARY, pidExchangeNonXmitReservedMin+0x0)
PR_PARENT_SOURCE_KEY			= PROP_TAG( PT_BINARY, pidExchangeNonXmitReservedMin+0x1)
PR_CHANGE_KEY					= PROP_TAG( PT_BINARY, pidExchangeNonXmitReservedMin+0x2)
PR_PREDECESSOR_CHANGE_LIST		= PROP_TAG( PT_BINARY, pidExchangeNonXmitReservedMin+0x3)
PR_FOLDER_CHILD_COUNT			= PROP_TAG( PT_LONG, pidFolderMin)
PR_RIGHTS						= PROP_TAG( PT_LONG, pidFolderMin+0x01)
PR_ACL_TABLE					= PROP_TAG( PT_OBJECT, pidExchangeXmitReservedMin)
PR_RULES_TABLE					= PROP_TAG( PT_OBJECT, pidExchangeXmitReservedMin+0x1)
PR_HAS_RULES				= PROP_TAG( PT_BOOLEAN, pidFolderMin+0x02)
PR_ADDRESS_BOOK_ENTRYID		= PROP_TAG( PT_BINARY, pidFolderMin+0x03)
PR_ACL_DATA					= PROP_TAG( PT_BINARY, pidExchangeXmitReservedMin)
PR_RULES_DATA				= PROP_TAG( PT_BINARY, pidExchangeXmitReservedMin+0x1)
PR_FOLDER_DESIGN_FLAGS		= PROP_TAG( PT_LONG, pidExchangeXmitReservedMin+0x2)
PR_DESIGN_IN_PROGRESS		= PROP_TAG( PT_BOOLEAN, pidExchangeXmitReservedMin+0x4)
PR_SECURE_ORIGINATION		= PROP_TAG( PT_BOOLEAN, pidExchangeXmitReservedMin+0x5)
PR_PUBLISH_IN_ADDRESS_BOOK	= PROP_TAG( PT_BOOLEAN, pidExchangeXmitReservedMin+0x6)
PR_RESOLVE_METHOD			= PROP_TAG( PT_LONG,  pidExchangeXmitReservedMin+0x7)
PR_ADDRESS_BOOK_DISPLAY_NAME	= PROP_TAG( PT_TSTRING, pidExchangeXmitReservedMin+0x8)
PR_EFORMS_LOCALE_ID			= PROP_TAG( PT_LONG, pidExchangeXmitReservedMin+0x9)
PR_REPLICA_LIST				= PROP_TAG( PT_BINARY, pidAdminMin+0x8)
PR_OVERALL_AGE_LIMIT		= PROP_TAG( PT_LONG, pidAdminMin+0x9)
RESOLVE_METHOD_DEFAULT			= 0
RESOLVE_METHOD_LAST_WRITER_WINS	= 1
RESOLVE_METHOD_NO_CONFLICT_NOTIFICATION = 2
PR_PUBLIC_FOLDER_ENTRYID	= PROP_TAG( PT_BINARY, pidFolderMin+0x04)
PR_HAS_NAMED_PROPERTIES			= PROP_TAG(PT_BOOLEAN, pidMessageReadOnlyMin+0x0A)
PR_CREATOR_NAME					= PROP_TAG(PT_TSTRING, pidExchangeXmitReservedMin+0x18)
PR_CREATOR_ENTRYID				= PROP_TAG(PT_BINARY, pidExchangeXmitReservedMin+0x19)
PR_LAST_MODIFIER_NAME			= PROP_TAG(PT_TSTRING, pidExchangeXmitReservedMin+0x1A)
PR_LAST_MODIFIER_ENTRYID		= PROP_TAG(PT_BINARY, pidExchangeXmitReservedMin+0x1B)
PR_HAS_DAMS						= PROP_TAG( PT_BOOLEAN, pidExchangeXmitReservedMin+0xA)
PR_RULE_TRIGGER_HISTORY			= PROP_TAG( PT_BINARY, pidExchangeXmitReservedMin+0x12)
PR_MOVE_TO_STORE_ENTRYID		= PROP_TAG( PT_BINARY, pidExchangeXmitReservedMin+0x13)
PR_MOVE_TO_FOLDER_ENTRYID		= PROP_TAG( PT_BINARY, pidExchangeXmitReservedMin+0x14)
PR_REPLICA_SERVER				= PROP_TAG(PT_TSTRING, pidMessageReadOnlyMin+0x4)
PR_DEFERRED_SEND_NUMBER			= PROP_TAG( PT_LONG, pidExchangeXmitReservedMin+0xB)
PR_DEFERRED_SEND_UNITS			= PROP_TAG( PT_LONG, pidExchangeXmitReservedMin+0xC)
PR_EXPIRY_NUMBER				= PROP_TAG( PT_LONG, pidExchangeXmitReservedMin+0xD)
PR_EXPIRY_UNITS					= PROP_TAG( PT_LONG, pidExchangeXmitReservedMin+0xE)
PR_DEFERRED_SEND_TIME			= PROP_TAG( PT_SYSTIME, pidExchangeXmitReservedMin+0xF)
PR_GW_ADMIN_OPERATIONS			= PROP_TAG( PT_LONG, pidMessageWriteableMin)
PR_P1_CONTENT					= PROP_TAG( PT_BINARY, 0x1100)
PR_P1_CONTENT_TYPE				= PROP_TAG( PT_BINARY, 0x1101)
PR_CLIENT_ACTIONS		  		= PROP_TAG(PT_BINARY, pidMessageReadOnlyMin+0x5)
PR_DAM_ORIGINAL_ENTRYID			= PROP_TAG(PT_BINARY, pidMessageReadOnlyMin+0x6)
PR_DAM_BACK_PATCHED				= PROP_TAG( PT_BOOLEAN, pidMessageReadOnlyMin+0x7)
PR_RULE_ERROR					= PROP_TAG(PT_LONG, pidMessageReadOnlyMin+0x8)
PR_RULE_ACTION_TYPE				= PROP_TAG(PT_LONG, pidMessageReadOnlyMin+0x9)
PR_RULE_ACTION_NUMBER			= PROP_TAG(PT_LONG, pidMessageReadOnlyMin+0x10)
PR_RULE_FOLDER_ENTRYID			= PROP_TAG(PT_BINARY, pidMessageReadOnlyMin+0x11)
PR_CONFLICT_ENTRYID				= PROP_TAG(PT_BINARY, pidExchangeXmitReservedMin+0x10)
PR_MESSAGE_LOCALE_ID			= PROP_TAG(PT_LONG, pidExchangeXmitReservedMin+0x11)
PR_STORAGE_QUOTA_LIMIT			= PROP_TAG(PT_LONG, pidExchangeXmitReservedMin+0x15)
PR_EXCESS_STORAGE_USED			= PROP_TAG(PT_LONG, pidExchangeXmitReservedMin+0x16)
PR_SVR_GENERATING_QUOTA_MSG		= PROP_TAG(PT_TSTRING, pidExchangeXmitReservedMin+0x17)
PR_DELEGATED_BY_RULE			= PROP_TAG( PT_BOOLEAN, pidExchangeXmitReservedMin+0x3)
MSGSTATUS_IN_CONFLICT			= 0x800
PR_IN_CONFLICT					= PROP_TAG(PT_BOOLEAN, pidAttachReadOnlyMin)
PR_LONGTERM_ENTRYID_FROM_TABLE	= PROP_TAG(PT_BINARY, pidSpecialMin)
PR_ORIGINATOR_NAME				= PROP_TAG( PT_TSTRING, pidMessageWriteableMin+0x3)
PR_ORIGINATOR_ADDR				= PROP_TAG( PT_TSTRING, pidMessageWriteableMin+0x4)
PR_ORIGINATOR_ADDRTYPE			= PROP_TAG( PT_TSTRING, pidMessageWriteableMin+0x5)
PR_ORIGINATOR_ENTRYID			= PROP_TAG( PT_BINARY, pidMessageWriteableMin+0x6)
PR_ARRIVAL_TIME					= PROP_TAG( PT_SYSTIME, pidMessageWriteableMin+0x7)
PR_TRACE_INFO					= PROP_TAG( PT_BINARY, pidMessageWriteableMin+0x8)
PR_INTERNAL_TRACE_INFO 			= PROP_TAG( PT_BINARY, pidMessageWriteableMin+0x12)
PR_SUBJECT_TRACE_INFO			= PROP_TAG( PT_BINARY, pidMessageWriteableMin+0x9)
PR_RECIPIENT_NUMBER				= PROP_TAG( PT_LONG, pidMessageWriteableMin+0xA)
PR_MTS_SUBJECT_ID				= PROP_TAG(PT_BINARY, pidMessageWriteableMin+0xB)
PR_REPORT_DESTINATION_NAME		= PROP_TAG(PT_TSTRING, pidMessageWriteableMin+0xC)
PR_REPORT_DESTINATION_ENTRYID	= PROP_TAG(PT_BINARY, pidMessageWriteableMin+0xD)
PR_CONTENT_SEARCH_KEY			= PROP_TAG(PT_BINARY, pidMessageWriteableMin+0xE)
PR_FOREIGN_ID					= PROP_TAG(PT_BINARY, pidMessageWriteableMin+0xF)
PR_FOREIGN_REPORT_ID			= PROP_TAG(PT_BINARY, pidMessageWriteableMin+0x10)
PR_FOREIGN_SUBJECT_ID			= PROP_TAG(PT_BINARY, pidMessageWriteableMin+0x11)
PR_MTS_ID						= PR_MESSAGE_SUBMISSION_ID
PR_MTS_REPORT_ID				= PR_MESSAGE_SUBMISSION_ID

PR_FOLDER_FLAGS                         = PROP_TAG( PT_LONG, pidAdminMin+0x18 )
PR_LAST_ACCESS_TIME		=				PROP_TAG( PT_SYSTIME, pidAdminMin+0x19 )
PR_RESTRICTION_COUNT                    = PROP_TAG( PT_LONG, pidAdminMin+0x1A )
PR_CATEG_COUNT                          = PROP_TAG( PT_LONG, pidAdminMin+0x1B )
PR_CACHED_COLUMN_COUNT                  = PROP_TAG( PT_LONG, pidAdminMin+0x1C )
PR_NORMAL_MSG_W_ATTACH_COUNT    		= PROP_TAG( PT_LONG, pidAdminMin+0x1D )
PR_ASSOC_MSG_W_ATTACH_COUNT             = PROP_TAG( PT_LONG, pidAdminMin+0x1E )
PR_RECIPIENT_ON_NORMAL_MSG_COUNT        = PROP_TAG( PT_LONG, pidAdminMin+0x1F )
PR_RECIPIENT_ON_ASSOC_MSG_COUNT 		= PROP_TAG( PT_LONG, pidAdminMin+0x20 )
PR_ATTACH_ON_NORMAL_MSG_COUNT   		= PROP_TAG( PT_LONG, pidAdminMin+0x21 )
PR_ATTACH_ON_ASSOC_MSG_COUNT    		= PROP_TAG( PT_LONG, pidAdminMin+0x22 )
PR_NORMAL_MESSAGE_SIZE                  = PROP_TAG( PT_LONG, pidAdminMin+0x23 )
PR_NORMAL_MESSAGE_SIZE_EXTENDED         = PROP_TAG( PT_I8, pidAdminMin+0x23 )
PR_ASSOC_MESSAGE_SIZE                   = PROP_TAG( PT_LONG, pidAdminMin+0x24 )
PR_ASSOC_MESSAGE_SIZE_EXTENDED          = PROP_TAG( PT_I8, pidAdminMin+0x24 )
PR_FOLDER_PATHNAME                      = PROP_TAG(PT_TSTRING, pidAdminMin+0x25 )
PR_OWNER_COUNT							= PROP_TAG( PT_LONG, pidAdminMin+0x26 )
PR_CONTACT_COUNT						= PROP_TAG( PT_LONG, pidAdminMin+0x27 )

PR_MESSAGE_SIZE_EXTENDED			= PROP_TAG(PT_I8, PROP_ID(PR_MESSAGE_SIZE))

