// PyGObjectSafety.cpp

#include "stdafx.h"
#include "PyIObjectSafety.h"

// Std delegation
STDMETHODIMP_(ULONG) PyGObjectSafety::AddRef(void) {return PyGatewayBase::AddRef();} \
STDMETHODIMP_(ULONG) PyGObjectSafety::Release(void) {return PyGatewayBase::Release();} \
STDMETHODIMP PyGObjectSafety::QueryInterface(REFIID iid, void ** obj) {return PyGatewayBase::QueryInterface(iid, obj);} \
STDMETHODIMP PyGObjectSafety::GetTypeInfoCount(UINT FAR* pctInfo) {return PyGatewayBase::GetTypeInfoCount(pctInfo);} \
STDMETHODIMP PyGObjectSafety::GetTypeInfo(UINT itinfo, LCID lcid, ITypeInfo FAR* FAR* pptInfo) {return PyGatewayBase::GetTypeInfo(itinfo, lcid, pptInfo);} \
STDMETHODIMP PyGObjectSafety::GetIDsOfNames(REFIID refiid, OLECHAR FAR* FAR* rgszNames, UINT cNames, LCID lcid, DISPID FAR* rgdispid) {return PyGatewayBase::GetIDsOfNames( refiid, rgszNames, cNames, lcid, rgdispid);} \
STDMETHODIMP PyGObjectSafety::Invoke(DISPID dispid, REFIID riid, LCID lcid, WORD wFlags, DISPPARAMS FAR* params, VARIANT FAR* pVarResult, EXCEPINFO FAR* pexcepinfo, UINT FAR* puArgErr) {return PyGatewayBase::Invoke( dispid, riid, lcid, wFlags, params, pVarResult, pexcepinfo, puArgErr);}


STDMETHODIMP PyGObjectSafety::GetInterfaceSafetyOptions( 
        /* [in] */ REFIID riid,
        /* [out] */ DWORD __RPC_FAR *pdwSupportedOptions,
        /* [out] */ DWORD __RPC_FAR *pdwEnabledOptions)
{
	PY_GATEWAY_METHOD;
	PyObject *obIID = PyCom_PyIIDObjectFromIID(riid);
	PyObject * result = NULL;
	HRESULT hr = S_OK;
	if (obIID) {
		hr = InvokeViaPolicy(	"GetInterfaceSafetyOptions", &result,
									"O",
									obIID);
		if (FAILED(hr))
			return hr;
	}

	if (result)
		PyArg_ParseTuple(result, "ii", pdwSupportedOptions, pdwEnabledOptions);
	if (PyErr_Occurred())
		hr = PyCom_HandlePythonFailureToCOM();
	PyTS_XDECREF(obIID);
	PyTS_XDECREF(result);
	return hr;
}
    
STDMETHODIMP PyGObjectSafety::SetInterfaceSafetyOptions( 
        /* [in] */ REFIID riid,
        /* [in] */ DWORD dwOptionSetMask,
        /* [in] */ DWORD dwEnabledOptions)
{
	PY_GATEWAY_METHOD;
	PyObject *obIID = PyCom_PyIIDObjectFromIID(riid);
	PyObject * result = NULL;
	if (obIID)  {
		HRESULT hr = InvokeViaPolicy(	"SetInterfaceSafetyOptions", &result,
									"Oii",
									obIID,
									dwOptionSetMask,
									dwEnabledOptions);
		if (FAILED(hr))
			return hr;
	}
	HRESULT hr = result==NULL ? PyCom_HandlePythonFailureToCOM() : S_OK;
	PyTS_XDECREF(obIID);
	PyTS_XDECREF(result);
	return hr;
}
