// PyGActiveScriptParse.cpp

#include "stdafx.h"

// Std delegation
STDMETHODIMP_(ULONG) PyGActiveScriptParse::AddRef(void) {return PyGatewayBase::AddRef();} \
STDMETHODIMP_(ULONG) PyGActiveScriptParse::Release(void) {return PyGatewayBase::Release();} \
STDMETHODIMP PyGActiveScriptParse::QueryInterface(REFIID iid, void ** obj) {return PyGatewayBase::QueryInterface(iid, obj);} \
STDMETHODIMP PyGActiveScriptParse::GetTypeInfoCount(UINT FAR* pctInfo) {return PyGatewayBase::GetTypeInfoCount(pctInfo);} \
STDMETHODIMP PyGActiveScriptParse::GetTypeInfo(UINT itinfo, LCID lcid, ITypeInfo FAR* FAR* pptInfo) {return PyGatewayBase::GetTypeInfo(itinfo, lcid, pptInfo);} \
STDMETHODIMP PyGActiveScriptParse::GetIDsOfNames(REFIID refiid, OLECHAR FAR* FAR* rgszNames, UINT cNames, LCID lcid, DISPID FAR* rgdispid) {return PyGatewayBase::GetIDsOfNames( refiid, rgszNames, cNames, lcid, rgdispid);} \
STDMETHODIMP PyGActiveScriptParse::Invoke(DISPID dispid, REFIID riid, LCID lcid, WORD wFlags, DISPPARAMS FAR* params, VARIANT FAR* pVarResult, EXCEPINFO FAR* pexcepinfo, UINT FAR* puArgErr) {return PyGatewayBase::Invoke( dispid, riid, lcid, wFlags, params, pVarResult, pexcepinfo, puArgErr);}

	// IActiveScriptParse
STDMETHODIMP PyGActiveScriptParse::InitNew(void)
{
	PY_GATEWAY_METHOD;
	return InvokeViaPolicy(	"InitNew", NULL, NULL);
}
        
STDMETHODIMP PyGActiveScriptParse::AddScriptlet( 
            /* [in] */ LPCOLESTR pstrDefaultName,
            /* [in] */ LPCOLESTR pstrCode,
            /* [in] */ LPCOLESTR pstrItemName,
            /* [in] */ LPCOLESTR pstrSubItemName,
            /* [in] */ LPCOLESTR pstrEventName,
            /* [in] */ LPCOLESTR pstrDelimiter,
            /* [in] */ DWORD dwSourceContextCookie,
            /* [in] */ ULONG ulStartingLineNumber,
            /* [in] */ DWORD dwFlags,
            /* [out] */ BSTR __RPC_FAR *pbstrName,
            /* [out] */ EXCEPINFO __RPC_FAR *pexcepinfo)
{
	PY_GATEWAY_METHOD;
	USES_CONVERSION;
	PyObject *result;
	HRESULT hr = InvokeViaPolicy("AddScriptlet", &result,
                                                        "ssssssii",
                                                        OLE2CT(pstrDefaultName),
                                                        OLE2CT(pstrCode),
                                                        OLE2CT(pstrItemName),
                                                        OLE2CT(pstrSubItemName),
                                                        OLE2CT(pstrEventName),
                                                        OLE2CT(pstrDelimiter),
                                                        dwSourceContextCookie,
                                                        ulStartingLineNumber);
	if (FAILED(hr)) return hr;
	if (result && PyString_Check(result)) {
		*pbstrName = MakeBstr(PyString_AsString(result));
	}
	Py_DECREF(result);
	return PyCom_HandlePythonFailureToCOM(pexcepinfo);
}
        
STDMETHODIMP PyGActiveScriptParse::ParseScriptText( 
            /* [in] */ LPCOLESTR pstrCode,
            /* [in] */ LPCOLESTR pstrItemName,
            /* [in] */ IUnknown __RPC_FAR *punkContext,
            /* [in] */ LPCOLESTR pstrDelimiter,
            /* [in] */ DWORD dwSourceContextCookie,
            /* [in] */ ULONG ulStartingLineNumber,
            /* [in] */ DWORD dwFlags,
            /* [out] */ VARIANT __RPC_FAR *pvarResult,
            /* [out] */ EXCEPINFO __RPC_FAR *pexcepinfo)
{
	PY_GATEWAY_METHOD;
	USES_CONVERSION;
	PyObject *context = PyCom_PyObjectFromIUnknown(punkContext, IID_IUnknown, TRUE);
	PyObject *result = NULL;
	BOOL bWantResult = pvarResult!=NULL;
	
	HRESULT hr = PyCom_HandlePythonFailureToCOM(pexcepinfo);
	if (FAILED(hr)) return hr;
	hr = InvokeViaPolicy(			"ParseScriptText", &result,
											"ssOsiiii",
											OLE2CT(pstrCode),
											OLE2CT(pstrItemName),
											context,
											OLE2CT(pstrDelimiter),
											dwSourceContextCookie,
											ulStartingLineNumber,
											dwFlags,
											bWantResult);
	if (FAILED(hr)) return hr;
	if (pvarResult) PyCom_MakePyObjectToVariant(result, pvarResult);
	return PyCom_HandlePythonFailureToCOM(pexcepinfo);
}
