#include "stdafx.h"
#include "PyGActiveScriptError.h"

// Std delegation
STDMETHODIMP_(ULONG) PyGActiveScriptError::AddRef(void) {return PyGatewayBase::AddRef();}
STDMETHODIMP_(ULONG) PyGActiveScriptError::Release(void) {return PyGatewayBase::Release();}
STDMETHODIMP PyGActiveScriptError::QueryInterface(REFIID iid, void ** obj) {return PyGatewayBase::QueryInterface(iid, obj);}
STDMETHODIMP PyGActiveScriptError::GetTypeInfoCount(UINT FAR* pctInfo) {return PyGatewayBase::GetTypeInfoCount(pctInfo);}
STDMETHODIMP PyGActiveScriptError::GetTypeInfo(UINT itinfo, LCID lcid, ITypeInfo FAR* FAR* pptInfo) {return PyGatewayBase::GetTypeInfo(itinfo, lcid, pptInfo);}
STDMETHODIMP PyGActiveScriptError::GetIDsOfNames(REFIID refiid, OLECHAR FAR* FAR* rgszNames, UINT cNames, LCID lcid, DISPID FAR* rgdispid) {return PyGatewayBase::GetIDsOfNames( refiid, rgszNames, cNames, lcid, rgdispid);}
STDMETHODIMP PyGActiveScriptError::Invoke(DISPID dispid, REFIID riid, LCID lcid, WORD wFlags, DISPPARAMS FAR* params, VARIANT FAR* pVarResult, EXCEPINFO FAR* pexcepinfo, UINT FAR* puArgErr) {return PyGatewayBase::Invoke( dispid, riid, lcid, wFlags, params, pVarResult, pexcepinfo, puArgErr);}

STDMETHODIMP PyGActiveScriptError::GetExceptionInfo(EXCEPINFO FAR *pexcepinfo)
{
	if (pexcepinfo==NULL) return E_POINTER;
	PY_GATEWAY_METHOD;
	PyObject *result;
	HRESULT hr = InvokeViaPolicy("GetExceptionInfo", &result, NULL);
	if (FAILED(hr))
		return hr;

	if (!PyCom_ExcepInfoFromPyObject(result, pexcepinfo))
		hr = PyCom_SetFromPyException();

	Py_DECREF(result);
	return hr;
}

STDMETHODIMP PyGActiveScriptError::GetSourcePosition(DWORD *pdwSourceContext, ULONG *pulLineNumber, LONG *plCharacterPosition)
{
	if (pdwSourceContext==NULL || pulLineNumber==NULL || plCharacterPosition==NULL) return E_POINTER;
	PY_GATEWAY_METHOD;
	PyObject *result;
	HRESULT hr = InvokeViaPolicy("GetSourcePosition", &result, NULL);
	if (FAILED(hr))
		return hr;

	if (!PyArg_ParseTuple(result, "iii", pdwSourceContext, pulLineNumber, plCharacterPosition))
		hr = PyCom_SetFromPyException();
	Py_DECREF(result);
	return hr;
}

STDMETHODIMP PyGActiveScriptError::GetSourceLineText(BSTR *pbstrSourceLine)
{
	if (pbstrSourceLine==NULL) return E_POINTER;
	PY_GATEWAY_METHOD;
	PyObject *result;
	HRESULT hr = InvokeViaPolicy("GetSourceLineText", &result, NULL);
	if (FAILED(hr))
		return hr;

	if (result != Py_None && !PyString_Check(result)) {
		PyErr_SetString(PyExc_TypeError, "result of GetSourceLineText must be a string or None");
		hr = PyCom_SetFromPyException();
	} else {
		*pbstrSourceLine = NULL;
		if (result != Py_None)
			*pbstrSourceLine = PyCom_BstrFromPyString(result);
	}
	Py_DECREF(result);
	return hr;
}

