// axcom.cpp :
// $Id:$

/***
Note that this source file contains embedded documentation.
This documentation consists of marked up text inside the
C comments, and is prefixed with an '@' symbol.  The source
files are processed by a tool called "autoduck" which
generates Windows .hlp files.
@doc
***/

#include "stdafx.h"
#include "PyGActiveScriptError.h"
#include "PyIActiveScriptError.h"
#include "PyIObjectSafety.h"
#include "PyIProvideMultipleClassInfo.h"
#include "PyIActiveScriptParseProcedure.h"


static PyObject* axcom_Error;     /* 'Python level' errors */

/* List of module functions */
// @module axscript|A module, encapsulating the ActiveX Scripting interfaces
static struct PyMethodDef axcom_methods[]=
{
	{ NULL, NULL }
};

// Register a Python on both the UID and Name maps.
int RegisterType(PyObject *obMapNameToType, PyObject *obMapIIDToType, PyTypeObject *typeOb, const GUID *guid)
{
	int rc = PyDict_SetItemString(obMapNameToType, typeOb->tp_name, (PyObject *)typeOb);
	if (rc==0 && guid) {
		PyObject *obiid = PyCom_PyIIDObjectFromIID(*guid);
		if (!obiid) return 1;
		rc = PyDict_SetItem(obMapIIDToType, obiid, (PyObject *)typeOb);
		PyTS_DECREF(obiid);
	}
	return rc;
}

int AddConstant(PyObject *dict, const char *key, long value)
{
	PyObject *oval = PyInt_FromLong(value);
	if (!oval)
	{
		return 1;
	}
	int rc = PyDict_SetItemString(dict, (char*)key, oval);
	PyTS_DECREF(oval);
	return rc;
}

int AddIID(PyObject *dict, const char *key, REFGUID guid)
{
	PyObject *obiid = PyCom_PyIIDObjectFromIID(guid);
	if (!obiid) return 1;
	int rc = PyDict_SetItemString(dict, (char*)key, obiid);
	PyTS_DECREF(obiid);
	return rc;
}

#define ADD_CONSTANT(tok) AddConstant(dict, #tok, tok)
#define ADD_IID(tok) AddIID(dict, #tok, tok)

/* Module initialisation */
extern "C" __declspec(dllexport) void initaxscript()
{
	char *modName = "axscript";
	static PyObject *oModule = NULL;
	if (oModule) return;
	// Create the module and add the functions
	oModule = Py_InitModule(modName, axcom_methods);
	PyObject *dict = PyModule_GetDict(oModule);

	// Add some symbolic constants to the module   
	axcom_Error = PyString_FromString("error");
	if (axcom_Error == NULL || PyDict_SetItemString(dict, "error", axcom_Error) != 0)
	{
		PyErr_SetString(PyExc_MemoryError, "can't define error");
		return;
	}

	// Register client extensions
	if (PyCom_RegisterClientType(&PyIActiveScriptSite::type, &IID_IActiveScriptSite)!=0) return;
	if (PyCom_RegisterClientType(&PyIProvideMultipleClassInfo::type, &IID_IProvideMultipleClassInfo)!=0) return;

	if ( PyCom_RegisterClientType(&PyIActiveScript::type, &IID_IActiveScript) != 0 ) return;
	if ( PyCom_RegisterClientType(&PyIActiveScriptParse::type, &IID_IActiveScriptParse) != 0 ) return;
	if ( PyCom_RegisterClientType(&PyIObjectSafety::type, &IID_IObjectSafety) != 0 ) return;
	if ( PyCom_RegisterClientType(&PyIActiveScriptError::type, &IID_IActiveScriptError) != 0 ) return;
	if ( PyCom_RegisterClientType(&PyIActiveScriptParseProcedure::type, &IID_IActiveScriptParseProcedure) != 0 ) return;


	// Register the gateways we support...
	PyCom_RegisterGatewayObject(IID_IActiveScript, GET_PYGATEWAY_CTOR(PyGActiveScript), "IActiveScript");
	PyCom_RegisterGatewayObject(IID_IActiveScriptParse, GET_PYGATEWAY_CTOR(PyGActiveScriptParse),"IActiveScriptParse");
	PyCom_RegisterGatewayObject(IID_IActiveScriptError, GET_PYGATEWAY_CTOR(PyGActiveScriptError), "IActiveScriptError");
	PyCom_RegisterGatewayObject(IID_IObjectSafety, GET_PYGATEWAY_CTOR(PyGObjectSafety), "IObjectSafety");
	PyCom_RegisterGatewayObject(IID_IActiveScriptSite, GET_PYGATEWAY_CTOR(PyGActiveScriptSite), "IActiveScriptSite");
	PyCom_RegisterGatewayObject(IID_IActiveScriptParseProcedure, GET_PYGATEWAY_CTOR(PyGActiveScriptParseProcedure), "ActiveScriptParseProcedure");

//	PyCom_RegisterGatewayObject(IID_IScriptSite, GET_PYGATEWAY_CTOR(PyGScriptSite));


	ADD_IID(IID_IActiveScript);
	ADD_IID(IID_IActiveScriptParse);
	ADD_IID(IID_IObjectSafety);
	ADD_IID(IID_IActiveScriptSite);
	ADD_IID(IID_IProvideMultipleClassInfo);
	ADD_IID(IID_IActiveScriptError);
	ADD_IID(IID_IActiveScriptSite);
	ADD_IID(IID_IActiveScriptParseProcedure);

	ADD_IID(CATID_ActiveScript);
	ADD_IID(CATID_ActiveScriptParse);

	ADD_CONSTANT(SCRIPTITEM_ISVISIBLE);
	ADD_CONSTANT(SCRIPTITEM_ISSOURCE);
	ADD_CONSTANT(SCRIPTITEM_GLOBALMEMBERS);
	ADD_CONSTANT(SCRIPTITEM_ISPERSISTENT);
	ADD_CONSTANT(SCRIPTITEM_CODEONLY);
	ADD_CONSTANT(SCRIPTITEM_NOCODE);
	ADD_CONSTANT(SCRIPTITEM_ALL_FLAGS);
	ADD_CONSTANT(SCRIPTTYPELIB_ISCONTROL);
	ADD_CONSTANT(SCRIPTTYPELIB_ISPERSISTENT);
//	ADD_CONSTANT(SCRIPTTYPELIB_ALL_FLAGS);
	ADD_CONSTANT(SCRIPTTEXT_ISVISIBLE);
	ADD_CONSTANT(SCRIPTTEXT_ISEXPRESSION);
	ADD_CONSTANT(SCRIPTTEXT_ISPERSISTENT);
	ADD_CONSTANT(SCRIPTTEXT_ALL_FLAGS);
	ADD_CONSTANT(SCRIPTINFO_IUNKNOWN);
	ADD_CONSTANT(SCRIPTINFO_ITYPEINFO);
	ADD_CONSTANT(SCRIPTINFO_ALL_FLAGS);
	ADD_CONSTANT(SCRIPTINTERRUPT_DEBUG);
	ADD_CONSTANT(SCRIPTINTERRUPT_RAISEEXCEPTION);
	ADD_CONSTANT(SCRIPTINTERRUPT_ALL_FLAGS);

	ADD_CONSTANT(SCRIPTPROC_HOSTMANAGESSOURCE);
	ADD_CONSTANT(SCRIPTPROC_IMPLICIT_THIS);
	ADD_CONSTANT(SCRIPTPROC_IMPLICIT_PARENTS);
	ADD_CONSTANT(SCRIPTPROC_ALL_FLAGS);


	ADD_CONSTANT(SCRIPTTHREADSTATE_NOTINSCRIPT);
	ADD_CONSTANT(SCRIPTTHREADSTATE_RUNNING);

	ADD_CONSTANT(SCRIPTSTATE_UNINITIALIZED);
	ADD_CONSTANT(SCRIPTSTATE_INITIALIZED);
	ADD_CONSTANT(SCRIPTSTATE_STARTED);
	ADD_CONSTANT(SCRIPTSTATE_CONNECTED);
	ADD_CONSTANT(SCRIPTSTATE_DISCONNECTED);
	ADD_CONSTANT(SCRIPTSTATE_CLOSED);

	// Multiinfo stuff
	ADD_CONSTANT(MULTICLASSINFO_GETTYPEINFO);
	ADD_CONSTANT(MULTICLASSINFO_GETNUMRESERVEDDISPIDS);
	ADD_CONSTANT(MULTICLASSINFO_GETIIDPRIMARY);
	ADD_CONSTANT(MULTICLASSINFO_GETIIDSOURCE);
	ADD_CONSTANT(TIFLAGS_EXTENDDISPATCHONLY);

	ADD_CONSTANT(INTERFACESAFE_FOR_UNTRUSTED_CALLER);
	ADD_CONSTANT(INTERFACESAFE_FOR_UNTRUSTED_DATA);
}
