import string
import ni
from win32com.axscript.server.error import Exception
from win32com.axscript.server import axsite
from win32com import pythoncom
from win32com.server import util, connect

class MySite(axsite.AXSite):

  def OnScriptError(self, error):
    exc = error.GetExceptionInfo()
    context, line, char = error.GetSourcePosition()
    print " >Exception:", exc[1]
    try:
      st = error.GetSourceLineText()
    except pythoncom.com_error:
      st = None
    if st is None: st = ""
    text = st + "\n" + (" " * (char-1)) + "^" + "\n" + exc[2]
    for line in string.split(text,"\n"):
      print "  >" + line

class Test:
  _public_methods_ = [ 'echo' ]
  def __init__(self):
    self.last = ""
#    self._connect_server_ = TestConnectServer(self)

  def echo(self, *args):
    self.last = string.join(map(str, args))
#    self._connect_server_.Broadcast(last)

#### Connections currently wont work, as there is no way for the engine to
#### know what events we support.  We need typeinfo support.

IID_ITestEvents = pythoncom.MakeIID("{8EB72F90-0D44-11d1-9C4B-00AA00125A98}")

class TestConnectServer(connect.ConnectableServer):
	_connect_interfaces_ = [IID_ITestEvents]
	# The single public method that the client can call on us
	# (ie, as a normal COM server, this exposes just this single method.
	def __init__(self, object):
		self.object = object
		
	def Broadcast(self,arg):
		# Simply broadcast a notification.
		self._BroadcastNotify(self.NotifyDoneIt, (arg,))

	def NotifyDoneIt(self, interface, arg):
		interface.Invoke(1000, 0, win32com.pythoncom.DISPATCH_METHOD, 1, arg)

VBScript = """\
prop = "Property Value"
sub hello(arg1)
   test.echo arg1
end sub
"""
PyScript = """\
print "PyScript is being parsed..."
prop = "Property Value"
def hello(arg1):
   test.echo(arg1)
"""

ErrScript = """\
bad code for everyone!
"""

def TestEngine(engineName, code):
  echoer = Test()
  model = {
    'test' : util.wrap(echoer),
    }

  site = MySite(model)
  engine = site._AddEngine(engineName)
  engine.AddCode(code)
  engine.Start()

  # Now call into the scripts IDispatch
  from win32com.client.dynamic import Dispatch
  ob = Dispatch(engine.GetScriptDispatch())
  try:
    ob.hello("Goober")
  except pythoncom.com_error:
    print "***** Calling 'hello' failed"
    return
  if echoer.last != "Goober":
    print "***** Function call didnt set value correctly"
    
  if str(ob.prop) != "Property Value":
    print "***** Property Value not correct"

if __name__ == '__main__':
  TestEngine("Python", PyScript)
  TestEngine("VBScript", VBScript)
  print "Testing Exceptions"
  try:
    TestEngine("Python", ErrScript)
  except pythoncom.com_error:
    pass
  try:
    TestEngine("VBScript", ErrScript)
  except pythoncom.com_error:
    pass
  print "AXScript Host worked correctly."
