"""dynamic dispatch objects for AX Script.

 This is an IDispatch object that a scripting host may use to
 query and invoke methods on the main script.  Not may hosts use
 this yet, so it is not well tested!
"""

import winerror
import types
from win32com.server.exception import Exception
from win32com.client import Dispatch
from win32com import pythoncom

PyIDispatchType = pythoncom.TypeIIDs[pythoncom.IID_IDispatch]

def _is_callable(obj):
	return type(obj) in [types.FunctionType, types.MethodType] or hasattr(obj, "__call__")

class ScriptDispatch:
	_public_methods_ = []
	def __init__(self, scriptNamespace):
		self.scriptNamespace = scriptNamespace
		
	def _dynamic_(self, name, lcid, wFlags, args):
		if wFlags & pythoncom.INVOKE_FUNC:
			# attempt to call a function
			try:
				func = getattr(self.scriptNamespace, name)
				if not _is_callable(func):
					raise AttributeError, name # Not a function.
			except AttributeError:
				if not wFlags & pythoncom.DISPATCH_PROPERTYGET:
					raise Exception(scode=winerror.DISP_E_MEMBERNOTFOUND)
			else:
				realArgs = []
				for arg in args:
					if type(arg)==PyIDispatchType:
						realArgs.append(Dispatch(arg))
					else:
						realArgs.append(arg)
				return apply(func, tuple(realArgs))
		
		if wFlags & pythoncom.DISPATCH_PROPERTYGET:
			# attempt to get a property
			try:
				ret =  getattr(self.scriptNamespace, name)
				if _is_callable(ret):
					raise AttributeError, name # Not a property.
				return ret
			except AttributeError:
				raise Exception(scode=winerror.DISP_E_MEMBERNOTFOUND)

		raise Exception(scode=winerror.DISP_E_MEMBERNOTFOUND)

