import traceback, sys, string

import win32com.server.util
from win32com.util import IIDToInterfaceName
from win32com.client.util import Enumerator
from win32com.server.exception import Exception
import pythoncom
from framework import trace
from win32com.axdebug import axdebug, gateways, contexts, stackframe, documents
from win32com.axdebug.codecontainer import SourceCodeContainer
from win32com.axdebug.util import _wrap, _wrap_remove
import win32com.client.connect
import win32api, winerror

debuggingTrace = 0		# Should we print "trace" output?

def trace(*args):
	"""A function used instead of "print" for debugging output.
	"""
	if not debuggingTrace:
		return 
	print win32api.GetCurrentThreadId(),
	for arg in args:
		print arg,
	print

# Note that the DebugManager receives debugger events, but is not a
# COM gateway class for the debugger - but it does create and manage them.
class DebugManager(gateways.RemoteDebugApplicationEvents):
	_debugger_interfaces_ = [axdebug.IID_IActiveScriptDebug]
	def __init__(self, scriptEngine):
		self.docContexts = []
		self.scriptEngine = scriptEngine
		self.docProviders = {}
		self.currentStackFrame = None
		self.threadStates = {}
		try:
			self.scriptSiteDebug = scriptEngine.GetScriptSite(axdebug.IID_IActiveScriptSiteDebug)
		except pythoncom.com_error:
			# No debugger interface (ie, dumb host).  Do the extra work.
			trace("Scripting site has no debugger interface")
			self.scriptSiteDebug = None
		# Get the debug application object.
		if self.scriptSiteDebug:
			self.debugApplication = self.scriptSiteDebug.GetApplication()
			self.rootNode = self.scriptSiteDebug.GetRootApplicationNode()
		else:
			# Try to get/create the default one
			try:
				pdm=pythoncom.CoCreateInstance(axdebug.CLSID_ProcessDebugManager,None,pythoncom.CLSCTX_ALL, axdebug.IID_IProcessDebugManager)
				self.debugApplication = pdm.GetDefaultApplication()
				self.rootNode = self.debugApplication.GetRootNode()
			except pythoncom.com_error:
				self.debugApplication = None
		self.activeScriptDebug = None

		if self.debugApplication is not None:
			self.stackSniffer = DebugStackFrameSniffer(self)
			self.stackSnifferCookie = self.debugApplication.AddStackFrameSniffer(_wrap(self.stackSniffer, axdebug.IID_IDebugStackFrameSniffer))
			trace("StackFrameSniffer added (%d)" % self.stackSnifferCookie)
			# Connect to the application events.
			self.appEventConnection = win32com.client.connect.SimpleConnection(self.debugApplication, self, axdebug.IID_IRemoteDebugApplicationEvents)
		else:
			self.stackSniffer = self.stackSnifferCookie = None
		self.activeScriptDebug = ActiveScriptDebug(self.scriptEngine, self)

	def IsAnyHost(self):
		"Do we have _any_ debugging interfaces installed?"
		return self.debugApplication is not None
	def IsSimpleHost(self):
		return self.scriptSiteDebug is None

	def Close(self):
		# Called by the language engine when it receives a close request
		for provider in self.docProviders.values():
			_wrap_remove(provider)
		self.docProviders = {}
		self.threadStates = {}
		if self.stackSnifferCookie is not None:
			try:
				trace("Removing sniffer from application...")
				self.debugApplication.RemoveStackFrameSniffer(self.stackSnifferCookie)

			except pythoncom.com_error:
				trace("*** Could not RemoveStackFrameSniffer %d - %s" % (self.stackSnifferCookie, sys.exc_value))
		if self.stackSniffer:
			_wrap_remove(self.stackSniffer)
		self.stackSnifferCookie = self.stackSniffer = None
		if self.activeScriptDebug:
			self.activeScriptDebug._Close()
		_wrap_remove(self.activeScriptDebug)
		self.activeScriptDebug = None
		self.scriptEngine = None
		self.debugApplication = None

#		print "Close complete"
				
	def _query_interface_for_debugger_(self, iid):
		if iid in self._debugger_interfaces_:
			# AARG - Either way, doesnt help
			return _wrap(self.activeScriptDebug, axdebug.IID_IActiveScriptDebug)
		trace("DebugManager QI - unknown IID", iid)
		return 0
		
	def _DebugDocumentTextFromFileName(self, fname):
		try:
			return self.docProviders[fname].document
		except KeyError:
			return None

	def PythonDebuggerTraceDispatch(self, frame, event, arg):
		if win32api.GetCurrentThreadId() != self.scriptThreadId:
#			print "Debugger - not my thread!", frame.f_code.co_filename
			return None
		try:
			# Check I am in the callstack somewhere.
			frame_look = frame
			context = None
			while (frame_look is not None) and (context is None):
				lineNo = frame_look.f_lineno
				docProvider=self._DebugDocumentTextFromFileName(frame_look.f_code.co_filename)
				if docProvider:
					offset = docProvider.GetPositionOfLine(lineNo)
					context = docProvider._DocContextFromOffset(offset)
				frame_look = frame_look.f_back
			if context:
				trace("Have breakpoint at context", context)
				if self.debugApplication:
					trace("Starting debug session!")
					self.currentStackFrame = frame
					try:
						try:
							self.debugApplication.HandleBreakPoint(axdebug.BREAKREASON_BREAKPOINT)
						finally:
							self.currentStackFrame = None
					except:
						traceback.print_exc()
					trace("HBP returned")
					return self.PythonDebuggerTraceDispatch
			else:
#				trace("Debug event in no context (%d)" % (frame.f_lineno))
				return self.PythonDebuggerTraceDispatch # ???
		except:
			traceback.print_exc()
	def _BreakAnywhere(self):
		# For now, if we have a debugger, assume we may break!
		# xxx - later, check appbreakflags and contexts.
		return 0 # Not!!!
		return self.debugApplication is not None
		
	def OnEnterScript(self):
		self.scriptThreadId = None
		if self._BreakAnywhere():
			self.scriptThreadId = win32api.GetCurrentThreadId()
			sys.settrace(self.PythonDebuggerTraceDispatch)
			trace("Set sys trace", self.scriptThreadId)

	def OnLeaveScript(self):
		if self.scriptThreadId:
			self.scriptThreadId = None
			sys.settrace(None)
			trace("Cleared sys trace")

	def AddScriptBlock(self, codeBlock):
		if not self.IsAnyHost(): return # We dont care!
		if self.IsSimpleHost():
			mynode = self.debugApplication.CreateApplicationNode()
			provider = AXDebugDocumentProvider(self, codeBlock)
			mynode.SetDocumentProvider(_wrap(provider, axdebug.IID_IDebugDocumentProvider))
			self.docProviders[codeBlock.GetFileName()]=provider
			mynode.Attach(self.rootNode)
		else:
			self.activeScriptDebug._AddScriptBlock(codeBlock)

	# RemoteDebugApplicationEvents interface
	def OnConnectDebugger(self, appDebugger):
		trace("OnConnectDebugger")
	def OnDisconnectDebugger(self):
		trace("OnDisconnectDebugger")
	def OnSetName(self, name):
		trace("OnSetName")
	def OnDebugOutput(self, string):
		trace("OnDebugOutput")
	def OnClose(self):
		trace("OnClose")
	def OnEnterBreakPoint(self, rdat):
		trace("OnEnterBreakPoint")
	def OnLeaveBreakPoint(self, rdat):
		trace("OnLeaveBreakPoint")
	def OnCreateThread(self, rdat):
		trace("OnCreateThread")
	def OnDestroyThread(self, rdat):
		trace("OnDestroyThread")
	def OnBreakFlagChange(self, abf, rdat):
		self.threadStates[rdat] = abf
		trace("OnBreakFlagChange",abf, rdat)


class ActiveScriptDebug:
	"""The class which implements the IActiveScriptDebug interface for the Active Script engine.

	   Only ever used by smart hosts.
	"""
	_public_methods_ = ["GetScriptTextAttributes", "GetScriptletTextAttributes", "EnumCodeContextsOfPosition"]
	_com_interfaces_ = [axdebug.IID_IActiveScriptDebug]
	def __init__(self, engine, debugMgr):
		self.engine = None
		self.debugMgr = debugMgr
		self.breakFlags = 0
		if engine: self._SetEngine(engine)
		self.scriptSiteDebug = debugMgr.scriptSiteDebug

	def _SetEngine(self, engine):
		self.engine = engine

	def _Close(self):
		self.engine = None
		self.debugMgr = None
		self.scriptSiteDebug = None

	def _query_interface_(self, iid):
		trace("DebuggerQI with", iid)
		return 0

	def _AddScriptBlock(self, codeBlock):
		pass
		
	def GetScriptTextAttributes(self, code, delim, flags):
		import traceback
#		trace ("GetScriptTextAttributes", code, delim, flags)
		try:
			container = SourceCodeContainer(code)
			return container.GetSyntaxColorAttributes()
		except:
			traceback.print_exc()
	def GetScriptletTextAttributes(self, code, delim, flags):
		trace ("GetScriptletTextAttributes", code, delim, flags)
		container = SourceCodeContainer(code)
		return container.GetSyntaxColorAttributes()
	def EnumCodeContextsOfPosition(self, context, charOffset, numChars):
		trace("EnumCodeContextsOfPosition", context, charOffset, numChars)
		docContext = self.scriptSiteDebug.GetDocumentContextFromPosition(context, charOffset, numChars)
		codeContext = contexts.DebugCodeContext(docContext)
		rc = _wrap(contexts.EnumDebugCodeContexts([codeContext]), axdebug.IID_IEnumDebugCodeContexts, 0)
		print "EnumCodeContextsOfPosition returning ", rc
		return rc

class AXDebugDocumentProvider(gateways.DebugDocumentProvider):
	"""A DebugDocumentProvider for the scripting engine.

	   Used by simple hosts.
	"""
	def __init__(self, debugManager, codeBlock):
		self.debugManager = debugManager
		self.codeBlock = codeBlock
		self.document = None
		gateways.DebugDocumentProvider.__init__(self)
	def _query_interface_(self, iid):
		rc = gateways.DebugDocumentText._query_interface_(self, iid)
#		if rc==0:
#			trace("DebugDocumentProvider QI with %s (%s)" % (IIDToInterfaceName(iid), str(iid)))
		return rc
	def GetName(self, dnt):
		if dnt==axdebug.DOCUMENTNAMETYPE_APPNODE:
			return self.codeBlock.GetDisplayName()
		elif dnt==axdebug.DOCUMENTNAMETYPE_TITLE:
			return self.codeBlock.GetDisplayName()
#		elif dnt==axdebug.DOCUMENTNAMETYPE_FILE_TAIL:
#		elif dnt==axdebug.DOCUMENTNAMETYPE_URL:
		else:
			raise Exception(scode=winerror.S_FALSE)

	def GetDocumentClassId(self):
		return pythoncom.IID_NULL
		
	def GetDocument(self):
		trace("GetDocument")
		if self.document is None:
			codeContainer = SourceCodeContainer(self.codeBlock.codeText)
			self.document = DebugDocumentText(codeContainer)
		return _wrap(self.document, axdebug.IID_IDebugDocument)

class DebugDocumentText(documents.CodeContainerDebugDocumentText):
	def _DocContextFromOffset(self, offset):
		try:
			return self.docContexts[offset]
		except KeyError:
			return None

DocContext = contexts.DebugDocumentContext
DebugCodeContext = contexts.DebugCodeContext

class EnumDebugStackFrames(stackframe.EnumDebugStackFrames):
	def Next(self, count):
		trace("EnumDebugStackFrames.Next called")
		try:
			rc = gateways.EnumDebugCodeContexts.Next(self, count)
			trace("EnumDebugStackFrames.Next returning")
			return rc
		except:
			traceback.print_exc()

class DebugStackFrameSniffer:
	_public_methods_ = ["EnumStackFrames"]
	_com_interfaces_ = [axdebug.IID_IDebugStackFrameSniffer]
	def __init__(self, debugManager):
		trace("DebugStackFrameSniffer instantiated")
		self.debugManager = debugManager
	def EnumStackFrames(self):
		trace("EnumStackFrames called")
		frame = self.debugManager.currentStackFrame
		if frame:
			frameInfo = DebugStackFrame(frame, self.debugManager), id(frame), 0, 0, None
			rc = _wrap(EnumDebugStackFrames([frameInfo]), axdebug.IID_IEnumDebugStackFrames, 0)
			trace("EnumStackFrames returning rc", rc)
		else:
			trace("EnumStackFrames raising FALSE")
			raise Exception(scode=winerror.S_FALSE)
		return rc

class DebugStackFrame(stackframe.DebugStackFrame):
	def __init__(self, frame, debugManager):
		stackframe.DebugStackFrame.__init__(self, frame)
		self.debugManager = debugManager
	def GetCodeContext(self):
		trace("GetCodeContext called")
		context = None
		doc = self.debugManager._DebugDocumentTextFromFileName(self.frame.f_code.co_filename)
		if doc:
			offset = doc.GetPositionOfLine(self.frame.f_lineno)
			context = doc.PyGetContextOfPosition(offset, 0).codeContext
		if context:
			trace("GetCodeContext returning context", context)
			return _wrap(context, axdebug.IID_IDebugCodeContext)
		else:
			raise Exception(scode=winerror.S_FALSE)
	def GetDescriptionString(self, fLong):
		trace("GetDescriptionString")
		return stackframe.DebugStackFrame.GetDescriptionString(self, fLong)

	def GetLanguageString(self, fLong):
		trace("GetLanguageString")
		return stackframe.DebugStackFrame.GetLanguageString(self, fLong)

	def GetThread(self):
		""" Returns the thread associated with this stack frame.

		Result must be a IDebugApplicationThread
		"""
		trace("GetThread")
		raise Exception(scode=winerror.E_NOTIMPL)
		


