import sys, traceback
import ni, win32com.server.util
from win32com.client.util import Enumerator
import win32com.client.connect
from win32com.server.exception import Exception
from win32com.axdebug import axdebug, gateways, documents, contexts, adb
from win32com.axdebug.util import trace, _wrap, _wrap_force, _wrap_remove
from win32com.axdebug import codecontainer

from win32com import pythoncom
import win32com.server.connect
import win32api, winerror
import os

import ttest

class ExternalConnection:
	_public_methods_ = ["AddConnection", "ReleaseConnection"]
	_com_interfaces_ = [pythoncom.IID_IExternalConnection]
	numExtRefs = 0

	def AddConnection( self, extconn, reserved):
		self.numExtRefs = self.numExtRefs + 1
		return self.numExtRefs
	def ReleaseConnection( self, extconn, reserved, fLastReleaseCloses):
		self.numExtRefs = self.numExtRefs - 1
		return self.numExtRefs

externalConnectionManager = ExternalConnection()
wrappedExternalConnectionManager = _wrap(externalConnectionManager, pythoncom.IID_IExternalConnection)

def DelegatedExternalConnectionQI(iid):
	# PyIExternalConnection (do I need this?  Keep getting QI'd for it, anyway?)
	if iid==pythoncom.IID_IExternalConnection:
		return wrappedExternalConnectionManager
	return 0

class DebugDocumentTextConnectServer(gateways.DebugDocumentTextConnectServer):
	def EnumConnections(self):
		trace("EnumConnections")
	def GetConnectionInterface(self):
		trace("GetConnectionInterface")
	def Advise(self, pUnk):
		trace("Advise")
		return gateways.DebugDocumentTextConnectServer.Advise(self, pUnk)
	def Unadvise(self, cookie):
		trace("Unadvise")
		return gateways.DebugDocumentTextConnectServer.Unadvise(self, cookie)
	# IConnectionPointContainer interfaces
	def EnumConnectionPoints(self):
		trace("EnumConnectionPoints")
		pass
	def FindConnectionPoint(self, iid):
		# Find a connection we support.  Only support the single event interface.
		trace("FindConnectionPoint")
		if iid==axdebug.IID_IDebugDocumentTextEvents:
			return _wrap_force(self, iid)

class DebugDocumentText(documents.PySourceModuleDebugDocumentTextExternalAuthor):
	def __init__(self, pydebugger, module):
		self.pydebugger = pydebugger
		documents.PySourceModuleDebugDocumentTextExternalAuthor.__init__(self, module)
	def _OnSetBreakPoint(self, docContext, codeContext, bps):
		trace("_OnSetBreakPoint",self, docContext, codeContext, bps)
		self.pydebugger._OnSetBreakPoint(self.module, codeContext, bps)
		

class PySourceModuleDebugDocumentProvider(documents.PySourceModuleDebugProvider):
	def __init__(self, pydebugger, context):
		self.pydebugger = pydebugger
		documents.PySourceModuleDebugProvider.__init__(self, context)
		self.document = None
#	def _query_interface_(self, iid):
#		from win32com.util import IIDToInterfaceName
#		trace("DebugDocumentProvider QI with %s (%s)" % (IIDToInterfaceName(iid), str(iid)))
#		return 0
	def _Close(self):
		_wrap_remove(self)
		if self.document:
			self.document._Close()
			
	def GetDocument(self):
		trace("GetDocument for module", self.module)
		if hasattr(self.module, '__file__'):
			if self.document is None:
				self.document = DebugDocumentText(self.pydebugger,self.module)
			return _wrap(self.document, axdebug.IID_IDebugDocument)
		else:
			print " - Have no document to return."
			raise Exception(scode=winerror.S_FALSE)


class DebugDocumentContext(contexts.DebugDocumentContext):
	def _query_interface_(self, iid):
		if iid==pythoncom.IID_IExternalConnection:
			return wrappedExternalConnectionManager
		from win32com.util import IIDToInterfaceName
		trace("DebugDocumentContext QI with %s (%s)" % (IIDToInterfaceName(iid), str(iid)))
		return 0
	def _MakeCodeContext(self):
		return DebugCodeContext(self)

class DebugCodeContext(contexts.DebugCodeContext):
	def _query_interface_(self, iid):
		if iid==pythoncom.IID_IExternalConnection:
			return wrappedExternalConnectionManager
		from win32com.util import IIDToInterfaceName
		trace("DebugCodeContext QI with %s (%s)" % (IIDToInterfaceName(iid), str(iid)))
		return 0

class PySourceModuleDebugDocumentHost(gateways.DebugDocumentHost):
	"""A DebugDocumentHost that works with Python source files.
	"""
	def __init__(self, module):
		self.module = module
		gateways.DebugDocumentHost.__init__(self)
		self.codeContainer = None
	def _query_interface_(self, iid):
		from win32com.util import IIDToInterfaceName
		trace("PySourceModuleDebugDocumentHost QI with %s (%s)" % (IIDToInterfaceName(iid), str(iid)))
		return 0
	def _GetCodeContainer(self):
		if self.codeContainer is None:
			try:
				codeText = open(self.module.__file__, "rt").read()
			except IOError, details:
				codeText = "# Exception opening file\n# %s" % (details)
			from win32com.axdebug import codecontainer
			self.codeContainer = codecontainer.SourceCodeContainer(codeText)
		return self.codeContainer
	def GetDeferredText(self, dwTextStartCookie,  maxChars, bWantAttr):
		try:
			trace("GetDeferredText", dwTextStartCookie,  maxChars, bWantAttr)
			cont = self._GetCodeContainer()
			if bWantAttr:
				attr = cont.GetSyntaxColorAttributes()
			else:
				attr = None
			return cont.text, attr
		except:
			traceback.print_exc()
  
	def GetScriptTextAttributes(self, codeText, delimterText, flags):
		# Result must be an attribute sequence of same "length" as the code.	
		trace("GetScriptTextAttributes", delimterText, flags)
		raise Exception(scode=winerror.E_NOTIMPL)
### not called.
		from win32com.axdebug import codecontainer
		cont = codecontainer.SourceCodeContainer(codeText)
		return cont.GetSyntaxColorAttributes()
  
	def OnCreateDocumentContext( self ): 
		# Result must be a PyIUnknown
		trace("OnCreateDocumentContext")
		raise Exception(scode=winerror.E_NOTIMPL)
  
	def GetPathName( self ):
		# Result must be (string, int) where the int is a BOOL
		# - TRUE if the path refers to the original file for the document.
		# - FALSE if the path refers to a newly created temporary file.
		# - raise Exception(scode=E_FAIL) if no source file can be created/determined.
		trace("GetPathName")
		try:
			return win32api.GetFullPathName(self.module.__file__), 1
		except (AttributeError, win32api.error):
			raise Exception(scode==E_FAIL)
  
	def GetFileName(self):
		# Result is a string with just the name of the document, no path information.
		trace("GetFileName")
		return os.path.split(module.__file__)
  
	def NotifyChanged():
		trace("NotifyChanged")
		raise Exception(scode=winerror.E_NOTIMPL)


class RemoteDebugApplicationEvents(gateways.RemoteDebugApplicationEvents):
	def OnConnectDebugger(self, appDebugger):
		trace("OnConnectDebugger", appDebugger)
	def OnDisconnectDebugger(self):
		trace("OnDisconnectDebugger")
	def OnSetName(self, name):
		trace("OnSetName", name)
	def OnDebugOutput(self, string):
		trace("OnDebugOutput", string)
	def OnClose(self):
		trace("OnClose")
	def OnEnterBreakPoint(self, rdat):
		trace("OnEnterBreakPoint", rdat)
	def OnLeaveBreakPoint(self, rdat):
		trace("OnLeaveBreakPoint", rdat)
	def OnCreateThread(self, rdat):
		trace("OnCreateThread", rdat)
	def OnDestroyThread(self, rdat):
		trace("OnDestroyThread", rdat)
	def OnBreakFlagChange(self, abf, rdat):
		trace("OnBreakFlagChange", abf, rdat)

class ModuleTreeNode:
	"""Helper class for building a module tree
	"""
	built_nodes = {}
	def __init__(self, module, modName = None):
		if modName is None: modName = module.__name__
		self.moduleName = modName
		self.module = module
		self.built_nodes[module.__name__] = self
		
	def Attach(self, parent):
		self.parent = parent


def BuildModuleTree():
	import sys
	module_names = sys.modules.values()
	import os
	ModuleTreeNode.built_nodes = {}
	for module in module_names:
		if module:
			keep = hasattr(module, '__path__') and module.__name__
			moduleFileName = None
			try:
				moduleFileName = module.__file__
				keep = keep or os.path.splitext(moduleFileName)[1]==".py"
			except AttributeError:
				pass
		if module and keep:
			node = ModuleTreeNode(module)

	# Now loop over the nodes, finding the appropriate parent node.
	for mod_name, node in ModuleTreeNode.built_nodes.items():
		try:
			module = sys.modules[mod_name]
		except KeyError:
			continue
		if not module.__.__name__: # A top-level object.
			node.Attach(None) # Attach to the root
		else:
			parent = ModuleTreeNode.built_nodes[module.__.__name__]
			node.Attach(parent)
	rc = ModuleTreeNode.built_nodes
	ModuleTreeNode.built_nodes = {}
	return rc


def testdumb():
	pdm=win32com.pythoncom.CoCreateInstance(axdebug.CLSID_ProcessDebugManager,None,win32com.pythoncom.CLSCTX_ALL, axdebug.IID_IProcessDebugManager)
	app = pdm.GetDefaultApplication()
#	root = pdm.CreateDebugDocumentHelper(None)
#	root.Init(app, "PyApp", "Python Application", axdebug.TEXT_DOC_ATTR_READONLY)

	nodes = BuildModuleTree()
	import statcache

	all_real_nodes = {}
	for node in nodes.values():
		realNode = pdm.CreateDebugDocumentHelper(None)
		all_real_nodes[node] = realNode
		realNode.Init(app, node.moduleName, "Python Module %s" % node.moduleName, 0)
		realNode.SetDebugDocumentHost(_wrap(PySourceModuleDebugDocumentHost(node.module), axdebug.IID_IDebugDocumentHost))
		try:
			fname = node.module.__file__
			size = statcache.stat(fname)[6]
		except (AttributeError, os.error):
			size = fname = None
		if size is not None:
			realNode.AddDeferredText(size, 0)
	# Loop attaching parents
	for node in nodes.values():
		realNode = all_real_nodes[node]
		if node.parent is None:
			realNode.Attach(None) # Attach to the root
		else:
			parentNode = all_real_nodes[node.parent]
			realNode.Attach(parentNode)
	

	raw_input("Waiting...")
	print "Done"

class SimpleConnection(win32com.client.connect.SimpleConnection):
	def _wrap(self, obj):
		return _wrap(obj, None)

def testsmart():
	pdm=pythoncom.CoCreateInstance(axdebug.CLSID_ProcessDebugManager,None,pythoncom.CLSCTX_ALL, axdebug.IID_IProcessDebugManager)
	app = pdm.CreateApplication()
	app.SetName("Python Process")

	pydebugger = adb.Adb(app)

	connection = SimpleConnection()
	connection.Connect(app, pydebugger,axdebug.IID_IRemoteDebugApplicationEvents)

	root = app.GetRootNode()

	nodes = BuildModuleTree()
	import statcache

	all_real_nodes = {}
	all_providers = []
	for node in nodes.values():
		realNode = app.CreateApplicationNode()
		provider = PySourceModuleDebugDocumentProvider(pydebugger, node.module)
		all_providers.append(provider)
		all_real_nodes[node] = realNode
		realNode.SetDocumentProvider(_wrap(provider, axdebug.IID_IDebugDocumentProvider))
	# Loop attaching parents
	for node in nodes.values():
		realNode = all_real_nodes[node]
		if node.parent is None:
			realNode.Attach(root) # Attach to the root
		else:
			parentNode = all_real_nodes[node.parent]
			realNode.Attach(parentNode)

	cookie = pdm.AddApplication(app)
	app.StartDebugSession()
	raw_input("Waiting...")
	ttest.test()

	for provider in all_providers:
		provider._Close()
	pdm.RemoveApplication(cookie)
	connection.Disconnect()
	print "Done"

if __name__=='__main__':
	try:
		app = testsmart()
#		app = testdumb()
	except:
		traceback.print_exc()

	_wrap_remove(externalConnectionManager)
	wrappedExternalConnectionManager = None
	import win32com.axdebug.util
	win32com.axdebug.util._dump_wrapped()
	sys.exc_type = sys.exc_value = sys.exc_traceback = None

	print pythoncom._GetInterfaceCount(),"com objects still alive"

