// This file implements the IDebugDocumentProvider Interface and Gateway for Python.
// Generated by makegw.py

#include "stdafx.h"

#include "PyIDebugDocumentInfo.h"
#include "PyIDebugDocumentProvider.h"

// @doc - This file contains autoduck documentation
// ---------------------------------------------------
//
// Interface Implementation

PyIDebugDocumentProvider::PyIDebugDocumentProvider(IUnknown *pdisp):
	PyIDebugDocumentInfo(pdisp)
{
	ob_type = &type;
}

PyIDebugDocumentProvider::~PyIDebugDocumentProvider()
{
}

/* static */ IDebugDocumentProvider *PyIDebugDocumentProvider::GetI(PyObject *self)
{
	return (IDebugDocumentProvider *)PyIUnknown::GetI(self);
}

// @pymethod <o PyIDebugDocument>|PyIDebugDocumentProvider|GetDocument|Causes the document to be instantiated if it does not already exist.
PyObject *PyIDebugDocumentProvider::GetDocument(PyObject *self, PyObject *args)
{
	IDebugDocumentProvider *pIDDP = GetI(self);
	if ( pIDDP == NULL )
		return NULL;
	if ( !PyArg_ParseTuple(args, ":GetDocument") )
		return NULL;
	IDebugDocument *ppssd;
	HRESULT hr = pIDDP->GetDocument( &ppssd );
	if ( FAILED(hr) )
		return SetPythonCOMError(self,hr);

	PyObject *obppssd = PyCom_PyObjectFromIUnknown(ppssd, IID_IDebugDocument, FALSE);
	PyObject *pyretval = Py_BuildValue("O", obppssd);
	Py_XDECREF(obppssd);
	return pyretval;
}

// @object PyIDebugDocumentProvider|Provides the means for instanciating a document on demand.  Derived from <o PyIDebugDocumentInfo>.
static struct PyMethodDef PyIDebugDocumentProvider_methods[] =
{
	{ "GetDocument", PyIDebugDocumentProvider::GetDocument, 1 }, // @pymeth GetDocument|Causes the document to be instantiated if it does not already exist.
	{ NULL }
};

PyComTypeObject PyIDebugDocumentProvider::type("PyIDebugDocumentProvider",
		&PyIDebugDocumentInfo::type,
		sizeof(PyIDebugDocumentProvider),
		PyIDebugDocumentProvider_methods,
		GET_PYCOM_CTOR(PyIDebugDocumentProvider));
// ---------------------------------------------------
//
// Gateway Implementation

// Std delegation
STDMETHODIMP_(ULONG) PyGDebugDocumentProvider::AddRef(void) {return PyGatewayBase::AddRef();}
STDMETHODIMP_(ULONG) PyGDebugDocumentProvider::Release(void) {return PyGatewayBase::Release();}
STDMETHODIMP PyGDebugDocumentProvider::QueryInterface(REFIID iid, void ** obj) {return PyGatewayBase::QueryInterface(iid, obj);}
STDMETHODIMP PyGDebugDocumentProvider::GetTypeInfoCount(UINT FAR* pctInfo) {return PyGatewayBase::GetTypeInfoCount(pctInfo);}
STDMETHODIMP PyGDebugDocumentProvider::GetTypeInfo(UINT itinfo, LCID lcid, ITypeInfo FAR* FAR* pptInfo) {return PyGatewayBase::GetTypeInfo(itinfo, lcid, pptInfo);}
STDMETHODIMP PyGDebugDocumentProvider::GetIDsOfNames(REFIID refiid, OLECHAR FAR* FAR* rgszNames, UINT cNames, LCID lcid, DISPID FAR* rgdispid) {return PyGatewayBase::GetIDsOfNames( refiid, rgszNames, cNames, lcid, rgdispid);}
STDMETHODIMP PyGDebugDocumentProvider::Invoke(DISPID dispid, REFIID riid, LCID lcid, WORD wFlags, DISPPARAMS FAR* params, VARIANT FAR* pVarResult, EXCEPINFO FAR* pexcepinfo, UINT FAR* puArgErr) {return PyGatewayBase::Invoke( dispid, riid, lcid, wFlags, params, pVarResult, pexcepinfo, puArgErr);}

// PyIDebugDocumentInfo
STDMETHODIMP PyGDebugDocumentProvider::GetName(DOCUMENTNAMETYPE dnt, BSTR __RPC_FAR * pbstrName) {return PyGDebugDocumentInfo::GetName(dnt, pbstrName);}
STDMETHODIMP PyGDebugDocumentProvider::GetDocumentClassId(GUID __RPC_FAR * pclsidDocument) {return PyGDebugDocumentInfo::GetDocumentClassId(pclsidDocument);}


STDMETHODIMP PyGDebugDocumentProvider::GetDocument(
		/* [out] */ IDebugDocument __RPC_FAR *__RPC_FAR * ppssd)
{
	PY_GATEWAY_METHOD;
	if (ppssd==NULL) return E_POINTER;
	PyObject *result;
	HRESULT hr=InvokeViaPolicy("GetDocument", &result);
	if (FAILED(hr)) return hr;
	// Process the Python results, and convert back to the real params
	PyObject *obppssd;
	if (!PyArg_Parse(result, "O" , &obppssd)) return PyCom_HandlePythonFailureToCOM(/*pexcepinfo*/);
	BOOL bPythonIsHappy = TRUE;
	if (!PyCom_InterfaceFromPyInstanceOrObject(obppssd, IID_IDebugDocument, (void **)ppssd, FALSE /* bNoneOK */))
		 bPythonIsHappy = FALSE;
	if (!bPythonIsHappy) hr = PyCom_HandlePythonFailureToCOM(/*pexcepinfo*/);
	Py_DECREF(result);
	return hr;
}

