""" Manangement of documents for AXDebugging.
"""

import axdebug, gateways
from util import _wrap, _wrap_remove, trace
from win32com.server.util import unwrap
import codecontainer
from win32com.server.exception import Exception
import win32api, winerror, os, string

class PySourceModuleDebugDocumentInfo(gateways.DebugDocumentInfo):
	# A DebugDocumentInfo that wraps a Python source module.
	def __init__(self, module):
		self.module = module
		gateways.DebugDocumentInfo.__init__(self)
		
	def GetName(self, dnt):
		name = self.module.__name__
		try:
			fullname = win32api.GetFullPathName(name)
		except win32api.error:
			fullname = name
		shortname = os.path.split(fullname)[1]
		if dnt==axdebug.DOCUMENTNAMETYPE_APPNODE:
			return string.split(shortname, ".")[-1]
		elif dnt==axdebug.DOCUMENTNAMETYPE_TITLE:
			return fullname
		elif dnt==axdebug.DOCUMENTNAMETYPE_FILE_TAIL:
			return shortname
		elif dnt==axdebug.DOCUMENTNAMETYPE_URL:
			return "file:%s" % fullname
		else:
			raise Exception(scode=winerror.E_UNEXPECTED)

	def GetDocumentClassId(self):
		return pythoncom.IID_NULL

class PySourceModuleDebugProvider(PySourceModuleDebugDocumentInfo, \
                                      gateways.DebugDocumentProvider,
                                      ):
	_public_methods_ = PySourceModuleDebugDocumentInfo._public_methods_ + \
	                   gateways.DebugDocumentProvider._public_methods_
	_com_interfaces_ = PySourceModuleDebugDocumentInfo._com_interfaces_ + \
	                   gateways.DebugDocumentProvider._com_interfaces_
	def GetDocument(self):
		raise Exception(scode=winerror.E_NOTIMPL)


class CodeContainerDebugDocumentText(gateways.DebugDocumentText):
	# A class which partially implements a DebugDocumentText, using the functionality
	# provided by a codeContainer
	def __init__(self, codeContainer):
		gateways.DebugDocumentText.__init__(self)
		self.codeContainer = codeContainer
		self.docContexts = {}
	def _Close(self):
		for context in self.docContexts.values():
			context._Close()
		self.docContexts = None
		self.codeContainer._Close()
		self.codeContainer = None
		_wrap_remove(self)
	def _MakeDebugDocumentContext(self, charPos, maxChars):
		import contexts
		return contexts.DebugDocumentContext(self, charPos, maxChars)
	def GetSize(self):
		trace("GetSize")
		rc = self.codeContainer.GetNumLines(), self.codeContainer.GetNumChars()
		print rc
		return rc
	def GetPositionOfLine(self, cLineNumber):
		return self.codeContainer.GetPositionOfLine(cLineNumber)
	def GetLineOfPosition(self, charPos):
		return self.codeContainer.GetLineOfPosition(charPos)
	def GetText(self, charPos, maxChars, wantAttr):
		# Get all the attributes, else the tokenizer will get upset.
		# XXX - not yet!
		print "GetText", charPos, maxChars, wantAttr
		cont = self.codeContainer
		attr = cont.GetSyntaxColorAttributes()
		return cont.text, attr

	def GetPositionOfContext(self, context):
		trace("GetPositionOfContext", context)
		cont = self.codeContainer
		context = unwrap(context)
		lineNo, offset = self.GetLineOfPosition(context.charPos)
		return context.charPos, len(cont.GetLine(lineNo))

	def PyGetContextOfPosition(self, charPos, maxChars):
		trace("GetContextOfPos", charPos, maxChars)
		# Convert to line number.
		lineNo, offset = self.GetLineOfPosition(charPos)
		charPos = self.GetPositionOfLine(lineNo)
		try:
			doccontext = self.docContexts[charPos]
			trace(" GetContextOfPos using existing")
		except KeyError:
			trace(" GetContextOfPos creating new")
			doccontext = self._MakeDebugDocumentContext(charPos, maxChars)
			self.docContexts[charPos] = doccontext
		return doccontext
		
	def GetContextOfPosition(self, charPos, maxChars):
		return _wrap(self.PyGetContextOfPosition(charPos, maxChars), axdebug.IID_IDebugDocumentContext)

	def _OnSetBreakPoint(self, docContext, codeContext, bps):
		pass

class PySourceModuleDebugDocumentText(CodeContainerDebugDocumentText):
	def __init__(self, module):
		self.module = module
		self._MakeCodeContainer()
		CodeContainerDebugDocumentText.__init__(self, self.codeContainer)
	def _MakeCodeContainer(self):
		if hasattr(self.module, '__file__'):
			try:
				codeText = open(self.module.__file__, "r").read()
			except IOError, details:
				codeText = "# Exception opening file\n# %s" % (`details`)
			self.codeContainer = codecontainer.SourceCodeContainer(codeText)
		else:
			raise Exception(winerror.S_FALSE)
	def GetDocumentAttributes(self):
		trace("GetDocumentAttributes")
		return 0

class PySourceModuleDebugDocumentTextExternalAuthor(PySourceModuleDebugDocumentText,
                                              gateways.DebugDocumentTextExternalAuthor):
	_public_methods_ = PySourceModuleDebugDocumentText._public_methods_ + \
	                   gateways.DebugDocumentTextExternalAuthor._public_methods_
	_com_interfaces_ = PySourceModuleDebugDocumentText._com_interfaces_ + \
	                   gateways.DebugDocumentTextExternalAuthor._com_interfaces_

	def __init__(self, module):
		PySourceModuleDebugDocumentText.__init__(self, module)
		gateways.DebugDocumentTextExternalAuthor.__init__(self)
	
	# DebugDocumentTextExternalAuthor
	def GetPathName(self):
		trace("GetPathName")
		return self.module.__file__, 1
  
	def GetFileName(self):
		trace("GetFileName")
		return os.path.split(self.module.__file__)[1]
  
	def NotifyChanged(self):
		trace("NotifyChanged")

