"""A utility class for a code container.

A code container is a class which holds source code for a debugger.  It knows how
to color the text, and also how to translate lines into offsets, and back.
"""

import ni, string, axdebug
import new_tokenize, token
tokenize = new_tokenize

from win32com.server.exception import Exception
import winerror

_keywords = {}				# set of Python keywords
for name in string.split("""
 and break class continue def del elif else except exec
 finally for from global if import in is lambda not
 or pass print raise return try while
 """):
    _keywords[name] = 1

class SourceCodeContainer:
	def __init__(self, text):
		self.text = str(text) # Convert from Unicode if necessary.
		self.nextLineNo = 0
		self._buildlines()
	def _Close(self):
		self.text = self.lines = self.lineOffsets = None
		
	def GetPositionOfLine(self, cLineNumber):
		try:
#			print "GPOL ret=",self.lineOffsets[cLineNumber]
			return self.lineOffsets[cLineNumber]
		except IndexError:
			raise Exception(scode=winerror.S_FALSE)
	def GetLineOfPosition(self, charPos):
		lastOffset = 0
		lineNo = 0
		for lineOffset in self.lineOffsets[1:]:
			if lineOffset > charPos:
				break
			lastOffset = lineOffset
			lineNo = lineNo + 1
		else: # for not broken.
			raise Exception(scode=winerror.S_FALSE)
#		print "GLOP ret=",lineNo, 	(charPos-lastOffset)
		return lineNo, 	(charPos-lastOffset)

	def GetNextLine(self):
		if self.nextLineNo>=len(self.lines):
			self.nextLineNo = 0 # auto-reset.
			return ""
		rc = self.lines[self.nextLineNo]
		self.nextLineNo = self.nextLineNo + 1
		return rc
		
	def GetLine(self, num):
		return self.lines[num]
		
	def GetNumChars(self):
		return len(self.text)
		
	def GetNumLines(self):
		return len(self.lines)

	def _buildline(self, pos):
		i = string.find(self.text, '\n', pos)
		if i < 0:
			newpos = len(self.text)
		else:
			newpos = i+1
		r = self.text[pos:newpos]
		return r, newpos
		
	def _buildlines(self):
		self.lines = []
		self.lineOffsets = [0]
		line, pos = self._buildline(0)
		while line:
			self.lines.append(line)
			self.lineOffsets.append(pos)
			line, pos = self._buildline(pos)

	def _ProcessToken(self, type, string, linenum, line, start, end):
		linenum = linenum - 1 # Lines zero based for us too.
		realCharPos = self.lineOffsets[linenum] + start
		numskipped = realCharPos - self.lastPos
		if numskipped==0:
			pass
		elif numskipped==1:
			self.attrs.append(axdebug.SOURCETEXT_ATTR_COMMENT)
		else:
			self.attrs.append((axdebug.SOURCETEXT_ATTR_COMMENT, numskipped))
		kwSize = end - start
		self.lastPos = realCharPos + kwSize
		attr = 0
		if type==token.NAME:
			if _keywords.has_key(string):
				attr = axdebug.SOURCETEXT_ATTR_KEYWORD
		elif type==token.STRING:
			attr = axdebug.SOURCETEXT_ATTR_STRING
		elif type==token.NUMBER:
			attr = axdebug.SOURCETEXT_ATTR_NUMBER
		elif type==token.OP:
			attr = axdebug.SOURCETEXT_ATTR_OPERATOR
		# else attr remains zero...
		if kwSize==0:
			pass
		elif kwSize==1:
			self.attrs.append(attr)
		else:
			self.attrs.append((attr, kwSize))

	def GetSyntaxColorAttributes(self):
		self.lastPos = 0
		self.attrs = []
		try:
			tokenize.tokenize(self.GetNextLine, self._ProcessToken)
		except tokenize.TokenError:
			pass # Ignore - will cause all subsequent text to be commented.
		numAtEnd = len(self.text) - self.lastPos
		if numAtEnd:
			self.attrs.append((axdebug.SOURCETEXT_ATTR_COMMENT, numAtEnd))
		return self.attrs

if __name__=='__main__':
	import sys
	text = open(sys.argv[1], "rb").read()
	print "Code (%d):" % len(text)
	print repr(text)
	sc = SourceCodeContainer(text)
	attrs = sc.GetSyntaxColorAttributes()
	attrlen = 0
	for attr in attrs:
		if type(attr)==type(()):
			attrlen = attrlen + attr[1]
		else:
			attrlen = attrlen + 1
	if attrlen!=len(text):
		print "Lengths dont match!!! (%d/%d)" % (attrlen, len(text))
	
#	print "Attributes:"
#	print attrs
	print "GetLineOfPos=", sc.GetLineOfPosition(0)
	print "GetLineOfPos=", sc.GetLineOfPosition(4)
	print "GetLineOfPos=", sc.GetLineOfPosition(10)


