"""The glue between the Python debugger interface and the Active Debugger interface
"""
from win32com.axdebug.util import trace, _wrap, _wrap_force, _wrap_remove
import gateways
import sys, bdb, traceback
import axdebug

class Adb(bdb.Bdb,gateways.RemoteDebugApplicationEvents):
	def __init__(self, debugApplication):
		self.debugApplication = debugApplication
		bdb.Bdb.__init__(self)
		self.reset()

	def reset(self):
		bdb.Bdb.reset(self)
		self.breakFlags = 0
		self.breakReason = None
		self.appDebugger = None
		self.contextFlags = {}
		
	def break_anywhere(self, frame):
		trace("break_anywhere", frame)
		if self.breakFlags:
			return 1
		
		if self.contextFlags:
			return 1

	def user_call(self, frame, argument_list):
#		trace("user_call",frame.f_lineno, frame.f_code.co_filename, argument_list)
		bdb.Bdb.user_call(self, frame, argument_list)
	def user_line(self, frame):
#		trace("user_line",frame.f_lineno, frame.f_code.co_filename)
		if self.breakFlags==axdebug.APPBREAKFLAG_DEBUGGER_HALT:
			breakReason = axdebug.BREAKREASON_DEBUGGER_HALT
		else:
			breakReason = None
			if self.breakFlags:
				trace("Unknown break flags!", self.breakFlags)
			try:
				context = self.contextFlags[frame.f_code.co_filename]
			except KeyError:
				context = None
			if context:
				breakReason = axdebug.BREAKREASON_BREAKPOINT
			
		if breakReason:
			print "Calling HBP"
			self.debugApplication.HandleBreakPoint(axdebug.BREAKREASON_BREAKPOINT)
			print "Calling HBP returned"

	def user_return(self, frame, return_value):
#		trace("user_return",frame,return_value)
		bdb.Bdb.user_return(self, frame, return_value)
	def user_exception(self, frame, (exc_type, exc_value, exc_traceback)):
		trace("user_exception")
		bdb.Bdb.user_exception(self, frame, (exc_type, exc_value, exc_traceback))

	def OnConnectDebugger(self, appDebugger):
		try:
			self.appDebugger = appDebugger
			trace("OnConnectDebugger", appDebugger)
		except:
			traceback.print_exc()
		
	def OnDisconnectDebugger(self):
		sys.settrace(None)
		self.reset()
		trace("OnDisconnectDebugger")
	def OnSetName(self, name):
		trace("OnSetName", name)
	def OnDebugOutput(self, string):
		trace("OnDebugOutput", string)
	def OnClose(self):
		trace("OnClose")
	def OnEnterBreakPoint(self, rdat):
		trace("OnEnterBreakPoint", rdat)
	def OnLeaveBreakPoint(self, rdat):
		trace("OnLeaveBreakPoint", rdat)
	def OnCreateThread(self, rdat):
		trace("OnCreateThread", rdat)
	def OnDestroyThread(self, rdat):
		trace("OnDestroyThread", rdat)
	def OnBreakFlagChange(self, abf, rdat):
		trace("OnBreakFlagChange", abf, rdat)
		self.breakFlags = abf
		self._BreakFlagsChanged()

	def _BreakFlagsChanged(self):
		if self.breakFlags or self.contextFlags:
			sys.settrace(self.trace_dispatch)
		else:
			sys.settrace(None)
	def _OnSetBreakPoint(self, module, codeContext, bps):
		key = module.__file__
		if not self.contextFlags.has_key(key ):
			self.contextFlags[key ] = {}
		self.contextFlags[key ][codeContext] = bps
		self._BreakFlagsChanged()



