// oleargs.cpp : ole args <--> python object implementation file
//

// Note - this currently only supports BSTRs by reference/pointers.

#include "stdafx.h"
#include "PythonCOM.h"

static BOOL PyCom_SAFEARRAYFromPyObject(PyObject *obj, SAFEARRAY **ppSA, VARENUM vt = VT_VARIANT);
static PyObject *PyCom_PyObjectFromSAFEARRAY(SAFEARRAY *psa, VARENUM vt = VT_VARIANT );

///////////////////////////////////////////////////////////
//
// Generic Python objects - to/from VARIANTS and Python objects.
//
//

// Given a Python object, make the best (ie, most appropriate) VARIANT.
// Should be used when the specific type of the variant is not known
// NOTE that passing by reference is not supported using this function
// you need to use the complicated ArgHelpers class for that!
BOOL PyCom_VariantFromPyObject(PyObject *obj, VARIANT *var)
{
	V_VT(var) = VT_EMPTY;
	if ( PyString_Check(obj) || PyUnicode_Check(obj) )
	{
		if ( !PyWinObject_AsBstr(obj, &V_BSTR(var)) ) {
			OleSetMemoryError("Making BSTR for variant");
			return FALSE;
		}
		V_VT(var) = VT_BSTR;
	}
	else if (PyInt_Check(obj))
	{
		V_VT(var) = VT_I4;
		V_I4(var) = PyInt_AsLong(obj);
	}
	else if (PyLong_Check(obj))
	{
		double dval = PyLong_AsDouble(obj);
		BOOL isDword = FALSE;
		if (dval >= 0 && dval < (double)ULONG_MAX)
		{
			DWORD dwval = (DWORD)dval;
			if ((double)dwval == dval)
			{
				V_VT(var) = VT_I4;
				V_I4(var) = dwval;
				isDword = TRUE;
			}
		}
		if (!isDword)
		{
			V_VT(var) = VT_R8;
			V_R8(var) = dval;
		}
	}
	else if (PyFloat_Check(obj))
	{
		V_VT(var) = VT_R8;
		V_R8(var) = PyFloat_AsDouble(obj);
	}
	else if (obj == Py_None)
	{
		V_VT(var) = VT_NULL;
	}
	else if (PyInstance_Check(obj) && PyObject_HasAttrString(obj, "_oleobj_"))
	{
		if (PyCom_InterfaceFromPyInstanceOrObject(obj, IID_IDispatch, (void **)&V_DISPATCH(var), FALSE))
				V_VT(var) = VT_DISPATCH;
		PyErr_Clear();
	}
	else if (PyIBase::is_object(obj, &PyIDispatch::type))
	{
		V_VT(var) = VT_DISPATCH;
		V_DISPATCH(var) = PyIDispatch::GetI(obj);
		V_DISPATCH(var)->AddRef();
	}
	else if (PyIBase::is_object(obj, &PyIUnknown::type))
	{
		V_VT(var) = VT_UNKNOWN;
		V_UNKNOWN(var) = PyIUnknown::GetI(obj);
		V_UNKNOWN(var)->AddRef();
	}
	else if (obj->ob_type == &PyOleEmptyType)
	{
		// use default parameter
		// Note the SDK documentation for FUNCDESC describes this behaviour
		// as correct.  However, IMAPI.Session.Logon, most DAO, etc do _not_ work
		// correctly in this case. ..Logon does work if the params are not
		// presented at all (ie, argCount < ..)  This is supported by the
		// PyOleMissing object, but should be handled before here.
		// Note that VB seems to use the "missing" rather than "empty"
		// behaviour (as logon works there)
		// Also note that MAPI still does _not_ work if a valid param with
		// VT_EMPTY is passed in, so that is also not an option - the param must
		// be _missing_.
		V_VT(var) = VT_ERROR;
		V_ERROR(var) = DISP_E_PARAMNOTFOUND;
	}
	else if (PyTime_Check(obj))
	{
		V_VT(var) = VT_DATE;
		PyWinObject_AsDATE(obj, &(V_DATE(var)));
	}
	// NOTE: PySequence_Check may return true for instance object,
	// or ANY object with a __len__ object.
	else if (PySequence_Check(obj))
	{
		if (!PyCom_SAFEARRAYFromPyObject(obj, &V_ARRAY(var)))
			return FALSE;
		V_VT(var) = VT_ARRAY | VT_VARIANT;
	}
	/*
	else if (obj->ob_type == &AutomatedType)
	{
	}
	*/
	return (V_VT(var) != VT_EMPTY);
}

// Given a variant, turn it into a Python object of the closest type.
// Note that ByRef params _are_ supported here - a normal PyObject is
// returned, but if you pass a BOOL *, you can learn if the variant specifies
// the value as BYREF.
PyObject *PyCom_PyObjectFromVariant(const VARIANT *var)
{
	HRESULT		hr;
	VARIANT		varValue;
	PyObject *	result = NULL;

	/* skip past any variant references to a "real" variant */
	while ( V_VT(var) == (VT_BYREF | VT_VARIANT) )
		var = V_VARIANTREF(var);

	/* ### note: we shouldn't see this, it is illegal in a VARIANT */
	if (V_ISVECTOR(var)) {
		return OleSetTypeError("Cant convert vectors!");
	}

	if (V_ISARRAY(var)) {
		SAFEARRAY FAR *psa;
		if (V_ISBYREF(var))
			psa = *V_ARRAYREF(var);
		else
			psa=V_ARRAY(var);
		VARENUM rawVT = (VARENUM)(V_VT(var) & (~ (VT_ARRAY | VT_BYREF)));
		return PyCom_PyObjectFromSAFEARRAY(psa, rawVT);
	}

	/* get a fully dereferenced copy of the variant */
	/* ### we may want to optimize this sometime... avoid copying values */
	VariantInit(&varValue);
	VariantCopyInd(&varValue, (VARIANT*)var);

	switch (V_VT(&varValue))
	{
		case VT_BOOL:
		case VT_I2:
		case VT_I4:
			hr = VariantChangeType(&varValue, &varValue, 0, VT_I4);
			if ( FAILED(hr) )
			{
				char buf[200];
				wsprintf(buf, "Error converting integer variant (%08lx)", hr);
				OleSetTypeError(buf);
				break;
			}
			result = PyInt_FromLong(V_I4(&varValue));
			break;

		case VT_ERROR:
			result = PyInt_FromLong(V_ERROR(&varValue));
			break;

		case VT_R4:
		case VT_R8:
			hr = VariantChangeType(&varValue, &varValue, 0, VT_R8);
			if ( FAILED(hr) )
			{
				char buf[200];
				wsprintf(buf, "Error converting floating point variant (%08lx)", hr);
				OleSetTypeError(buf);
				break;
			}
			result = PyFloat_FromDouble(V_R8(&varValue));
			break;

		case VT_DISPATCH:
		{
			IDispatch *pIDispatch = V_DISPATCH(&varValue);
			if (pIDispatch)
				result = PyCom_PyObjectFromIUnknown(pIDispatch, IID_IDispatch,TRUE);
			else
			{
				Py_INCREF(Py_None);
				result = Py_None;
			}
			break;
		}

		case VT_UNKNOWN:
		{
			IUnknown *punk = V_UNKNOWN(&varValue);
			if (punk)
				result = PyCom_PyObjectFromIUnknown(punk, IID_IUnknown, TRUE);
			else
			{
				Py_INCREF(Py_None);
				result = Py_None;
			}
			break;
		}

		case VT_BSTR:
			result = PyWinObject_FromBstr(V_BSTR(&varValue));
			break;

		case VT_NULL:
		case VT_EMPTY:
			Py_INCREF(Py_None);
			result = Py_None;
			break;

		case VT_DATE:
			result = PyWinObject_FromDATE(V_DATE(&varValue));
			break;

		default:
			{
				HRESULT hr = VariantChangeType(&varValue, &varValue, 0, VT_BSTR);
				if (FAILED(hr)) {
					char buf[200];
					wsprintf(buf, "The Variant type (0x%x) is not supported, and it can not be converted to a string", V_VT(var));
					OleSetTypeError(buf);
					break;
				}
				result = PyWinObject_FromBstr(V_BSTR(&varValue));
				break;
			}
	}

	VariantClear(&varValue);
	return result;
}

///////////////////////////////////////////////////////////
//
// SAFEARRAY support - to/from SAFEARRAYS and Python sequences.
//
//
// PyObject -> SafeArray
static BOOL PyCom_SAFEARRAYFromPyObjectBuildDimension(PyObject *obj, SAFEARRAY *pSA, VARENUM vt, UINT dimNo, UINT nDims, SAFEARRAYBOUND *pBounds, LONG *pIndices)
{
	LONG numElements = pBounds[dimNo-1].cElements;
	if ((LONG)PySequence_Length(obj)!=numElements) {
		OleSetTypeError("All dimensions must be a tuple of the same size");
		return FALSE;
	}
	BOOL ok = TRUE;
	for (int index=0;index<(int)numElements && ok;index++) {
		pIndices[dimNo-1] = index;
		PyObject *item = PySequence_GetItem(obj, index);
		if ( item == NULL )
			return FALSE;
		if (dimNo==nDims) { // Last one - fill the data
			VARIANT element;
			LPVOID pvData;
			if (vt==VT_VARIANT) { // simple conversion
				ok = PyCom_VariantFromPyObject(item, &element);
				pvData = &element;
			} else {
				// Complex conversion.
				if (vt & VT_ARRAY || vt & VT_BYREF) {
					OleSetTypeError("Internal error - unexpected argument - only simple VARIANTTYPE expected");
					ok = FALSE;
				} else {
					PythonOleArgHelper helper;
					helper.m_reqdType = vt;
					ok = helper.MakeObjToVariant(item, &element);
					pvData = &V_I4(&element);
				}
			}
			if (ok) {
				HRESULT hr = SafeArrayPutElement(pSA, pIndices, pvData);
				VariantClear(&element);
				if ( FAILED(hr) ) {
					OleSetError("Could not set the SAFEARRAY element");
					ok = FALSE;
				}
			}
		} else {
			// recurse down dimensions
			ok = PyCom_SAFEARRAYFromPyObjectBuildDimension(item, pSA, vt, dimNo+1, nDims, pBounds, pIndices);
		}
		Py_DECREF(item);
	}
	return ok;
}

static BOOL PyCom_SAFEARRAYFromPyObject(PyObject *obj, SAFEARRAY **ppSA, VARENUM vt /*= VT_VARIANT*/)
{
	// Seek down searching for total dimension count.
	// Item zero of each element will do for now
	// (as all must be same)
	LONG cDims = 0;
	PyObject *obItemCheck = obj;
	Py_INCREF(obItemCheck);
	// Dont allow arb. seq - we dont want strings to qualify...
	while (obItemCheck && (PyList_Check(obItemCheck) || PyTuple_Check(obItemCheck))) {
		if (PySequence_Length(obItemCheck)) {
			PyObject *obSave = obItemCheck;
			obItemCheck = PySequence_GetItem(obItemCheck,0);
			Py_DECREF(obSave);
			if (obItemCheck==NULL)
				return FALSE;
		} else
			obItemCheck = NULL;
		cDims = cDims + 1;
	}
	Py_XDECREF(obItemCheck);

	if (cDims==0) {
		OleSetTypeError("Objects for SAFEARRAYS must be sequences (of sequences)");
		return FALSE;
	}

	SAFEARRAYBOUND* pBounds = new SAFEARRAYBOUND[cDims];

	// Now run down again, setting up the bounds
	obItemCheck = obj;
	Py_INCREF(obItemCheck);
	for (LONG dimLook = 1;dimLook <= cDims;dimLook++) {
		pBounds[dimLook-1].lLbound = 0; // always!
		pBounds[dimLook-1].cElements = PySequence_Length(obItemCheck);
		PyObject *obSave = obItemCheck;
		if (pBounds[dimLook-1].cElements) {
			obItemCheck = PySequence_GetItem(obItemCheck,0);
			Py_DECREF(obSave);
			if (obItemCheck==NULL) {
				delete [] pBounds;
				return FALSE;
			}
		} else {
			obItemCheck = NULL;
		}
	}
	Py_XDECREF(obItemCheck);

	// OK - Finally can create the array...
	SAFEARRAY FAR* psa = SafeArrayCreate(vt, cDims, pBounds);
	if ( psa == NULL ) {
		delete pBounds;
		OleSetMemoryError("CreatingSafeArray");
		return FALSE;
	}
	LONG *indices = new LONG[cDims];
	// Get the data

	BOOL bOK = PyCom_SAFEARRAYFromPyObjectBuildDimension(obj, psa, vt, 1, cDims, pBounds, indices);
	if (bOK)
		*ppSA = psa;
	else
		SafeArrayDestroy(psa);
	delete [] indices;
	delete [] pBounds;

	return bOK;
}

///////////////////////////
//
// SafeArray -> PyObject
/* 
   Helper - Convert the current index to a Python object.
   No iteration - returns a simple object (not a tuple) 
*/
static PyObject *PyCom_PyObjectFromSAFEARRAYDimensionItem(SAFEARRAY *psa, VARENUM vt, long *arrayIndices)
{
	PyObject *subitem = NULL;
	HRESULT hres = 0;
	switch (vt) {
		case VT_VARIANT: {
			VARIANT		varValue;
			VariantInit(&varValue);
			hres = SafeArrayGetElement(psa, arrayIndices, &varValue);
			if (FAILED(hres)) break;
			subitem = PyCom_PyObjectFromVariant(&varValue);
			VariantClear(&varValue); // clean this up
			break;
			}
		case VT_UI1: {
			char i1;
			hres = SafeArrayGetElement(psa, arrayIndices, &i1);
			if (FAILED(hres)) break;
			subitem = PyInt_FromLong(i1);
			break;
		}
		case VT_I2: {
			short sh;
			hres = SafeArrayGetElement(psa, arrayIndices, &sh);
			if (FAILED(hres)) break;
			subitem = PyInt_FromLong(sh);
			break;
			}
		case VT_I4:	{
			long ln;
			hres = SafeArrayGetElement(psa, arrayIndices, &ln);
			if (FAILED(hres)) break;
			subitem = PyInt_FromLong(ln);
			break;
			}
		case VT_R4: {
			double db;
			hres = SafeArrayGetElement(psa, arrayIndices, &db);
			if (FAILED(hres)) break;
			subitem = PyFloat_FromDouble(db);
			break;
			}
		case VT_BSTR: {
			BSTR str;
			hres = SafeArrayGetElement(psa, arrayIndices, &str);
			if (FAILED(hres)) break;
			subitem = PyWinObject_FromBstr(str);
			break;
			}
		case VT_DATE: {
			DATE dt;
			hres = SafeArrayGetElement(psa, arrayIndices, &dt);
			if (FAILED(hres)) break;
			subitem = PyWinObject_FromDATE(dt);
			break;
			};
		default:
			OleSetTypeError("The VARIANT type is not supported for SAFEARRAYS");
	}
	if (FAILED(hres)) {
		OleSetOleError(hres);
		Py_XDECREF(subitem);
		subitem =  NULL;
	}
	// All done.
	return subitem;
}

/* Helper - Convert the specified dimension of the specified safe array to
   a Python object (a tuple)
*/
static PyObject *PyCom_PyObjectFromSAFEARRAYBuildDimension(SAFEARRAY *psa, VARENUM vt, UINT dimNo, UINT nDims, long *arrayIndices)
{
	long lb, ub;
	HRESULT hres = SafeArrayGetLBound(psa, dimNo, &lb);
	if (FAILED(hres))
		return OleSetOleError(hres);
	hres = SafeArrayGetUBound(psa, dimNo, &ub);
	if (FAILED(hres))
		return OleSetOleError(hres);
	PyObject *retTuple = PyTuple_New(ub-lb+1);
	if (retTuple==NULL) return FALSE;
	int tupleIndex=0;
	// Get a pointer for the dimension to iterate (the last one)
	long *pMyArrayIndex = arrayIndices+(dimNo-1);
	*pMyArrayIndex = lb;
	BOOL bBuildItems = (nDims==dimNo);
	PyObject *subItem;
	for ( ; *pMyArrayIndex<=ub ; (*pMyArrayIndex)++, tupleIndex++) {
		if (bBuildItems) {
			subItem = PyCom_PyObjectFromSAFEARRAYDimensionItem(psa, vt, arrayIndices);
		} else {
			// Recurse and build sub-array.
			subItem = PyCom_PyObjectFromSAFEARRAYBuildDimension(psa, vt, dimNo+1, nDims, arrayIndices);
		}
		if (subItem == NULL)
			break;
		PyTuple_SET_ITEM(retTuple, tupleIndex, subItem);
	}
	if (subItem==NULL) { 
		PyTS_DECREF(retTuple);
		return NULL;
	}
	return retTuple;
}

/* Actual doer - Convert the specified safe array to a Python object - either a
   single tuple, or a tuples of tuples for each dimension
*/
static PyObject *PyCom_PyObjectFromSAFEARRAY(SAFEARRAY *psa, VARENUM vt /* = VT_VARIANT */)
{
	// Our caller must has resolved all byref and array references.
	if (vt & VT_ARRAY || vt & VT_BYREF) {
		OleSetTypeError("Internal error - unexpected argument - only simple VARIANTTYPE expected");
		return FALSE;
	}
	UINT nDim = SafeArrayGetDim(psa);
	LONG *pIndices = new LONG[nDim];
	PyObject *result = PyCom_PyObjectFromSAFEARRAYBuildDimension(psa, vt, 1, nDim, pIndices);
	delete [] pIndices;
	return result;
}


///////////////////////////////////////////////////////
//
// Python arg helper class
//
PythonOleArgHelper::PythonOleArgHelper() 
{
	m_bByRef = FALSE;
	m_reqdType = VT_VARIANT;
	m_bParsedTypeInfo = FALSE;
}
PythonOleArgHelper::~PythonOleArgHelper() 
{
	if (m_reqdType & VT_ARRAY) {
		// Array datatype - cleanup (but how?)
		if (m_reqdType & VT_BYREF) {
			// We own array pointer - free it.
			if (m_arrayBuf) {
				HRESULT	hr = SafeArrayDestroy(m_arrayBuf);
#ifdef _DEBUG
				if (hr!=S_OK) {
					char buf[256];
					wsprintf(buf, "SafeArrayDestroy failed with rc=%d\n", hr);
					OutputDebugString(buf);
				}
#endif
			} // have array pointer
		} // BYREF array.
	} else {
		switch (m_reqdType) {
			case VT_BSTR | VT_BYREF:
				if (m_pValueHolder)
					SysFreeString((BSTR)m_pValueHolder);
				break;
			case VT_DISPATCH | VT_BYREF:
				if (m_dispBuf)
					m_dispBuf->Release();
				break;
			case VT_UNKNOWN | VT_BYREF:
				if (m_unkBuf)
					m_unkBuf->Release();
				break;
		} // switch
	}
}

BOOL PythonOleArgHelper::ParseTypeInformation(PyObject *reqdObjectTuple)
{
	if (m_bParsedTypeInfo) return TRUE;
	int indirectionLevel = 0;
	if (!PyTuple_Check(reqdObjectTuple)) {
		OleSetTypeError("types must be specified in a tuple of tuples.");
		return FALSE;
	}
	// tuple[0] == either integer type, or (type, type)
	// tuple[1] == in/out
	PyObject *extraObject = PyTuple_GetItem(reqdObjectTuple, 1);
	long indirectType = 0;
	BOOL bForcedType = FALSE;
	int reqdFlags = 0;
	if (!extraObject) return FALSE;
	PyObject *typeDesc = PyTuple_GetItem(reqdObjectTuple, 0);
	while (PyTuple_Check(typeDesc)) {
		if (PyTuple_Size(typeDesc)!=2) {
			PyErr_SetString(PyExc_TypeError, "OLE type description - expecting a sub-type tuple of size 2");
			return FALSE;
		}
		indirectType = PyInt_AsLong(PyTuple_GetItem(typeDesc, 0));
		switch (indirectType) {
			case VT_PTR:
				indirectionLevel++;
				break;
			case VT_USERDEFINED:
				// Remove indirection level VT_USERDEFINED.
				// This type has not been translated by makepy or similar,
				--indirectionLevel;
				// This is an alias, or some other type.
				// Do the best we can, and get out now.
				m_reqdType = VT_VARIANT;
				bForcedType = TRUE;
				break;
			case VT_SAFEARRAY:
				reqdFlags |= VT_ARRAY;
				break;
			default:
				PyErr_SetString(PyExc_TypeError, "OLE type description - unknown indirection type.");
				return FALSE;
		} /* case */
		typeDesc = PyTuple_GetItem(typeDesc, 1);
	}
	if (!bForcedType)
		m_reqdType = (VARENUM)PyInt_AsLong(typeDesc);
	// XXX - hack - VT_INT and VT_UINT are not valid types for a variant
	// (only valid in tlb.)  Translate here.
	if (m_reqdType == VT_INT || m_reqdType == VT_UINT)
		m_reqdType = VT_I4; 
	// Hack - whats the correct thing?
	if (m_reqdType == VT_VARIANT && indirectionLevel>0)
		indirectionLevel = 0;

	if (indirectionLevel) {
		reqdFlags |= VT_BYREF;
		m_bByRef = TRUE;
	}
	m_reqdType |= reqdFlags;

	m_bParsedTypeInfo = TRUE;
	return TRUE;
}

#define BREAK_FALSE {rc=FALSE;break;}
#define VALID_BYREF_MISSING(obUse) (obUse==Py_None || obUse->ob_type == &PyOleEmptyType)

BOOL PythonOleArgHelper::MakeObjToVariant(PyObject *obj, VARIANT *var, PyObject *reqdObjectTuple)
{
	if (obj->ob_type == &PyOleEmptyType)
	{
		// Quick exit - use default parameter 
		V_VT(var) = VT_ERROR;
		V_ERROR(var) = DISP_E_PARAMNOTFOUND;
		return TRUE;
	}
	if (reqdObjectTuple) {
		if (!ParseTypeInformation(reqdObjectTuple))
			return FALSE;
	}
	if (m_reqdType & VT_ARRAY) {
		VARENUM rawVT = (VARENUM)(m_reqdType & (~ (VT_ARRAY | VT_BYREF)));
		if (m_reqdType & VT_BYREF) {
			if (!VALID_BYREF_MISSING(obj)) {
				OleSetTypeError("SAFEARRAY ** arguments can only be returned - pass None");
				return FALSE;
			}
			V_VT(var) = m_reqdType;
			SAFEARRAYBOUND rgsabound[1];
			rgsabound[0].lLbound = 0;
			rgsabound[0].cElements = 1;
			m_arrayBuf = SafeArrayCreate(rawVT, 1, rgsabound);

//			m_arrayBuf = NULL;
			V_ARRAYREF(var) = &m_arrayBuf;
		} else {
			if (!PyCom_SAFEARRAYFromPyObject(obj, &V_ARRAY(var), rawVT))
				return FALSE;
			V_VT(var) = m_reqdType;
		}
		return TRUE; // All done with array!
	}
	if (m_reqdType & VT_VECTOR) { // we have been asked for an array.
		OleSetTypeError("Sorry - cant support VT_VECTOR arguments");
		return FALSE;
	}
	BOOL rc = TRUE;
	PyObject *obUse = NULL;
	switch (m_reqdType) {
	case VT_VARIANT:
	// If the m_reqdType is VARIANT or unknown, let the Python type decide.
		return PyCom_VariantFromPyObject(obj, var);
	case VT_BSTR:
		if ( PyString_Check(obj) || PyUnicode_Check(obj) )
		{
			if ( !PyWinObject_AsBstr(obj, &V_BSTR(var)) ) BREAK_FALSE
		}
		else
		{
			if ((obUse=PyObject_Str(obj))==NULL) BREAK_FALSE
			V_BSTR(var) = PyCom_BstrFromPyString(obUse);
		}
		break;
	case VT_BSTR | VT_BYREF:
		m_pValueHolder = NULL;
		if (!VALID_BYREF_MISSING(obj)) {
			if ( PyString_Check(obj) || PyUnicode_Check(obj) )
			{
				if ( !PyWinObject_AsBstr(obj, (BSTR *)&m_pValueHolder) ) BREAK_FALSE
			}
			else
			{
				if ((obUse=PyObject_Str(obj))==NULL) BREAK_FALSE
				m_pValueHolder = PyCom_BstrFromPyString(obUse);
			}
		} else
			m_pValueHolder = NULL;
		V_BSTRREF(var) = (BSTR *)&m_pValueHolder;
		break;
	case VT_I4:
		if ((obUse=PyNumber_Int(obj))==NULL) BREAK_FALSE
		V_I4(var) = PyInt_AsLong(obUse);
		break;
	case VT_I4 | VT_BYREF:
		if (!VALID_BYREF_MISSING(obj)) {
			if ((obUse=PyNumber_Int(obj))==NULL) BREAK_FALSE
			m_lBuf = PyInt_AsLong(obUse);
		} else
			m_lBuf = 0;
		V_I4REF(var) = &m_lBuf;
		break;
	case VT_I2:
		if ((obUse=PyNumber_Int(obj))==NULL) BREAK_FALSE
		V_I2(var) = (short)PyInt_AsLong(obUse);
		break;
	case VT_I2  | VT_BYREF:
		if (!VALID_BYREF_MISSING(obj)) {
			if ((obUse=PyNumber_Int(obj))==NULL) BREAK_FALSE
			m_sBuf = (short)PyInt_AsLong(obUse);
		} else
			m_sBuf = 0;
		V_I2REF(var) = &m_sBuf;
	case VT_UI1:
		if ((obUse=PyNumber_Int(obj))==NULL) BREAK_FALSE
		V_UI1(var) = (BYTE)PyInt_AsLong(obUse);
		break;
	case VT_BOOL:
		if ((obUse=PyNumber_Int(obj))==NULL) BREAK_FALSE
		V_BOOL(var) = (BOOL)PyInt_AsLong(obUse);
		break;
	case VT_BOOL | VT_BYREF:
		if (!VALID_BYREF_MISSING(obj)) {
			if ((obUse=PyNumber_Int(obj))==NULL) BREAK_FALSE
			m_boolBuf = (VARIANT_BOOL)PyInt_AsLong(obj);
		} else
			m_boolBuf = 0;
#if _MSC_VER <= 1010
			// use this macro for MSVC4.1 or before
			V_BOOLREF(var) = &m_boolBuf;
#else
		// this is used in MSVC4.2 and after
		var->pboolVal = &m_boolBuf;
#endif
		break;
	case VT_R8:
		if ((obUse=PyNumber_Float(obj))==NULL) BREAK_FALSE
		V_R8(var) = PyFloat_AsDouble(obUse);
		break;
	case VT_R8 | VT_BYREF:
		if (!VALID_BYREF_MISSING(obj)) {
			if ((obUse=PyNumber_Float(obj))==NULL) BREAK_FALSE
			m_dBuf = PyFloat_AsDouble(obUse);
		} else
			m_dBuf = 0.0;
		V_R8REF(var) = &m_dBuf;
		break;
	case VT_R4:
		if ((obUse=PyNumber_Float(obj))==NULL) BREAK_FALSE
		V_R4(var) = (float)PyFloat_AsDouble(obUse);
		break;
	case VT_R4 | VT_BYREF:
		if (!VALID_BYREF_MISSING(obj)) {
			if ((obUse=PyNumber_Float(obj))==NULL) BREAK_FALSE
			m_fBuf = (float)PyFloat_AsDouble(obUse);
		} else
			m_fBuf = (float)0.0;
		V_R4REF(var) = &m_fBuf;
		break;
		
	case VT_NULL:
		break;
	case VT_DISPATCH:
		V_DISPATCH(var) = NULL;
		if (!PyCom_InterfaceFromPyInstanceOrObject(obj, IID_IDispatch, (void **)&V_DISPATCH(var), FALSE))
			BREAK_FALSE;
		// COM Reference added by InterfaceFrom...
		break;
	case VT_DISPATCH | VT_BYREF:
		m_dispBuf = NULL;
		if (!PyCom_InterfaceFromPyInstanceOrObject(obj, IID_IDispatch, (void **)&m_dispBuf, TRUE))
			BREAK_FALSE;
		V_DISPATCHREF(var) = &m_dispBuf;
		// COM Reference added by InterfaceFrom...
		break;
	case VT_UNKNOWN:
		V_UNKNOWN(var) = NULL;
		if (!PyCom_InterfaceFromPyInstanceOrObject(obj, IID_IUnknown, (void **)&V_UNKNOWN(var), FALSE))
			BREAK_FALSE;
		// COM Reference added by InterfaceFrom...
		break;
	case VT_UNKNOWN | VT_BYREF:
		m_unkBuf = NULL;
		if (!PyCom_InterfaceFromPyInstanceOrObject(obj, IID_IDispatch, (void **)&m_unkBuf, TRUE))
			BREAK_FALSE;
		// COM Reference added by InterfaceFrom...
		V_UNKNOWNREF(var) = &m_unkBuf;
		break;
	case VT_DATE:
		if ( !PyTime_Check(obj) ) BREAK_FALSE;
		if ( !PyWinObject_AsDATE(obj, &V_DATE(var) ) ) BREAK_FALSE;
		break;
	case VT_ERROR:
		V_ERROR(var) = DISP_E_PARAMNOTFOUND; // should this be PyObject_Int??
		break;
	default:
		// could try default, but this error indicates we need to
		// beef up the VARIANT support, rather than default.
		OleSetTypeError("The VARIANT type is unknown.");
		rc = FALSE;
		break;
	}
	PyTS_XDECREF(obUse);
	if (rc)
		var->vt = m_reqdType;
	return rc;
}

PyObject *PythonOleArgHelper::MakeVariantToObj(VARIANT *var)
{
	m_bByRef = V_ISBYREF(var);
	return PyCom_PyObjectFromVariant(var);
}

BOOL MakePythonArgumentTuples(PyObject **ppArgs, PythonOleArgHelper **ppHelpers, 
                     PyObject **ppNamedArgs, PythonOleArgHelper **ppNamedHelpers,
                     DISPPARAMS FAR* params)
{
	*ppArgs = *ppNamedArgs = NULL;
	*ppArgs = PyTuple_New(params->cArgs);
	if (*ppArgs==NULL) return FALSE;
	*ppNamedArgs = PyDict_New();
	if (*ppNamedArgs==NULL) {
		Py_DECREF(*ppArgs);
		return FALSE;
	}

	*ppHelpers = *ppNamedHelpers = NULL;
	*ppHelpers = new PythonOleArgHelper[params->cArgs];
	*ppNamedHelpers = new PythonOleArgHelper[params->cNamedArgs];
	if (params->cArgs>0)
		for (int arg=params->cArgs-1;arg>=0;arg--)
			PyTuple_SetItem( *ppArgs, params->cArgs-arg-1, (*ppHelpers)[(unsigned)arg].MakeVariantToObj(params->rgvarg+(unsigned)arg));
	return TRUE;
}

BOOL PyCom_MakeOlePythonCall(PyObject *handler, DISPPARAMS FAR* params, VARIANT FAR* pVarResult,
	EXCEPINFO FAR* pexcepinfo, UINT FAR* puArgErr, PyObject *addnlArgs)
{
	PythonOleArgHelper *pHelpers = NULL;
	PythonOleArgHelper *pNamedHelpers = NULL;
	PyObject *argList = NULL;
	PyObject *namedArgList = NULL;
	if (params) {
		if (!MakePythonArgumentTuples(&argList, &pHelpers, &namedArgList, &pNamedHelpers, params )) {
			PyErr_Clear();
			return FALSE;
		}
	}
	if (addnlArgs) {
		PyObject *varArgs = argList;
		argList = Py_BuildValue("OO", varArgs, addnlArgs);
		Py_DECREF(varArgs);
	}
	PyObject *result = PyEval_CallObject(handler, argList);
	Py_XDECREF(argList);
	Py_XDECREF(namedArgList);
	// handlers reference cleaned up by virtual manager.
	BOOL bOK = (result!=NULL);
	if (result) {
		// If result is a tuple, then the Python code
		// wishes to set some "byval" arguments.
		// make the return type
		PyObject *simpleRet;
		if (PyTuple_Check(result)) {
			simpleRet = PyTuple_GetItem(result, 0);
			int retNumber = 1;
			int paramMax = min((int)params->cArgs,PyTuple_Size(result)-1);

			for (int param=0;param<paramMax;param++) {
				if (pHelpers[param].m_bByRef) {
					PyObject *val = PyTuple_GetItem(result, retNumber);
					pHelpers[param].MakeObjToVariant(val, params->rgvarg+(unsigned)param, NULL);
					retNumber++;
				}
			}
		} else {
			simpleRet = result;
		}
		if (simpleRet!=Py_None)
			(void)PyCom_VariantFromPyObject(simpleRet, pVarResult);
		Py_DECREF(result);
	}
	delete [] pHelpers;
	delete [] pNamedHelpers;
	return bOK;
}

