#ifndef __PYTHONCOMSERVER_H__
#define __PYTHONCOMSERVER_H__

// PythonCOMServer.h :Server side COM support

#include <Python.h>

#define DLLAcquireGlobalLock	PyWin_AcquireGlobalLock
#define DLLReleaseGlobalLock	PyWin_ReleaseGlobalLock

void PYCOM_EXPORT PyCom_DLLAddRef(void);
void PYCOM_EXPORT PyCom_DLLReleaseRef(void);

// Use this macro at the start of all gateway methods.
#define PY_GATEWAY_METHOD CEnterLeavePython _celp

// Use these macros _directly_ around the calls in interfaces.
// XXX - these need to be moved, but at the moment the core doesnt use them
// xxx - wait for the great reorg :-)
#define PY_INTERFACE_METHOD
#define PY_INTERFACE_PRECALL
#define PY_INTERFACE_POSTCALL

// Gateway constructors.
// Each gateway must be able to be created from a "gateway constructor".  This
// is simply a function that takes a Python instance as as argument, and returns
// a gateway object of the correct type.  The MAKE_PYGATEWAY_CTOR is a helper that
// will embed such a constructor in the class - however, this is not necessary - 
// _any_ function of the correct signature can be used.

typedef HRESULT (* pfnPyGatewayConstructor)(PyObject *PythonInstance, void **ppResult, REFIID iid);
HRESULT PYCOM_EXPORT PyCom_RegisterGatewayObject(REFIID iid, pfnPyGatewayConstructor ctor, const char *interfaceName);
HRESULT PYCOM_EXPORT PyCom_MakeRegisteredGatewayObject(REFIID iid, PyObject *instance, void **ppv);

#define PYGATEWAY_MAKE_SUPPORT(classname, IInterface, theIID) \
	public: \
		static HRESULT classname::PyGatewayConstruct(PyObject *pPyInstance, void **ppResult, REFIID iid) { \
			if (ppResult==NULL) return E_INVALIDARG; \
/*			*ppResult = (IInterface *)new classname(pPyInstance); */ \
			*ppResult = (new classname(pPyInstance))->ThisAsIID(iid);  \
			return *ppResult ? S_OK : E_OUTOFMEMORY; } \
	protected: \
		virtual IID GetIID(void) { return theIID; } \
		virtual void *ThisAsIID(IID iid) {if (this==NULL) return NULL;if (iid==theIID) return (IInterface *)this; else return (IDispatch *)(PyGatewayBase *)this;}


#define GET_PYGATEWAY_CTOR(classname) classname::PyGatewayConstruct

// Disable an OK warning...
#pragma warning( disable : 4275 )
// warning C4275: non dll-interface struct 'IDispatch' used as base for dll-interface class 'PyGatewayBase'

// Helper interface for fetching a Python object from a gateway

extern const GUID IID_IInternalUnwrapPythonObject;

interface IInternalUnwrapPythonObject : public IUnknown
{
public:
    STDMETHOD(Unwrap)( PyObject **ppPyObject ) = 0;
};

/////////////////////////////////////////////////////////////////////////////
// PyGatewayBase
//
// Base class for all gateways.
//
class PYCOM_EXPORT PyGatewayBase : 
	public IDispatch,
	public ISupportErrorInfo,
	public IInternalUnwrapPythonObject
{
protected:
	PyGatewayBase(PyObject *instance);
	~ PyGatewayBase();

	// ### this method is deprecated...
	PyObject *DispatchViaPolicy(const char *szMethodName, const char *szFormat, ...);
	// Invoke the Python method (via the policy object)
	STDMETHOD(InvokeViaPolicy)(
		const char *szMethodName,
		PyObject **ppResult = NULL,
		const char *szFormat = NULL,
		...);

public:
	// IUnknown
	STDMETHOD_(ULONG,AddRef)(void);
	STDMETHOD_(ULONG,Release)(void);
	STDMETHOD(QueryInterface)(REFIID iid, void ** obj);

	// IDispatch
	STDMETHOD(GetTypeInfoCount)(UINT FAR* pctInfo);
	STDMETHOD(GetTypeInfo)(UINT itinfo, LCID lcid, ITypeInfo FAR* FAR* pptInfo);
	STDMETHOD(GetIDsOfNames)(REFIID refiid,	OLECHAR FAR* FAR* rgszNames, UINT cNames, LCID lcid, DISPID FAR* rgdispid);
	STDMETHOD(Invoke)(DISPID dispid, REFIID riid, LCID lcid, WORD wFlags, DISPPARAMS FAR* params, VARIANT FAR* pVarResult, EXCEPINFO FAR* pexcepinfo, UINT FAR* puArgErr);

	// ISupportErrorInfo
	STDMETHOD(InterfaceSupportsErrorInfo)(REFIID riid);

	// IInternalUnwrapPythonObject
	STDMETHOD(Unwrap)(PyObject **ppPyObject);

	PYGATEWAY_MAKE_SUPPORT(PyGatewayBase, IDispatch, IID_IDispatch);

	PyObject * m_pPyObject;
private:
	LONG m_cRef;
};

#pragma warning(default : 4275 )


#endif /* __PYTHONCOMSERVER_H__ */
