// PyIProvideClassInfo

// @doc
#include "stdafx.h"
#include "PythonCOM.h"

PyIProvideClassInfo::PyIProvideClassInfo(IUnknown *pDisp) :
	PyIUnknown(pDisp)
{
	ob_type = &type;
}

PyIProvideClassInfo::~PyIProvideClassInfo()
{
}

/*static*/ IProvideClassInfo *PyIProvideClassInfo::GetI(PyObject *self)
{
	return (IProvideClassInfo *)PyIUnknown::GetI(self);
}


// @pymethod <o PyITypeInfo>|PyIProvideClassInfo|GetClassInfo|Gets information about the CO_CLASS.
PyObject *PyIProvideClassInfo::GetClassInfo(PyObject *self, PyObject *args)
{
	if (!PyArg_ParseTuple(args, ":GetClassInfo"))
		return NULL;

	IProvideClassInfo *pMy = GetI(self);
	if (pMy==NULL) return NULL;
	ITypeInfo *pti = NULL;
	SCODE sc = pMy->GetClassInfo(&pti);
	if (S_OK!=sc) // S_OK only acceptable
		return OleSetOleError(sc);
	return PyCom_PyObjectFromIUnknown(pti, IID_ITypeInfo);
}


// @object PyIProvideClassInfo|A Python interface to IProvideClassInfo
static struct PyMethodDef PyIProvideClassInfo_methods[] =
{
	{"GetClassInfo",         PyIProvideClassInfo::GetClassInfo,  1},
	{NULL,  NULL}        
};

PyComTypeObject PyIProvideClassInfo::type("PyIProvideClassInfo",
                 &PyIUnknown::type,
                 sizeof(PyIProvideClassInfo),
                 PyIProvideClassInfo_methods,
				 GET_PYCOM_CTOR(PyIProvideClassInfo));


//////////////////////////////////////////////////////////
// IProvideClassInfo2 client support.

PyIProvideClassInfo2::PyIProvideClassInfo2(IUnknown *pDisp) :
	PyIProvideClassInfo(pDisp)
{
	ob_type = &type;
}

PyIProvideClassInfo2::~PyIProvideClassInfo2()
{
}

/*static*/ IProvideClassInfo2 *PyIProvideClassInfo2::GetI(PyObject *self)
{
	return (IProvideClassInfo2 *)PyIUnknown::GetI(self);
}


// @pymethod <o PyIID>|PyIProvideClassInfo2|GetGUID|
PyObject *PyIProvideClassInfo2::GetGUID(PyObject *self, PyObject *args)
{
	int flags;
	if (!PyArg_ParseTuple(args, "i:GetGUID", &flags))
		return NULL;

	IProvideClassInfo2 *pMyInfo = GetI(self);
	if (pMyInfo==NULL) return NULL;
	GUID guid;
	SCODE sc = pMyInfo->GetGUID(flags, &guid);
	if (FAILED(sc))
		return OleSetOleError(sc);
	return PyCom_PyIIDObjectFromIID(guid);
}

// @object PyIProvideClassInfo2|
static struct PyMethodDef PyIProvideClassInfo2_methods[] =
{
	{"GetGUID",PyIProvideClassInfo2::GetGUID,  1}, // @pymeth GetGUID|
	{NULL,  NULL}        
};

PyComTypeObject PyIProvideClassInfo2::type("PyIProvideClassInfo2",
                 &PyIProvideClassInfo::type,
                 sizeof(PyIProvideClassInfo2),
                 PyIProvideClassInfo2_methods,
				 GET_PYCOM_CTOR(PyIProvideClassInfo2));

