#include "stdafx.h"
#include "PythonCOM.h"
#include "PythonCOMServer.h"
#include "propbag.h"

PyIPropertyBag::PyIPropertyBag(IUnknown *pdisp):
	PyIUnknown(pdisp)
{
	ob_type = &type;
}

PyIPropertyBag::~PyIPropertyBag()
{
}

/* static */ IPropertyBag *PyIPropertyBag::GetI(PyObject *self)
{
	return (IPropertyBag *)PyIUnknown::GetI(self);
}

/* static */ PyObject *PyIPropertyBag::Read(PyObject *self, PyObject *args)
{
	const char *propName;
	int varType = VT_EMPTY;
	PyObject *obLog = NULL;
	if ( !PyArg_ParseTuple(args, "s|iO:Read", &propName, &varType, &obLog) )
		return NULL;

	IPropertyBag *pIPB = GetI(self);
	if ( pIPB == NULL )
		return NULL;

	IErrorLog *pIEL = NULL;
	if ( obLog != NULL && obLog != Py_None &&
		 !PyCom_InterfaceFromPyObject(obLog, IID_IErrorLog, (LPVOID*)&pIEL, FALSE) )
		return NULL;

	VARIANT var;
	VariantInit(&var);
	V_VT(&var) = varType;	// ### do we need to set anything more?

	USES_CONVERSION;
	HRESULT hr = pIPB->Read(A2OLE(propName), &var, pIEL);
	if ( pIEL != NULL )
		pIEL->Release();
	if ( FAILED(hr) )
		return OleSetOleError(hr);

	PyObject *result = PyCom_PyObjectFromVariant(&var);
	VariantClear(&var);
	return result;
}

/* static */ PyObject *PyIPropertyBag::Write(PyObject *self, PyObject *args)
{
	const char *propName;
	PyObject *obValue;
	if ( !PyArg_ParseTuple(args, "sO:Write", &propName, &obValue) )
		return NULL;

	IPropertyBag *pIPB = GetI(self);
	if ( pIPB == NULL )
		return NULL;

	VARIANT var;
	if ( !PyCom_VariantFromPyObject(obValue, &var) )
		return NULL;

	USES_CONVERSION;
	HRESULT hr = pIPB->Write(A2OLE(propName), &var);
	VariantClear(&var);
	if ( FAILED(hr) )
		return OleSetOleError(hr);

	Py_INCREF(Py_None);
	return Py_None;
}

static struct PyMethodDef PyIPropertyBag_methods[] =
{
	{ "Read", PyIPropertyBag::Read, 1 },
	{ "Write", PyIPropertyBag::Write, 1 },
	{ NULL }
};

PyComTypeObject PyIPropertyBag::type("PyIPropertyBag",
		&PyIUnknown::type,
		sizeof(PyIPropertyBag),
		PyIPropertyBag_methods,
		GET_PYCOM_CTOR(PyIPropertyBag));
