// This file implements the IPersistStorage interface for Python.
// Generated by makegw.py
#include "stdafx.h"
#include "PythonCOM.h"
#include "PyIPersist.h"
#include "PyIPersistStorage.h"

// @doc - This file contains autoduck documentation

PyIPersistStorage::PyIPersistStorage(IUnknown *pdisp):
	PyIPersist(pdisp)
{
	ob_type = &type;
}

PyIPersistStorage::~PyIPersistStorage()
{
}

/* static */ IPersistStorage *PyIPersistStorage::GetI(PyObject *self)
{
	return (IPersistStorage *)PyIPersist::GetI(self);
}

// @pymethod int|PyIPersistStorage|IsDirty|Description of IsDirty.
PyObject *PyIPersistStorage::IsDirty(PyObject *self, PyObject *args)
{
	IPersistStorage *pIPS = GetI(self);
	if ( pIPS == NULL )
		return NULL;
	if ( !PyArg_ParseTuple(args, ":IsDirty") )
		return NULL;
	HRESULT hr = pIPS->IsDirty( );
	if ( FAILED(hr) )
		return OleSetOleError(hr);
	return PyInt_FromLong(hr);
}
// @pymethod |PyIPersistStorage|InitNew|Description of InitNew.
PyObject *PyIPersistStorage::InitNew(PyObject *self, PyObject *args)
{
	IPersistStorage *pIPS = GetI(self);
	if ( pIPS == NULL )
		return NULL;
	// @pyparm <o PyIStorage>|obIStorage||Description for obIStorage
	PyObject * obIStorage;
	if ( !PyArg_ParseTuple(args, "O:InitNew", &obIStorage) )
		return NULL;
	IStorage *pStg;
	if (!PyCom_InterfaceFromPyObject(obIStorage, IID_IStorage, (void **)&pStg, FALSE /* bNoneOK */))
		return NULL;

	HRESULT hr = pIPS->InitNew( pStg );
	pStg->Release();
	if ( FAILED(hr) )
		return OleSetOleError(hr);
	Py_INCREF(Py_None);
	return Py_None;
}
// @pymethod |PyIPersistStorage|Load|Description of Load.
PyObject *PyIPersistStorage::Load(PyObject *self, PyObject *args)
{
	IPersistStorage *pIPS = GetI(self);
	if ( pIPS == NULL )
		return NULL;
	// @pyparm <o PyIStorage>|obIStorage||Description for obIStorage
	PyObject * obIStorage;
	if ( !PyArg_ParseTuple(args, "O:Load", &obIStorage) )
		return NULL;
	IStorage *pStg;
	if (!PyCom_InterfaceFromPyObject(obIStorage, IID_IStorage, (void **)&pStg, FALSE /* bNoneOK */))
		return NULL;

	HRESULT hr = pIPS->Load( pStg );
	pStg->Release();
	if ( FAILED(hr) )
		return OleSetOleError(hr);
	Py_INCREF(Py_None);
	return Py_None;
}
// @pymethod |PyIPersistStorage|Save|Description of Save.
PyObject *PyIPersistStorage::Save(PyObject *self, PyObject *args)
{
	IPersistStorage *pIPS = GetI(self);
	if ( pIPS == NULL )
		return NULL;
	// @pyparm <o PyIStorage>|obIStorage||Description for obIStorage
	// @pyparm fSameAsLoad|int||Description for fSameAsLoad
	PyObject * obIStorage;
	BOOL fSameAsLoad;
	if ( !PyArg_ParseTuple(args, "Oi:Save", &obIStorage, &fSameAsLoad) )
		return NULL;
	IStorage *pStgSave;
	if (!PyCom_InterfaceFromPyObject(obIStorage, IID_IStorage, (void **)&pStgSave, FALSE /* bNoneOK */))
		return NULL;

	HRESULT hr = pIPS->Save( pStgSave, fSameAsLoad );
	pStgSave->Release();
	if ( FAILED(hr) )
		return OleSetOleError(hr);
	Py_INCREF(Py_None);
	return Py_None;
}
// @pymethod |PyIPersistStorage|SaveCompleted|Description of SaveCompleted.
PyObject *PyIPersistStorage::SaveCompleted(PyObject *self, PyObject *args)
{
	IPersistStorage *pIPS = GetI(self);
	if ( pIPS == NULL )
		return NULL;
	// @pyparm <o PyIStorage>|obIStorage||Description for obIStorage
	PyObject * obIStorage;
	if ( !PyArg_ParseTuple(args, "O:SaveCompleted", &obIStorage) )
		return NULL;
	IStorage *pStgNew;
	if (!PyCom_InterfaceFromPyObject(obIStorage, IID_IStorage, (void **)&pStgNew, FALSE /* bNoneOK */))
		return NULL;

	HRESULT hr = pIPS->SaveCompleted( pStgNew );
	pStgNew->Release();
	if ( FAILED(hr) )
		return OleSetOleError(hr);
	Py_INCREF(Py_None);
	return Py_None;
}
// @pymethod |PyIPersistStorage|HandsOffStorage|Description of HandsOffStorage.
PyObject *PyIPersistStorage::HandsOffStorage(PyObject *self, PyObject *args)
{
	IPersistStorage *pIPS = GetI(self);
	if ( pIPS == NULL )
		return NULL;
	if ( !PyArg_ParseTuple(args, ":HandsOffStorage") )
		return NULL;
	HRESULT hr = pIPS->HandsOffStorage( );
	if ( FAILED(hr) )
		return OleSetOleError(hr);
	Py_INCREF(Py_None);
	return Py_None;
}
// @object PyIPersistStorage|Description of the interface
static struct PyMethodDef PyIPersistStorage_methods[] =
{
	{ "IsDirty", PyIPersistStorage::IsDirty, 1 }, // @pymeth IsDirty|Description of IsDirty
	{ "InitNew", PyIPersistStorage::InitNew, 1 }, // @pymeth InitNew|Description of InitNew
	{ "Load", PyIPersistStorage::Load, 1 }, // @pymeth Load|Description of Load
	{ "Save", PyIPersistStorage::Save, 1 }, // @pymeth Save|Description of Save
	{ "SaveCompleted", PyIPersistStorage::SaveCompleted, 1 }, // @pymeth SaveCompleted|Description of SaveCompleted
	{ "HandsOffStorage", PyIPersistStorage::HandsOffStorage, 1 }, // @pymeth HandsOffStorage|Description of HandsOffStorage
	{ NULL }
};

PyComTypeObject PyIPersistStorage::type("PyIPersistStorage",
		&PyIUnknown::type,
		sizeof(PyIPersistStorage),
		PyIPersistStorage_methods,
		GET_PYCOM_CTOR(PyIPersistStorage));
