#include "stdafx.h"
#include "PythonCOM.h"
#include "PythonCOMServer.h"
#include "propbag.h"

PyIPersistPropertyBag::PyIPersistPropertyBag(IUnknown *pdisp):
	PyIUnknown(pdisp)
{
	ob_type = &type;
}

PyIPersistPropertyBag::~PyIPersistPropertyBag()
{
}

/* static */ IPersistPropertyBag *PyIPersistPropertyBag::GetI(PyObject *self)
{
	return (IPersistPropertyBag *)PyIUnknown::GetI(self);
}

/* static */ PyObject *PyIPersistPropertyBag::InitNew(PyObject *self, PyObject *args)
{
	if ( !PyArg_ParseTuple(args, ":InitNew") )
		return NULL;

	IPersistPropertyBag *pIPPB = GetI(self);
	if ( pIPPB == NULL )
		return NULL;

	HRESULT hr = pIPPB->InitNew();
	if ( FAILED(hr) )
		return OleSetOleError(hr);

	Py_INCREF(Py_None);
	return Py_None;
}

/* static */ PyObject *PyIPersistPropertyBag::Load(PyObject *self, PyObject *args)
{
	PyObject *obBag;
	PyObject *obLog = NULL;
	if ( !PyArg_ParseTuple(args, "O|O:Load", &obBag, &obLog) )
		return NULL;

	IPersistPropertyBag *pIPPB = GetI(self);
	if ( pIPPB == NULL )
		return NULL;

	IPropertyBag *pIPB;
	if ( !PyCom_InterfaceFromPyObject(obBag, IID_IPropertyBag, (LPVOID*)&pIPB, FALSE) )
		return NULL;

	IErrorLog *pIEL = NULL;
	if ( obLog != NULL &&
		 !PyCom_InterfaceFromPyObject(obLog, IID_IErrorLog, (LPVOID*)&pIEL, FALSE) )
	{
		pIPB->Release();
		return NULL;
	}

	HRESULT hr = pIPPB->Load(pIPB, pIEL);
	pIPB->Release();
	pIEL->Release();
	if ( FAILED(hr) )
		return OleSetOleError(hr);

	Py_INCREF(Py_None);
	return Py_None;
}

/* static */ PyObject *PyIPersistPropertyBag::Save(PyObject *self, PyObject *args)
{
	PyObject *obBag;
	int clearDirty;
	int saveAllProperties;
	if ( !PyArg_ParseTuple(args, "Oii:Save", &obBag, &clearDirty, &saveAllProperties) )
		return NULL;

	IPersistPropertyBag *pIPPB = GetI(self);
	if ( pIPPB == NULL )
		return NULL;

	IPropertyBag *pIPB;
	if ( !PyCom_InterfaceFromPyObject(obBag, IID_IPropertyBag, (LPVOID*)&pIPB, FALSE) )
		return NULL;

	HRESULT hr = pIPPB->Save(pIPB, clearDirty, saveAllProperties);
	pIPB->Release();
	if ( FAILED(hr) )
		return OleSetOleError(hr);

	Py_INCREF(Py_None);
	return Py_None;
}

static struct PyMethodDef PyIPersistPropertyBag_methods[] =
{
	{ "InitNew", PyIPersistPropertyBag::InitNew, 1 },
	{ "Load", PyIPersistPropertyBag::Load, 1 },
	{ "Save", PyIPersistPropertyBag::Save, 1 },
	{ NULL }
};

PyComTypeObject PyIPersistPropertyBag::type("PyIPersistPropertyBag",
		&PyIPersist::type,
		sizeof(PyIPersistPropertyBag),
		PyIPersistPropertyBag_methods,
		GET_PYCOM_CTOR(PyIPersistPropertyBag));
