// This file implements the ILockBytes Interface and Gateway for Python.
// Generated by makegw.py

#include "stdafx.h"
#include "PythonCOM.h"
#include "PythonCOMServer.h"
#include "PyILockBytes.h"

// @doc - This file contains autoduck documentation
// ---------------------------------------------------
//
// Interface Implementation

PyILockBytes::PyILockBytes(IUnknown *pdisp):
	PyIUnknown(pdisp)
{
	ob_type = &type;
}

PyILockBytes::~PyILockBytes()
{
}

/* static */ ILockBytes *PyILockBytes::GetI(PyObject *self)
{
	return (ILockBytes *)PyIUnknown::GetI(self);
}

// @pymethod |PyILockBytes|ReadAt|Description of ReadAt.
PyObject *PyILockBytes::ReadAt(PyObject *self, PyObject *args)
{
	ILockBytes *pILB = GetI(self);
	if ( pILB == NULL )
		return NULL;
	// @pyparm <o ULARGE_INTEGER>|ulOffset||Offset to start reading
	// @pyparm int|cb||Number of bytes to read
	PyObject *obulOffset;
	ULONG cb;
	if ( !PyArg_ParseTuple(args, "Oi:ReadAt", &obulOffset, &cb) )
		return NULL;
	ULARGE_INTEGER ulOffset;
	BOOL bPythonIsHappy = TRUE;
	if (!PyObjectToULARGE_INTEGER(obulOffset, &ulOffset)) bPythonIsHappy = FALSE;
	if (!bPythonIsHappy) return NULL;
	char *pv = (char *)malloc(cb);
	ULONG pcbRead;
	HRESULT hr = pILB->ReadAt( ulOffset, pv, cb, &pcbRead );
	if ( FAILED(hr) )
		return OleSetOleError(hr);

	PyObject *pyretval = PyString_FromStringAndSize(pv, pcbRead);
	return pyretval;
}

// @pymethod |PyILockBytes|WriteAt|Description of WriteAt.
PyObject *PyILockBytes::WriteAt(PyObject *self, PyObject *args)
{
	ILockBytes *pILB = GetI(self);
	if ( pILB == NULL )
		return NULL;
	// @pyparm <o ULARGE_INTEGER>|ulOffset||Offset to write at.
	// @pyparm string|data||Data to write
	PyObject *obulOffset;
	char *pv;
	ULONG cb;
	if ( !PyArg_ParseTuple(args, "Os#:WriteAt", &obulOffset, &pv, &cb) )
		return NULL;
	ULARGE_INTEGER ulOffset;
	BOOL bPythonIsHappy = TRUE;
	if (!PyObjectToULARGE_INTEGER(obulOffset, &ulOffset)) bPythonIsHappy = FALSE;
	if (!bPythonIsHappy) return NULL;
	ULONG pcbWritten;
	HRESULT hr = pILB->WriteAt( ulOffset, pv, cb, &pcbWritten );
	if ( FAILED(hr) )
		return OleSetOleError(hr);

	PyObject *pyretval = Py_BuildValue("i", pcbWritten);
	return pyretval;
}

// @pymethod |PyILockBytes|Flush|Description of Flush.
PyObject *PyILockBytes::Flush(PyObject *self, PyObject *args)
{
	ILockBytes *pILB = GetI(self);
	if ( pILB == NULL )
		return NULL;
	if ( !PyArg_ParseTuple(args, ":Flush") )
		return NULL;
	HRESULT hr = pILB->Flush( );
	if ( FAILED(hr) )
		return OleSetOleError(hr);
	Py_INCREF(Py_None);
	return Py_None;

}

// @pymethod |PyILockBytes|SetSize|Description of SetSize.
PyObject *PyILockBytes::SetSize(PyObject *self, PyObject *args)
{
	ILockBytes *pILB = GetI(self);
	if ( pILB == NULL )
		return NULL;
	// @pyparm <o ULARGE_INTEGER>|cb||Description for cb
	PyObject *obcb;
	if ( !PyArg_ParseTuple(args, "O:SetSize", &obcb) )
		return NULL;
	ULARGE_INTEGER cb;
	BOOL bPythonIsHappy = TRUE;
	if (!PyObjectToULARGE_INTEGER(obcb, &cb)) bPythonIsHappy = FALSE;
	if (!bPythonIsHappy) return NULL;
	HRESULT hr = pILB->SetSize( cb );
	if ( FAILED(hr) )
		return OleSetOleError(hr);
	Py_INCREF(Py_None);
	return Py_None;

}

// @pymethod |PyILockBytes|LockRegion|Description of LockRegion.
PyObject *PyILockBytes::LockRegion(PyObject *self, PyObject *args)
{
	ILockBytes *pILB = GetI(self);
	if ( pILB == NULL )
		return NULL;
	// @pyparm <o ULARGE_INTEGER>|libOffset||Description for libOffset
	// @pyparm <o ULARGE_INTEGER>|cb||Description for cb
	// @pyparm int|dwLockType||Description for dwLockType
	PyObject *oblibOffset;
	PyObject *obcb;
	DWORD dwLockType;
	if ( !PyArg_ParseTuple(args, "OOi:LockRegion", &oblibOffset, &obcb, &dwLockType) )
		return NULL;
	ULARGE_INTEGER libOffset;
	ULARGE_INTEGER cb;
	BOOL bPythonIsHappy = TRUE;
	if (!PyObjectToULARGE_INTEGER(oblibOffset, &libOffset)) bPythonIsHappy = FALSE;
	if (!PyObjectToULARGE_INTEGER(obcb, &cb)) bPythonIsHappy = FALSE;
	if (!bPythonIsHappy) return NULL;
	HRESULT hr = pILB->LockRegion( libOffset, cb, dwLockType );
	if ( FAILED(hr) )
		return OleSetOleError(hr);
	Py_INCREF(Py_None);
	return Py_None;

}

// @pymethod |PyILockBytes|UnlockRegion|Description of UnlockRegion.
PyObject *PyILockBytes::UnlockRegion(PyObject *self, PyObject *args)
{
	ILockBytes *pILB = GetI(self);
	if ( pILB == NULL )
		return NULL;
	// @pyparm <o ULARGE_INTEGER>|libOffset||Description for libOffset
	// @pyparm <o ULARGE_INTEGER>|cb||Description for cb
	// @pyparm int|dwLockType||Description for dwLockType
	PyObject *oblibOffset;
	PyObject *obcb;
	DWORD dwLockType;
	if ( !PyArg_ParseTuple(args, "OOi:UnlockRegion", &oblibOffset, &obcb, &dwLockType) )
		return NULL;
	ULARGE_INTEGER libOffset;
	ULARGE_INTEGER cb;
	BOOL bPythonIsHappy = TRUE;
	if (!PyObjectToULARGE_INTEGER(oblibOffset, &libOffset)) bPythonIsHappy = FALSE;
	if (!PyObjectToULARGE_INTEGER(obcb, &cb)) bPythonIsHappy = FALSE;
	if (!bPythonIsHappy) return NULL;
	HRESULT hr = pILB->UnlockRegion( libOffset, cb, dwLockType );
	if ( FAILED(hr) )
		return OleSetOleError(hr);
	Py_INCREF(Py_None);
	return Py_None;

}

// @pymethod |PyILockBytes|Stat|Description of Stat.
PyObject *PyILockBytes::Stat(PyObject *self, PyObject *args)
{
	ILockBytes *pILB = GetI(self);
	if ( pILB == NULL )
		return NULL;
	// @pyparm int|grfStatFlag||Description for grfStatFlag
	DWORD grfStatFlag;
	if ( !PyArg_ParseTuple(args, "i:Stat", &grfStatFlag) )
		return NULL;
	STATSTG pstatstg;
	HRESULT hr = pILB->Stat( &pstatstg, grfStatFlag );
	if ( FAILED(hr) )
		return OleSetOleError(hr);

	PyObject *obpstatstg = PyCom_PyObjectFromSTATSTG(&pstatstg);
	// STATSTG doco says our responsibility to free
	if ((pstatstg).pwcsName) CoTaskMemFree((pstatstg).pwcsName);
	PyObject *pyretval = Py_BuildValue("O", obpstatstg);
	Py_XDECREF(obpstatstg);
	return pyretval;
}

// @object PyILockBytes|Description of the interface
static struct PyMethodDef PyILockBytes_methods[] =
{
	{ "ReadAt", PyILockBytes::ReadAt, 1 }, // @pymeth ReadAt|Description of ReadAt
	{ "WriteAt", PyILockBytes::WriteAt, 1 }, // @pymeth WriteAt|Description of WriteAt
	{ "Flush", PyILockBytes::Flush, 1 }, // @pymeth Flush|Description of Flush
	{ "SetSize", PyILockBytes::SetSize, 1 }, // @pymeth SetSize|Description of SetSize
	{ "LockRegion", PyILockBytes::LockRegion, 1 }, // @pymeth LockRegion|Description of LockRegion
	{ "UnlockRegion", PyILockBytes::UnlockRegion, 1 }, // @pymeth UnlockRegion|Description of UnlockRegion
	{ "Stat", PyILockBytes::Stat, 1 }, // @pymeth Stat|Description of Stat
	{ NULL }
};

PyComTypeObject PyILockBytes::type("PyILockBytes",
		&PyIUnknown::type,
		sizeof(PyILockBytes),
		PyILockBytes_methods,
		GET_PYCOM_CTOR(PyILockBytes));
// ---------------------------------------------------
//
// Gateway Implementation

// Std delegation
STDMETHODIMP_(ULONG) PyGLockBytes::AddRef(void) {return PyGatewayBase::AddRef();}
STDMETHODIMP_(ULONG) PyGLockBytes::Release(void) {return PyGatewayBase::Release();}
STDMETHODIMP PyGLockBytes::QueryInterface(REFIID iid, void ** obj) {return PyGatewayBase::QueryInterface(iid, obj);}
STDMETHODIMP PyGLockBytes::GetTypeInfoCount(UINT FAR* pctInfo) {return PyGatewayBase::GetTypeInfoCount(pctInfo);}
STDMETHODIMP PyGLockBytes::GetTypeInfo(UINT itinfo, LCID lcid, ITypeInfo FAR* FAR* pptInfo) {return PyGatewayBase::GetTypeInfo(itinfo, lcid, pptInfo);}
STDMETHODIMP PyGLockBytes::GetIDsOfNames(REFIID refiid, OLECHAR FAR* FAR* rgszNames, UINT cNames, LCID lcid, DISPID FAR* rgdispid) {return PyGatewayBase::GetIDsOfNames( refiid, rgszNames, cNames, lcid, rgdispid);}
STDMETHODIMP PyGLockBytes::Invoke(DISPID dispid, REFIID riid, LCID lcid, WORD wFlags, DISPPARAMS FAR* params, VARIANT FAR* pVarResult, EXCEPINFO FAR* pexcepinfo, UINT FAR* puArgErr) {return PyGatewayBase::Invoke( dispid, riid, lcid, wFlags, params, pVarResult, pexcepinfo, puArgErr);}

STDMETHODIMP PyGLockBytes::ReadAt(
		/* [in] */ ULARGE_INTEGER ulOffset,
		/* [in] */ void __RPC_FAR * pv,
		/* [in] */ ULONG cb,
		/* [out] */ ULONG __RPC_FAR * pcbRead)
{
	PY_GATEWAY_METHOD;
// *** The input argument pv of type "void __RPC_FAR *" was not processed ***
//   - None will always be passed to the Python function as a placeholder
//   - Only 'reserved' void params are supported (pv)
	PyObject *obulOffset = PyObjectFromULARGE_INTEGER(ulOffset);
	PyObject *result;
	HRESULT hr=InvokeViaPolicy("ReadAt", &result, "Ozi", obulOffset, NULL, cb);
	Py_XDECREF(obulOffset);
	if (FAILED(hr)) return hr;
	// Process the Python results, and convert back to the real params
	if (!PyArg_Parse(result, "i" , &pcbRead)) return PyCom_HandlePythonFailureToCOM(/*pexcepinfo*/);
	Py_DECREF(result);
	return hr;
}

STDMETHODIMP PyGLockBytes::WriteAt(
		/* [in] */ ULARGE_INTEGER ulOffset,
		/* [in] */ const void __RPC_FAR * pv,
		/* [in] */ ULONG cb,
		/* [out] */ ULONG __RPC_FAR * pcbWritten)
{
	PY_GATEWAY_METHOD;
// *** The input argument pv of type "const void __RPC_FAR *" was not processed ***
//   - None will always be passed to the Python function as a placeholder
//   - The type 'const void' (pv) is unknown.
	PyObject *obulOffset = PyObjectFromULARGE_INTEGER(ulOffset);
	PyObject *result;
	HRESULT hr=InvokeViaPolicy("WriteAt", &result, "Ozi", obulOffset, NULL, cb);
	Py_XDECREF(obulOffset);
	if (FAILED(hr)) return hr;
	// Process the Python results, and convert back to the real params
	if (!PyArg_Parse(result, "i" , &pcbWritten)) return PyCom_HandlePythonFailureToCOM(/*pexcepinfo*/);
	Py_DECREF(result);
	return hr;
}

STDMETHODIMP PyGLockBytes::Flush(
		void)
{
	PY_GATEWAY_METHOD;
	HRESULT hr=InvokeViaPolicy("Flush", NULL, "i");
	return hr;
}

STDMETHODIMP PyGLockBytes::SetSize(
		/* [in] */ ULARGE_INTEGER cb)
{
	PY_GATEWAY_METHOD;
	PyObject *obcb = PyObjectFromULARGE_INTEGER(cb);
	HRESULT hr=InvokeViaPolicy("SetSize", NULL, "O", obcb);
	Py_XDECREF(obcb);
	return hr;
}

STDMETHODIMP PyGLockBytes::LockRegion(
		/* [in] */ ULARGE_INTEGER libOffset,
		/* [in] */ ULARGE_INTEGER cb,
		/* [in] */ DWORD dwLockType)
{
	PY_GATEWAY_METHOD;
	PyObject *oblibOffset = PyObjectFromULARGE_INTEGER(libOffset);
	PyObject *obcb = PyObjectFromULARGE_INTEGER(cb);
	HRESULT hr=InvokeViaPolicy("LockRegion", NULL, "OOi", oblibOffset, obcb, dwLockType);
	Py_XDECREF(oblibOffset);
	Py_XDECREF(obcb);
	return hr;
}

STDMETHODIMP PyGLockBytes::UnlockRegion(
		/* [in] */ ULARGE_INTEGER libOffset,
		/* [in] */ ULARGE_INTEGER cb,
		/* [in] */ DWORD dwLockType)
{
	PY_GATEWAY_METHOD;
	PyObject *oblibOffset = PyObjectFromULARGE_INTEGER(libOffset);
	PyObject *obcb = PyObjectFromULARGE_INTEGER(cb);
	HRESULT hr=InvokeViaPolicy("UnlockRegion", NULL, "OOi", oblibOffset, obcb, dwLockType);
	Py_XDECREF(oblibOffset);
	Py_XDECREF(obcb);
	return hr;
}

STDMETHODIMP PyGLockBytes::Stat(
		/* [out] */ STATSTG __RPC_FAR * pstatstg,
		/* [in] */ DWORD grfStatFlag)
{
	PY_GATEWAY_METHOD;
	PyObject *result;
	HRESULT hr=InvokeViaPolicy("Stat", &result, "i", grfStatFlag);
	if (FAILED(hr)) return hr;
	// Process the Python results, and convert back to the real params
	PyObject *obpstatstg;
	if (!PyArg_Parse(result, "O" , &obpstatstg)) return PyCom_HandlePythonFailureToCOM(/*pexcepinfo*/);
	BOOL bPythonIsHappy = TRUE;
	if (!PyCom_PyObjectAsSTATSTG(obpstatstg, pstatstg, 0/*flags*/)) bPythonIsHappy = FALSE;
	if (!bPythonIsHappy) hr = PyCom_HandlePythonFailureToCOM(/*pexcepinfo*/);
	Py_DECREF(result);
	return hr;
}

