// This file implements the IExternalConnection Interface and Gateway for Python.
// Generated by makegw.py

#include "stdafx.h"
#include "PythonCOM.h"
#include "PythonCOMServer.h"
#include "PyIExternalConnection.h"

// @doc - This file contains autoduck documentation
// ---------------------------------------------------
//
// Interface Implementation

PyIExternalConnection::PyIExternalConnection(IUnknown *pdisp):
	PyIUnknown(pdisp)
{
	ob_type = &type;
}

PyIExternalConnection::~PyIExternalConnection()
{
}

/* static */ IExternalConnection *PyIExternalConnection::GetI(PyObject *self)
{
	return (IExternalConnection *)PyIUnknown::GetI(self);
}

// @pymethod |PyIExternalConnection|AddConnection|Description of AddConnection.
PyObject *PyIExternalConnection::AddConnection(PyObject *self, PyObject *args)
{
	IExternalConnection *pIEC = GetI(self);
	if ( pIEC == NULL )
		return NULL;
	// @pyparm int|extconn||Description for extconn
	// @pyparm int|reserved||Description for reserved
	DWORD extconn;
	DWORD reserved;
	if ( !PyArg_ParseTuple(args, "ii:AddConnection", &extconn, &reserved) )
		return NULL;
	DWORD rc = pIEC->AddConnection( extconn, reserved );
	return PyInt_FromLong(rc);
}

// @pymethod |PyIExternalConnection|ReleaseConnection|Description of ReleaseConnection.
PyObject *PyIExternalConnection::ReleaseConnection(PyObject *self, PyObject *args)
{
	IExternalConnection *pIEC = GetI(self);
	if ( pIEC == NULL )
		return NULL;
	// @pyparm int|extconn||Description for extconn
	// @pyparm int|reserved||Description for reserved
	// @pyparm int|fLastReleaseCloses||Description for fLastReleaseCloses
	DWORD extconn;
	DWORD reserved;
	BOOL fLastReleaseCloses;
	if ( !PyArg_ParseTuple(args, "iii:ReleaseConnection", &extconn, &reserved, &fLastReleaseCloses) )
		return NULL;
	DWORD rc = pIEC->ReleaseConnection( extconn, reserved, fLastReleaseCloses );
	return PyInt_FromLong(rc);
}

// @object PyIExternalConnection|Description of the interface
static struct PyMethodDef PyIExternalConnection_methods[] =
{
	{ "AddConnection", PyIExternalConnection::AddConnection, 1 }, // @pymeth AddConnection|Description of AddConnection
	{ "ReleaseConnection", PyIExternalConnection::ReleaseConnection, 1 }, // @pymeth ReleaseConnection|Description of ReleaseConnection
	{ NULL }
};

PyComTypeObject PyIExternalConnection::type("PyIExternalConnection",
		&PyIUnknown::type,
		sizeof(PyIExternalConnection),
		PyIExternalConnection_methods,
		GET_PYCOM_CTOR(PyIExternalConnection));
// ---------------------------------------------------
//
// Gateway Implementation

// Std delegation
STDMETHODIMP_(ULONG) PyGExternalConnection::AddRef(void) {return PyGatewayBase::AddRef();}
STDMETHODIMP_(ULONG) PyGExternalConnection::Release(void) {return PyGatewayBase::Release();}
STDMETHODIMP PyGExternalConnection::QueryInterface(REFIID iid, void ** obj) {return PyGatewayBase::QueryInterface(iid, obj);}
STDMETHODIMP PyGExternalConnection::GetTypeInfoCount(UINT FAR* pctInfo) {return PyGatewayBase::GetTypeInfoCount(pctInfo);}
STDMETHODIMP PyGExternalConnection::GetTypeInfo(UINT itinfo, LCID lcid, ITypeInfo FAR* FAR* pptInfo) {return PyGatewayBase::GetTypeInfo(itinfo, lcid, pptInfo);}
STDMETHODIMP PyGExternalConnection::GetIDsOfNames(REFIID refiid, OLECHAR FAR* FAR* rgszNames, UINT cNames, LCID lcid, DISPID FAR* rgdispid) {return PyGatewayBase::GetIDsOfNames( refiid, rgszNames, cNames, lcid, rgdispid);}
STDMETHODIMP PyGExternalConnection::Invoke(DISPID dispid, REFIID riid, LCID lcid, WORD wFlags, DISPPARAMS FAR* params, VARIANT FAR* pVarResult, EXCEPINFO FAR* pexcepinfo, UINT FAR* puArgErr) {return PyGatewayBase::Invoke( dispid, riid, lcid, wFlags, params, pVarResult, pexcepinfo, puArgErr);}

DWORD STDMETHODCALLTYPE PyGExternalConnection::AddConnection(
		/* [in] */ DWORD extconn,
		/* [in] */ DWORD reserved)
{
	PY_GATEWAY_METHOD;
	return InvokeViaPolicy("AddConnection", NULL, "ii", extconn, reserved);
}

DWORD STDMETHODCALLTYPE PyGExternalConnection::ReleaseConnection(
		/* [in] */ DWORD extconn,
		/* [in] */ DWORD reserved,
		/* [in] */ BOOL fLastReleaseCloses)
{
	PY_GATEWAY_METHOD;
	return InvokeViaPolicy("ReleaseConnection", NULL, "iii", extconn, reserved, fLastReleaseCloses);
}

