#include "stdafx.h"
#include "PythonCOM.h"
#include "PythonCOMServer.h"
#include "propbag.h"

PyIErrorLog::PyIErrorLog(IUnknown *pdisp):
	PyIUnknown(pdisp)
{
	ob_type = &type;
}

PyIErrorLog::~PyIErrorLog()
{
}

/* static */ IErrorLog *PyIErrorLog::GetI(PyObject *self)
{
	return (IErrorLog *)PyIUnknown::GetI(self);
}

/* static */ PyObject *PyIErrorLog::AddError(PyObject *self, PyObject *args)
{
	const char *propName;
	PyObject *obExcepInfo = NULL;
	if ( !PyArg_ParseTuple(args, "s|O:AddError", &propName, &obExcepInfo) )
		return NULL;

	EXCEPINFO excepInfo;
	EXCEPINFO *pExcepInfo;
	if ( obExcepInfo )
	{
		if ( !PyCom_ExcepInfoFromPyObject(obExcepInfo, &excepInfo) )
			return NULL;
		pExcepInfo = &excepInfo;
	}
	else
	{
		pExcepInfo = NULL;
	}

	IErrorLog *pIEL = GetI(self);
	if ( pIEL == NULL )
		return NULL;

	USES_CONVERSION;
	HRESULT hr = pIEL->AddError(A2OLE(propName), pExcepInfo);
	if ( FAILED(hr) )
		return OleSetOleError(hr);

	Py_INCREF(Py_None);
	return Py_None;
}

static struct PyMethodDef PyIErrorLog_methods[] =
{
	{ "AddError", PyIErrorLog::AddError, 1 },
	{ NULL }
};

PyComTypeObject PyIErrorLog::type("PyIErrorLog",
		&PyIUnknown::type,
		sizeof(PyIErrorLog),
		PyIErrorLog_methods,
		GET_PYCOM_CTOR(PyIErrorLog));
