#include "stdafx.h"
#include "comcat.h"
#include "PythonCOM.h"
#include "PyICatRegister.h"

BOOL CATIDsFromPyObject( PyObject *obCatIds, CATID **ppCatIds, UINT *pNumIds)
{
	if (!PySequence_Check(obCatIds)) {
		PyErr_SetString(PyExc_TypeError, "Object must be a sequence of CATIDs");
		return FALSE;
	}
	int len = PyObject_Length(obCatIds);
	CATID *ids = new CATID[len];
	BOOL rc = TRUE;
	for (int i=0;rc && i<len;i++) {
		PyObject *obThis = PySequence_GetItem(obCatIds, i);
		if (obThis==NULL) {
			rc = FALSE;
			break;
		}
		if (!PyCom_CLSIDFromPyObject(obThis, ids+i)) {
			PyErr_SetString(PyExc_TypeError, "CATID is not valid");
			rc = FALSE;
		}
		Py_DECREF(obThis);
	}
	if (rc) {
		*ppCatIds = ids;
		*pNumIds = len;
	} else {
		delete [] ids;
	}
	return rc;
}

void DeleteCATIDs( CATID *pCatIds )
{
	delete [] pCatIds;
}
PyICatRegister::PyICatRegister(IUnknown *pdisp):
	PyIUnknown(pdisp)
{
	ob_type = &type;
}

PyICatRegister::~PyICatRegister()
{
}

/* static */ ICatRegister *PyICatRegister::GetI(PyObject *self)
{
	return (ICatRegister *)PyIUnknown::GetI(self);
}


/* static */ PyObject *PyICatRegister::RegisterCategories(PyObject *self, PyObject *args)
{
	USES_CONVERSION;
	PyObject *obCatList;
	if ( !PyArg_ParseTuple(args, "O:RegisterCategories", &obCatList) )
		return NULL;

	ICatRegister *pICR = GetI(self);
	if ( pICR == NULL )
		return NULL;

	if (!PySequence_Check(obCatList)) {
		PyErr_SetString(PyExc_TypeError, "Argument must be a list of CATEGORYINFO tuples");
		return NULL;
	}
	int noInfos = PyObject_Length(obCatList);
	CATEGORYINFO *infos = new CATEGORYINFO [noInfos];
	if (infos==NULL) {
		PyErr_SetString(PyExc_MemoryError, "Allocating CATEGORYINFO array");
		return NULL;
	}
	for (int i=0;i<noInfos;i++) {
		PyObject *obCatId;
		char *desc;
		PyObject *obThis = PySequence_GetItem(obCatList, i);
		if (obThis==NULL) return NULL;
		BOOL ok = TRUE;
		int descLen;
		if (!PyArg_ParseTuple(obThis, "Ols#", &obCatId, (long *)&infos[i].lcid, &desc, &descLen)) {
			Py_DECREF(obThis);
			PyErr_SetString(PyExc_TypeError, "Category infos must be CATID, lcid, description");
			delete [] infos;
			return NULL;
		}
		if (!PyCom_CLSIDFromPyObject(obCatId, &infos[i].catid)) {
			Py_DECREF(obThis);
			PyErr_SetString(PyExc_TypeError, "CATID is not valid");
			delete [] infos;
			return NULL;
		}
		Py_DECREF(obThis);
		OLECHAR *oc =  T2OLE(desc);
		++descLen;	/* copy the terminator, too! */
		if (descLen>127) descLen = 127;
		wcsncpy(infos[i].szDescription, oc, descLen);
	}

	HRESULT hr = pICR->RegisterCategories(noInfos, infos);
	delete [] infos;
	if ( FAILED(hr) )
		return OleSetOleError(hr);
	Py_INCREF(Py_None);
	return Py_None;
}

/* static */ PyObject *PyICatRegister::UnRegisterCategories(PyObject *self, PyObject *args)
{
	PyObject *obCatIds;
	if ( !PyArg_ParseTuple(args, "O:UnRegisterCategories", &obCatIds) )
		return NULL;

	ICatRegister *pICR = GetI(self);
	if ( pICR == NULL )
		return NULL;

	CATID *pids;
	UINT numIds;
	if (!CATIDsFromPyObject(obCatIds, &pids, &numIds))
		return NULL;

	HRESULT hr = pICR->UnRegisterCategories( numIds, pids );

	DeleteCATIDs(pids);

	if ( FAILED(hr) )
		return OleSetOleError(hr);

	Py_INCREF(Py_None);
	return Py_None;
}

/* static */ PyObject *PyICatRegister::RegisterClassImplCategories(PyObject *self, PyObject *args)
{
	PyObject *obCLSID, *obCatIds;
	if ( !PyArg_ParseTuple(args, "OO:RegisterClassImplCategories", &obCLSID, &obCatIds) )
		return NULL;

	ICatRegister *pICR = GetI(self);
	if ( pICR == NULL )
		return NULL;

	CLSID clsid;
	if (!PyCom_CLSIDFromPyObject(obCLSID, &clsid)) {
		PyErr_SetString(PyExc_TypeError, "CLSID is not valid");
		return NULL;
	}

	CATID *pids;
	UINT numIds;
	if (!CATIDsFromPyObject(obCatIds, &pids, &numIds))
		return NULL;

	HRESULT hr = pICR->RegisterClassImplCategories(clsid, numIds, pids);

	DeleteCATIDs(pids);
	if ( FAILED(hr) )
		return OleSetOleError(hr);

	Py_INCREF(Py_None);
	return Py_None;
}

/* static */ PyObject *PyICatRegister::UnRegisterClassImplCategories(PyObject *self, PyObject *args)
{
	PyObject *obCLSID, *obCatIds;
	if ( !PyArg_ParseTuple(args, "OO:UnRegisterClassImplCategories", &obCLSID, &obCatIds) )
		return NULL;

	ICatRegister *pICR = GetI(self);
	if ( pICR == NULL )
		return NULL;

	CLSID clsid;
	if (!PyCom_CLSIDFromPyObject(obCLSID, &clsid)) {
		PyErr_SetString(PyExc_TypeError, "CLSID is not valid");
		return NULL;
	}

	CATID *pids;
	UINT numIds;
	if (!CATIDsFromPyObject(obCatIds, &pids, &numIds))
		return NULL;

	HRESULT hr = pICR->UnRegisterClassImplCategories(clsid, numIds, pids);

	DeleteCATIDs(pids);
	if ( FAILED(hr) )
		return OleSetOleError(hr);

	Py_INCREF(Py_None);
	return Py_None;
}

/* static */ PyObject *PyICatRegister::RegisterClassReqCategories(PyObject *self, PyObject *args)
{
	PyObject *obCLSID, *obCatIds;
	if ( !PyArg_ParseTuple(args, "OO:RegisterClassReqCategories", &obCLSID, &obCatIds) )
		return NULL;

	ICatRegister *pICR = GetI(self);
	if ( pICR == NULL )
		return NULL;

	CLSID clsid;
	if (!PyCom_CLSIDFromPyObject(obCLSID, &clsid)) {
		PyErr_SetString(PyExc_TypeError, "CLSID is not valid");
		return NULL;
	}

	CATID *pids;
	UINT numIds;
	if (!CATIDsFromPyObject(obCatIds, &pids, &numIds))
		return NULL;

	HRESULT hr = pICR->RegisterClassReqCategories(clsid, numIds, pids);

	DeleteCATIDs(pids);
	if ( FAILED(hr) )
		return OleSetOleError(hr);

	Py_INCREF(Py_None);
	return Py_None;
}

/* static */ PyObject *PyICatRegister::UnRegisterClassReqCategories(PyObject *self, PyObject *args)
{
	PyObject *obCLSID, *obCatIds;
	if ( !PyArg_ParseTuple(args, "OO:UnRegisterClassReqCategories", &obCLSID, &obCatIds) )
		return NULL;

	ICatRegister *pICR = GetI(self);
	if ( pICR == NULL )
		return NULL;

	CLSID clsid;
	if (!PyCom_CLSIDFromPyObject(obCLSID, &clsid)) {
		PyErr_SetString(PyExc_TypeError, "CLSID is not valid");
		return NULL;
	}

	CATID *pids;
	UINT numIds;
	if (!CATIDsFromPyObject(obCatIds, &pids, &numIds))
		return NULL;

	HRESULT hr = pICR->UnRegisterClassReqCategories(clsid, numIds, pids);

	DeleteCATIDs(pids);
	if ( FAILED(hr) )
		return OleSetOleError(hr);

	Py_INCREF(Py_None);
	return Py_None;
}

static struct PyMethodDef PyICatRegister_methods[] =
{
	{ "RegisterCategories", PyICatRegister::RegisterCategories, 1 },
	{ "UnRegisterCategories", PyICatRegister::UnRegisterCategories, 1 },
	{ "RegisterClassImplCategories", PyICatRegister::RegisterClassImplCategories, 1 },
	{ "UnRegisterClassImplCategories", PyICatRegister::UnRegisterClassImplCategories, 1 },
	{ "RegisterClassReqCategories", PyICatRegister::RegisterClassReqCategories, 1 },
	{ "UnRegisterClassReqCategories", PyICatRegister::UnRegisterClassReqCategories, 1 },
	{ NULL }
};

PyComTypeObject PyICatRegister::type("PyICatRegister",
		&PyIUnknown::type,
		sizeof(PyICatRegister),
		PyICatRegister_methods,
		GET_PYCOM_CTOR(PyICatRegister));
