#include "stdafx.h"
#include "PyIPersistStream.h"
#include "PyIStream.h"

// Std delegation
STDMETHODIMP_(ULONG) PyGPersistStream::AddRef(void) {return PyGatewayBase::AddRef();}
STDMETHODIMP_(ULONG) PyGPersistStream::Release(void) {return PyGatewayBase::Release();}
STDMETHODIMP PyGPersistStream::QueryInterface(REFIID iid, void ** obj) {return PyGatewayBase::QueryInterface(iid, obj);}
STDMETHODIMP PyGPersistStream::GetTypeInfoCount(UINT FAR* pctInfo) {return PyGatewayBase::GetTypeInfoCount(pctInfo);}
STDMETHODIMP PyGPersistStream::GetTypeInfo(UINT itinfo, LCID lcid, ITypeInfo FAR* FAR* pptInfo) {return PyGatewayBase::GetTypeInfo(itinfo, lcid, pptInfo);}
STDMETHODIMP PyGPersistStream::GetIDsOfNames(REFIID refiid, OLECHAR FAR* FAR* rgszNames, UINT cNames, LCID lcid, DISPID FAR* rgdispid) {return PyGatewayBase::GetIDsOfNames( refiid, rgszNames, cNames, lcid, rgdispid);}
STDMETHODIMP PyGPersistStream::Invoke(DISPID dispid, REFIID riid, LCID lcid, WORD wFlags, DISPPARAMS FAR* params, VARIANT FAR* pVarResult, EXCEPINFO FAR* pexcepinfo, UINT FAR* puArgErr) {return PyGatewayBase::Invoke( dispid, riid, lcid, wFlags, params, pVarResult, pexcepinfo, puArgErr);}

STDMETHODIMP PyGPersistStream::GetClassID(CLSID FAR *pClassID) {return PyGPersist::GetClassID(pClassID); }

STDMETHODIMP PyGPersistStream::IsDirty(
		void)
{
	HRESULT hr;
	PyCom_EnterPython();
	{
		PyObject *result;
		hr = InvokeViaPolicy("IsDirty", &result);
		if ( SUCCEEDED(hr) )
		{
			/* returning 0 means not dirty. *anything* else means dirty */

			int dirty = PyInt_AsLong(result);
			Py_DECREF(result);
			hr = dirty == 0 ? S_FALSE : S_OK;
		}
	}
	PyCom_LeavePython();
	return hr;
}

STDMETHODIMP PyGPersistStream::Load(
            /* [unique][in] */ IStream __RPC_FAR *pStm)
{
	if ( pStm == NULL )
		return PyCom_SetFromSimple(E_POINTER, GetIID());

	HRESULT hr;
	PyCom_EnterPython();
	{
		PyObject *obStm = NULL;

		obStm = PyCom_PyObjectFromIUnknown(pStm, IID_IStream, TRUE);
		if ( obStm == NULL )
			hr = PyCom_SetFromPyException(GetIID());
		else
		{
			hr = InvokeViaPolicy("Load", NULL, "O", obStm);
			Py_DECREF(obStm);
		}
	}
	PyCom_LeavePython();
	return hr;
}

STDMETHODIMP PyGPersistStream::Save(
            /* [unique][in] */ IStream __RPC_FAR *pStm,
            /* [in] */ BOOL fClearDirty)
{
	if ( pStm == NULL )
		return PyCom_SetFromSimple(E_POINTER, GetIID());

	HRESULT hr;
	PyCom_EnterPython();
	{
		PyObject *obStm = NULL;

		obStm = PyCom_PyObjectFromIUnknown(pStm, IID_IStream, TRUE);
		if ( obStm == NULL)
			hr = PyCom_SetFromPyException(GetIID());
		else
		{
			hr = InvokeViaPolicy("Save", NULL, "Oi", obStm, (int)fClearDirty);
			Py_DECREF(obStm);
		}
	}
	PyCom_LeavePython();
	return hr;
}

STDMETHODIMP PyGPersistStream::GetSizeMax(
            /* [out] */ ULARGE_INTEGER __RPC_FAR *pcbSize)
{
	if ( pcbSize == NULL )
		return PyCom_SetFromSimple(E_POINTER, GetIID());

	HRESULT hr;
	PyCom_EnterPython();
	{
		PyObject *result;
		hr = InvokeViaPolicy("GetSizeMax", &result);
		if ( SUCCEEDED(hr) )
		{
			BOOL ok = PyObjectToULARGE_INTEGER(result, pcbSize);
			Py_DECREF(result);
			PyErr_Clear();	/* just in case */
			hr = ok ? S_OK : E_FAIL;
		}
	}
	PyCom_LeavePython();

	return hr;
}

