// This file implements the IPersistStorage gateway for Python.
// Generated by makegw.py
#include "stdafx.h"
#include "PythonCOM.h"
#include "PythonCOMServer.h"
#include "PyIPersist.h"
#include "PyGPersistStorage.h"

// Std delegation
STDMETHODIMP_(ULONG) PyGPersistStorage::AddRef(void) {return PyGPersist::AddRef();}
STDMETHODIMP_(ULONG) PyGPersistStorage::Release(void) {return PyGPersist::Release();}
STDMETHODIMP PyGPersistStorage::QueryInterface(REFIID iid, void ** obj) {return PyGPersist::QueryInterface(iid, obj);}
STDMETHODIMP PyGPersistStorage::GetTypeInfoCount(UINT FAR* pctInfo) {return PyGPersist::GetTypeInfoCount(pctInfo);}
STDMETHODIMP PyGPersistStorage::GetTypeInfo(UINT itinfo, LCID lcid, ITypeInfo FAR* FAR* pptInfo) {return PyGPersist::GetTypeInfo(itinfo, lcid, pptInfo);}
STDMETHODIMP PyGPersistStorage::GetIDsOfNames(REFIID refiid, OLECHAR FAR* FAR* rgszNames, UINT cNames, LCID lcid, DISPID FAR* rgdispid) {return PyGPersist::GetIDsOfNames( refiid, rgszNames, cNames, lcid, rgdispid);}
STDMETHODIMP PyGPersistStorage::Invoke(DISPID dispid, REFIID riid, LCID lcid, WORD wFlags, DISPPARAMS FAR* params, VARIANT FAR* pVarResult, EXCEPINFO FAR* pexcepinfo, UINT FAR* puArgErr) {return PyGPersist::Invoke( dispid, riid, lcid, wFlags, params, pVarResult, pexcepinfo, puArgErr);}

STDMETHODIMP PyGPersistStorage::GetClassID(CLSID FAR *pClassID) {return PyGPersist::GetClassID(pClassID); }

STDMETHODIMP PyGPersistStorage::IsDirty(
		void)
{
	PY_GATEWAY_METHOD;
	HRESULT hr=InvokeViaPolicy("IPersistStorage", NULL, NULL);
	return hr;
}

STDMETHODIMP PyGPersistStorage::InitNew(
		/* [unique][in] */ IStorage __RPC_FAR * pStg)
{
	PY_GATEWAY_METHOD;
	PyObject *obIStorage = PyCom_PyObjectFromIUnknown(pStg, IID_IStorage, TRUE);
	HRESULT hr=InvokeViaPolicy("IPersistStorage", NULL, "O",obIStorage);
	return hr;
}

STDMETHODIMP PyGPersistStorage::Load(
		/* [unique][in] */ IStorage __RPC_FAR * pStg)
{
	PY_GATEWAY_METHOD;
	PyObject *obIStorage = PyCom_PyObjectFromIUnknown(pStg, IID_IStorage, TRUE);
	HRESULT hr=InvokeViaPolicy("IPersistStorage", NULL, "O",obIStorage);
	return hr;
}

STDMETHODIMP PyGPersistStorage::Save(
		/* [unique][in] */ IStorage __RPC_FAR * pStgSave,
		/* [in] */ BOOL fSameAsLoad)
{
	PY_GATEWAY_METHOD;
	PyObject *obIStorage = PyCom_PyObjectFromIUnknown(pStgSave, IID_IStorage, TRUE);
	HRESULT hr=InvokeViaPolicy("IPersistStorage", NULL, "Oi",obIStorage,fSameAsLoad);
	return hr;
}

STDMETHODIMP PyGPersistStorage::SaveCompleted(
		/* [unique][in] */ IStorage __RPC_FAR * pStgNew)
{
	PY_GATEWAY_METHOD;
	PyObject *obIStorage = PyCom_PyObjectFromIUnknown(pStgNew, IID_IStorage, TRUE);
	HRESULT hr=InvokeViaPolicy("IPersistStorage", NULL, "O",obIStorage);
	return hr;
}

STDMETHODIMP PyGPersistStorage::HandsOffStorage(
		void)
{
	PY_GATEWAY_METHOD;
	HRESULT hr=InvokeViaPolicy("IPersistStorage", NULL, NULL);
	return hr;
}

