#include "stdafx.h"
#include "PythonCOM.h"
#include "PythonCOMServer.h"
#include "propbag.h"

// Std delegation
STDMETHODIMP_(ULONG) PyGPersistPropertyBag::AddRef(void) {return PyGatewayBase::AddRef();}
STDMETHODIMP_(ULONG) PyGPersistPropertyBag::Release(void) {return PyGatewayBase::Release();}
STDMETHODIMP PyGPersistPropertyBag::QueryInterface(REFIID iid, void ** obj) {return PyGatewayBase::QueryInterface(iid, obj);}
STDMETHODIMP PyGPersistPropertyBag::GetTypeInfoCount(UINT FAR* pctInfo) {return PyGatewayBase::GetTypeInfoCount(pctInfo);}
STDMETHODIMP PyGPersistPropertyBag::GetTypeInfo(UINT itinfo, LCID lcid, ITypeInfo FAR* FAR* pptInfo) {return PyGatewayBase::GetTypeInfo(itinfo, lcid, pptInfo);}
STDMETHODIMP PyGPersistPropertyBag::GetIDsOfNames(REFIID refiid, OLECHAR FAR* FAR* rgszNames, UINT cNames, LCID lcid, DISPID FAR* rgdispid) {return PyGatewayBase::GetIDsOfNames( refiid, rgszNames, cNames, lcid, rgdispid);}
STDMETHODIMP PyGPersistPropertyBag::Invoke(DISPID dispid, REFIID riid, LCID lcid, WORD wFlags, DISPPARAMS FAR* params, VARIANT FAR* pVarResult, EXCEPINFO FAR* pexcepinfo, UINT FAR* puArgErr) {return PyGatewayBase::Invoke( dispid, riid, lcid, wFlags, params, pVarResult, pexcepinfo, puArgErr);}

STDMETHODIMP PyGPersistPropertyBag::GetClassID(CLSID FAR *pClassID) {return PyGPersist::GetClassID(pClassID); }


STDMETHODIMP PyGPersistPropertyBag::InitNew(void)
{
	PyObject *result = DispatchViaPolicy("InitNew", NULL);
	HRESULT hr = PyCom_HandlePythonFailureToCOM();
	Py_XDECREF(result);
	return hr;
}

STDMETHODIMP PyGPersistPropertyBag::Load(
            /* [in] */ IPropertyBag __RPC_FAR *pPropBag,
            /* [in] */ IErrorLog __RPC_FAR *pErrorLog)
{
	HRESULT hr;

	if ( pPropBag == NULL )
		return E_POINTER;

	PyObject *obLog;
	if ( pErrorLog != NULL )
	{
		obLog = PyCom_PyObjectFromIUnknown(pErrorLog, IID_IErrorLog, TRUE);
		if ( !obLog )
			return PyCom_HandlePythonFailureToCOM();
	}
	else
	{
		Py_INCREF(Py_None);
		obLog = Py_None;
	}

	PyObject *obBag = PyCom_PyObjectFromIUnknown(pPropBag, IID_IPropertyBag, TRUE);
	if ( !obBag )
	{
		hr = PyCom_HandlePythonFailureToCOM();
		Py_DECREF(obLog);
		return hr;
	}

	PyObject *result = DispatchViaPolicy("Load", "OO", obBag, obLog);
	hr = PyCom_HandlePythonFailureToCOM();
	Py_DECREF(obBag);
	Py_DECREF(obLog);
	Py_XDECREF(result);
	return hr;
}

STDMETHODIMP PyGPersistPropertyBag::Save(
            /* [in] */ IPropertyBag __RPC_FAR *pPropBag,
            /* [in] */ BOOL fClearDirty,
            /* [in] */ BOOL fSaveAllProperties)
{
	if ( pPropBag == NULL )
		return E_POINTER;

	PyObject *obBag = PyCom_PyObjectFromIUnknown(pPropBag, IID_IPropertyBag, TRUE);
	if ( !obBag )
		return PyCom_HandlePythonFailureToCOM();

	PyObject *result = DispatchViaPolicy("Save",
										 "Oii",
										 obBag,
										 (int)fClearDirty,
										 (int)fSaveAllProperties);
	HRESULT hr = PyCom_HandlePythonFailureToCOM();
	Py_DECREF(obBag);
	Py_XDECREF(result);
	return hr;
}

