#include "stdafx.h"
#include "PythonCOM.h"
#include "PythonCOMServer.h"
#include "propbag.h"

// Std delegation
STDMETHODIMP_(ULONG) PyGErrorLog::AddRef(void) {return PyGatewayBase::AddRef();}
STDMETHODIMP_(ULONG) PyGErrorLog::Release(void) {return PyGatewayBase::Release();}
STDMETHODIMP PyGErrorLog::QueryInterface(REFIID iid, void ** obj) {return PyGatewayBase::QueryInterface(iid, obj);}
STDMETHODIMP PyGErrorLog::GetTypeInfoCount(UINT FAR* pctInfo) {return PyGatewayBase::GetTypeInfoCount(pctInfo);}
STDMETHODIMP PyGErrorLog::GetTypeInfo(UINT itinfo, LCID lcid, ITypeInfo FAR* FAR* pptInfo) {return PyGatewayBase::GetTypeInfo(itinfo, lcid, pptInfo);}
STDMETHODIMP PyGErrorLog::GetIDsOfNames(REFIID refiid, OLECHAR FAR* FAR* rgszNames, UINT cNames, LCID lcid, DISPID FAR* rgdispid) {return PyGatewayBase::GetIDsOfNames( refiid, rgszNames, cNames, lcid, rgdispid);}
STDMETHODIMP PyGErrorLog::Invoke(DISPID dispid, REFIID riid, LCID lcid, WORD wFlags, DISPPARAMS FAR* params, VARIANT FAR* pVarResult, EXCEPINFO FAR* pexcepinfo, UINT FAR* puArgErr) {return PyGatewayBase::Invoke( dispid, riid, lcid, wFlags, params, pVarResult, pexcepinfo, puArgErr);}

STDMETHODIMP PyGErrorLog::AddError(
            /* [in] */ LPCOLESTR pszPropName,
            /* [in] */ EXCEPINFO __RPC_FAR *pExcepInfo)
{
	if ( pszPropName == NULL || pExcepInfo == NULL )
		return E_POINTER;

	PyObject *obExcepInfo = PyCom_PyObjectFromExcepInfo(pExcepInfo);
	if ( !obExcepInfo )
		return PyCom_HandlePythonFailureToCOM();

	USES_CONVERSION;
	PyObject *result = DispatchViaPolicy("AddError",
										 "sO",
										 OLE2A(pszPropName),
										 obExcepInfo);
	HRESULT hr = PyCom_HandlePythonFailureToCOM();
	Py_DECREF(obExcepInfo);
	Py_XDECREF(result);
	return hr;
}

