#include "stdafx.h"
#include "PythonCOM.h"
#include "PythonCOMServer.h"
#include "PyIEnumVARIANT.h"

extern void PyCom_LogF(const char *fmt, ...);
#define LogF PyCom_LogF

// Std delegation
STDMETHODIMP_(ULONG) PyGEnumVARIANT::AddRef(void) {return PyGatewayBase::AddRef();} \
STDMETHODIMP_(ULONG) PyGEnumVARIANT::Release(void) {return PyGatewayBase::Release();} \
STDMETHODIMP PyGEnumVARIANT::QueryInterface(REFIID iid, void ** obj) {return PyGatewayBase::QueryInterface(iid, obj);} \
STDMETHODIMP PyGEnumVARIANT::GetTypeInfoCount(UINT FAR* pctInfo) {return PyGatewayBase::GetTypeInfoCount(pctInfo);} \
STDMETHODIMP PyGEnumVARIANT::GetTypeInfo(UINT itinfo, LCID lcid, ITypeInfo FAR* FAR* pptInfo) {return PyGatewayBase::GetTypeInfo(itinfo, lcid, pptInfo);} \
STDMETHODIMP PyGEnumVARIANT::GetIDsOfNames(REFIID refiid, OLECHAR FAR* FAR* rgszNames, UINT cNames, LCID lcid, DISPID FAR* rgdispid) {return PyGatewayBase::GetIDsOfNames( refiid, rgszNames, cNames, lcid, rgdispid);} \
STDMETHODIMP PyGEnumVARIANT::Invoke(DISPID dispid, REFIID riid, LCID lcid, WORD wFlags, DISPPARAMS FAR* params, VARIANT FAR* pVarResult, EXCEPINFO FAR* pexcepinfo, UINT FAR* puArgErr) {return PyGatewayBase::Invoke( dispid, riid, lcid, wFlags, params, pVarResult, pexcepinfo, puArgErr);}

STDMETHODIMP PyGEnumVARIANT::Next( 
            /* [in] */ ULONG celt,
            /* [length_is][size_is][out] */ VARIANT __RPC_FAR *rgVar,
            /* [out] */ ULONG __RPC_FAR *pCeltFetched)
{
	PY_GATEWAY_METHOD;
	PyObject *result;
	HRESULT hr = InvokeViaPolicy("Next", &result, "i", celt);
	if ( FAILED(hr) )
		return hr;

	if ( !PySequence_Check(result) )
		goto error;
	int len;
	len = PyObject_Length(result);
	if ( len == -1 )
		goto error;
	if ( len > (int)celt)
		len = celt;

	if ( pCeltFetched )
		*pCeltFetched = len;

	int i;
	for ( i = 0; i < len; ++i )
	{
		PyObject *ob = PySequence_GetItem(result, i);
		if ( ob == NULL )
			goto error;

		if ( !PyCom_MakePyObjectToVariant(ob, &rgVar[i]) )
		{
			Py_DECREF(ob);
			Py_DECREF(result);
			return PyCom_SetFromSimple(E_OUTOFMEMORY, IID_IEnumVARIANT);
		}
		Py_DECREF(ob);
	}

	Py_DECREF(result);

	return len < (int)celt ? S_FALSE : S_OK;

  error:
	PyErr_Clear();	// just in case
	LogF("PyGEnumVariant::Next got a bad return value");
	Py_DECREF(result);
	return PyCom_SetFromSimple(E_FAIL, IID_IEnumVARIANT);
}

STDMETHODIMP PyGEnumVARIANT::Skip( 
            /* [in] */ ULONG celt)
{
	PY_GATEWAY_METHOD;
	return InvokeViaPolicy("Skip", NULL, "i", celt);
}

STDMETHODIMP PyGEnumVARIANT::Reset(void)
{
	return InvokeViaPolicy("Reset");
}

STDMETHODIMP PyGEnumVARIANT::Clone( 
            /* [out] */ IEnumVARIANT __RPC_FAR *__RPC_FAR *ppEnum)
{
	PY_GATEWAY_METHOD;
	PyObject * result;
	HRESULT hr = InvokeViaPolicy("Clone", &result);
	if ( FAILED(hr) )
		return hr;

	/*
	** Make sure we have the right kind of object: we should have some kind
	** of IUnknown subclass wrapped into a PyIUnknown instance.
	*/
	if ( !PyIBase::is_object(result, &PyIUnknown::type) )
	{
		/* the wrong kind of object was returned to us */
		Py_DECREF(result);
		return PyCom_SetFromSimple(E_FAIL, IID_IEnumVARIANT);
	}

	/*
	** Get the IUnknown out of the thing. note that the Python ob maintains
	** a reference, so we don't have to explicitly AddRef() here.
	*/
	IUnknown *punk = ((PyIUnknown *)result)->m_obj;
	if ( !punk )
	{
		/* damn. the object was released. */
		Py_DECREF(result);
		return PyCom_SetFromSimple(E_FAIL, IID_IEnumVARIANT);
	}

	/*
	** Get the interface we want. note it is returned with a refcount.
	** This QI is actually going to instantiate a PyGEnumVARIANT.
	*/
	hr = punk->QueryInterface(IID_IEnumVARIANT, (LPVOID *)ppEnum);

	/* done with the result; this DECREF is also for <punk> */
	Py_DECREF(result);

	return PyCom_SetFromSimple(hr, IID_IEnumVARIANT);
}
