#include "stdafx.h"
#include "PythonCOM.h"
#include "PythonCOMServer.h"
#include <PyGConnectionPoint.h>

// Std delegation
STDMETHODIMP_(ULONG) PyGConnectionPoint::AddRef(void) {return PyGatewayBase::AddRef();}
STDMETHODIMP_(ULONG) PyGConnectionPoint::Release(void) {return PyGatewayBase::Release();}
STDMETHODIMP PyGConnectionPoint::QueryInterface(REFIID iid, void ** obj) {return PyGatewayBase::QueryInterface(iid, obj);}
STDMETHODIMP PyGConnectionPoint::GetTypeInfoCount(UINT FAR* pctInfo) {return PyGatewayBase::GetTypeInfoCount(pctInfo);}
STDMETHODIMP PyGConnectionPoint::GetTypeInfo(UINT itinfo, LCID lcid, ITypeInfo FAR* FAR* pptInfo) {return PyGatewayBase::GetTypeInfo(itinfo, lcid, pptInfo);}
STDMETHODIMP PyGConnectionPoint::GetIDsOfNames(REFIID refiid, OLECHAR FAR* FAR* rgszNames, UINT cNames, LCID lcid, DISPID FAR* rgdispid) {return PyGatewayBase::GetIDsOfNames( refiid, rgszNames, cNames, lcid, rgdispid);}
STDMETHODIMP PyGConnectionPoint::Invoke(DISPID dispid, REFIID riid, LCID lcid, WORD wFlags, DISPPARAMS FAR* params, VARIANT FAR* pVarResult, EXCEPINFO FAR* pexcepinfo, UINT FAR* puArgErr) {return PyGatewayBase::Invoke( dispid, riid, lcid, wFlags, params, pVarResult, pexcepinfo, puArgErr);}

STDMETHODIMP PyGConnectionPoint::GetConnectionInterface(IID *pIID)
{
	if (pIID==NULL) return E_POINTER;
	PyObject *result = DispatchViaPolicy("GetConnectionInterface", NULL);
	if (result)
		PyCom_CLSIDFromPyObject(result, pIID);
	Py_XDECREF(result);
	return PyCom_HandlePythonFailureToCOM();
}

STDMETHODIMP PyGConnectionPoint::GetConnectionPointContainer( IConnectionPointContainer **ppCPC)
{
	if (ppCPC==NULL) return E_POINTER;
	PyObject *result = DispatchViaPolicy("GetConnectionPointContainer", NULL);
	if (result)
		PyCom_InterfaceFromPyObject(result, IID_IConnectionPointContainer, (void **)ppCPC);
	HRESULT hr = PyCom_HandlePythonFailureToCOM();
	Py_XDECREF(result);
	return hr;
}

STDMETHODIMP PyGConnectionPoint::Advise(IUnknown *pUnk, DWORD *pdwCookie)
{
	if (pUnk==NULL || pdwCookie==NULL) return E_POINTER;
	PyObject *obUnknown = PyCom_PyObjectFromIUnknown(pUnk, IID_IUnknown, TRUE); // Take a reference to this object.
	PyObject *result = NULL;
	*pdwCookie = 0;
	if (obUnknown) {
		result = DispatchViaPolicy("Advise", "O", obUnknown);
		Py_DECREF(obUnknown);
		if (result) {
			PyErr_Clear();
			*pdwCookie = PyInt_AsLong(result);
			if (PyErr_Occurred())
				*pdwCookie = 0;
		}
	}
	HRESULT hr = PyCom_HandlePythonFailureToCOM();
	Py_XDECREF(result);
	return hr;
}

STDMETHODIMP PyGConnectionPoint::Unadvise(DWORD cookie)
{
	PyObject *result = DispatchViaPolicy("Unadvise", "i", cookie);
	HRESULT hr = PyCom_HandlePythonFailureToCOM();
	Py_XDECREF(result);
	return hr;
}

STDMETHODIMP PyGConnectionPoint::EnumConnections(IEnumConnections **ppEnum)
{
	return E_NOTIMPL;
/*
	PyObject *result = DispatchViaPolicy("EnumConnections", NULL);
	HRESULT hr = PyCom_HandlePythonFailureToCOM();
	Py_XDECREF(result);
	return hr;
*/
}

