/*
** Storage helpers.
*/

#include "stdafx.h"

#include "PythonCOM.h"
#include "PythonCOMServer.h"
// @doc

// @pymethod <o PyIStorage>|pythoncom|StgCreateDocfile|Creates a new compound file storage object using the OLE-provided compound file implementation for the <o PyIStorage> interface.
PyObject *pythoncom_StgCreateDocfile(PyObject *self, PyObject *args)
{
	USES_CONVERSION;
	DWORD reserved = 0;
	char *name;
	DWORD mode;
	IStorage *pResult;

	if (!PyArg_ParseTuple(args, "zi|i:StgCreateDocfile",
		               &name, // @pyparm string|name||Name of the stream.  If None, a temporary stream is created.
					   &mode, // @pyparm int|mode||Specifies the access mode used to open the storage.
					   &reserved)) // @pyparm int|reserved|0|A reversed value
		return NULL;
	HRESULT hr = StgCreateDocfile(T2OLE(name), mode, reserved, &pResult);
	if (FAILED(hr)) return OleSetOleError(hr);
	return PyCom_PyObjectFromIUnknown(pResult, IID_IStorage, FALSE);
}

// @pymethod <o PyIStorage>|pythoncom|StgCreateDocfileOnILockBytes|Creates a new compound file storage object using the OLE-provided compound file implementation for the <o PyIStorage> interface.
PyObject *pythoncom_StgCreateDocfileOnILockBytes(PyObject *self, PyObject *args)
{
	USES_CONVERSION;
	DWORD reserved = 0;
	DWORD mode;
	IStorage *pResult;
	PyObject *obLockBytes;

	if (!PyArg_ParseTuple(args, "zi|i:StgCreateDocfileOnILockBytes",
		               &obLockBytes, // @pyparm <o PyILockBytes>|lockBytes||The <o PyILockBytes> interface on the underlying byte array object on which to create a compound file.
					   &mode, // @pyparm int|mode||Specifies the access mode used to open the storage.
					   &reserved)) // @pyparm int|reserved|0|A reversed value
		return NULL;
	ILockBytes *plb;
	if (!PyCom_InterfaceFromPyObject(obLockBytes, IID_ILockBytes, (void **)&plb, FALSE))
		return NULL;

	HRESULT hr = StgCreateDocfileOnILockBytes(plb, mode, reserved, &pResult);
	plb->Release();
	if (FAILED(hr)) return OleSetOleError(hr);
	return PyCom_PyObjectFromIUnknown(pResult, IID_IStorage, FALSE);
}

// @pymethod int|pythoncom|StgIsStorageFile|Indicates whether a particular disk file contains a storage object.
PyObject *pythoncom_StgIsStorageFile(PyObject *self, PyObject *args)
{
	USES_CONVERSION;
	char *name;
	if (!PyArg_ParseTuple(args, "s:StgIsStorageFile",
		               &name)) // @pyparm string|name||Name of the file to check.
		return NULL;
	HRESULT hr = StgIsStorageFile(T2OLE(name));
	if (FAILED(hr)) return OleSetOleError(hr);
	// @rdesc The return value is 1 if a storage file, else 0
	return PyInt_FromLong(hr==0);
}

// @pymethod <o PyIStorage>|pythoncom|StgOpenStorage|Opens an existing root storage object in the file system.
PyObject *pythoncom_StgOpenStorage(PyObject *self, PyObject *args)
{
	USES_CONVERSION;
	char *temp = NULL;
	DWORD reserved = 0;
	char *name;
	DWORD mode;
	IStorage *pResult;
	PyObject *obOther;

	if (!PyArg_ParseTuple(args, "zOi|zi:StgOpenStorage",
		               &name, // @pyparm string|name||Name of the stream, or possibly None if storageOther is non None.
					   &obOther, // @pyparm <o PyIStorage>|other||Usually None, or another parent storage.
					   &mode, // @pyparm int|mode||Specifies the access mode used to open the storage.
					   &temp, // @pyparm object|snbExclude||Not yet supported - must be None
					   &reserved)) // @pyparm int|reserved|0|A reversed value
		return NULL;
	IStorage *pOther;
	if (!PyCom_InterfaceFromPyObject(obOther, IID_IStorage, (void **)&pOther, TRUE))
		return NULL;
	HRESULT hr = StgOpenStorage(T2OLE(name), pOther, mode, NULL, reserved, &pResult);
	if (pOther) pOther->Release();
	if (FAILED(hr)) return OleSetOleError(hr);
	return PyCom_PyObjectFromIUnknown(pResult, IID_IStorage, FALSE);
}

